/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.dialogs;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.dialogs.ItemDialogContents;
import com.ibm.wmqfte.explorer.dialogs.ItemDialogUtils;
import com.ibm.wmqfte.explorer.utils.v2.ControlGroup;
import com.ibm.wmqfte.explorer.utils.v2.EnvironmentInformation;
import com.ibm.wmqfte.explorer.utils.v2.PriorityStatus;
import com.ibm.wmqfte.explorer.utils.v2.ResMonAssist;
import com.ibm.wmqfte.explorer.utils.v2.SectionHistory;
import com.ibm.wmqfte.explorer.utils.v2.TransferItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ItemDialogLocationContents
extends ItemDialogUtils {

    public static class DataSetLocationContent
    implements ItemDialogContents {
        private final ControlGroup cg = new ControlGroup("Data Set Content");
        private final ResMonAssist.ComboAssist datasetComboAssist;
        private final SectionHistory.HistoryReference historyReference;

        public DataSetLocationContent(Composite panel, int labelWidth, SectionHistory.HistoryReference historyReference, String toolTip) {
            this.historyReference = historyReference;
            Composite dataSetComp = new Composite(panel, 0);
            dataSetComp.setLayout((Layout)new GridLayout(2, false));
            dataSetComp.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.cg.add((Control)dataSetComp);
            Label dataSetLabel = ItemDialogLocationContents.fixedWidthLabel(dataSetComp, labelWidth, Elements.UI_WIZARD_V2_ITEM_DIALOG_SDS_LABEL);
            this.cg.add((Control)dataSetLabel);
            this.cg.visible(true);
            this.datasetComboAssist = new ResMonAssist.ComboAssist(dataSetComp, 0, this.cg, ResMonAssist.AssistItemType.DATASET);
            historyReference.loadHistory(this.datasetComboAssist.getCombo());
            this.datasetComboAssist.setToolTipText(toolTip);
            this.datasetComboAssist.setLayoutData(new GridData(4, 1, true, false));
            ItemDialogLocationContents.addListener((Control)this.datasetComboAssist.getCombo());
        }

        public String getLocation() {
            return this.datasetComboAssist.getCombo().getText();
        }

        public void setLocation(String value) {
            this.datasetComboAssist.getCombo().setText(value);
        }

        @Override
        public void setActive(boolean active) {
            this.cg.visible(active);
        }

        @Override
        public PriorityStatus validate(boolean withVarSt) {
            PriorityStatus priorityStatus = new PriorityStatus(null);
            String dataSetName = this.datasetComboAssist.getText();
            if (dataSetName == null || dataSetName.length() == 0) {
                priorityStatus.setIncomplete();
            } else if (!TransferItem.DataSetItem.isDataSetNameValid(dataSetName, withVarSt)) {
                priorityStatus.setError(MessageFormat.format(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_INV, dataSetName));
            }
            return priorityStatus;
        }

        @Override
        public void saveHistory() {
            this.historyReference.put(this.datasetComboAssist.getCombo());
        }
    }

    public static class DirectoryLocationContent
    implements ItemDialogContents {
        private final ControlGroup cg = new ControlGroup("Directory Content");
        private final ResMonAssist.ComboAssist directoryComboAssist;
        private final SectionHistory.HistoryReference historyReference;

        public DirectoryLocationContent(Composite panel, int labelWidth, SectionHistory.HistoryReference historyReference, String toolTip, EnvironmentInformation envOptions) {
            this.historyReference = historyReference;
            Composite dirComp = new Composite(panel, 0);
            dirComp.setLayout((Layout)new GridLayout(3, false));
            dirComp.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.cg.add((Control)dirComp);
            Label directoryLabel = ItemDialogLocationContents.fixedWidthLabel(dirComp, labelWidth, Elements.UI_WIZARD_V2_ITEM_DIALOG_DIRECTORY_NAME_LABEL);
            this.cg.add((Control)directoryLabel);
            this.cg.visible(true);
            this.directoryComboAssist = new ResMonAssist.ComboAssist(dirComp, 0, this.cg, ResMonAssist.AssistItemType.DIRECTORY);
            historyReference.loadHistory(this.directoryComboAssist.getCombo());
            this.directoryComboAssist.setToolTipText(toolTip);
            this.directoryComboAssist.setLayoutData(new GridData(4, 1, true, false));
            ItemDialogLocationContents.addListener((Control)this.directoryComboAssist.getCombo());
            Button browser = ItemDialogLocationContents.addBrowse(dirComp, this.directoryComboAssist, envOptions.isAgentLocalToMachine(), true);
            this.cg.add((Control)browser);
        }

        public String getLocation() {
            return this.directoryComboAssist.getCombo().getText();
        }

        public void setLocation(String value) {
            this.directoryComboAssist.getCombo().setText(value);
        }

        @Override
        public void setActive(boolean active) {
            this.cg.visible(active);
        }

        @Override
        public PriorityStatus validate(boolean withVarSt) {
            PriorityStatus priorityStatus = new PriorityStatus(null);
            String filePath = this.directoryComboAssist.getText();
            if (filePath == null || filePath.length() == 0) {
                priorityStatus.setIncomplete();
            } else if (!TransferItem.FileItem.isFileNamesValid(filePath.trim())) {
                priorityStatus.setWarning(MessageFormat.format(Elements.UI_WIZARD_V2_ITEM_DIALOG_FILE_PATH_INV, filePath));
            }
            return priorityStatus;
        }

        @Override
        public void saveHistory() {
            this.historyReference.put(this.directoryComboAssist.getCombo());
        }
    }

    public static class FileLocationContent
    implements ItemDialogContents {
        private final ControlGroup cg = new ControlGroup("File Name Content");
        private final ResMonAssist.ComboAssist fileComboAssist;
        private final SectionHistory.HistoryReference historyReference;
        private final EnvironmentInformation environmentInfo;

        public FileLocationContent(Composite panel, int labelWidth, SectionHistory.HistoryReference historyReference, String toolTip, EnvironmentInformation environmentInfo) {
            this.historyReference = historyReference;
            this.environmentInfo = environmentInfo;
            Composite fileComp = new Composite(panel, 0);
            fileComp.setLayout((Layout)new GridLayout(3, false));
            fileComp.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.cg.add((Control)fileComp);
            Label fileLabel = ItemDialogLocationContents.fixedWidthLabel(fileComp, labelWidth, Elements.UI_WIZARD_V2_ITEM_DIALOG_FILE_NAME_LABEL);
            this.cg.add((Control)fileLabel);
            this.cg.visible(true);
            this.fileComboAssist = new ResMonAssist.ComboAssist(fileComp, 0, this.cg, ResMonAssist.AssistItemType.FILE);
            historyReference.loadHistory(this.fileComboAssist.getCombo());
            this.fileComboAssist.setToolTipText(toolTip);
            this.fileComboAssist.setLayoutData(new GridData(4, 1, true, false));
            ItemDialogLocationContents.addListener((Control)this.fileComboAssist.getCombo());
            Button browser = ItemDialogLocationContents.addBrowse(fileComp, this.fileComboAssist, environmentInfo.isAgentLocalToMachine(), false);
            this.cg.add((Control)browser);
        }

        public String getLocation() {
            return this.fileComboAssist.getCombo().getText();
        }

        public void setLocation(String value) {
            this.fileComboAssist.getCombo().setText(value);
        }

        @Override
        public void setActive(boolean active) {
            this.cg.visible(active);
        }

        @Override
        public PriorityStatus validate(boolean withVarSt) {
            PriorityStatus priorityStatus = new PriorityStatus(null);
            String filePath = this.fileComboAssist.getText();
            if (filePath == null || filePath.length() == 0) {
                priorityStatus.setIncomplete();
            } else if (!TransferItem.FileItem.isFileNamesValid(filePath.trim())) {
                priorityStatus.setWarning(MessageFormat.format(Elements.UI_WIZARD_V2_ITEM_DIALOG_FILE_PATH_INV, filePath));
            } else if (ItemDialogLocationContents.hasWildCardChar(filePath)) {
                if (this.environmentInfo.isSource() && this.environmentInfo.isResourceMonitor()) {
                    priorityStatus.setWarning(Elements.UI_WIZARD_V2_ITEM_MONITOR_WILD_WILD);
                } else if (!this.environmentInfo.isWildCardSupported()) {
                    priorityStatus.setError(Elements.UI_WIZARD_V2_ITEM_AGENT_NOT_SUPP_WILDCARD);
                } else if (this.environmentInfo.isDestination()) {
                    priorityStatus.setWarning(Elements.UI_WIZARD_V2_ITEM_AGENT_WILDCARD_IN_DESTINATION);
                }
            }
            return priorityStatus;
        }

        @Override
        public void saveHistory() {
            this.historyReference.put(this.fileComboAssist.getCombo());
        }
    }

    public static class FileSpaceLocationContent
    implements ItemDialogContents {
        private final ControlGroup cg = new ControlGroup("File Space Content");
        private final ResMonAssist.ComboAssist fileSpaceComboAssist;
        private final SectionHistory.HistoryReference historyReference;

        public FileSpaceLocationContent(Composite panel, int labelWidth, SectionHistory.HistoryReference historyReference, String toolTip) {
            this.historyReference = historyReference;
            Label label = ItemDialogLocationContents.fixedWidthLabel(panel, labelWidth, Elements.UI_WIZARD_V2_ITEM_DIALOG_FILESPACE_LABEL);
            this.cg.add((Control)label);
            this.cg.visible(true);
            this.fileSpaceComboAssist = new ResMonAssist.ComboAssist(panel, 0, this.cg, ResMonAssist.AssistItemType.FILESPACE);
            historyReference.loadHistory(this.fileSpaceComboAssist.getCombo());
            this.fileSpaceComboAssist.setToolTipText(toolTip);
            this.fileSpaceComboAssist.setLayoutData(new GridData(4, 1, true, false));
            ItemDialogLocationContents.addListener((Control)this.fileSpaceComboAssist.getCombo());
        }

        public String getLocation() {
            return this.fileSpaceComboAssist.getCombo().getText();
        }

        public void setLocation(String value) {
            this.fileSpaceComboAssist.getCombo().setText(value);
        }

        @Override
        public void setActive(boolean active) {
            this.cg.visible(active);
        }

        @Override
        public PriorityStatus validate(boolean withVarSt) {
            PriorityStatus priorityStatus = new PriorityStatus(null);
            String fileSpace = this.fileSpaceComboAssist.getText();
            if (fileSpace == null || fileSpace.length() == 0) {
                priorityStatus.setIncomplete();
            } else if (!TransferItem.FileSpaceItem.isFileSpaceValid(fileSpace, withVarSt)) {
                priorityStatus.setError(MessageFormat.format(Elements.UI_WIZARD_V2_ITEM_DIALOG_FILESPACE_INV, fileSpace));
            }
            return priorityStatus;
        }

        @Override
        public void saveHistory() {
            this.historyReference.put(this.fileSpaceComboAssist.getCombo());
        }
    }

    public static class PartitionedDataSetLocationContent
    implements ItemDialogContents {
        private final ControlGroup cg = new ControlGroup("Data Set Content");
        private final ResMonAssist.ComboAssist partitionedDatasetComboAssist;
        private final SectionHistory.HistoryReference historyReference;

        public PartitionedDataSetLocationContent(Composite panel, int labelWidth, SectionHistory.HistoryReference historyReference, String toolTip) {
            this.historyReference = historyReference;
            Composite partitionedDataSetComp = new Composite(panel, 0);
            partitionedDataSetComp.setLayout((Layout)new GridLayout(2, false));
            partitionedDataSetComp.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.cg.add((Control)partitionedDataSetComp);
            Label dataSetLabel = ItemDialogLocationContents.fixedWidthLabel(partitionedDataSetComp, labelWidth, Elements.UI_WIZARD_V2_ITEM_DIALOG_PDS_LABEL);
            this.cg.add((Control)dataSetLabel);
            this.cg.visible(true);
            this.partitionedDatasetComboAssist = new ResMonAssist.ComboAssist(partitionedDataSetComp, 0, this.cg, ResMonAssist.AssistItemType.DATASET);
            historyReference.loadHistory(this.partitionedDatasetComboAssist.getCombo());
            this.partitionedDatasetComboAssist.setToolTipText(toolTip);
            this.partitionedDatasetComboAssist.setLayoutData(new GridData(4, 1, true, false));
            ItemDialogLocationContents.addListener((Control)this.partitionedDatasetComboAssist.getCombo());
        }

        public String getLocation() {
            return this.partitionedDatasetComboAssist.getCombo().getText();
        }

        public void setLocation(String value) {
            this.partitionedDatasetComboAssist.getCombo().setText(value);
        }

        @Override
        public void setActive(boolean active) {
            this.cg.visible(active);
        }

        @Override
        public PriorityStatus validate(boolean withVarSt) {
            PriorityStatus priorityStatus = new PriorityStatus(null);
            String dataSetName = this.partitionedDatasetComboAssist.getText();
            if (dataSetName == null || dataSetName.length() <= 2) {
                priorityStatus.setIncomplete();
            } else if (!TransferItem.DataSetItem.isPDSNameValid(dataSetName, withVarSt)) {
                priorityStatus.setError(MessageFormat.format(Elements.UI_WIZARD_V2_ITEM_DIALOG_PDS_INV, dataSetName));
            }
            return priorityStatus;
        }

        @Override
        public void saveHistory() {
            this.historyReference.put(this.partitionedDatasetComboAssist.getCombo());
        }
    }

    public static class QueueLocationContent
    implements ItemDialogContents {
        private ResMonAssist.ComboAssist queueComboAssist;
        private ResMonAssist.ComboAssist queueMgrCombo;
        private ControlGroup cg = new ControlGroup("Queue Content");
        private final SectionHistory.HistoryReference historyReference;
        private final String fixedQMgr;

        public QueueLocationContent(Composite panel, int labelWidth, String fixedQMgr, SectionHistory.HistoryReference historyReference, String toolTipQueue, String toolTipQueueMgr) {
            this.historyReference = historyReference;
            this.fixedQMgr = fixedQMgr;
            Composite queueComp = new Composite(panel, 0);
            queueComp.setLayout((Layout)new GridLayout(2, false));
            queueComp.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.cg.add((Control)queueComp);
            Label queueLabel = ItemDialogLocationContents.fixedWidthLabel(queueComp, labelWidth, Elements.UI_WIZARD_V2_ITEM_DIALOG_QUEUE_LABEL);
            this.cg.add((Control)queueLabel);
            this.cg.visible(true);
            this.queueComboAssist = new ResMonAssist.ComboAssist(queueComp, 0, this.cg, ResMonAssist.AssistItemType.QUEUE);
            this.queueComboAssist.setToolTipText(toolTipQueue);
            this.queueComboAssist.setLayoutData(new GridData(4, 1, true, false));
            ItemDialogLocationContents.addListener((Control)this.queueComboAssist.getCombo());
            Label queueMgrLabel = ItemDialogLocationContents.fixedWidthLabel(queueComp, labelWidth, Elements.UI_WIZARD_V2_ITEM_DIALOG_QUEUE_MGR_LABEL);
            this.cg.add((Control)queueMgrLabel);
            if (fixedQMgr == null) {
                this.queueMgrCombo = new ResMonAssist.ComboAssist(queueComp, 0, this.cg, ResMonAssist.AssistItemType.QUEUEMGR);
                this.cg.add((Control)this.queueMgrCombo);
                if (toolTipQueueMgr != null) {
                    this.queueMgrCombo.setToolTipText(toolTipQueueMgr);
                }
                this.queueMgrCombo.setLayoutData(new GridData(4, 1, true, false));
                ItemDialogLocationContents.addListener((Control)this.queueMgrCombo.getCombo());
            } else {
                Label fixedQMgrLabel = new Label(queueComp, 0);
                fixedQMgrLabel.setText(fixedQMgr);
                this.cg.add((Control)fixedQMgrLabel);
            }
            this.loadQueueHistory(historyReference, fixedQMgr == null, this.queueComboAssist.getCombo(), this.queueMgrCombo == null ? null : this.queueMgrCombo.getCombo());
        }

        @Override
        public PriorityStatus validate(boolean withVarSt) {
            PriorityStatus priorityStatus = new PriorityStatus(null);
            String queueName = this.queueComboAssist.getText();
            if (queueName == null || queueName.length() == 0) {
                priorityStatus.setIncomplete();
            } else if (!TransferItem.QueueItem.isQueueNameValid(queueName, withVarSt)) {
                priorityStatus.setError(MessageFormat.format(Elements.UI_WIZARD_V2_ITEM_DIALOG_QUEUE_INV, queueName));
            }
            if (this.queueMgrCombo != null) {
                String queueMgrName = this.queueMgrCombo.getText();
                if (queueMgrName == null || queueMgrName.length() == 0) {
                    priorityStatus.setOK();
                } else if (!TransferItem.QueueItem.isQMgrNameValid(queueMgrName, withVarSt)) {
                    priorityStatus.setError(MessageFormat.format(Elements.UI_WIZARD_V2_ITEM_DIALOG_QUEUE_MGR_INV, queueMgrName));
                }
            }
            return priorityStatus;
        }

        public String getLocation() {
            String qmgr;
            String queue = this.queueComboAssist.getText();
            String string = qmgr = this.fixedQMgr != null ? this.fixedQMgr : this.queueMgrCombo.getText();
            if (qmgr == null || qmgr.trim().isEmpty()) {
                return queue;
            }
            return String.valueOf(queue) + "@" + qmgr;
        }

        public String getQueueName() {
            return this.queueComboAssist.getText();
        }

        public String getQMgrName() {
            Object qmgr = this.fixedQMgr != null ? (this.fixedQMgr.equals("") ? null : this.fixedQMgr) : this.queueMgrCombo.getText();
            return qmgr;
        }

        public void setLocation(String value) {
            if (value != null) {
                String[] parts = value.split("@");
                if (parts.length == 1) {
                    this.queueComboAssist.setText(parts[0]);
                } else if (parts.length == 2) {
                    this.queueComboAssist.setText(parts[0]);
                    if (this.queueMgrCombo != null) {
                        this.queueMgrCombo.setText(parts[1]);
                    }
                }
            }
        }

        @Override
        public void setActive(boolean active) {
            this.cg.visible(active);
        }

        private void loadQueueHistory(SectionHistory.HistoryReference reference, boolean queueMgrChangeable, Combo queueCombo, Combo queueMgrCombo) {
            String[] fullPaths = reference.get();
            ArrayList<String> queueNames = new ArrayList<String>();
            ArrayList<String> queueMgrNames = new ArrayList<String>();
            if (fullPaths != null) {
                String[] stringArray = fullPaths;
                int n = fullPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    String[] names = path.split("@");
                    if (names.length > 0 && !queueNames.contains(names[0])) {
                        queueNames.add(names[0]);
                    }
                    if (names.length > 1 && !queueMgrNames.contains(names[1])) {
                        queueMgrNames.add(names[1]);
                    }
                    ++n2;
                }
                queueCombo.setItems(queueNames.toArray(new String[0]));
                if (queueMgrChangeable) {
                    queueMgrCombo.setItems(queueMgrNames.toArray(new String[0]));
                }
            }
        }

        @Override
        public void saveHistory() {
            this.historyReference.put(this.getLocation());
        }
    }
}

