/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.dialogs;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.dialogs.ItemDialogUtils;
import com.ibm.wmqfte.explorer.utils.AgentDetails;
import com.ibm.wmqfte.explorer.utils.v2.ControlGroup;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.utils.AgentType;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ItemDialogInfo
extends ItemDialogUtils {

    public static enum AgentInfo {
        STANDARD(AgentType.STANDARD, Elements.UI_WIZARD_V2_INITIAL_AGENT_STANDARD_LABEL, false, null),
        BRIDGE(AgentType.BRIDGE, Elements.UI_WIZARD_V2_INITIAL_AGENT_BRIDGE_LABEL, false, Elements.UI_WIZARD_V2_INITIAL_AGENT_ENDPOINT_LABEL),
        CD_BRIDGE(AgentType.CD_BRIDGE, Elements.UI_WIZARD_V2_INITIAL_AGENT_CD_BRIDGE_LABEL, true, Elements.UI_WIZARD_V2_INITIAL_AGENT_NODE_LABEL),
        WEBGATEWAY(AgentType.WEB_GATEWAY, Elements.UI_WIZARD_V2_INITIAL_AGENT_WEB_GATEWAY_LABEL, true, null),
        EMBEDDED(AgentType.EMBEDDED, Elements.UI_WIZARD_V2_INITIAL_AGENT_EMBEDDED_LABEL, false, null),
        SFG(AgentType.SFG, Elements.UI_WIZARD_V2_INITIAL_AGENT_SFG_LABEL, false, null);

        private AgentType agentType;
        private String nlsTypeInfo;
        private boolean includeName;
        private String nlsEndPoint;

        private AgentInfo(AgentType agentType, String nlsTypeInfo, boolean includeName, String nlsEndPoint) {
            this.agentType = agentType;
            this.nlsTypeInfo = nlsTypeInfo;
            this.includeName = includeName;
            this.nlsEndPoint = nlsEndPoint;
        }

        public String getTypeInformation(AgentDetails agentDetails) {
            String information;
            if (this.includeName) {
                information = this == CD_BRIDGE ? MessageFormat.format(this.nlsTypeInfo, agentDetails.getCDBridgeNodeName()) : MessageFormat.format(this.nlsTypeInfo, agentDetails.getWebGatewayName());
            } else {
                information = this.nlsTypeInfo;
                if (this == STANDARD && agentDetails.getAgentOsName() != null) {
                    information = String.valueOf(information) + " (" + agentDetails.getAgentOsName() + ')';
                }
            }
            return information;
        }

        public String getEndPoint() {
            return this.nlsEndPoint;
        }

        public static AgentInfo getByDetails(AgentType agentType) {
            AgentInfo[] agentInfoArray = AgentInfo.values();
            int n = agentInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                AgentInfo agentInfo = agentInfoArray[n2];
                if (agentInfo.agentType == agentType) {
                    return agentInfo;
                }
                ++n2;
            }
            return null;
        }
    }

    public static class AgentInformation {
        private final ControlGroup cg = new ControlGroup("Agent Information Content");

        public AgentInformation(Composite outer, AgentDetails agentDetails, int labelWidthParam, boolean includeTypeLabel) {
            AgentInfo agentInfo;
            AgentInfo agentInfo2 = agentInfo = agentDetails == null ? null : AgentInfo.getByDetails(agentDetails.getAgentType());
            if (agentInfo != null) {
                int labelWidth = labelWidthParam;
                if (labelWidth == 0) {
                    labelWidth = Tools.getWidth(outer, new String[]{Elements.UI_WIZARD_V2_ITEM_DIALOG_AGENT, Elements.UI_WIZARD_V2_ITEM_DIALOG_AGENT_TYPE, Elements.UI_WIZARD_V2_INITIAL_AGENT_NODE_LABEL, Elements.UI_WIZARD_V2_INITIAL_AGENT_ENDPOINT_LABEL});
                }
                Label agentlabel = ItemDialogInfo.fixedWidthLabel(outer, labelWidth, Elements.UI_WIZARD_V2_ITEM_DIALOG_AGENT);
                this.cg.add((Control)agentlabel);
                this.cg.visible(true);
                Text agentName = Tools.accessibleLabel(outer, agentDetails.getDescriptiveAgentName());
                this.cg.add((Control)agentName);
                Label agentTypeLabel = ItemDialogInfo.fixedWidthLabel(outer, labelWidth, Elements.UI_WIZARD_V2_ITEM_DIALOG_AGENT_TYPE);
                this.cg.add((Control)agentTypeLabel);
                Text agentType = Tools.accessibleLabel(outer, agentInfo.getTypeInformation(agentDetails));
                this.cg.add((Control)agentType);
                String endPoint = agentInfo.getEndPoint();
                if (endPoint != null) {
                    Label endPointLabel = ItemDialogInfo.fixedWidthLabel(outer, labelWidth, endPoint);
                    this.cg.add((Control)endPointLabel);
                    Text endPointName = Tools.accessibleLabel(outer, agentDetails.getEndPointName());
                    this.cg.add((Control)endPointName);
                }
            } else if (agentDetails != null) {
                Tools.internalError(new Exception(), Elements.UI_WIZARD_V2_INTERR_AGENT_NOT_SUPP, agentDetails.getAgentType().toString());
            }
        }

        public void setActive(boolean active) {
            this.cg.visible(active);
        }
    }
}

