/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.dialogs;

import com.ibm.wmqfte.command.impl.CmdLinePropertyValueValidator;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.dialogs.ItemDialog;
import com.ibm.wmqfte.explorer.dialogs.ItemDialogContents;
import com.ibm.wmqfte.explorer.dialogs.ItemDialogUtils;
import com.ibm.wmqfte.explorer.utils.v2.ControlGroup;
import com.ibm.wmqfte.explorer.utils.v2.DatasetAttributes;
import com.ibm.wmqfte.explorer.utils.v2.EnvironmentInformation;
import com.ibm.wmqfte.explorer.utils.v2.PriorityStatus;
import com.ibm.wmqfte.explorer.utils.v2.QueueProperties;
import com.ibm.wmqfte.explorer.utils.v2.SectionHistory;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.utils.v2.TransferItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class ItemDialogAttributes
extends ItemDialogUtils {
    private static final String[] BPXYWDYN = new String[]{"MOD", "NEW", "SHR", "OLD", Elements.UI_WIZARD_V2_ITEM_DIALOG_BPXWDYN_RECFM, Elements.UI_WIZARD_V2_ITEM_DIALOG_BPXWDYN_LRECL, Elements.UI_WIZARD_V2_ITEM_DIALOG_BPXWDYN_BLKSIZE, "TRACKS", "CYL", "BLOCK", Elements.UI_WIZARD_V2_ITEM_DIALOG_BPXWDYN_SPACE, Elements.UI_WIZARD_V2_ITEM_DIALOG_BPXWDYN_DIR, Elements.UI_WIZARD_V2_ITEM_DIALOG_BPXWDYN_STORCLAS, Elements.UI_WIZARD_V2_ITEM_DIALOG_BPXWDYN_MGMTCLAS, Elements.UI_WIZARD_V2_ITEM_DIALOG_BPXWDYN_DATACLAS, "DSNTYPE(<LIBRARY|PDS|HDS>)"};

    private static void refresh(Composite composite) {
        composite.getParent().layout();
        Composite innerScrollable = composite;
        while (innerScrollable != null) {
            Composite parent = innerScrollable.getParent();
            if (parent != null && parent instanceof ScrolledComposite) {
                ScrolledComposite scrolledComposite = (ScrolledComposite)parent;
                scrolledComposite.notifyListeners(11, new Event());
                break;
            }
            innerScrollable = innerScrollable.getParent();
        }
    }

    public static class BPXWDYNAttributes {
        private final ControlGroup cg = new ControlGroup("Destination data set inner attributes Content");
        private final Table table;
        private final TableViewer tbv;
        private final Composite composite;
        private final Composite tableComp;
        private final Composite parent;
        private ExpandableComposite advancedTwisty = null;
        private List<DatasetAttributes.DataSetParameter> items = new ArrayList<DatasetAttributes.DataSetParameter>();

        public BPXWDYNAttributes(final Composite parent, boolean inTwisty) {
            this.parent = parent;
            if (inTwisty) {
                this.advancedTwisty = new ExpandableComposite(parent, 0, 18);
                this.advancedTwisty.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_PARAMETERS_TITLE);
                this.advancedTwisty.setExpanded(false);
                this.advancedTwisty.setEnabled(true);
                this.advancedTwisty.setLayoutData((Object)new GridData(4, 1, true, false));
                this.cg.add((Control)this.advancedTwisty);
            }
            this.composite = new Composite((Composite)(this.advancedTwisty != null ? this.advancedTwisty : parent), 0);
            if (this.advancedTwisty != null) {
                this.advancedTwisty.setClient((Control)this.composite);
            }
            this.composite.setLayout((Layout)Tools.noMarginGridLayout(1));
            this.composite.setLayoutData((Object)new GridData(4, 1, true, false));
            this.cg.add((Control)this.composite);
            Group dsParametersGroup = new Group(this.composite, 0);
            dsParametersGroup.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_PARAMETERS_TITLE);
            dsParametersGroup.setLayout((Layout)new GridLayout(2, false));
            dsParametersGroup.setLayoutData((Object)new GridData(4, 1, true, false));
            this.tableComp = new Composite((Composite)dsParametersGroup, 0);
            TableColumnLayout tableColumnLayout = new TableColumnLayout();
            this.tableComp.setLayout((Layout)tableColumnLayout);
            this.table = new Table(this.tableComp, 68354);
            this.table.setLayoutData((Object)new GridData(4, 4, true, true));
            this.table.setHeaderVisible(true);
            this.tbv = new TableViewer(this.table);
            this.tbv.setContentProvider((IContentProvider)new DataSetContentProvider());
            this.tbv.setLabelProvider((IBaseLabelProvider)new DataSetLabelProvider());
            this.tbv.setInput(this.items);
            this.tbv.refresh();
            TableColumn attribute = new TableColumn(this.table, 16384);
            attribute.setText(Elements.UI_WIZARD_V2_METADATA_NAME_LABEL);
            attribute.setResizable(false);
            tableColumnLayout.setColumnData((Widget)attribute, (ColumnLayoutData)new ColumnWeightData(1));
            GridData tableGridData = new GridData(4, 4, true, false);
            tableGridData.heightHint = this.table.getHeaderHeight() + 5 * (this.table.getItemHeight() + 3);
            this.tableComp.setLayoutData((Object)tableGridData);
            Composite buttonColumn = new Composite((Composite)dsParametersGroup, 0);
            buttonColumn.setLayout((Layout)new GridLayout(1, false));
            buttonColumn.setLayoutData((Object)new GridData(1, 1, false, false));
            Button add = new Button(buttonColumn, 8);
            add.setLayoutData((Object)new GridData(4, 1, false, false));
            add.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_ADD);
            this.tbv.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent arg0) {
                    this.editSelectedAttribute();
                }
            });
            add.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    BPXYWDYNParameterDialog dialog = new BPXYWDYNParameterDialog(parent.getShell(), null);
                    dialog.open();
                    DatasetAttributes.DataSetParameter parameter = dialog.getParameter();
                    if (parameter != null) {
                        items.add(parameter);
                        tbv.refresh();
                        ItemDialogAttributes.refresh((Composite)table);
                    }
                }
            });
            final Button edit = new Button(buttonColumn, 8);
            edit.setLayoutData((Object)new GridData(4, 1, false, false));
            edit.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_EDIT);
            edit.setEnabled(false);
            edit.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    this.editSelectedAttribute();
                }
            });
            final Button remove = new Button(buttonColumn, 8);
            remove.setLayoutData((Object)new GridData(4, 1, false, false));
            remove.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_REMOVE);
            remove.setEnabled(false);
            remove.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    ISelection s = tbv.getSelection();
                    if (s instanceof IStructuredSelection) {
                        IStructuredSelection ss = (IStructuredSelection)s;
                        Iterator it = ss.iterator();
                        while (it.hasNext()) {
                            items.remove(it.next());
                        }
                        tbv.refresh();
                        ItemDialogAttributes.refresh((Composite)table);
                    }
                }
            });
            this.tbv.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    remove.setEnabled(!event.getSelection().isEmpty());
                    ISelection s = event.getSelection();
                    if (s instanceof IStructuredSelection) {
                        IStructuredSelection ss = (IStructuredSelection)s;
                        edit.setEnabled(ss.size() == 1);
                    }
                }
            });
            if (this.advancedTwisty != null) {
                this.advancedTwisty.addExpansionListener(new IExpansionListener(){

                    public void expansionStateChanged(ExpansionEvent arg0) {
                        ItemDialogAttributes.refresh((Composite)advancedTwisty);
                    }

                    public void expansionStateChanging(ExpansionEvent arg0) {
                    }
                });
            }
            this.composite.layout();
            this.cg.visible(false);
        }

        private void editSelectedAttribute() {
            IStructuredSelection ss;
            ISelection s = this.tbv.getSelection();
            if (s instanceof IStructuredSelection && (ss = (IStructuredSelection)s).size() == 1) {
                BPXYWDYNParameterDialog dialog = new BPXYWDYNParameterDialog(this.parent.getShell(), (DatasetAttributes.DataSetParameter)ss.getFirstElement());
                dialog.open();
                this.tbv.refresh();
                ItemDialogAttributes.refresh((Composite)this.table);
            }
        }

        public void setValue(DatasetAttributes attributes) {
            for (DatasetAttributes.DataSetParameter parameter : attributes.getAsList()) {
                this.items.add(parameter);
            }
            this.tbv.refresh();
            ItemDialogAttributes.refresh((Composite)this.table);
        }

        public DatasetAttributes getValue() {
            return new DatasetAttributes(this.items.toArray(new DatasetAttributes.DataSetParameter[0]));
        }

        public void setActive(boolean active) {
            this.cg.visible(active);
            this.tableComp.layout(true);
        }

        public static class DataSetContentProvider
        implements IStructuredContentProvider {
            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        public static class DataSetLabelProvider
        implements ITableLabelProvider {
            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                String result = "";
                if (element instanceof DatasetAttributes.DataSetParameter) {
                    DatasetAttributes.DataSetParameter dsp = (DatasetAttributes.DataSetParameter)element;
                    switch (columnIndex) {
                        case 0: {
                            result = dsp.getName();
                        }
                    }
                }
                return result;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        }
    }

    public static class BPXYWDYNParameterDialog
    extends Dialog {
        private Combo field;
        private DatasetAttributes.DataSetParameter parameter;

        public BPXYWDYNParameterDialog(Shell parentShell, DatasetAttributes.DataSetParameter parameter) {
            super(parentShell);
            this.parameter = parameter;
        }

        public void okPressed() {
            String value = this.field.getText();
            if (value != null && value.length() > 0) {
                if (this.parameter == null) {
                    this.parameter = new DatasetAttributes.DataSetParameter(this.field.getText());
                } else {
                    this.parameter.setName(value);
                }
            }
            super.okPressed();
        }

        public void cancelPressed() {
            this.parameter = null;
            super.cancelPressed();
        }

        public DatasetAttributes.DataSetParameter getParameter() {
            return this.parameter;
        }

        public Control createDialogArea(Composite outer) {
            this.getShell().setText(this.parameter == null ? Elements.UI_WIZARD_V2_ITEM_DIALOG_FIELD_ADD_TITLE : Elements.UI_WIZARD_V2_ITEM_DIALOG_FIELD_EDIT_TITLE);
            Composite composite = new Composite(outer, 0);
            composite.setLayoutData((Object)new GridData(4, 1, true, false));
            composite.setLayout((Layout)new GridLayout(1, false));
            StyledText descText = new StyledText(composite, 72);
            descText.setText(this.parameter == null ? Elements.UI_WIZARD_V2_ITEM_DIALOG_FIELD_ADD_DESC : Elements.UI_WIZARD_V2_ITEM_DIALOG_FIELD_EDIT_DESC);
            GridData gd = new GridData(16384, 0x1000000, false, false);
            gd.widthHint = this.convertWidthInCharsToPixels(50);
            descText.setLayoutData((Object)gd);
            descText.setBackground(composite.getDisplay().getSystemColor(22));
            this.field = new Combo(composite, 0);
            this.field.setFocus();
            this.field.setItems(BPXYWDYN);
            this.field.setLayoutData((Object)new GridData(4, 1, true, false));
            this.field.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    Point p = ItemDialogAttributes.findSelectionPoint(field.getText());
                    if (p != null) {
                        field.setSelection(p);
                    }
                }
            });
            if (this.parameter != null) {
                this.field.setText(this.parameter.getName());
            }
            return composite;
        }
    }

    public static enum DataSetDelimiterPosition {
        PREFIX(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_DELIMITER_POSITION_PREFIX, "prefix"),
        POSTFIX(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_DELIMITER_POSITION_POSTFIX, "postfix");

        private final String nlsMessage;
        private final String dataSetDelimiter;

        private DataSetDelimiterPosition(String nlsMessage, String dataSetDelimiter) {
            this.nlsMessage = nlsMessage;
            this.dataSetDelimiter = dataSetDelimiter;
        }

        public static String[] getAllNames() {
            ArrayList<String> names = new ArrayList<String>();
            DataSetDelimiterPosition[] dataSetDelimiterPositionArray = DataSetDelimiterPosition.values();
            int n = dataSetDelimiterPositionArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataSetDelimiterPosition dp = dataSetDelimiterPositionArray[n2];
                names.add(dp.nlsMessage);
                ++n2;
            }
            return names.toArray(new String[0]);
        }

        public static DataSetDelimiterPosition getByPosition(int position) {
            return position >= 0 && position < DataSetDelimiterPosition.values().length ? DataSetDelimiterPosition.values()[position] : null;
        }

        public static DataSetDelimiterPosition getByDataSetDelimiter(String dataSetDelimiter) {
            DataSetDelimiterPosition[] dataSetDelimiterPositionArray = DataSetDelimiterPosition.values();
            int n = dataSetDelimiterPositionArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataSetDelimiterPosition dp = dataSetDelimiterPositionArray[n2];
                if (dp.dataSetDelimiter.equalsIgnoreCase(dataSetDelimiter)) {
                    return dp;
                }
                ++n2;
            }
            return null;
        }

        public String getNLSMessage() {
            return this.nlsMessage;
        }

        public String getDataSetDelimiter() {
            return this.dataSetDelimiter;
        }

        public int getPosition() {
            return this.ordinal();
        }
    }

    public static class DestinationDataSetAttributes
    implements ItemDialogContents {
        private final ControlGroup cg = new ControlGroup("Destination data set Attributes Content");
        private final BPXWDYNAttributes attr;
        private final Button overwriteButton;
        private final Button oversizeRecWrapped;
        private final Button oversizeRecTruncated;
        private final ExpandableComposite advancedTwisty;
        private final Composite dataSetComp;
        private final ItemDialog outerDialog;

        public DestinationDataSetAttributes(Composite parent, ItemDialog outerDialogParm) {
            this.outerDialog = outerDialogParm;
            this.dataSetComp = new Composite(parent, 0);
            this.dataSetComp.setLayout((Layout)new GridLayout(1, false));
            this.dataSetComp.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.cg.add((Control)this.dataSetComp);
            this.overwriteButton = new Button(this.dataSetComp, 32);
            this.overwriteButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_OVERWRITE_BUTTON);
            this.overwriteButton.setToolTipText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_OVERWRITE_BUTTON_TOOLTIP);
            this.cg.add((Control)this.overwriteButton);
            this.attr = new BPXWDYNAttributes(this.dataSetComp, false);
            this.advancedTwisty = new ExpandableComposite(this.dataSetComp, 0, 18);
            this.advancedTwisty.marginWidth = 15;
            this.advancedTwisty.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_ADVANCED_TITLE);
            this.advancedTwisty.setExpanded(false);
            this.advancedTwisty.setEnabled(false);
            this.advancedTwisty.setLayoutData((Object)new GridData(4, 1, true, true));
            Composite buttons = new Composite((Composite)this.advancedTwisty, 0);
            this.advancedTwisty.setClient((Control)buttons);
            Tools.accessibleLabel(buttons, Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_OVERSIZE_LABEL);
            buttons.setLayout((Layout)Tools.indentedGridLayout(1));
            buttons.setLayoutData((Object)new GridData(1, 1, false, false));
            this.oversizeRecWrapped = new Button(buttons, 16);
            this.oversizeRecWrapped.setLayoutData((Object)new GridData(4, 1, false, false));
            this.oversizeRecWrapped.setText(TransferItem.OversizeDatasetRecord.WRAP.getName());
            this.oversizeRecWrapped.setSelection(true);
            this.oversizeRecTruncated = new Button(buttons, 16);
            this.oversizeRecTruncated.setText(TransferItem.OversizeDatasetRecord.TRUNCATE.getName());
            this.oversizeRecTruncated.setLayoutData((Object)new GridData(4, 1, false, false));
            this.advancedTwisty.addExpansionListener(new IExpansionListener(){

                public void expansionStateChanged(ExpansionEvent arg0) {
                    outerDialog.refresh();
                }

                public void expansionStateChanging(ExpansionEvent arg0) {
                }
            });
        }

        @Override
        public void setActive(boolean active) {
            this.cg.visible(active);
            this.attr.setActive(active);
        }

        @Override
        public PriorityStatus validate(boolean withVarSt) {
            return new PriorityStatus(null);
        }

        @Override
        public void saveHistory() {
        }

        public void setAttributes(DatasetAttributes da) {
            this.attr.setValue(da);
        }

        public DatasetAttributes getAttributes() {
            return this.attr.getValue();
        }

        public void setDestinationDisposition(TransferItem.DestinationDispositionType value) {
            this.overwriteButton.setSelection(value.equals((Object)TransferItem.DestinationDispositionType.OVERWRITE));
        }

        public TransferItem.DestinationDispositionType getDestinationDisposition() {
            return this.overwriteButton.getSelection() ? TransferItem.DestinationDispositionType.OVERWRITE : TransferItem.DestinationDispositionType.ERROR;
        }

        public void setOverSizeDatasetRecord(TransferItem.OversizeDatasetRecord oversizeDatasetRecord) {
            this.oversizeRecTruncated.setSelection(oversizeDatasetRecord.isTruncate());
            this.oversizeRecWrapped.setSelection(!oversizeDatasetRecord.isTruncate());
        }

        public TransferItem.OversizeDatasetRecord getOverSizeDatasetRecord() {
            return this.oversizeRecTruncated.getSelection() ? TransferItem.OversizeDatasetRecord.TRUNCATE : TransferItem.OversizeDatasetRecord.WRAP;
        }

        public boolean isOverSizeTruncated() {
            return this.oversizeRecTruncated.getSelection();
        }

        public void setTransferMode(boolean textMode) {
            this.advancedTwisty.setEnabled(textMode);
            if (!textMode) {
                this.advancedTwisty.setExpanded(false);
                this.outerDialog.refresh();
            }
        }
    }

    public static class DestinationFileAttributes
    implements ItemDialogContents {
        private final ControlGroup cg = new ControlGroup("Destination file Attributes Content");
        private final Button overwriteButton;
        final ExpandableComposite advancedTwisty;
        private final Button defaultButton;
        private final Button specificDistributionTypeButton;
        private final Combo specificDistributionTypeCombo;
        private final Map<String, String> distributionTypes = new LinkedHashMap<String, String>(6){
            private static final long serialVersionUID = -4395309825526763178L;
            {
                super($anonymous0);
                this.put(Elements.UI_WIZARD_V2_ITEM_DIALOG_DISTRIB_LOCAL, "DIST(LOCAL)");
                this.put(Elements.UI_WIZARD_V2_ITEM_DIALOG_DISTRIB_MIRROR_UPDATE, "DIST(MIRRORED,UPDATE)");
                this.put(Elements.UI_WIZARD_V2_ITEM_DIALOG_DISTRIB_MIRROR_CLOSE, "DIST(MIRRORED,CLOSE)");
                this.put(Elements.UI_WIZARD_V2_ITEM_DIALOG_DISTRIB_COMPOUND_UPDATE, "DIST(COMPOUND,UPDATE)");
                this.put(Elements.UI_WIZARD_V2_ITEM_DIALOG_DISTRIB_COMPOUND_CLOSE, "DIST(COMPOUND,CLOSE)");
            }
        };

        public DestinationFileAttributes(Composite parent, EnvironmentInformation destinationEnvironment) {
            Composite destFileComp = new Composite(parent, 0);
            destFileComp.setLayout((Layout)new GridLayout(1, false));
            destFileComp.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.cg.add((Control)destFileComp);
            this.overwriteButton = new Button(destFileComp, 32);
            this.overwriteButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_FILE_OVERWRITE_BUTTON);
            this.overwriteButton.setToolTipText(Elements.UI_WIZARD_V2_ITEM_DIALOG_FILE_OVERWRITE_BUTTON_TOOLTIP);
            this.cg.add((Control)this.overwriteButton);
            if (destinationEnvironment.getAgentDetails().isOSPlatform("4690 OS")) {
                this.advancedTwisty = new ExpandableComposite(destFileComp, 0, 18);
                this.advancedTwisty.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_FILE_ADVANCED);
                this.advancedTwisty.setExpanded(false);
                this.advancedTwisty.setEnabled(true);
                this.advancedTwisty.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
                this.cg.add((Control)this.advancedTwisty);
                Composite advancedComposite = new Composite((Composite)this.advancedTwisty, 0);
                advancedComposite.setLayout((Layout)new GridLayout(2, false));
                advancedComposite.setLayoutData((Object)new GridData(4, 1, true, false));
                this.cg.add((Control)advancedComposite);
                this.advancedTwisty.setClient((Control)advancedComposite);
                Group distributionTypeGroup = new Group(advancedComposite, 0);
                distributionTypeGroup.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DISTRIB_TYPE_TITLE);
                distributionTypeGroup.setLayout((Layout)new GridLayout(2, false));
                distributionTypeGroup.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
                this.defaultButton = new Button((Composite)distributionTypeGroup, 16);
                this.defaultButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DISTRIB_DEFAULT_BUTTON);
                this.defaultButton.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
                this.defaultButton.setSelection(true);
                this.specificDistributionTypeButton = new Button((Composite)distributionTypeGroup, 16);
                this.specificDistributionTypeButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DISTRIB_SPECIFIC_BUTTON);
                this.specificDistributionTypeButton.setLayoutData((Object)new GridData(4, 1, false, false));
                this.specificDistributionTypeCombo = new Combo((Composite)distributionTypeGroup, 8);
                this.specificDistributionTypeCombo.setLayoutData((Object)new GridData(1, 1, false, false));
                this.specificDistributionTypeCombo.setItems(this.distributionTypes.keySet().toArray(new String[0]));
                this.specificDistributionTypeCombo.select(0);
                this.specificDistributionTypeCombo.setEnabled(false);
                this.specificDistributionTypeButton.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        specificDistributionTypeCombo.setEnabled(specificDistributionTypeButton.getSelection());
                    }
                });
                if (this.advancedTwisty != null) {
                    this.advancedTwisty.addExpansionListener(new IExpansionListener(){

                        public void expansionStateChanged(ExpansionEvent e) {
                            ItemDialogAttributes.refresh((Composite)advancedTwisty);
                        }

                        public void expansionStateChanging(ExpansionEvent e) {
                        }
                    });
                }
            } else {
                this.advancedTwisty = null;
                this.defaultButton = null;
                this.specificDistributionTypeButton = null;
                this.specificDistributionTypeCombo = null;
            }
        }

        @Override
        public void setActive(boolean active) {
            this.cg.visible(active);
        }

        @Override
        public PriorityStatus validate(boolean withVarSt) {
            return new PriorityStatus(null);
        }

        public void setDestinationDisposition(TransferItem.DestinationDispositionType value) {
            this.overwriteButton.setSelection(value.equals((Object)TransferItem.DestinationDispositionType.OVERWRITE));
        }

        public TransferItem.DestinationDispositionType getDestinationDisposition() {
            return this.overwriteButton.getSelection() ? TransferItem.DestinationDispositionType.OVERWRITE : TransferItem.DestinationDispositionType.ERROR;
        }

        public void setSpecificDistributionType(String type) {
            if (this.defaultButton == null || this.defaultButton.isDisposed()) {
                return;
            }
            if (type == null) {
                this.defaultButton.setSelection(true);
                this.specificDistributionTypeButton.setSelection(false);
                this.advancedTwisty.setExpanded(false);
            } else {
                this.defaultButton.setSelection(false);
                this.specificDistributionTypeButton.setSelection(true);
                int pos = 0;
                for (Map.Entry<String, String> entry : this.distributionTypes.entrySet()) {
                    if (type.equals(entry.getValue())) {
                        this.specificDistributionTypeCombo.select(pos);
                    }
                    ++pos;
                }
                this.advancedTwisty.setExpanded(true);
            }
            this.specificDistributionTypeButton.notifyListeners(13, new Event());
            this.advancedTwisty.notifyListeners(17, new Event());
        }

        public String getSpecificDistributionType() {
            String specificDistributionType = null;
            if (this.specificDistributionTypeButton != null && this.specificDistributionTypeButton.getSelection()) {
                specificDistributionType = this.distributionTypes.get(this.specificDistributionTypeCombo.getText());
            }
            return specificDistributionType;
        }

        @Override
        public void saveHistory() {
        }
    }

    public static class DestinationQueueAttributes
    implements ItemDialogContents {
        private final ControlGroup cg = new ControlGroup("Destination queue attributes Content");
        private final Combo persistenceCombo;
        private final Button includeRFHButton;
        private final Button splitMessageButton;
        private final Button messageSizeButton;
        private final Button messageDelimiterButton;
        private final Spinner sizeSpinner;
        private final Combo unitCombo;
        private final Combo delimiterCombo;
        private final Label delimiterInfoLabel;
        private final Combo delimiterPositionCombo;
        private final Button includeDelimiter;
        private boolean textMode = false;

        public DestinationQueueAttributes(Composite parent) {
            final ExpandableComposite advancedTwisty = new ExpandableComposite(parent, 0, 18);
            advancedTwisty.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_ADVANCED);
            advancedTwisty.setExpanded(false);
            advancedTwisty.setEnabled(true);
            advancedTwisty.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.cg.add((Control)advancedTwisty);
            Composite composite = new Composite((Composite)advancedTwisty, 0);
            advancedTwisty.setClient((Control)composite);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 1, true, false));
            this.cg.add((Control)composite);
            Label messagePersistenceLabel = new Label(composite, 0);
            messagePersistenceLabel.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_PERSISTENCE_LABEL);
            messagePersistenceLabel.setLayoutData((Object)new GridData(1, 1, false, false));
            this.persistenceCombo = new Combo(composite, 8);
            this.persistenceCombo.setLayoutData((Object)new GridData(1, 1, false, false));
            this.persistenceCombo.setItems(QueueProperties.DelimiterType.PersistenceType.getAllNLSMessages());
            this.persistenceCombo.select(0);
            this.includeRFHButton = new Button(composite, 32);
            this.includeRFHButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            this.includeRFHButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_INCLUDE_RFH);
            this.includeRFHButton.setToolTipText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_INCLUDE_RFH_TOOLTIP);
            Group delimiterGroup = new Group(composite, 0);
            delimiterGroup.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            delimiterGroup.setLayout((Layout)new GridLayout(1, false));
            delimiterGroup.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_GROUP);
            this.splitMessageButton = new Button((Composite)delimiterGroup, 32);
            this.splitMessageButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_SPLIT);
            ItemDialogAttributes.addListener((Control)this.splitMessageButton);
            final ControlGroup splitByCG = new ControlGroup("split by queue attributes Content");
            final ControlGroup sizeCG = new ControlGroup("split by size queue attributes Content");
            final ControlGroup delimiterCG = new ControlGroup("split by delimiter queue attributes Content");
            Composite splitByComposite = new Composite((Composite)delimiterGroup, 0);
            splitByComposite.setLayoutData((Object)new GridData(4, 1, true, false));
            splitByComposite.setLayout((Layout)ItemDialogAttributes.indentedGridLayout(2));
            this.messageSizeButton = new Button(splitByComposite, 16);
            this.messageSizeButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_DELIMITER_SIZE);
            this.messageSizeButton.setSelection(true);
            GridData gd = new GridData();
            this.messageSizeButton.setLayoutData((Object)gd);
            ItemDialogAttributes.addListener((Control)this.messageSizeButton);
            splitByCG.add((Control)this.messageSizeButton);
            Composite unitComposite = new Composite(splitByComposite, 0);
            unitComposite.setLayoutData((Object)new GridData(4, 1, false, false));
            unitComposite.setLayout((Layout)Tools.noMarginGridLayout(2));
            this.sizeSpinner = new Spinner(unitComposite, 2048);
            this.sizeSpinner.setMinimum(1);
            this.sizeSpinner.setIncrement(1);
            this.sizeSpinner.setMaximum(QueueProperties.Unit.B.getMaxFieldSize());
            sizeCG.add((Control)this.sizeSpinner);
            this.unitCombo = new Combo(unitComposite, 8);
            this.unitCombo.setLayoutData((Object)new GridData(1, 1, false, false));
            this.unitCombo.setItems(QueueProperties.Unit.getAllNLSmessages());
            this.unitCombo.select(0);
            sizeCG.add((Control)this.unitCombo);
            splitByCG.add(sizeCG);
            this.messageDelimiterButton = new Button(splitByComposite, 16);
            this.messageDelimiterButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_DELIMITER_BYTE);
            GridData gd2 = new GridData();
            this.messageDelimiterButton.setLayoutData((Object)gd2);
            ItemDialogAttributes.addListener((Control)this.messageDelimiterButton);
            splitByCG.add((Control)this.messageDelimiterButton);
            this.delimiterCombo = new Combo(splitByComposite, 0);
            this.delimiterCombo.setLayoutData((Object)new GridData(4, 1, false, false));
            ItemDialogAttributes.addListener((Control)this.delimiterCombo);
            delimiterCG.add((Control)this.delimiterCombo);
            Label padding = new Label(splitByComposite, 0);
            splitByCG.add((Control)padding);
            this.delimiterInfoLabel = new Label(splitByComposite, 0);
            this.delimiterInfoLabel.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_INFO_BYTE);
            gd2 = new GridData(4, 0x1000000, true, false);
            this.delimiterInfoLabel.setLayoutData((Object)gd2);
            delimiterCG.add((Control)this.delimiterInfoLabel);
            Label delimiterPositionLabel = new Label(splitByComposite, 0);
            delimiterPositionLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            delimiterPositionLabel.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_DELIMITER_POSITION);
            delimiterCG.add((Control)delimiterPositionLabel);
            this.delimiterPositionCombo = new Combo(splitByComposite, 8);
            this.delimiterPositionCombo.setLayoutData((Object)new GridData(1, 1, false, false));
            this.delimiterPositionCombo.setItems(QueueProperties.DelimiterPosition.getAllNames());
            this.delimiterPositionCombo.select(0);
            delimiterCG.add((Control)this.delimiterPositionCombo);
            Composite includeComposite = new Composite((Composite)delimiterGroup, 0);
            includeComposite.setLayoutData((Object)new GridData(4, 1, true, false));
            includeComposite.setLayout((Layout)ItemDialogAttributes.indentedGridLayout(1));
            this.includeDelimiter = new Button(includeComposite, 32);
            this.includeDelimiter.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_INCLUDE_BYTE);
            this.includeDelimiter.setLayoutData((Object)new GridData(1, 1, false, false));
            delimiterCG.add((Control)this.includeDelimiter);
            splitByCG.add(delimiterCG);
            if (advancedTwisty != null) {
                advancedTwisty.addExpansionListener(new IExpansionListener(){

                    public void expansionStateChanged(ExpansionEvent arg0) {
                        ItemDialogAttributes.refresh((Composite)advancedTwisty);
                    }

                    public void expansionStateChanging(ExpansionEvent arg0) {
                    }
                });
            }
            this.messageSizeButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    sizeCG.enabled(messageSizeButton.getSelection());
                }
            });
            this.messageDelimiterButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    delimiterCG.enabled(messageDelimiterButton.getSelection());
                }
            });
            this.splitMessageButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    splitByCG.enabled(splitMessageButton.getSelection());
                    if (splitMessageButton.getSelection()) {
                        messageSizeButton.notifyListeners(13, new Event());
                        messageDelimiterButton.notifyListeners(13, new Event());
                    }
                }
            });
            this.unitCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    QueueProperties.Unit newUnit = QueueProperties.Unit.getByPosition(unitCombo.getSelectionIndex());
                    int maxSize = newUnit.getMaxFieldSize();
                    sizeSpinner.setMaximum(maxSize);
                    if (sizeSpinner.getSelection() > maxSize) {
                        sizeSpinner.setMaximum(maxSize);
                    }
                }
            });
            this.splitMessageButton.notifyListeners(13, new Event());
        }

        @Override
        public void setActive(boolean active) {
            this.cg.visible(active);
        }

        @Override
        public PriorityStatus validate(boolean withVarSt) {
            PriorityStatus status = new PriorityStatus(null);
            if (this.splitMessageButton.getSelection() && this.messageDelimiterButton.getSelection()) {
                String delSeq = this.delimiterCombo.getText();
                if (delSeq == null || delSeq.length() == 0) {
                    status.setIncomplete();
                } else if (!this.textMode && !CmdLinePropertyValueValidator.MsgBinaryDelimiterValidator.pattern.matcher(delSeq).matches()) {
                    status.setError(Elements.UI_WIZARD_V2_ITEM_DIALOG_QUEUE_BIN_ILL_DEL);
                }
            }
            return status;
        }

        public void setTransferMode(boolean textMode) {
            this.textMode = textMode;
            if (textMode) {
                this.messageDelimiterButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_DELIMITER_TEXT);
                this.includeDelimiter.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_INCLUDE_TEXT);
                this.delimiterInfoLabel.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_INFO_TEXT);
                SectionHistory.HistoryReference.QUEUE_DELIMITER_TEXT.loadHistory(this.delimiterCombo);
            } else {
                this.messageDelimiterButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_DELIMITER_BYTE);
                this.includeDelimiter.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_QUEUE_INCLUDE_BYTE);
                this.delimiterInfoLabel.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_INFO_BYTE);
                SectionHistory.HistoryReference.QUEUE_DELIMITER_BYTE.loadHistory(this.delimiterCombo);
            }
        }

        @Override
        public void saveHistory() {
            if (this.textMode) {
                SectionHistory.HistoryReference.QUEUE_DELIMITER_TEXT.put(this.delimiterCombo);
            } else {
                SectionHistory.HistoryReference.QUEUE_DELIMITER_BYTE.put(this.delimiterCombo);
            }
        }

        public void setAttributes(QueueProperties.MessageDestination md) {
            if (md.getPersistence() != null) {
                this.persistenceCombo.select(md.getPersistence().getPosition());
            }
            this.includeRFHButton.setSelection(md.includeProperties());
            QueueProperties.MessageDelimiter delimiter = md.getDelimiter();
            if (delimiter != null) {
                this.splitMessageButton.setSelection(true);
                if (delimiter instanceof QueueProperties.MessageDelimiterBinary) {
                    QueueProperties.MessageDelimiterBinary mdb = (QueueProperties.MessageDelimiterBinary)delimiter;
                    this.messageDelimiterButton.setSelection(true);
                    this.messageSizeButton.setSelection(false);
                    this.delimiterCombo.setText(mdb.getField());
                    this.delimiterPositionCombo.select(mdb.getPostion().getPosition());
                    this.includeDelimiter.setSelection(mdb.includeDelimiter().booleanValue());
                } else if (delimiter instanceof QueueProperties.MessageDelimiterText) {
                    QueueProperties.MessageDelimiterText mdt = (QueueProperties.MessageDelimiterText)delimiter;
                    this.messageDelimiterButton.setSelection(true);
                    this.messageSizeButton.setSelection(false);
                    this.delimiterCombo.setText(mdt.getField());
                    this.delimiterPositionCombo.select(mdt.getPostion().getPosition());
                    this.includeDelimiter.setSelection(mdt.includeDelimiter().booleanValue());
                } else if (delimiter instanceof QueueProperties.MessageDelimiterSize) {
                    QueueProperties.MessageDelimiterSize mds = (QueueProperties.MessageDelimiterSize)delimiter;
                    this.messageSizeButton.setSelection(true);
                    this.messageDelimiterButton.setSelection(false);
                    this.sizeSpinner.setSelection(mds.getSize());
                    this.unitCombo.select(mds.getUnit().getPosition());
                }
            }
            this.splitMessageButton.notifyListeners(13, new Event());
        }

        public QueueProperties.MessageDestination getAttributes() {
            QueueProperties.MessageDestination md;
            QueueProperties.DelimiterType.PersistenceType persistanceOption = QueueProperties.DelimiterType.PersistenceType.getByPosition(this.persistenceCombo.getSelectionIndex());
            if (this.splitMessageButton.getSelection()) {
                if (this.messageSizeButton.getSelection()) {
                    md = QueueProperties.MessageDestination.createDestinationSizeDelimitedMessage(persistanceOption, this.includeRFHButton.getSelection(), this.sizeSpinner.getSelection(), QueueProperties.Unit.getByIndex(this.unitCombo.getSelectionIndex()));
                } else {
                    QueueProperties.DelimiterPosition delimiterPosition = QueueProperties.DelimiterPosition.getByPosition(this.delimiterPositionCombo.getSelectionIndex());
                    md = this.textMode ? QueueProperties.MessageDestination.createDestinationTextDelimitedMessage(persistanceOption, this.includeRFHButton.getSelection(), delimiterPosition, this.delimiterCombo.getText(), this.includeDelimiter.getSelection()) : QueueProperties.MessageDestination.createDestinationBinaryDelimitedMessage(persistanceOption, this.includeRFHButton.getSelection(), delimiterPosition, this.delimiterCombo.getText(), this.includeDelimiter.getSelection());
                }
            } else {
                md = new QueueProperties.MessageDestination(persistanceOption, this.includeRFHButton.getSelection(), null);
            }
            return md;
        }
    }

    public static class EOLAttributes
    implements ItemDialogContents {
        private final ControlGroup cg = new ControlGroup("EOL Attributes Content");
        private final Combo eolCombo;

        public EOLAttributes(Composite parent, String toolTip) {
            this.cg.visible(true);
            Composite eolComp = new Composite(parent, 0);
            eolComp.setLayout((Layout)new GridLayout(2, false));
            eolComp.setLayoutData((Object)new GridData(4, 1, true, false));
            Label label = new Label(eolComp, 0);
            label.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DEST_EOL);
            this.cg.add((Control)label);
            this.eolCombo = new Combo(eolComp, 8);
            this.eolCombo.setLayoutData((Object)new GridData(1, 1, false, false));
            this.eolCombo.setToolTipText(toolTip);
            this.eolCombo.setItems(EOLOption.getAllNLSMessages());
            this.eolCombo.select(0);
            this.cg.add((Control)this.eolCombo);
        }

        public String getValue() {
            EOLOption eolOption = EOLOption.getByPosition(this.eolCombo.getSelectionIndex());
            return eolOption.getValue();
        }

        public EOLOption getType() {
            return EOLOption.getByPosition(this.eolCombo.getSelectionIndex());
        }

        @Override
        public void setActive(boolean active) {
            this.cg.visible(active);
        }

        public void setValue(String value) {
            EOLOption eolOption;
            int index = 0;
            if (value != null && (eolOption = EOLOption.getByValue(value)) != null) {
                index = eolOption.getPosition();
            }
            this.eolCombo.select(index);
        }

        @Override
        public PriorityStatus validate(boolean withVarSt) {
            return new PriorityStatus(null);
        }

        @Override
        public void saveHistory() {
        }
    }

    public static enum EOLOption {
        AGENT_DEFAULT(null, Elements.UI_WIZARD_V2_ITEM_DIALOG_AGENT_DEFAULT_EOL),
        CRLF("CRLF", "CRLF"),
        LF("LF", "LF");

        private String value;
        private String nlsMessage;

        private EOLOption(String value, String nlsMessage) {
            this.value = value;
            this.nlsMessage = nlsMessage;
        }

        public String getValue() {
            return this.value;
        }

        public String getNLSMessage() {
            return this.nlsMessage;
        }

        public int getPosition() {
            return this.ordinal();
        }

        public static String[] getAllNLSMessages() {
            ArrayList<String> names = new ArrayList<String>();
            EOLOption[] eOLOptionArray = EOLOption.values();
            int n = eOLOptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                EOLOption option = eOLOptionArray[n2];
                names.add(option.nlsMessage);
                ++n2;
            }
            return names.toArray(new String[0]);
        }

        public static EOLOption getByPosition(int index) {
            return EOLOption.values()[index];
        }

        public static EOLOption getByValue(String value) {
            EOLOption[] eOLOptionArray = EOLOption.values();
            int n = eOLOptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                EOLOption option = eOLOptionArray[n2];
                if (option.value != null && option.value.equals(value)) {
                    return option;
                }
                ++n2;
            }
            return null;
        }
    }

    public static class EncodingAttributes
    implements ItemDialogContents {
        private final ControlGroup cg = new ControlGroup("Encoding Attributes Content");
        private final Button defaultEncodingButton;
        private final Button userEncodingButton;
        private final Combo encodingCombo;
        private final String missingSpecificCodePageMsg;
        private boolean active = true;

        public EncodingAttributes(Composite parent, String groupTitle, String toolTip, String missingSpecificCodePageMsg) {
            this.missingSpecificCodePageMsg = missingSpecificCodePageMsg;
            this.cg.visible(true);
            Group encodingGroup = new Group(parent, 0);
            encodingGroup.setText(groupTitle);
            encodingGroup.setLayout((Layout)new GridLayout(2, false));
            encodingGroup.setLayoutData((Object)new GridData(4, 1, true, false));
            this.cg.add((Control)encodingGroup);
            this.defaultEncodingButton = new Button((Composite)encodingGroup, 16);
            this.defaultEncodingButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DEFAULT_ENCODING_BUTTON);
            this.defaultEncodingButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            this.defaultEncodingButton.setSelection(true);
            this.cg.add((Control)this.defaultEncodingButton);
            this.userEncodingButton = new Button((Composite)encodingGroup, 16);
            this.userEncodingButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DEFINED_ENCODING_BUTTON);
            this.cg.add((Control)this.userEncodingButton);
            this.encodingCombo = new Combo((Composite)encodingGroup, 0);
            this.encodingCombo.setToolTipText(toolTip);
            this.encodingCombo.setLayoutData((Object)new GridData(4, 1, true, false));
            this.encodingCombo.setEnabled(false);
            SectionHistory.HistoryReference.TEXT_ENCODING.loadHistory(this.encodingCombo);
            ItemDialogAttributes.addListener((Control)this.defaultEncodingButton);
            ItemDialogAttributes.addListener((Control)this.userEncodingButton);
            ItemDialogAttributes.addListener((Control)this.encodingCombo);
            this.userEncodingButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    encodingCombo.setEnabled(userEncodingButton.getSelection());
                }
            });
        }

        public String getValue() {
            return this.defaultEncodingButton.getSelection() ? null : this.encodingCombo.getText();
        }

        @Override
        public void setActive(boolean active) {
            this.active = active;
            this.cg.visible(active);
        }

        public void setValue(String value) {
            this.defaultEncodingButton.setSelection(value == null);
            this.userEncodingButton.setSelection(value != null);
            this.encodingCombo.setText(value == null ? "" : value);
            this.encodingCombo.setEnabled(value != null);
        }

        @Override
        public PriorityStatus validate(boolean withVarSt) {
            String encodingValue;
            PriorityStatus priorityStatus = new PriorityStatus(null);
            if (this.active && this.userEncodingButton.getSelection() && ((encodingValue = this.encodingCombo.getText()) == null || encodingValue.length() == 0)) {
                priorityStatus.setError(this.missingSpecificCodePageMsg);
            }
            return priorityStatus;
        }

        @Override
        public void saveHistory() {
            SectionHistory.HistoryReference.TEXT_ENCODING.put(this.encodingCombo);
        }
    }

    public static class SourceDataSetAttributes
    implements ItemDialogContents {
        private final ControlGroup cg = new ControlGroup("Source data set Attributes Content");
        private final ControlGroup cgBinaryMode = new ControlGroup("Source data set Attributes/binary mode");
        private final ControlGroup cgTextMode = new ControlGroup("Source data set Attributes/text mode");
        private final ControlGroup delimiterInnerCG = new ControlGroup("Delimiter inner queue attributes Content");
        private final Composite composite;
        private final Button removeButton;
        private final Button trailPadButton;
        private final BPXWDYNAttributes attr;
        private final Button addDelimiterButton;
        private final Combo delimiterCombo;
        private final Label delimiterInfoLabel;
        private final Combo delimiterPositionCombo;
        private boolean textMode = false;
        private ExpandableComposite advancedTwisty = null;

        public SourceDataSetAttributes(Composite parent, int singleCharPixelHeight) {
            Composite dataSetComp = new Composite(parent, 0);
            dataSetComp.setLayout((Layout)new GridLayout(1, false));
            dataSetComp.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.cg.add((Control)dataSetComp);
            this.removeButton = new Button(dataSetComp, 32);
            this.removeButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_DELETE_SOURCE_BUTTON);
            this.removeButton.setToolTipText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_DELETE_SOURCE_BUTTON_TOOLTIP);
            this.cg.add((Control)this.removeButton);
            this.trailPadButton = new Button(dataSetComp, 32);
            this.trailPadButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_TRAIL_PAD_BUTTON);
            this.trailPadButton.setToolTipText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_TRAIL_PAD_BUTTON_TOOLTIP);
            this.cgTextMode.add((Control)this.trailPadButton);
            this.cg.add(this.cgTextMode);
            this.advancedTwisty = new ExpandableComposite(dataSetComp, 0, 18);
            this.advancedTwisty.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_PARAMETERS_TWISTY);
            this.advancedTwisty.setExpanded(true);
            this.advancedTwisty.setEnabled(true);
            GridData gd = new GridData(4, 1, true, false);
            this.advancedTwisty.setLayoutData((Object)gd);
            this.advancedTwisty.setLayout((Layout)new GridLayout(1, true));
            this.composite = new Composite((Composite)this.advancedTwisty, 0);
            this.advancedTwisty.setClient((Control)this.composite);
            this.composite.setLayout((Layout)new GridLayout(1, false));
            this.composite.setLayoutData((Object)new GridData(4, 1, false, false));
            Group recrdDelimiterGroup = new Group(this.composite, 0);
            recrdDelimiterGroup.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_DELIMITER_GROUP);
            recrdDelimiterGroup.setLayoutData((Object)new GridData(4, 1, false, false));
            recrdDelimiterGroup.setLayout((Layout)new GridLayout(1, false));
            this.cgBinaryMode.add((Control)recrdDelimiterGroup);
            this.addDelimiterButton = new Button((Composite)recrdDelimiterGroup, 32);
            this.addDelimiterButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_DELIMITER_AS_BYTE);
            this.addDelimiterButton.setLayoutData((Object)new GridData(1, 1, false, false));
            ItemDialogAttributes.addListener((Control)this.addDelimiterButton);
            this.cgBinaryMode.add((Control)this.addDelimiterButton);
            Composite delimiterOptionGroup = new Composite((Composite)recrdDelimiterGroup, 0);
            delimiterOptionGroup.setLayoutData((Object)new GridData(4, 1, true, false));
            delimiterOptionGroup.setLayout((Layout)ItemDialogAttributes.indentedGridLayout(2));
            this.delimiterInnerCG.add((Control)delimiterOptionGroup);
            int labelWidth = Tools.getWidth(delimiterOptionGroup, new String[]{Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_BYTE_LABEL, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_TEXT_LABEL, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_POSITION_LABEL});
            Label delimiterLabel = ItemDialogAttributes.fixedWidthLabel(delimiterOptionGroup, labelWidth, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_BYTE_LABEL);
            this.delimiterInnerCG.add((Control)delimiterLabel);
            this.delimiterCombo = new Combo(delimiterOptionGroup, 0);
            this.delimiterCombo.setLayoutData((Object)new GridData(4, 1, true, false));
            SectionHistory.HistoryReference.DATASET_DELIMITER_BYTE.loadHistory(this.delimiterCombo);
            this.delimiterInnerCG.add((Control)this.delimiterCombo);
            ItemDialogAttributes.addListener((Control)this.delimiterCombo);
            new Label(delimiterOptionGroup, 0);
            this.delimiterInfoLabel = new Label(delimiterOptionGroup, 0);
            this.delimiterInfoLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.delimiterInfoLabel.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_DELIMITER_INFO_BYTE);
            this.delimiterInnerCG.add((Control)this.delimiterInfoLabel);
            Label delimiterPositionLabel = ItemDialogAttributes.fixedWidthLabel(delimiterOptionGroup, labelWidth, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_POSITION_LABEL);
            this.delimiterInnerCG.add((Control)delimiterPositionLabel);
            this.delimiterPositionCombo = new Combo(delimiterOptionGroup, 8);
            this.delimiterPositionCombo.setLayoutData((Object)new GridData(1, 1, false, false));
            this.delimiterPositionCombo.setItems(DataSetDelimiterPosition.getAllNames());
            this.delimiterPositionCombo.select(1);
            this.delimiterInnerCG.add((Control)this.delimiterPositionCombo);
            this.delimiterInnerCG.enabled(false);
            this.cgBinaryMode.add(this.delimiterInnerCG);
            this.cg.add(this.cgBinaryMode);
            this.attr = new BPXWDYNAttributes(this.composite, false);
            this.cg.add((Control)this.composite);
            this.cg.add((Control)this.advancedTwisty);
            this.addDelimiterButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    delimiterInnerCG.enabled(addDelimiterButton.getSelection());
                }
            });
            if (this.advancedTwisty != null) {
                this.advancedTwisty.addExpansionListener(new IExpansionListener(){

                    public void expansionStateChanged(ExpansionEvent arg0) {
                        ItemDialogAttributes.refresh((Composite)advancedTwisty);
                    }

                    public void expansionStateChanging(ExpansionEvent arg0) {
                    }
                });
            }
            this.setTransferMode(false);
            this.advancedTwisty.setExpanded(!this.advancedTwisty.isExpanded());
            ItemDialogAttributes.refresh((Composite)this.advancedTwisty);
            this.advancedTwisty.setExpanded(!this.advancedTwisty.isExpanded());
        }

        public void setAttributes(DatasetAttributes da) {
            this.attr.setValue(da);
        }

        public DatasetAttributes getAttributes() {
            return this.attr.getValue();
        }

        @Override
        public void setActive(boolean active) {
            this.cg.visible(active);
            this.attr.setActive(active);
            this.advancedTwisty.setExpanded(false);
            this.cgBinaryMode.visible(!this.textMode);
            this.cgTextMode.enabled(this.textMode);
        }

        public void setTransferMode(boolean textMode) {
            this.textMode = textMode;
            this.cgBinaryMode.visible(!textMode);
            this.cgTextMode.enabled(textMode);
            if (!textMode) {
                this.trailPadButton.setSelection(false);
            }
            ItemDialogAttributes.refresh(this.composite);
        }

        public void setSourceDisposition(TransferItem.SourceDispositionType value) {
            this.removeButton.setSelection(value.equals((Object)TransferItem.SourceDispositionType.DELETE));
        }

        public TransferItem.SourceDispositionType getSourceDisposition() {
            return this.removeButton.getSelection() ? TransferItem.SourceDispositionType.DELETE : TransferItem.SourceDispositionType.LEAVE;
        }

        public TransferItem.DataSetItem.RecordDelimiter generateRecordDelimiter() {
            TransferItem.DataSetItem.RecordDelimiter recordDelimiter = null;
            if (this.addDelimiterButton.getSelection()) {
                DataSetDelimiterPosition position = DataSetDelimiterPosition.getByPosition(this.delimiterPositionCombo.getSelectionIndex());
                recordDelimiter = new TransferItem.DataSetItem.RecordDelimiter(position, this.delimiterCombo.getText());
            }
            return recordDelimiter;
        }

        public void setRecordDelimiter(TransferItem.DataSetItem.RecordDelimiter recordDelimiter) {
            if (recordDelimiter != null) {
                this.delimiterInnerCG.enabled(true);
                this.addDelimiterButton.setSelection(true);
                this.delimiterCombo.setText(recordDelimiter.getDelimiter());
                this.delimiterPositionCombo.select(recordDelimiter.getPosition().getPosition());
            } else {
                this.delimiterInnerCG.enabled(false);
                this.addDelimiterButton.setSelection(false);
            }
        }

        public void setTrailingSpaces(boolean include) {
            this.trailPadButton.setSelection(include);
        }

        public boolean includeTrailingSpaces() {
            return this.trailPadButton.getSelection();
        }

        @Override
        public PriorityStatus validate(boolean withVarSt) {
            PriorityStatus status = new PriorityStatus(null);
            if (this.addDelimiterButton.getSelection()) {
                String delSeq = this.delimiterCombo.getText();
                if (delSeq == null || delSeq.length() == 0) {
                    status.setIncomplete();
                } else if (!this.textMode && !CmdLinePropertyValueValidator.MsgBinaryDelimiterValidator.pattern.matcher(delSeq).matches()) {
                    status.setError(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_BIN_ILL_DEL);
                }
            }
            return status;
        }

        @Override
        public void saveHistory() {
            if (this.addDelimiterButton.getSelection()) {
                SectionHistory.HistoryReference.DATASET_DELIMITER_BYTE.put(this.delimiterCombo);
            }
        }
    }

    public static class SourceDirectoryAttributes
    implements ItemDialogContents {
        private final ControlGroup cg = new ControlGroup("Source file Attributes Content");
        private final Button subdirectoryButton;
        private final Button removeFileButton;

        public SourceDirectoryAttributes(Composite parent) {
            Composite srcFileComp = new Composite(parent, 0);
            srcFileComp.setLayout((Layout)new GridLayout(1, false));
            srcFileComp.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.cg.add((Control)srcFileComp);
            this.subdirectoryButton = new Button(srcFileComp, 32);
            this.subdirectoryButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SUB_DIR_BUTTON);
            this.cg.add((Control)this.subdirectoryButton);
            this.removeFileButton = new Button(srcFileComp, 32);
            this.removeFileButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_REMOVE_FILE_DIR_BUTTON);
            this.cg.add((Control)this.removeFileButton);
        }

        @Override
        public void setActive(boolean active) {
            this.cg.visible(active);
        }

        @Override
        public PriorityStatus validate(boolean withVarSt) {
            return new PriorityStatus(null);
        }

        public void setSourceDisposition(TransferItem.SourceDispositionType value) {
            this.removeFileButton.setSelection(value.equals((Object)TransferItem.SourceDispositionType.DELETE));
        }

        public TransferItem.SourceDispositionType getSourceDisposition() {
            return this.removeFileButton.getSelection() ? TransferItem.SourceDispositionType.DELETE : TransferItem.SourceDispositionType.LEAVE;
        }

        public void setSubDirectory(TransferItem.SubDirectoryType value) {
            this.subdirectoryButton.setSelection(value.equals((Object)TransferItem.SubDirectoryType.INCLUDED));
        }

        public boolean isRecurse() {
            return this.subdirectoryButton.getSelection();
        }

        @Override
        public void saveHistory() {
        }
    }

    public static class SourceFileAttributes
    implements ItemDialogContents {
        private final ControlGroup cg = new ControlGroup("Source file Attributes Content");
        private final Button removeFileButton;

        public SourceFileAttributes(Composite parent) {
            Composite srcFileComp = new Composite(parent, 0);
            srcFileComp.setLayout((Layout)new GridLayout(1, false));
            srcFileComp.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.cg.add((Control)srcFileComp);
            this.removeFileButton = new Button(srcFileComp, 32);
            this.removeFileButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_REMOVE_FILE_DIR_BUTTON);
            this.cg.add((Control)this.removeFileButton);
        }

        @Override
        public void setActive(boolean active) {
            this.cg.visible(active);
        }

        @Override
        public PriorityStatus validate(boolean withVarSt) {
            return new PriorityStatus(null);
        }

        public void setSourceDisposition(TransferItem.SourceDispositionType value) {
            this.removeFileButton.setSelection(value.equals((Object)TransferItem.SourceDispositionType.DELETE));
        }

        public TransferItem.SourceDispositionType getSourceDisposition() {
            return this.removeFileButton.getSelection() ? TransferItem.SourceDispositionType.DELETE : TransferItem.SourceDispositionType.LEAVE;
        }

        public void setSubDirectory(TransferItem.SubDirectoryType value) {
            this.removeFileButton.setSelection(value.equals((Object)TransferItem.SubDirectoryType.INCLUDED));
        }

        @Override
        public void saveHistory() {
        }
    }

    public static class SourceQueueAttributes
    implements ItemDialogContents {
        private final ControlGroup cg = new ControlGroup("Source queue attributes Content");
        private final Composite composite;
        private final ExpandableComposite advancedTwisty;
        private final Button allMessageButton;
        private final Button groupMessageButton;
        private final Button addDelimiterButton;
        private final Label delimiterLabel;
        private final Combo delimiterCombo;
        private final Label delimiterInfoLabel;
        private final Combo delimiterPositionCombo;
        private final Button waitMessageButton;
        private final Spinner waitTimeSpinner;
        private boolean textMode = false;

        public SourceQueueAttributes(Composite parent, int singleCharPixelHeight) {
            this.advancedTwisty = new ExpandableComposite(parent, 0, 18);
            this.advancedTwisty.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_ADVANCED);
            this.advancedTwisty.setExpanded(false);
            this.advancedTwisty.setEnabled(true);
            this.advancedTwisty.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            this.cg.add((Control)this.advancedTwisty);
            this.composite = new Composite((Composite)this.advancedTwisty, 0);
            this.advancedTwisty.setClient((Control)this.composite);
            this.composite.setLayout((Layout)new GridLayout(1, false));
            this.composite.setLayoutData((Object)new GridData(4, 1, true, false));
            this.cg.add((Control)this.composite);
            Group fileCompGroup = new Group(this.composite, 0);
            fileCompGroup.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_GROUP);
            fileCompGroup.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
            fileCompGroup.setLayout((Layout)new GridLayout(1, false));
            this.allMessageButton = new Button((Composite)fileCompGroup, 16);
            this.allMessageButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_ALL_MESSAGES);
            this.allMessageButton.setToolTipText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_ALL_MESSAGES_TOOLTIP);
            this.allMessageButton.setSelection(true);
            this.groupMessageButton = new Button((Composite)fileCompGroup, 16);
            this.groupMessageButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_GROUP_MESSAGES);
            this.groupMessageButton.setToolTipText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_GROUP_MESSAGES_TOOLTIP);
            this.addDelimiterButton = new Button((Composite)fileCompGroup, 32);
            this.addDelimiterButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_AS_TEXT);
            this.addDelimiterButton.setToolTipText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_AS_TEXT_TOOLTIP);
            GridData gd = new GridData();
            gd.verticalIndent = singleCharPixelHeight / 2;
            this.addDelimiterButton.setLayoutData((Object)gd);
            ItemDialogAttributes.addListener((Control)this.addDelimiterButton);
            Composite delimiterOptionGroup = new Composite((Composite)fileCompGroup, 0);
            delimiterOptionGroup.setLayoutData((Object)new GridData(4, 1, true, false));
            delimiterOptionGroup.setLayout((Layout)ItemDialogAttributes.indentedGridLayout(2));
            int labelWidth = Tools.getWidth(delimiterOptionGroup, new String[]{Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_BYTE_LABEL, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_TEXT_LABEL, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_POSITION_LABEL});
            final ControlGroup delimiterInnerCG = new ControlGroup("Delimiter inner queue attributes Content");
            this.delimiterLabel = ItemDialogAttributes.fixedWidthLabel(delimiterOptionGroup, labelWidth, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_BYTE_LABEL);
            delimiterInnerCG.add((Control)this.delimiterLabel);
            this.delimiterCombo = new Combo(delimiterOptionGroup, 0);
            this.delimiterCombo.setLayoutData((Object)new GridData(4, 1, true, false));
            delimiterInnerCG.add((Control)this.delimiterCombo);
            ItemDialogAttributes.addListener((Control)this.delimiterCombo);
            Label padding = new Label(delimiterOptionGroup, 0);
            delimiterInnerCG.add((Control)padding);
            this.delimiterInfoLabel = new Label(delimiterOptionGroup, 0);
            this.delimiterInfoLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            delimiterInnerCG.add((Control)this.delimiterInfoLabel);
            Label delimiterPositionLabel = ItemDialogAttributes.fixedWidthLabel(delimiterOptionGroup, labelWidth, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_POSITION_LABEL);
            delimiterInnerCG.add((Control)delimiterPositionLabel);
            this.delimiterPositionCombo = new Combo(delimiterOptionGroup, 8);
            this.delimiterPositionCombo.setLayoutData((Object)new GridData(1, 1, false, false));
            this.delimiterPositionCombo.setItems(QueueProperties.DelimiterPosition.getAllNames());
            this.delimiterPositionCombo.select(0);
            delimiterInnerCG.add((Control)this.delimiterPositionCombo);
            delimiterInnerCG.enabled(false);
            this.waitMessageButton = new Button(this.composite, 32);
            this.waitMessageButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_ENABLE_WAIT);
            this.waitMessageButton.setToolTipText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_ENABLE_WAIT_TOOLTIP);
            Composite waitMessageGroup = new Composite(this.composite, 0);
            waitMessageGroup.setLayoutData((Object)new GridData(4, 1, true, false));
            waitMessageGroup.setLayout((Layout)ItemDialogAttributes.indentedGridLayout(3));
            final ControlGroup waitTimeCG = new ControlGroup("Wait time queue attributes Content");
            Label waitTimeLabel = new Label(waitMessageGroup, 0);
            waitTimeLabel.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_ENABLE_WAIT_LABEL);
            waitTimeCG.add((Control)waitTimeLabel);
            this.waitTimeSpinner = new Spinner(waitMessageGroup, 2048);
            this.waitTimeSpinner.setMinimum(0);
            this.waitTimeSpinner.setIncrement(1);
            this.waitTimeSpinner.setMaximum(99);
            this.waitTimeSpinner.setSelection(5);
            waitTimeCG.add((Control)this.waitTimeSpinner);
            Label waitTimeLabelUnit = new Label(waitMessageGroup, 0);
            waitTimeLabelUnit.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_ENABLE_WAIT_SECONDS_UNIT);
            waitTimeCG.add((Control)waitTimeLabelUnit);
            waitTimeCG.enabled(false);
            if (this.advancedTwisty != null) {
                this.advancedTwisty.addExpansionListener(new IExpansionListener(){

                    public void expansionStateChanged(ExpansionEvent arg0) {
                        ItemDialogAttributes.refresh((Composite)advancedTwisty);
                    }

                    public void expansionStateChanging(ExpansionEvent arg0) {
                    }
                });
            }
            this.waitMessageButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    waitTimeCG.enabled(waitMessageButton.getSelection());
                }
            });
            this.addDelimiterButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    delimiterInnerCG.enabled(addDelimiterButton.getSelection());
                }
            });
            this.groupMessageButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ItemDialogUtils.sendValidationEvent((Control)groupMessageButton);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }

        public void setTransferMode(boolean textMode) {
            this.textMode = textMode;
            if (textMode) {
                this.addDelimiterButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_AS_TEXT);
                this.addDelimiterButton.setToolTipText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_AS_TEXT_TOOLTIP);
                this.delimiterLabel.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_TEXT_LABEL);
                this.delimiterInfoLabel.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_INFO_TEXT);
                SectionHistory.HistoryReference.QUEUE_DELIMITER_TEXT.loadHistory(this.delimiterCombo);
            } else {
                this.addDelimiterButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_AS_BYTE);
                this.addDelimiterButton.setToolTipText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_AS_BYTE_TOOLTIP);
                this.delimiterLabel.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_BYTE_LABEL);
                this.delimiterInfoLabel.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_DELIMITER_INFO_BYTE);
                SectionHistory.HistoryReference.QUEUE_DELIMITER_BYTE.loadHistory(this.delimiterCombo);
            }
        }

        @Override
        public void setActive(boolean active) {
            this.cg.visible(active);
        }

        @Override
        public PriorityStatus validate(boolean withVarSt) {
            PriorityStatus status = new PriorityStatus(null);
            if (this.addDelimiterButton.getSelection()) {
                String delSeq = this.delimiterCombo.getText();
                if (delSeq == null || delSeq.length() == 0) {
                    status.setIncomplete();
                } else if (!this.textMode && !CmdLinePropertyValueValidator.MsgBinaryDelimiterValidator.pattern.matcher(delSeq).matches()) {
                    status.setError(Elements.UI_WIZARD_V2_ITEM_DIALOG_QUEUE_BIN_ILL_DEL);
                }
            }
            return status;
        }

        @Override
        public void saveHistory() {
            if (this.textMode) {
                SectionHistory.HistoryReference.QUEUE_DELIMITER_TEXT.put(this.delimiterCombo);
            } else {
                SectionHistory.HistoryReference.QUEUE_DELIMITER_BYTE.put(this.delimiterCombo);
            }
        }

        public void setAttributes(QueueProperties.MessageSource ms) {
            QueueProperties.MessageDelimiter delimiter;
            if (ms.areMessageGrouped()) {
                this.groupMessageButton.setSelection(true);
                this.allMessageButton.setSelection(false);
            } else {
                this.allMessageButton.setSelection(true);
                this.groupMessageButton.setSelection(false);
            }
            if (ms.timeout() != null) {
                this.waitMessageButton.setSelection(true);
                this.waitTimeSpinner.setSelection(ms.timeout().intValue());
                this.waitTimeSpinner.setEnabled(true);
            }
            if ((delimiter = ms.getDelimiter()) != null) {
                this.addDelimiterButton.setSelection(true);
                if (delimiter instanceof QueueProperties.MessageDelimiterBinary) {
                    QueueProperties.MessageDelimiterBinary bd = (QueueProperties.MessageDelimiterBinary)delimiter;
                    this.delimiterCombo.setText(bd.getField());
                    this.delimiterPositionCombo.select(bd.getPostion().getPosition());
                } else if (delimiter instanceof QueueProperties.MessageDelimiterText) {
                    QueueProperties.MessageDelimiterText bt = (QueueProperties.MessageDelimiterText)delimiter;
                    this.delimiterCombo.setText(bt.getField());
                    this.delimiterPositionCombo.select(bt.getPostion().getPosition());
                }
            }
            this.addDelimiterButton.notifyListeners(13, new Event());
        }

        public QueueProperties.MessageSource getAttributes() {
            QueueProperties.MessageSource ms;
            Integer waitTime;
            Integer n = waitTime = this.waitMessageButton.getSelection() ? Integer.valueOf(this.waitTimeSpinner.getSelection()) : null;
            if (this.addDelimiterButton.getSelection()) {
                QueueProperties.DelimiterPosition delimiterPosition = QueueProperties.DelimiterPosition.getByPosition(this.delimiterPositionCombo.getSelectionIndex());
                ms = this.textMode ? QueueProperties.MessageSource.createSourceTextDelimitedMessage(this.groupMessageButton.getSelection(), waitTime, delimiterPosition, this.delimiterCombo.getText(), false) : QueueProperties.MessageSource.createSourceBinaryDelimitedMessage(this.groupMessageButton.getSelection(), waitTime, delimiterPosition, this.delimiterCombo.getText(), false);
            } else {
                ms = new QueueProperties.MessageSource(this.groupMessageButton.getSelection(), waitTime, null);
            }
            return ms;
        }
    }
}

