/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.dialogs;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.dialogs.ItemDialogAttributes;
import com.ibm.wmqfte.explorer.dialogs.ItemDialogContents;
import com.ibm.wmqfte.explorer.dialogs.ItemDialogInfo;
import com.ibm.wmqfte.explorer.dialogs.ItemDialogLocationContents;
import com.ibm.wmqfte.explorer.dialogs.ItemDialogUtils;
import com.ibm.wmqfte.explorer.utils.AgentDetails;
import com.ibm.wmqfte.explorer.utils.v2.EnvironmentInformation;
import com.ibm.wmqfte.explorer.utils.v2.PriorityStatus;
import com.ibm.wmqfte.explorer.utils.v2.QueueProperties;
import com.ibm.wmqfte.explorer.utils.v2.ResMonAssist;
import com.ibm.wmqfte.explorer.utils.v2.SectionHistory;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.utils.v2.TransferItem;
import com.ibm.wmqfte.explorer.wizards.pages.v2.ResourceMonitorPage;
import com.ibm.wmqfte.monitor.impl.MonitorTriggerCondition;
import com.ibm.wmqfte.monitor.impl.MonitorTriggerOperator;
import com.ibm.wmqfte.utils.AgentType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class ItemDialog
extends TitleAreaDialog {
    public static final int ValidateRequest = 1000;
    private final EnvironmentInformation sourceEnvInfo;
    private final EnvironmentInformation destinationEnvInfo;
    private final ResourceMonitorPage.ResourceType resourceType;
    private final MonitorTriggerCondition resourceTrigger;
    private TransferItem generatedItem;
    private Composite innerScrollable;
    private ScrolledComposite scrolledComposite;
    private Button binaryTransferModeButton;
    private Button textTransferModeButton;
    private ExpandableComposite advancedTwisty;
    private ItemDialogAttributes.EncodingAttributes sourceEncoding;
    private ItemDialogAttributes.EncodingAttributes destinationEncoding;
    private ItemDialogAttributes.EOLAttributes destinationEOLAttributes;
    private Combo sourceTypeCombo;
    private Combo destinationTypeCombo;
    private ItemDialogLocationContents.FileLocationContent sourceFileName;
    private ItemDialogLocationContents.DirectoryLocationContent sourceDirectoryName;
    private ItemDialogLocationContents.DataSetLocationContent sourceDataSet;
    private ItemDialogLocationContents.PartitionedDataSetLocationContent sourcePartitionedDataSet;
    private ItemDialogLocationContents.QueueLocationContent sourceQueue;
    private ItemDialogAttributes.SourceFileAttributes sourceFileAttributes;
    private ItemDialogAttributes.SourceDirectoryAttributes sourceDirectoryAttributes;
    private ItemDialogAttributes.SourceDataSetAttributes sourceDataSetAttributes;
    private ItemDialogAttributes.SourceQueueAttributes sourceQueueAttributes;
    private ItemDialogLocationContents.FileLocationContent destinationFileName;
    private ItemDialogLocationContents.DirectoryLocationContent destinationDirectoryName;
    private ItemDialogLocationContents.DataSetLocationContent destinationDataSet;
    private ItemDialogLocationContents.PartitionedDataSetLocationContent destinationPartitionedDataSet;
    private ItemDialogLocationContents.QueueLocationContent destinationQueue;
    private ItemDialogLocationContents.FileSpaceLocationContent destinationFileSpace;
    private ItemDialogAttributes.DestinationFileAttributes destinationFileAttributes;
    private ItemDialogAttributes.DestinationDataSetAttributes destinationDataSetAttributes;
    private ItemDialogAttributes.DestinationQueueAttributes destinationQueueAttributes;
    private ItemDialogContents sourceLocation;
    private ItemDialogContents sourceAttributes;
    private ItemDialogContents destinationEnableLocation;
    private ItemDialogContents destinationEnableAttributes;

    public ItemDialog(Shell parentShell, EnvironmentInformation sourceEnvInfo, EnvironmentInformation destinationEnvInfo, ResourceMonitorPage.ResourceType resourceType, MonitorTriggerCondition resourceTrigger) {
        super(parentShell);
        this.sourceEnvInfo = sourceEnvInfo;
        this.destinationEnvInfo = destinationEnvInfo;
        this.resourceType = resourceType;
        this.resourceTrigger = resourceTrigger;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public TransferItem getItem() {
        return this.generatedItem;
    }

    public Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        int labelWidth = Tools.getWidth(area, new String[]{Elements.UI_WIZARD_V2_ITEM_DIALOG_FILE_NAME_LABEL, Elements.UI_WIZARD_V2_ITEM_DIALOG_DIRECTORY_NAME_LABEL, Elements.UI_WIZARD_V2_ITEM_DIALOG_QUEUE_LABEL, Elements.UI_WIZARD_V2_ITEM_DIALOG_QUEUE_MGR_LABEL, Elements.UI_WIZARD_V2_ITEM_DIALOG_SDS_LABEL, Elements.UI_WIZARD_V2_ITEM_DIALOG_PDS_LABEL, Elements.UI_WIZARD_V2_ITEM_DIALOG_FILESPACE_LABEL});
        this.setTitle(Elements.UI_WIZARD_V2_ITEM_DIALOG_ADD_TITLE);
        this.getShell().setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_ADD_TITLE);
        this.setMessage(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESC);
        ExplorerPlugin.setHelp((Control)area, "com.ibm.wmqfte.explorer.context.UI_ItemDialog");
        this.scrolledComposite = new ScrolledComposite(area, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledComposite.setAlwaysShowScrollBars(true);
        this.scrolledComposite.setMinWidth(1024);
        this.innerScrollable = new Composite((Composite)this.scrolledComposite, 0);
        this.innerScrollable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.innerScrollable.setLayout((Layout)new GridLayout(1, true));
        this.scrolledComposite.setContent((Control)this.innerScrollable);
        this.scrolledComposite.setMinHeight(this.innerScrollable.computeSize((int)-1, (int)-1, (boolean)true).y);
        this.transferModeContent(this.innerScrollable);
        Composite sourceDestOptions = new Composite(this.innerScrollable, 0);
        sourceDestOptions.setLayoutData((Object)new GridData(4, 1, true, false));
        GridLayout gl = new GridLayout(2, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        sourceDestOptions.setLayout((Layout)gl);
        this.sourceContent(sourceDestOptions, labelWidth);
        this.destinationContent(sourceDestOptions, labelWidth);
        ResMonAssist.getInst().visible(this.sourceEnvInfo.isResourceMonitor(), this.resourceType);
        this.refresh();
        this.scrolledComposite.addListener(1000, new Listener(){

            public void handleEvent(Event arg0) {
                ItemDialog.this.validate();
            }
        });
        this.scrolledComposite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                ItemDialog.this.scrolledComposite.setMinHeight(((ItemDialog)ItemDialog.this).innerScrollable.computeSize((int)-1, (int)-1, (boolean)true).y);
                ItemDialog.this.scrolledComposite.layout();
                ItemDialog.this.innerScrollable.layout();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.scrolledComposite.notifyListeners(11, new Event());
        return area;
    }

    public void okPressed() {
        this.generatedItem = this.createItem();
        this.saveHistory();
        super.okPressed();
    }

    private void transferModeContent(Composite parent) {
        Group transferModeGroup = new Group(parent, 0);
        transferModeGroup.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_TRANSFER_MODE_GRP);
        transferModeGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        transferModeGroup.setLayout((Layout)new GridLayout(1, false));
        this.binaryTransferModeButton = new Button((Composite)transferModeGroup, 16);
        this.binaryTransferModeButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_TRANSFER_MODE_BINARY_BUTTON);
        this.binaryTransferModeButton.setSelection(true);
        this.textTransferModeButton = new Button((Composite)transferModeGroup, 16);
        this.textTransferModeButton.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_TRANSFER_MODE_TEXT_BUTTON);
        this.advancedTwisty = new ExpandableComposite((Composite)transferModeGroup, 0, 18);
        this.advancedTwisty.marginWidth = 15;
        this.advancedTwisty.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_ADVANCED_ENCODING_TITLE);
        this.advancedTwisty.setExpanded(false);
        this.advancedTwisty.setEnabled(false);
        this.advancedTwisty.setLayoutData((Object)new GridData(4, 1, true, true));
        Composite advancedEncoding = new Composite((Composite)this.advancedTwisty, 0);
        this.advancedTwisty.setClient((Control)advancedEncoding);
        advancedEncoding.setLayoutData((Object)new GridData(4, 1, true, true));
        advancedEncoding.setLayout((Layout)new GridLayout(1, false));
        this.sourceEncoding = new ItemDialogAttributes.EncodingAttributes(advancedEncoding, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_ENCODING_TITLE, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_ENCODING_TOOLTIP, Elements.UI_WIZARD_V2_ITEM_DIALOG_SRC_ENCODING_MISSING);
        this.destinationEncoding = new ItemDialogAttributes.EncodingAttributes(advancedEncoding, Elements.UI_WIZARD_V2_ITEM_DIALOG_DEST_ENCODING_TITLE, Elements.UI_WIZARD_V2_ITEM_DIALOG_DEST_ENCODING_TOOLTIP, Elements.UI_WIZARD_V2_ITEM_DIALOG_DEST_ENCODING_MISSING);
        this.destinationEOLAttributes = new ItemDialogAttributes.EOLAttributes(advancedEncoding, Elements.UI_WIZARD_V2_ITEM_DIALOG_DEST_EOL_TOOLTIP);
        this.textTransferModeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean mode = ItemDialog.this.textTransferModeButton.getSelection();
                ItemDialog.this.advancedTwisty.setEnabled(mode);
                if (!mode) {
                    ItemDialog.this.advancedTwisty.setExpanded(false);
                    ItemDialog.this.refresh();
                }
                if (ItemDialog.this.sourceQueueAttributes != null) {
                    ItemDialog.this.sourceQueueAttributes.setTransferMode(ItemDialog.this.textTransferModeButton.getSelection());
                }
                if (ItemDialog.this.sourceDataSetAttributes != null) {
                    ItemDialog.this.sourceDataSetAttributes.setTransferMode(ItemDialog.this.textTransferModeButton.getSelection());
                }
                if (ItemDialog.this.destinationQueueAttributes != null) {
                    ItemDialog.this.destinationQueueAttributes.setTransferMode(ItemDialog.this.textTransferModeButton.getSelection());
                }
                if (ItemDialog.this.destinationDataSetAttributes != null) {
                    ItemDialog.this.destinationDataSetAttributes.setTransferMode(ItemDialog.this.textTransferModeButton.getSelection());
                }
            }
        });
        this.advancedTwisty.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent arg0) {
                ItemDialog.this.refresh();
            }

            public void expansionStateChanging(ExpansionEvent arg0) {
            }
        });
    }

    public void loadValues(TransferItem item) {
        if (this.getContents() == null) {
            super.create();
        }
        if (item == null) {
            this.setTitle(Elements.UI_WIZARD_V2_ITEM_DIALOG_ADD_TITLE);
            this.getShell().setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_ADD_TITLE);
            this.sourceTypeCombo.select(0);
            this.destinationTypeCombo.select(0);
            if (this.sourceEnvInfo.isResourceMonitor() && ResourceMonitorPage.ResourceType.QUEUE == this.resourceType) {
                this.sourceTypeCombo.setText(ItemType.MESSAGE.getComboName());
                this.sourceQueue.setLocation("${QueueName}");
                if (this.resourceTrigger.getTriggerOperator() == MonitorTriggerOperator.COMPLETE_GROUPS) {
                    QueueProperties.MessageSource messageSource = new QueueProperties.MessageSource(true, null, null);
                    this.sourceQueueAttributes.setAttributes(messageSource);
                }
            }
        } else {
            QueueProperties.SchemaSet attributes;
            TransferItem.QueueItem queueItem;
            TransferItem.DataSetItem dataSetItem;
            TransferItem.FileItem fileItem;
            TransferItem.DirItem dirItem;
            this.setTitle(Elements.UI_WIZARD_V2_ITEM_DIALOG_EDIT_TITLE);
            this.getShell().setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_EDIT_TITLE);
            if (item.getTransferMode() == TransferItem.TransferModeType.BINARY) {
                this.binaryTransferModeButton.setSelection(true);
                this.textTransferModeButton.setSelection(false);
            } else {
                this.textTransferModeButton.setSelection(true);
                this.binaryTransferModeButton.setSelection(false);
                this.sourceEncoding.setValue(item.getSource().getCodePage());
                this.destinationEncoding.setValue(item.getDestination().getCodePage());
                this.destinationEOLAttributes.setValue(item.getDestination().getEOL());
            }
            TransferItem.BaseItem baseItem = item.getSource();
            if (baseItem instanceof TransferItem.DirItem) {
                dirItem = (TransferItem.DirItem)baseItem;
                this.sourceTypeCombo.setText(ItemType.DIRECTORY.getComboName());
                this.sourceDirectoryName.setLocation(dirItem.getName());
                this.sourceDirectoryAttributes.setSubDirectory(dirItem.doesRecurse() ? TransferItem.SubDirectoryType.INCLUDED : TransferItem.SubDirectoryType.EXCLUDED);
                this.sourceDirectoryAttributes.setSourceDisposition(item.getSourceDisposition());
            } else if (baseItem instanceof TransferItem.FileItem) {
                fileItem = (TransferItem.FileItem)baseItem;
                this.sourceTypeCombo.setText(ItemType.FILE.getComboName());
                this.sourceFileName.setLocation(fileItem.getName());
                this.sourceFileAttributes.setSourceDisposition(item.getSourceDisposition());
            } else if (baseItem instanceof TransferItem.DataSetItem) {
                dataSetItem = (TransferItem.DataSetItem)baseItem;
                this.sourceTypeCombo.setText(ItemType.DATASET.getComboName());
                this.sourceDataSet.setLocation(dataSetItem.getName());
                this.sourceDataSetAttributes.setSourceDisposition(item.getSourceDisposition());
                this.sourceDataSetAttributes.setAttributes(dataSetItem.getAttributes());
                this.sourceDataSetAttributes.setRecordDelimiter(dataSetItem.getRecordDelimiter());
                this.sourceDataSetAttributes.setTrailingSpaces(dataSetItem.includeTrailingSpaces());
            } else if (baseItem instanceof TransferItem.QueueItem) {
                queueItem = (TransferItem.QueueItem)baseItem;
                this.sourceTypeCombo.setText(ItemType.MESSAGE.getComboName());
                this.sourceQueue.setLocation(queueItem.getName());
                attributes = queueItem.getAttributes();
                QueueProperties.MessageSource messageSource = attributes.getSource();
                if (messageSource != null) {
                    this.sourceQueueAttributes.setAttributes(messageSource);
                }
            }
            baseItem = item.getDestination();
            if (baseItem instanceof TransferItem.DirItem) {
                dirItem = (TransferItem.DirItem)baseItem;
                this.destinationTypeCombo.setText(ItemType.DIRECTORY.getComboName());
                this.destinationDirectoryName.setLocation(dirItem.getName());
                this.destinationFileAttributes.setDestinationDisposition(item.getDestinationDisposition());
                this.destinationFileAttributes.setSpecificDistributionType(item.getDestinationSpecificDistributionType());
            } else if (baseItem instanceof TransferItem.FileItem) {
                fileItem = (TransferItem.FileItem)baseItem;
                this.destinationTypeCombo.setText(ItemType.FILE.getComboName());
                this.destinationFileName.setLocation(fileItem.getName());
                this.destinationFileAttributes.setDestinationDisposition(item.getDestinationDisposition());
                this.destinationFileAttributes.setSpecificDistributionType(item.getDestinationSpecificDistributionType());
            } else if (baseItem instanceof TransferItem.DataSetItem) {
                dataSetItem = (TransferItem.DataSetItem)baseItem;
                if (dataSetItem.isPartitionedDataSet()) {
                    this.destinationTypeCombo.setText(ItemType.PDS.getComboName());
                    this.destinationPartitionedDataSet.setLocation(dataSetItem.getName());
                } else {
                    this.destinationTypeCombo.setText(ItemType.SDS.getComboName());
                    this.destinationDataSet.setLocation(dataSetItem.getName());
                }
                this.destinationDataSetAttributes.setAttributes(dataSetItem.getAttributes());
                this.destinationDataSetAttributes.setDestinationDisposition(item.getDestinationDisposition());
                this.destinationDataSetAttributes.setOverSizeDatasetRecord(dataSetItem.getOversizeDatasetRecord());
            } else if (baseItem instanceof TransferItem.QueueItem) {
                queueItem = (TransferItem.QueueItem)baseItem;
                this.destinationTypeCombo.setText(ItemType.MESSAGE.getComboName());
                this.destinationQueue.setLocation(queueItem.getName());
                attributes = queueItem.getAttributes();
                QueueProperties.MessageDestination messageDest = attributes.getDestination();
                if (messageDest != null) {
                    this.destinationQueueAttributes.setAttributes(messageDest);
                }
            } else if (baseItem instanceof TransferItem.FileSpaceItem) {
                TransferItem.FileSpaceItem fileSpaceItem = (TransferItem.FileSpaceItem)baseItem;
                this.destinationTypeCombo.setText(ItemType.FILESPACE.getComboName());
                this.destinationFileSpace.setLocation(fileSpaceItem.getName());
            }
        }
        this.scrolledComposite.setAlwaysShowScrollBars(false);
        this.textTransferModeButton.notifyListeners(13, new Event());
        this.sourceTypeCombo.notifyListeners(13, new Event());
        this.destinationTypeCombo.notifyListeners(13, new Event());
        this.scrolledComposite.notifyListeners(11, new Event());
    }

    private void sourceContent(Composite parent, int labelWidth) {
        final Group group = new Group(parent, 0);
        group.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_GRP);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        new ItemDialogInfo.AgentInformation((Composite)group, this.sourceEnvInfo.getAgentDetails(), labelWidth, false);
        ItemDialogLocationContents.fixedWidthLabel((Composite)group, labelWidth, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_TYPE);
        this.sourceTypeCombo = new Combo((Composite)group, 8);
        GridData gd = new GridData(1, 1, false, false);
        gd.widthHint = ItemType.getSize((Composite)group) + 50;
        this.sourceTypeCombo.setLayoutData((Object)gd);
        this.sourceTypeCombo.setToolTipText(Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_TYPE_TOOLTIP);
        this.sourceTypeCombo.setItems(ItemType.listOfTypes(this.sourceEnvInfo.getAgentDetails(), LocationMenuType.Source));
        this.sourceTypeCombo.select(0);
        this.sourceTypeCombo.setText(ItemType.DATASET.getComboName());
        this.sourceFileName = new ItemDialogLocationContents.FileLocationContent((Composite)group, labelWidth, SectionHistory.HistoryReference.SOURCE_FILE_HISTORY, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_PATH_TOOLTIP, this.sourceEnvInfo);
        this.sourceDirectoryName = new ItemDialogLocationContents.DirectoryLocationContent((Composite)group, labelWidth, SectionHistory.HistoryReference.SOURCE_FILE_HISTORY, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_PATH_TOOLTIP, this.sourceEnvInfo);
        this.sourceDataSet = new ItemDialogLocationContents.DataSetLocationContent((Composite)group, labelWidth, SectionHistory.HistoryReference.SOURCE_DATASET_HISTORY, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_DATASET_TOOLTIP);
        this.sourcePartitionedDataSet = new ItemDialogLocationContents.PartitionedDataSetLocationContent((Composite)group, labelWidth, SectionHistory.HistoryReference.DEST_DATASET_HISTORY, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_DATASET_TOOLTIP);
        this.sourceQueue = new ItemDialogLocationContents.QueueLocationContent((Composite)group, labelWidth, this.sourceEnvInfo.getQueueManagerName(), SectionHistory.HistoryReference.SOURCE_QUEUE_HISTORY, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_TOOLTIP, null);
        this.sourceFileAttributes = new ItemDialogAttributes.SourceFileAttributes((Composite)group);
        this.sourceDirectoryAttributes = new ItemDialogAttributes.SourceDirectoryAttributes((Composite)group);
        this.sourceDataSetAttributes = new ItemDialogAttributes.SourceDataSetAttributes((Composite)group, this.convertHeightInCharsToPixels(1));
        this.sourceDataSetAttributes.setTransferMode(this.textTransferModeButton.getSelection());
        this.sourceQueueAttributes = new ItemDialogAttributes.SourceQueueAttributes((Composite)group, this.convertHeightInCharsToPixels(1));
        this.sourceQueueAttributes.setTransferMode(this.textTransferModeButton.getSelection());
        final ItemDialogContents[] sourceTypeOptions = new ItemDialogContents[]{this.sourceFileName, this.sourceDirectoryName, this.sourceDataSet, this.sourcePartitionedDataSet, this.sourceQueue, this.sourceFileAttributes, this.sourceDirectoryAttributes, this.sourceDataSetAttributes, this.sourceQueueAttributes};
        this.sourceTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = ItemDialog.this.sourceTypeCombo.getSelectionIndex();
                List<ItemType> types = ItemType.listOfItemTypes(ItemDialog.this.sourceEnvInfo.getAgentDetails(), LocationMenuType.Source);
                ItemType type = types.get(index);
                switch (type) {
                    case FILE: {
                        ItemDialog.this.sourceLocation = ItemDialog.this.sourceFileName;
                        ItemDialog.this.sourceAttributes = ItemDialog.this.sourceFileAttributes;
                        break;
                    }
                    case DIRECTORY: {
                        ItemDialog.this.sourceLocation = ItemDialog.this.sourceDirectoryName;
                        ItemDialog.this.sourceAttributes = ItemDialog.this.sourceDirectoryAttributes;
                        break;
                    }
                    case DATASET: {
                        ItemDialog.this.sourceLocation = ItemDialog.this.sourceDataSet;
                        ItemDialog.this.sourceAttributes = ItemDialog.this.sourceDataSetAttributes;
                        break;
                    }
                    case MESSAGE: {
                        ItemDialog.this.sourceLocation = ItemDialog.this.sourceQueue;
                        ItemDialog.this.sourceAttributes = ItemDialog.this.sourceQueueAttributes;
                        break;
                    }
                    default: {
                        ItemDialog.this.sourceLocation = null;
                        ItemDialog.this.sourceAttributes = null;
                    }
                }
                if (ItemDialog.this.sourceLocation == null) {
                    Tools.internalError(Elements.UI_WIZARD_V2_INTERR_ITEM_DIALOG_INV_SOURCE_TYPE, type.toString());
                }
                ItemDialogContents[] itemDialogContentsArray = sourceTypeOptions;
                int n = sourceTypeOptions.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemDialogContents sourceTypeOption;
                    sourceTypeOption.setActive((sourceTypeOption = itemDialogContentsArray[n2]).equals(ItemDialog.this.sourceLocation) || sourceTypeOption.equals(ItemDialog.this.sourceAttributes));
                    ++n2;
                }
                group.layout();
                ItemDialog.this.refresh();
                ItemDialogUtils.sendValidationEvent((Control)ItemDialog.this.destinationTypeCombo);
            }
        });
    }

    private void destinationContent(Composite parent, int labelWidth) {
        final Group group = new Group(parent, 0);
        group.setText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_GRP);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        new ItemDialogInfo.AgentInformation((Composite)group, this.destinationEnvInfo.getAgentDetails(), labelWidth, false);
        boolean hobsonChoice = false;
        if (this.destinationEnvInfo.getAgentDetails() != null) {
            String[] items = ItemType.listOfTypes(this.destinationEnvInfo.getAgentDetails(), LocationMenuType.Destination);
            boolean bl = hobsonChoice = items == null || items.length <= 1;
        }
        if (!hobsonChoice) {
            ItemDialogLocationContents.fixedWidthLabel((Composite)group, labelWidth, Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_TYPE);
        }
        this.destinationTypeCombo = new Combo((Composite)group, 8);
        GridData gd = new GridData(1, 1, false, false);
        gd.widthHint = ItemType.getSize((Composite)group) + 50;
        gd.exclude = hobsonChoice;
        this.destinationTypeCombo.setLayoutData((Object)gd);
        this.destinationTypeCombo.setToolTipText(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_TYPE_TOOLTIP);
        this.destinationTypeCombo.setItems(ItemType.listOfTypes(this.destinationEnvInfo.getAgentDetails(), LocationMenuType.Destination));
        this.destinationTypeCombo.select(0);
        this.destinationTypeCombo.setText(ItemType.SDS.getComboName());
        this.destinationFileName = new ItemDialogLocationContents.FileLocationContent((Composite)group, labelWidth, SectionHistory.HistoryReference.DEST_FILE_HISTORY, Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_PATH_TOOLTIP, this.destinationEnvInfo);
        this.destinationDirectoryName = new ItemDialogLocationContents.DirectoryLocationContent((Composite)group, labelWidth, SectionHistory.HistoryReference.DEST_FILE_HISTORY, Elements.UI_WIZARD_V2_ITEM_DIALOG_DESTINATION_PATH_TOOLTIP, this.destinationEnvInfo);
        this.destinationDataSet = new ItemDialogLocationContents.DataSetLocationContent((Composite)group, labelWidth, SectionHistory.HistoryReference.DEST_DATASET_HISTORY, Elements.UI_WIZARD_V2_ITEM_DIALOG_DEST_DATASET_TOOLTIP);
        this.destinationPartitionedDataSet = new ItemDialogLocationContents.PartitionedDataSetLocationContent((Composite)group, labelWidth, SectionHistory.HistoryReference.DEST_DATASET_HISTORY, Elements.UI_WIZARD_V2_ITEM_DIALOG_DEST_PDS_TOOLTIP);
        this.destinationQueue = new ItemDialogLocationContents.QueueLocationContent((Composite)group, labelWidth, null, SectionHistory.HistoryReference.DEST_QUEUE_HISTORY, Elements.UI_WIZARD_V2_ITEM_DIALOG_DEST_QUEUE_TOOLTIP, Elements.UI_WIZARD_V2_ITEM_DIALOG_DEST_QUEUE_QMGR_TOOLTIP);
        this.destinationFileSpace = new ItemDialogLocationContents.FileSpaceLocationContent((Composite)group, labelWidth, SectionHistory.HistoryReference.DEST_FILESPACE_HISTORY, Elements.UI_WIZARD_V2_ITEM_DIALOG_DEST_FILESPACE_TOOLTIP);
        this.destinationFileAttributes = new ItemDialogAttributes.DestinationFileAttributes((Composite)group, this.destinationEnvInfo);
        this.destinationDataSetAttributes = new ItemDialogAttributes.DestinationDataSetAttributes((Composite)group, this);
        this.destinationQueueAttributes = new ItemDialogAttributes.DestinationQueueAttributes((Composite)group);
        this.destinationQueueAttributes.setTransferMode(this.textTransferModeButton.getSelection());
        final ItemDialogContents[] destinationTypeOptions = new ItemDialogContents[]{this.destinationFileName, this.destinationDirectoryName, this.destinationDataSet, this.destinationPartitionedDataSet, this.destinationQueue, this.destinationFileSpace, this.destinationFileAttributes, this.destinationDataSetAttributes, this.destinationQueueAttributes};
        this.destinationTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ItemType type = ItemType.getByLabel(ItemDialog.this.destinationTypeCombo.getText());
                ItemDialog.this.destinationEnableLocation = null;
                ItemDialog.this.destinationEnableAttributes = null;
                if (type != null) {
                    switch (type) {
                        case FILE: {
                            ItemDialog.this.destinationEnableLocation = ItemDialog.this.destinationFileName;
                            ItemDialog.this.destinationEnableAttributes = ItemDialog.this.destinationFileAttributes;
                            break;
                        }
                        case DIRECTORY: {
                            ItemDialog.this.destinationEnableLocation = ItemDialog.this.destinationDirectoryName;
                            ItemDialog.this.destinationEnableAttributes = ItemDialog.this.destinationFileAttributes;
                            break;
                        }
                        case SDS: {
                            ItemDialog.this.destinationEnableLocation = ItemDialog.this.destinationDataSet;
                            ItemDialog.this.destinationEnableAttributes = ItemDialog.this.destinationDataSetAttributes;
                            break;
                        }
                        case PDS: {
                            ItemDialog.this.destinationEnableLocation = ItemDialog.this.destinationPartitionedDataSet;
                            ItemDialog.this.destinationEnableAttributes = ItemDialog.this.destinationDataSetAttributes;
                            break;
                        }
                        case MESSAGE: {
                            ItemDialog.this.destinationEnableLocation = ItemDialog.this.destinationQueue;
                            ItemDialog.this.destinationEnableAttributes = ItemDialog.this.destinationQueueAttributes;
                            break;
                        }
                        case FILESPACE: {
                            ItemDialog.this.destinationEnableLocation = ItemDialog.this.destinationFileSpace;
                        }
                    }
                }
                if (ItemDialog.this.destinationEnableLocation == null) {
                    Tools.internalError(Elements.UI_WIZARD_V2_INTERR_ITEM_DIALOG_INV_SOURCE_TYPE, type.toString());
                }
                ItemDialogContents[] itemDialogContentsArray = destinationTypeOptions;
                int n = destinationTypeOptions.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemDialogContents typeOption;
                    typeOption.setActive((typeOption = itemDialogContentsArray[n2]).equals(ItemDialog.this.destinationEnableLocation) || typeOption.equals(ItemDialog.this.destinationEnableAttributes));
                    ++n2;
                }
                group.layout();
                ItemDialog.this.refresh();
                ItemDialogUtils.sendValidationEvent((Control)ItemDialog.this.destinationTypeCombo);
            }
        });
    }

    public void refresh() {
        this.scrolledComposite.notifyListeners(11, new Event());
    }

    private void saveHistory() {
        ItemDialogContents[] items;
        ItemDialogContents[] itemDialogContentsArray = items = new ItemDialogContents[]{this.sourceEncoding, this.destinationEncoding, this.sourceLocation, this.sourceAttributes, this.destinationEnableLocation, this.destinationEnableAttributes};
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ItemDialogContents item = itemDialogContentsArray[n2];
            if (item != null) {
                item.saveHistory();
            }
            ++n2;
        }
    }

    private void validate() {
        ItemDialogContents[] items = new ItemDialogContents[]{this.sourceEncoding, this.destinationEncoding, this.sourceLocation, this.sourceAttributes, this.destinationEnableLocation, this.destinationEnableAttributes};
        PriorityStatus overvalPS = new PriorityStatus(Elements.UI_WIZARD_V2_ITEM_DIALOG_DESC);
        ItemDialogContents[] itemDialogContentsArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            PriorityStatus itemPS;
            ItemDialogContents item = itemDialogContentsArray[n2];
            if (item != null && (overvalPS = new PriorityStatus(overvalPS, itemPS = item.validate(this.sourceEnvInfo.isResourceMonitor()))).getSeverity() >= 4) break;
            ++n2;
        }
        if (overvalPS.getSeverity() < 4) {
            ItemType sourceType = ItemType.getByLabel(this.sourceTypeCombo.getText());
            ItemType destinationType = ItemType.getByLabel(this.destinationTypeCombo.getText());
            if (sourceType == ItemType.MESSAGE && destinationType == ItemType.MESSAGE) {
                overvalPS.setError(Elements.UI_WIZARD_V2_ITEM_QUEUE_TO_QUEUE);
            }
            if (overvalPS.isComplete() && sourceType == ItemType.DIRECTORY && destinationType == ItemType.FILE) {
                overvalPS.setWarning(Elements.UI_WIZARD_V2_ITEM_DIALOG_CONTAIN_TO_FILE);
            } else if (overvalPS.isComplete() && sourceType == ItemType.DIRECTORY && destinationType == ItemType.SDS) {
                overvalPS.setWarning(Elements.UI_WIZARD_V2_ITEM_DIALOG_CONTAIN_TO_SDS);
            }
            if (this.sourceEnvInfo.isResourceMonitor() && ResourceMonitorPage.ResourceType.QUEUE == this.resourceType) {
                if (!this.sourceTypeCombo.getText().equals(ItemType.MESSAGE.getComboName()) || this.sourceQueue == null || !"${QueueName}".equals(this.sourceQueue.getQueueName())) {
                    overvalPS.setWarning(Elements.UI_WIZARD_V2_ITEM_DIALOG_QUEUEMONITOR_NOT_QUEUE);
                }
                if (this.resourceTrigger.getTriggerOperator() == MonitorTriggerOperator.COMPLETE_GROUPS && !this.sourceQueueAttributes.getAttributes().areMessageGrouped()) {
                    overvalPS.setWarning(MessageFormat.format(Elements.UI_WIZARD_V2_ITEM_DIALOG_QUEUEMONITOR_COMPLETE_NOT_GROUPED, Elements.UI_WIZARD_V2_ITEM_DIALOG_SOURCE_QUEUE_GROUP_MESSAGES));
                }
            }
        }
        overvalPS.updateTitleStatus(this);
        this.getButton(0).setEnabled(overvalPS.isComplete());
    }

    public TransferItem createItem() {
        String path;
        String name;
        String name2;
        TransferItem.SourceDispositionType sourceDisposition = TransferItem.SourceDispositionType.LEAVE;
        TransferItem.DestinationDispositionType destinationDisposition = TransferItem.DestinationDispositionType.ERROR;
        TransferItem.OversizeDatasetRecord destinationOverSizeRec = TransferItem.OversizeDatasetRecord.WRAP;
        String destinationSpecificDistributionType = null;
        ItemType sourceItemType = ItemType.getByLabel(this.sourceTypeCombo.getText());
        TransferItem.BaseItem sourceItem = null;
        if (sourceItemType == ItemType.FILE) {
            name2 = this.sourceFileName == null ? "" : this.sourceFileName.getLocation().trim();
            sourceItem = new TransferItem.FileItem(name2, false, null, this.sourceEncoding.getValue());
            sourceDisposition = this.sourceFileAttributes.getSourceDisposition();
        } else if (sourceItemType == ItemType.DIRECTORY) {
            String path2 = this.sourceDirectoryName == null ? "" : this.sourceDirectoryName.getLocation();
            boolean recurse = this.sourceDirectoryAttributes.isRecurse();
            sourceItem = new TransferItem.DirItem(path2, recurse, null, this.sourceEncoding.getValue());
            sourceDisposition = this.sourceDirectoryAttributes.getSourceDisposition();
        } else if (sourceItemType == ItemType.DATASET) {
            name2 = this.sourceDataSet == null ? "" : this.sourceDataSet.getLocation().trim();
            TransferItem.DataSetItem.RecordDelimiter recordDelimiter = this.sourceDataSetAttributes.generateRecordDelimiter();
            sourceItem = new TransferItem.DataSetItem(name2, false, this.sourceDataSetAttributes.getAttributes(), null, this.sourceEncoding.getValue(), recordDelimiter, this.sourceDataSetAttributes.includeTrailingSpaces(), false);
            sourceDisposition = this.sourceDataSetAttributes.getSourceDisposition();
        } else if (sourceItemType == ItemType.MESSAGE) {
            String queueName = this.sourceQueue.getQueueName();
            String queueMgrName = this.sourceQueue.getQMgrName();
            QueueProperties.SchemaSet ms = new QueueProperties.SchemaSet(null, this.sourceQueueAttributes.getAttributes(), null);
            sourceItem = new TransferItem.QueueItem(queueName, queueMgrName, ms, null, this.sourceEncoding.getValue());
        } else {
            Tools.internalError(new Exception(), "Invalid source type of " + (Object)((Object)sourceItemType), new Object[0]);
        }
        ItemType destinationItemType = ItemType.getByLabel(this.destinationTypeCombo.getText());
        TransferItem.BaseItem destinationItem = null;
        if (destinationItemType == ItemType.FILE) {
            name = this.destinationFileName == null ? "" : this.destinationFileName.getLocation().trim();
            destinationItem = new TransferItem.FileItem(name, false, this.destinationEOLAttributes.getValue(), this.destinationEncoding.getValue());
            destinationDisposition = this.destinationFileAttributes.getDestinationDisposition();
            destinationSpecificDistributionType = this.destinationFileAttributes.getSpecificDistributionType();
        } else if (destinationItemType == ItemType.DIRECTORY) {
            path = this.destinationDirectoryName == null ? "" : this.destinationDirectoryName.getLocation().trim();
            destinationItem = new TransferItem.DirItem(path, false, this.destinationEOLAttributes.getValue(), this.destinationEncoding.getValue());
            destinationDisposition = this.destinationFileAttributes.getDestinationDisposition();
            destinationSpecificDistributionType = this.destinationFileAttributes.getSpecificDistributionType();
        } else if (destinationItemType == ItemType.SDS) {
            name = this.destinationDataSet == null ? "" : this.destinationDataSet.getLocation().trim();
            destinationItem = new TransferItem.DataSetItem(name, false, this.destinationDataSetAttributes.getAttributes(), this.destinationEOLAttributes.getValue(), this.destinationEncoding.getValue(), null, false, this.destinationDataSetAttributes.isOverSizeTruncated());
            destinationDisposition = this.destinationDataSetAttributes.getDestinationDisposition();
            destinationOverSizeRec = this.destinationDataSetAttributes.getOverSizeDatasetRecord();
        } else if (destinationItemType == ItemType.PDS) {
            name = this.destinationPartitionedDataSet == null ? "" : this.destinationPartitionedDataSet.getLocation().trim();
            destinationItem = new TransferItem.DataSetItem(name, true, this.destinationDataSetAttributes.getAttributes(), this.destinationEOLAttributes.getValue(), this.destinationEncoding.getValue(), null, false, this.destinationDataSetAttributes.isOverSizeTruncated());
            destinationDisposition = this.destinationDataSetAttributes.getDestinationDisposition();
            destinationOverSizeRec = this.destinationDataSetAttributes.getOverSizeDatasetRecord();
        } else if (destinationItemType == ItemType.MESSAGE) {
            String queueName = this.destinationQueue.getQueueName();
            String queueMgrName = this.destinationQueue.getQMgrName();
            boolean isDestQueMgrSpecified = queueMgrName != null && !queueMgrName.trim().equals("");
            queueMgrName = isDestQueMgrSpecified ? queueMgrName.trim() : this.destinationEnvInfo.getQueueManagerName();
            QueueProperties.SchemaSet ms = new QueueProperties.SchemaSet(null, null, this.destinationQueueAttributes.getAttributes());
            destinationItem = new TransferItem.QueueItem(queueName, queueMgrName, ms, this.destinationEOLAttributes.getValue(), this.destinationEncoding.getValue());
        } else if (destinationItemType == ItemType.FILESPACE) {
            path = this.destinationFileSpace == null ? "" : this.destinationFileSpace.getLocation().trim();
            destinationItem = new TransferItem.FileSpaceItem(path, this.destinationEOLAttributes.getValue(), this.destinationEncoding.getValue());
        } else {
            Tools.internalError(new Exception(), "Invalid destination type of " + (Object)((Object)destinationItemType), new Object[0]);
        }
        TransferItem item = new TransferItem(sourceItem, destinationItem);
        item.setTransferMode(this.textTransferModeButton.getSelection() ? TransferItem.TransferModeType.TEXT : TransferItem.TransferModeType.BINARY);
        item.setSourceDisposition(sourceDisposition);
        item.setDestinationDisposition(destinationDisposition);
        item.setDestinationSpecificDistributionType(destinationSpecificDistributionType);
        item.setDestinationOversizeRec(destinationOverSizeRec);
        return item;
    }

    public static enum ItemType {
        FILE(Elements.UI_WIZARD_V2_ITEM_DIALOG_FILE_TYPE, false, false, LocationMenuType.Both),
        DIRECTORY(Elements.UI_WIZARD_V2_ITEM_DIALOG_DIRECTORY_TYPE, true, false, LocationMenuType.Both),
        DATASET(Elements.UI_WIZARD_V2_ITEM_DIALOG_DATASET_TYPE, false, false, LocationMenuType.Source),
        SDS(Elements.UI_WIZARD_V2_ITEM_DIALOG_SDS_TYPE, false, false, LocationMenuType.Destination),
        PDS(Elements.UI_WIZARD_V2_ITEM_DIALOG_PDS_TYPE, true, false, LocationMenuType.Destination),
        MESSAGE(Elements.UI_WIZARD_V2_ITEM_DIALOG_MESSAGE_TYPE, false, false, LocationMenuType.Both),
        FILESPACE(Elements.UI_WIZARD_V2_ITEM_DIALOG_FILESPACE_TYPE, true, false, LocationMenuType.Destination);

        private static Map<AgentType, ItemType[]> supportedSourceAgentTypes;
        private static Map<AgentType, ItemType[]> supportedDestinationAgentTypes;
        private static List<ItemType> allSupportedSourceAgentTypes;
        private static List<ItemType> allSupportedDestinationAgentTypes;
        private String comboLabel;
        private boolean isContainer;
        private boolean remoteEndDependant;
        private LocationMenuType locationMenuType;

        static {
            supportedSourceAgentTypes = new HashMap<AgentType, ItemType[]>();
            supportedDestinationAgentTypes = new HashMap<AgentType, ItemType[]>();
            allSupportedSourceAgentTypes = Arrays.asList(FILE, DIRECTORY, DATASET, SDS, PDS, MESSAGE);
            supportedSourceAgentTypes.put(AgentType.STANDARD, new ItemType[]{FILE, DIRECTORY, DATASET, SDS, PDS, MESSAGE});
            supportedSourceAgentTypes.put(AgentType.EMBEDDED, new ItemType[]{FILE, DIRECTORY, DATASET, SDS, PDS, MESSAGE});
            supportedSourceAgentTypes.put(AgentType.WEB_GATEWAY, new ItemType[]{FILESPACE});
            supportedSourceAgentTypes.put(AgentType.BRIDGE, new ItemType[]{FILE, DIRECTORY});
            supportedSourceAgentTypes.put(AgentType.CD_BRIDGE, new ItemType[]{FILE, DATASET, SDS, PDS});
            supportedSourceAgentTypes.put(AgentType.SFG, new ItemType[]{FILE, DIRECTORY, DATASET, SDS, PDS, MESSAGE});
            allSupportedDestinationAgentTypes = Arrays.asList(FILE, DIRECTORY, DATASET, SDS, PDS, MESSAGE, FILESPACE);
            supportedDestinationAgentTypes.put(AgentType.STANDARD, new ItemType[]{FILE, DIRECTORY, DATASET, SDS, PDS, MESSAGE});
            supportedDestinationAgentTypes.put(AgentType.EMBEDDED, new ItemType[]{FILE, DIRECTORY, DATASET, SDS, PDS, MESSAGE});
            supportedDestinationAgentTypes.put(AgentType.WEB_GATEWAY, new ItemType[]{FILESPACE});
            supportedDestinationAgentTypes.put(AgentType.BRIDGE, new ItemType[]{FILE, DIRECTORY});
            supportedDestinationAgentTypes.put(AgentType.CD_BRIDGE, new ItemType[]{FILE, DIRECTORY, DATASET, SDS, PDS});
            supportedDestinationAgentTypes.put(AgentType.SFG, new ItemType[]{FILE, DIRECTORY, DATASET, SDS, PDS, MESSAGE});
        }

        private ItemType(String comboLabel, boolean isContainer, boolean remoteEndDependant, LocationMenuType locationMenuType) {
            this.comboLabel = comboLabel;
            this.isContainer = isContainer;
            this.remoteEndDependant = remoteEndDependant;
            this.locationMenuType = locationMenuType;
        }

        public boolean isRemoteEndDependant() {
            return this.remoteEndDependant;
        }

        public boolean isContainer() {
            return this.isContainer;
        }

        public LocationMenuType getLocationMenuType() {
            return this.locationMenuType;
        }

        public String getComboName() {
            return this.comboLabel;
        }

        public boolean includeInTypeMenu(LocationMenuType locationMenu) {
            return this.locationMenuType == LocationMenuType.Both || this.locationMenuType == locationMenu;
        }

        public static List<ItemType> listOfItemTypes(AgentType localAgentType, AgentType remoteAgentType, LocationMenuType locationMenuType) {
            List<ItemType> localItemType = ItemType.getSupportedSourceAgentTypes(localAgentType);
            List<ItemType> remoteItemType = remoteAgentType == null ? null : ItemType.getSupportedDestinationAgentTypes(remoteAgentType);
            ArrayList<ItemType> types = new ArrayList<ItemType>();
            for (ItemType item : localItemType) {
                if (!item.includeInTypeMenu(locationMenuType) || item.isRemoteEndDependant() && remoteItemType != null && !remoteItemType.contains((Object)item)) continue;
                types.add(item);
            }
            return types;
        }

        public static List<ItemType> listOfItemTypes(AgentDetails localAgent, LocationMenuType locationMenuType) {
            AgentType agentType = localAgent == null ? null : localAgent.getAgentType();
            ArrayList<ItemType> localItemType = locationMenuType == LocationMenuType.Source ? new ArrayList<ItemType>(ItemType.getSupportedSourceAgentTypes(agentType)) : new ArrayList<ItemType>(ItemType.getSupportedDestinationAgentTypes(agentType));
            if (localAgent != null && !localAgent.isOSPlatform("z/OS")) {
                localItemType.remove((Object)DATASET);
                localItemType.remove((Object)PDS);
                localItemType.remove((Object)SDS);
            }
            ArrayList<ItemType> types = new ArrayList<ItemType>();
            for (ItemType item : localItemType) {
                if (!item.includeInTypeMenu(locationMenuType)) continue;
                types.add(item);
            }
            return types;
        }

        public static String[] listOfTypes(AgentDetails localAgent, LocationMenuType locationMenuType) {
            List<ItemType> types = ItemType.listOfItemTypes(localAgent, locationMenuType);
            ArrayList<String> names = new ArrayList<String>();
            for (ItemType type : types) {
                names.add(type.comboLabel);
            }
            return names.toArray(new String[0]);
        }

        public static ItemType getByPosition(int position) {
            return position >= 0 || position < ItemType.values().length ? ItemType.values()[position] : null;
        }

        public static ItemType getByLabel(String label) {
            int i = 0;
            while (i < ItemType.values().length) {
                if (ItemType.values()[i].comboLabel.equalsIgnoreCase(label)) {
                    return ItemType.values()[i];
                }
                ++i;
            }
            return null;
        }

        public static int getSize(Composite parent) {
            ArrayList<String> labels = new ArrayList<String>();
            ItemType[] itemTypeArray = ItemType.values();
            int n = itemTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemType type = itemTypeArray[n2];
                labels.add(type.comboLabel);
                ++n2;
            }
            return Tools.getWidth(parent, labels.toArray(new String[0]));
        }

        private static List<ItemType> getSupportedSourceAgentTypes(AgentType agentType) {
            List<ItemType> itemTypes = agentType == null ? allSupportedSourceAgentTypes : Arrays.asList(supportedSourceAgentTypes.get(agentType));
            return itemTypes;
        }

        private static List<ItemType> getSupportedDestinationAgentTypes(AgentType agentType) {
            List<ItemType> itemTypes = agentType == null ? allSupportedDestinationAgentTypes : Arrays.asList(supportedDestinationAgentTypes.get(agentType));
            return itemTypes;
        }
    }

    public static enum LocationMenuType {
        None,
        Source,
        Destination,
        Both;

    }
}

