/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.dialogs;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.utils.AgentDetails;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.utils.v2.ControlGroup;
import com.ibm.wmqfte.explorer.utils.v2.PriorityStatus;
import com.ibm.wmqfte.explorer.utils.v2.SectionHistory;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.io.zos.DatasetUtils;
import com.ibm.wmqfte.runcommand.CommandType;
import com.ibm.wmqfte.utils.xmlmessage.transfer.CallSpecificationException;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ProgramCall;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class InvocationDialog
extends TitleAreaDialog {
    private Combo callOutTypeCombo;
    private Label commandLabel;
    private Combo commandCombo;
    private Combo argumentsCombo;
    private Button defaultTargetButton;
    private Button specificTargetButton;
    private Combo targetCombo;
    private Spinner retryCountSpinner;
    private Spinner retryWaitSpinner;
    private Combo successQualiferCombo;
    private Spinner successQualiferSpinner;
    private Spinner prioritySpinner;
    private Combo messageTextCombo;
    private ControlGroup completeCG;
    private ControlGroup outerCG;
    private ControlGroup argumentCG;
    private ControlGroup targetsCG;
    private ControlGroup successCG;
    private ControlGroup propertiesCG;
    private ControlGroup retriesCG;
    private ControlGroup waitCG;
    private ControlGroup os4690backgroundCG;
    private final Map<String, String> antVariables = new TreeMap<String, String>();
    private TableViewer tbv;
    private final String callOutName;
    private final String message;
    private ProgramCall programCall;
    private AgentDetails agentDetails;

    public InvocationDialog(Shell parentShell, String callOutName, String message) {
        super(parentShell);
        this.callOutName = callOutName;
        this.message = message;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    private ProgramCall generateProgramCall() {
        CommandOptions ct;
        ProgramCall pc = null;
        if (this.callOutTypeCombo != null && !this.callOutTypeCombo.isDisposed() && (ct = CommandOptions.getByName(this.callOutTypeCombo.getText())).isCommandRequired()) {
            String command = null;
            try {
                command = this.getProgramCallString();
                pc = ProgramCall.fromString((String)command);
            }
            catch (CallSpecificationException ex) {
                Tools.internalError(ex, Elements.UI_WIZARD_V2_INTERR_NEW_TRANSFER_CALL_OUT_VALIDATION, command, ex.getLocalizedMessage());
            }
        }
        return pc;
    }

    public ProgramCall getProgramCall() {
        return this.programCall;
    }

    public int open() {
        this.setMessage("");
        this.setMessage(this.message);
        return super.open();
    }

    public boolean close() {
        if (this.getReturnCode() == 0) {
            this.programCall = this.generateProgramCall();
            this.saveHistory();
        }
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        final Composite area = (Composite)super.createDialogArea(parent);
        ExplorerPlugin.setHelp((Control)area, "com.ibm.wmqfte.explorer.context.UI_Invocation");
        final ScrolledComposite scrolledComposite = new ScrolledComposite(area, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        final Composite container = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)container);
        this.initializeDialogUnits((Control)container);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(2, false));
        int hintWidthLabel = Tools.getWidth(container, new String[]{Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_COMMAND_TYPE_LABEL, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_COMMAND_LABEL, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_ARGUMENTS_LABEL, Elements.UI_WIZARD_V2_INVOCATION_DIALOG_SCRIPT_LABEL, Elements.UI_WIZARD_V2_INVOCATION_DIALOG_JOBSTREAM_LABEL, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_PRIORITY_LABEL, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_MESSAGE_LABEL});
        this.completeCG = new ControlGroup("Call out - complete");
        this.completeCG.add((Control)container);
        this.createLabel(container, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_COMMAND_TYPE_LABEL, hintWidthLabel, this.completeCG);
        this.callOutTypeCombo = new Combo(container, 8);
        String[] availableCommandOptions = this.getAvailableCommandOptions();
        this.callOutTypeCombo.setItems(availableCommandOptions);
        int indexOfAnt = Arrays.asList(availableCommandOptions).indexOf(CommandOptions.ANT.fullName);
        this.callOutTypeCombo.select(indexOfAnt);
        this.completeCG.add((Control)this.callOutTypeCombo);
        this.outerCG = new ControlGroup("Call out - outer");
        this.completeCG.add(this.outerCG);
        this.argumentCG = new ControlGroup("Argument/Call out");
        this.targetsCG = new ControlGroup("Ant Targets");
        this.successCG = new ControlGroup("Success RC CG");
        this.os4690backgroundCG = new ControlGroup("OS4690 Background CG");
        this.propertiesCG = new ControlGroup("Ant Properties");
        this.retriesCG = new ControlGroup("Retries options");
        this.outerCG.add(this.argumentCG);
        this.outerCG.add(this.targetsCG);
        this.outerCG.add(this.successCG);
        this.outerCG.add(this.os4690backgroundCG);
        this.outerCG.add(this.propertiesCG);
        this.outerCG.add(this.retriesCG);
        this.commandLabel = this.createLabel(container, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_COMMAND_LABEL, hintWidthLabel, this.outerCG);
        this.commandCombo = this.createCombo(container, 0, this.outerCG);
        Label argumentLabel = this.createLabel(container, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_ARGUMENTS_LABEL, hintWidthLabel, this.outerCG);
        this.argumentsCombo = this.createCombo(container, 0, this.outerCG);
        this.argumentCG.add((Control)argumentLabel);
        this.argumentCG.add((Control)this.argumentsCombo);
        if (this.agentDetails != null && this.agentDetails.isOSPlatform("4690 OS")) {
            this.createLabel(container, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_PRIORITY_LABEL, hintWidthLabel, this.os4690backgroundCG);
            this.prioritySpinner = new Spinner(container, 2048);
            this.prioritySpinner.setValues(5, 1, 9, 0, 1, 1);
            this.os4690backgroundCG.add((Control)this.prioritySpinner);
            this.createLabel(container, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_MESSAGE_LABEL, hintWidthLabel, this.os4690backgroundCG);
            this.messageTextCombo = this.createCombo(container, 0, this.os4690backgroundCG);
            this.messageTextCombo.setTextLimit(46);
            this.messageTextCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.os4690backgroundCG.add((Control)this.messageTextCombo);
        }
        Label targetsLabel = new Label(container, 131072);
        targetsLabel.setText(Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_TARGETS_LABEL);
        GridData gd = new GridData(0x1000008, 1, false, false, 1, 2);
        gd.verticalIndent = 4;
        gd.widthHint = hintWidthLabel;
        targetsLabel.setLayoutData((Object)gd);
        this.outerCG.add((Control)targetsLabel);
        this.targetsCG.add((Control)targetsLabel);
        Composite targets = new Composite(container, 0);
        GridData gd2 = new GridData(4, 0x1000000, false, false, 1, 2);
        targets.setLayoutData((Object)gd2);
        targets.setLayout((Layout)new GridLayout(2, false));
        this.defaultTargetButton = new Button(targets, 16);
        this.defaultTargetButton.setText(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_DEFAULT_TARGET_BUTTON);
        this.defaultTargetButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.defaultTargetButton.setSelection(true);
        this.outerCG.add((Control)this.defaultTargetButton);
        this.targetsCG.add((Control)this.defaultTargetButton);
        this.specificTargetButton = new Button(targets, 16);
        this.specificTargetButton.setText(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_SPECIFIC_TARGET_BUTTON);
        this.specificTargetButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.outerCG.add((Control)this.specificTargetButton);
        this.targetsCG.add((Control)this.specificTargetButton);
        this.targetCombo = this.createCombo(targets, 0, this.outerCG);
        this.targetsCG.add((Control)this.targetCombo);
        Composite successQualifier = new Composite(container, 0);
        successQualifier.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        successQualifier.setLayout((Layout)new GridLayout(3, false));
        this.successCG.add((Control)successQualifier);
        Label successQualifierLabel = new Label(successQualifier, 0);
        successQualifierLabel.setText(Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_SUCCESS_LABEL);
        GridData gd3 = new GridData(1, 0x1000000, false, false);
        successQualifierLabel.setLayoutData((Object)gd3);
        this.successCG.add((Control)successQualifierLabel);
        this.successQualiferCombo = this.createCombo(successQualifier, 8, this.successCG);
        this.successQualiferCombo.setItems(new String[]{Elements.UI_WIZARD_V2_INVOCATION_DIALOG_IS_LESS_THAN, Elements.UI_WIZARD_V2_INVOCATION_DIALOG_EQUALS, Elements.UI_WIZARD_V2_INVOCATION_DIALOG_DOES_NOT_EQUAL, Elements.UI_WIZARD_V2_INVOCATION_DIALOG_IS_GREATER_THAN});
        this.successQualiferCombo.select(1);
        this.successQualiferSpinner = new Spinner(successQualifier, 2048);
        this.successQualiferSpinner.setMinimum(-9999);
        this.successQualiferSpinner.setIncrement(1);
        this.successQualiferSpinner.setMaximum(9999);
        this.successCG.add((Control)this.successQualiferCombo);
        this.successCG.add((Control)this.successQualiferSpinner);
        Group antProperties = new Group(container, 0);
        antProperties.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        antProperties.setText(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_PROPERTIES_LABEL);
        this.propertiesCG.add((Control)antProperties);
        antProperties.setLayout((Layout)new GridLayout(2, false));
        Label title = new Label((Composite)antProperties, 0);
        title.setText(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_PROPERTIES_DESC);
        title.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 2, 1));
        int hintWidthLabel2 = Tools.getWidth(container, new String[]{String.valueOf(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_PROPERTYNAME_LABEL) + ":", String.valueOf(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_PROPERTYVALUE_LABEL) + ":"});
        this.createLabel((Composite)antProperties, String.valueOf(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_PROPERTYNAME_LABEL) + ":", hintWidthLabel2, this.propertiesCG);
        final Combo name = this.createCombo((Composite)antProperties, 0, this.propertiesCG);
        this.createLabel((Composite)antProperties, String.valueOf(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_PROPERTYVALUE_LABEL) + ":", hintWidthLabel2, this.propertiesCG);
        final Combo value = this.createCombo((Composite)antProperties, 0, this.propertiesCG);
        Composite buttons = new Composite((Composite)antProperties, 0);
        this.propertiesCG.add((Control)buttons);
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 2, 1));
        buttons.setLayout((Layout)new GridLayout(2, false));
        final Button addButton = new Button(buttons, 0);
        this.propertiesCG.add((Control)addButton);
        addButton.setText(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_ADD_BUTTON);
        addButton.setEnabled(false);
        addButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        final Button removeButton = new Button(buttons, 0);
        this.propertiesCG.add((Control)removeButton);
        removeButton.setText(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_REMOVE_BUTTON);
        removeButton.setEnabled(false);
        removeButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                addButton.setEnabled(name.getText().length() > 0 && value.getText().length() > 0);
            }
        });
        value.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                addButton.setEnabled(name.getText().length() > 0 && value.getText().length() > 0);
            }
        });
        this.tbv = new TableViewer((Composite)antProperties, 68354);
        this.tbv.setContentProvider((IContentProvider)new PropertiesContentProvider());
        this.tbv.setLabelProvider((IBaseLabelProvider)new PropertiesLabelProvider());
        this.tbv.setInput(PageUtils.getEmptyList(3));
        Table table = this.tbv.getTable();
        TableColumn n = new TableColumn(table, 16384);
        n.setText(String.valueOf(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_PROPERTYNAME_LABEL) + "    ");
        TableColumn v = new TableColumn(table, 16384);
        v.setText(String.valueOf(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_PROPERTYVALUE_LABEL) + "    ");
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        table.pack();
        n.pack();
        v.pack();
        this.propertiesCG.add((Control)table);
        table.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.tbv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (InvocationDialog.this.tbv.getInput() == InvocationDialog.this.antVariables) {
                    removeButton.setEnabled(!event.getSelection().isEmpty());
                } else {
                    InvocationDialog.this.tbv.setInput((Object)InvocationDialog.this.antVariables);
                }
            }
        });
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (name.getText().length() > 0 && value.getText().length() > 0) {
                    if (InvocationDialog.this.tbv.getInput() != InvocationDialog.this.antVariables) {
                        InvocationDialog.this.tbv.setInput((Object)InvocationDialog.this.antVariables);
                    }
                    InvocationDialog.this.antVariables.put(name.getText(), value.getText());
                    name.setText("");
                    value.setText("");
                    name.notifyListeners(24, new Event());
                    InvocationDialog.this.tbv.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ISelection s = InvocationDialog.this.tbv.getSelection();
                if (s instanceof IStructuredSelection) {
                    for (Object o : ((IStructuredSelection)s).toList()) {
                        if (!(o instanceof Map.Entry)) continue;
                        InvocationDialog.this.antVariables.remove(((Map.Entry)o).getKey());
                    }
                    InvocationDialog.this.tbv.refresh();
                }
            }
        });
        Group retryAttrGroup = new Group(container, 0);
        retryAttrGroup.setText(Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_RETRY_ATTR_GROUP);
        retryAttrGroup.setLayout((Layout)new GridLayout(3, false));
        retryAttrGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.retriesCG.add((Control)retryAttrGroup);
        int hintWidthRetryAttrLabel = Tools.getWidth(container, new String[]{Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_RETRY_COUNT_LABEL, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_RETRY_WAIT_LABEL});
        this.createLabel((Composite)retryAttrGroup, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_RETRY_COUNT_LABEL, hintWidthRetryAttrLabel, this.retriesCG);
        this.retryCountSpinner = new Spinner((Composite)retryAttrGroup, 2048);
        this.retryCountSpinner.setMinimum(0);
        this.retryCountSpinner.setIncrement(1);
        this.retryCountSpinner.setMaximum(999);
        this.retriesCG.add((Control)this.retryCountSpinner);
        this.createLabel((Composite)retryAttrGroup, null, hintWidthRetryAttrLabel, this.retriesCG);
        this.waitCG = new ControlGroup("Wait/CallOut");
        Label retryWaitLabel = this.createLabel((Composite)retryAttrGroup, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_RETRY_WAIT_LABEL, hintWidthRetryAttrLabel, this.retriesCG);
        this.retryWaitSpinner = new Spinner((Composite)retryAttrGroup, 2048);
        this.retryWaitSpinner.setMinimum(0);
        this.retryWaitSpinner.setIncrement(1);
        this.retryWaitSpinner.setMaximum(999);
        Label retryWaitUnits = new Label((Composite)retryAttrGroup, 0);
        retryWaitUnits.setText(Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_RETRY_WAIT_UNITS);
        GridData gd4 = new GridData(1, 0x1000000, false, false);
        retryWaitUnits.setLayoutData((Object)gd4);
        this.waitCG.add((Control)retryWaitUnits);
        this.waitCG.add((Control)retryWaitLabel);
        this.waitCG.add((Control)this.retryWaitSpinner);
        this.waitCG.enabled(false);
        this.retriesCG.add(this.waitCG);
        this.updateContents();
        this.callOutTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                InvocationDialog.this.updateContents();
                container.layout();
                InvocationDialog.this.checkPageForErrors();
                scrolledComposite.setMinSize(container.computeSize(-1, -1));
            }
        });
        this.commandCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InvocationDialog.this.checkPageForErrors();
            }
        });
        this.argumentsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InvocationDialog.this.checkPageForErrors();
            }
        });
        this.successQualiferCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InvocationDialog.this.checkPageForErrors();
            }
        });
        this.retryCountSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InvocationDialog.this.waitCG.enabled(InvocationDialog.this.retryCountSpinner.getSelection() != 0);
            }
        });
        this.targetCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InvocationDialog.this.checkPageForErrors();
            }
        });
        this.defaultTargetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InvocationDialog.this.targetCombo.setEnabled(!InvocationDialog.this.defaultTargetButton.getSelection());
                InvocationDialog.this.checkPageForErrors();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.specificTargetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InvocationDialog.this.targetCombo.setEnabled(InvocationDialog.this.specificTargetButton.getSelection());
                if (InvocationDialog.this.specificTargetButton.getSelection()) {
                    InvocationDialog.this.targetCombo.setFocus();
                }
                InvocationDialog.this.checkPageForErrors();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setTitle(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_INVOCATION_TITLE);
        this.getShell().setText(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_INVOCATION_TITLE);
        area.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                area.layout();
                container.layout();
                scrolledComposite.setMinSize(container.computeSize(-1, -1));
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        area.notifyListeners(11, new Event());
        return area;
    }

    protected Point getInitialSize() {
        Point point = this.getContents() == null ? super.getInitialSize() : this.getContents().getParent().computeSize(-1, -1, true);
        return point;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void loadValues(ProgramCall programCall) {
        if (this.callOutTypeCombo == null || this.callOutTypeCombo.isDisposed()) {
            return;
        }
        if (programCall == null) {
            this.callOutTypeCombo.select(0);
            this.callOutTypeCombo.notifyListeners(13, new Event());
        } else {
            CommandOptions co = CommandOptions.getByCommandTypeName(programCall.getCommandType());
            this.callOutTypeCombo.setItems(this.getAvailableCommandOptions());
            this.callOutTypeCombo.setText(co.getFullname());
            this.callOutTypeCombo.notifyListeners(13, new Event());
            this.commandCombo.setText(programCall.getCommand());
            if (co.isRequiresArgument()) {
                this.argumentsCombo.setText(programCall.getArguments());
            } else if (co.isRequiresTargetProps()) {
                String t = programCall.getTargets();
                Map properties = programCall.getProperties();
                if (t != null && t.length() > 0) {
                    this.targetCombo.setText(t);
                    this.defaultTargetButton.setSelection(false);
                    this.specificTargetButton.setSelection(true);
                    this.specificTargetButton.notifyListeners(13, new Event());
                }
                if (properties != null && !properties.isEmpty()) {
                    this.antVariables.putAll(properties);
                    this.tbv.setInput(this.antVariables);
                    this.tbv.refresh();
                }
            }
            String success = programCall.getSuccesRC();
            if (success != null && success.length() > 0) {
                if (success.charAt(0) == '<') {
                    this.successQualiferCombo.select(0);
                    this.successQualiferSpinner.setSelection(Integer.parseInt(success.substring(1)));
                } else if (success.charAt(0) == '!') {
                    this.successQualiferCombo.select(2);
                    this.successQualiferSpinner.setSelection(Integer.parseInt(success.substring(1)));
                } else if (success.charAt(0) == '>') {
                    this.successQualiferCombo.select(3);
                    this.successQualiferSpinner.setSelection(Integer.parseInt(success.substring(1)));
                } else {
                    this.successQualiferCombo.select(1);
                    this.successQualiferSpinner.setSelection(Integer.parseInt(success));
                }
            }
            this.retryCountSpinner.setSelection(programCall.getRetryCount());
            this.retryWaitSpinner.setSelection(programCall.getRetryWait());
        }
    }

    public String[] getAvailableCommandOptions() {
        return new String[]{CommandOptions.NONE.fullName, CommandOptions.EXEC.fullName, CommandOptions.ANT.fullName, CommandOptions.JCL.fullName};
    }

    public void checkPageForErrors() {
        CommandOptions ct;
        PriorityStatus ps = new PriorityStatus(this.message);
        if (this.callOutTypeCombo != null && !this.callOutTypeCombo.isDisposed() && (ct = CommandOptions.getByName(this.callOutTypeCombo.getText())).isCommandRequired()) {
            if (this.commandCombo.getText() == null || this.commandCombo.getText().trim().length() == 0) {
                ps.setIncomplete();
            } else {
                block11: {
                    try {
                        String commandString = this.getProgramCallString();
                        ProgramCall.fromString((String)commandString);
                    }
                    catch (CallSpecificationException ex) {
                        if (ex.getLocalizedMessage() == null) break block11;
                        if (ex.getLocalizedMessage().startsWith("BFGPR0054")) {
                            ps.setError(MessageFormat.format(Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_COMMAND_REQUIRED, this.callOutName));
                        }
                        if (ex.getLocalizedMessage().startsWith("BFGPR0055")) {
                            ps.setError(MessageFormat.format(Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_BAD_ARGUMENTS, this.callOutName));
                        }
                        if (ex.getLocalizedMessage().startsWith("BFGPR0056")) {
                            ps.setError(MessageFormat.format(Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_ARGUMENT_NOT_SUPP, this.callOutName));
                        }
                        if (ex.getLocalizedMessage().startsWith("BFGPR0057")) {
                            ps.setError(MessageFormat.format(Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_COMMAND_INVALID, this.callOutName));
                        }
                        ps.setError(ex.getLocalizedMessage());
                    }
                }
                CommandType commandType = CommandOptions.getByName(this.callOutTypeCombo.getText()).getCommandType();
                if (commandType == CommandType.JCL && !DatasetUtils.validDSN((String)this.commandCombo.getText())) {
                    ps.setError(MessageFormat.format(Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_JCL_INVALIDNAME, this.commandCombo.getText()));
                }
            }
        }
        ps.updateTitleStatus(this);
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(ps.isComplete());
        }
    }

    public void saveHistory() {
        if (this.callOutTypeCombo == null || this.callOutTypeCombo.isDisposed()) {
            return;
        }
        switch (CommandOptions.getByName(this.callOutTypeCombo.getText())) {
            case EXEC: {
                this.addHistory(SectionHistory.HistoryReference.CALL_OUT_COMMAND_EXEC, this.commandCombo.getText());
                this.addHistory(SectionHistory.HistoryReference.CALL_OUT_ARGUMENTS_EXEC, this.argumentsCombo.getText());
                break;
            }
            case ANT: {
                this.addHistory(SectionHistory.HistoryReference.CALL_OUT_COMMAND_ANT, this.commandCombo.getText());
                this.addHistory(SectionHistory.HistoryReference.CALL_OUT_ARGUMENTS_ANT, this.argumentsCombo.getText());
                this.addHistory(SectionHistory.HistoryReference.CALL_OUT_SUCCESS_ANT, this.successQualiferCombo.getText());
                break;
            }
            case JCL: {
                this.addHistory(SectionHistory.HistoryReference.CALL_OUT_COMMAND_JCL, this.commandCombo.getText());
                break;
            }
            case NONE: {
                break;
            }
        }
    }

    private void addHistory(SectionHistory.HistoryReference historyReference, String value) {
        if (value != null && value.length() > 0) {
            historyReference.put(value);
        }
    }

    private void updateContents() {
        switch (CommandOptions.getByName(this.callOutTypeCombo.getText())) {
            case NONE: {
                this.outerCG.visible(false);
                this.argumentCG.visible(false);
                this.targetsCG.visible(false);
                this.successCG.visible(false);
                this.propertiesCG.visible(false);
                this.retriesCG.visible(false);
                this.os4690backgroundCG.visible(false);
                break;
            }
            case EXEC: {
                this.commandLabel.setText(Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_COMMAND_LABEL);
                SectionHistory.HistoryReference.CALL_OUT_COMMAND_EXEC.loadHistory(this.commandCombo);
                SectionHistory.HistoryReference.CALL_OUT_ARGUMENTS_EXEC.loadHistory(this.argumentsCombo);
                this.outerCG.visible(true);
                this.argumentCG.visible(true);
                this.targetsCG.visible(false);
                this.successCG.visible(true);
                this.propertiesCG.visible(false);
                this.retriesCG.visible(true);
                this.os4690backgroundCG.visible(false);
                break;
            }
            case ANT: {
                this.commandLabel.setText(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_SCRIPT_LABEL);
                SectionHistory.HistoryReference.CALL_OUT_COMMAND_ANT.loadHistory(this.commandCombo);
                SectionHistory.HistoryReference.CALL_OUT_ARGUMENTS_ANT.loadHistory(this.argumentsCombo);
                this.outerCG.visible(true);
                this.argumentCG.visible(false);
                this.targetsCG.visible(true);
                this.successCG.visible(true);
                this.propertiesCG.visible(true);
                this.retriesCG.visible(true);
                this.os4690backgroundCG.visible(false);
                break;
            }
            case JCL: {
                this.commandLabel.setText(Elements.UI_WIZARD_V2_INVOCATION_DIALOG_JOBSTREAM_LABEL);
                SectionHistory.HistoryReference.CALL_OUT_COMMAND_JCL.loadHistory(this.commandCombo);
                this.outerCG.visible(true);
                this.argumentCG.visible(false);
                this.targetsCG.visible(false);
                this.successCG.visible(false);
                this.propertiesCG.visible(false);
                this.retriesCG.visible(false);
                this.os4690backgroundCG.visible(false);
                break;
            }
        }
        this.specificTargetButton.notifyListeners(13, new Event());
    }

    private Label createLabel(Composite comp, String nlsTitle, int width, ControlGroup cg) {
        Label label = new Label(comp, 131072);
        if (nlsTitle != null) {
            label.setText(nlsTitle);
        }
        GridData gd = new GridData(0x1000008, 0x1000000, false, false);
        gd.widthHint = width;
        label.setLayoutData((Object)gd);
        if (cg != null) {
            cg.add((Control)label);
        }
        return label;
    }

    private String getProgramCallString() {
        String argument;
        StringBuilder sb = new StringBuilder();
        CommandType commandType = CommandOptions.getByName(this.callOutTypeCombo.getText()).getCommandType();
        sb.append(commandType.toString().toUpperCase());
        sb.append(":");
        sb.append(ProgramCall.escapeCommand((String)this.commandCombo.getText().replace("\\", "\\\\")));
        if (commandType == CommandType.ANTSCRIPT && (this.specificTargetButton.getSelection() || !this.antVariables.isEmpty())) {
            sb.append("(");
            String prefix = "";
            String target = this.targetCombo.getText();
            if (target != null && target.trim().length() > 0) {
                sb.append(ProgramCall.escapeCommand((String)target));
                prefix = ",";
            }
            if (!this.antVariables.isEmpty()) {
                for (Map.Entry<String, String> entry : this.antVariables.entrySet()) {
                    sb.append(prefix);
                    sb.append(ProgramCall.escapeCommand((String)entry.getKey().replace("\\", "\\\\"))).append('=').append(ProgramCall.escapeCommand((String)entry.getValue().replace("\\", "\\\\")));
                    prefix = ",";
                }
            }
            sb.append(")");
        }
        if (commandType == CommandType.EXECUTABLE && (argument = this.argumentsCombo.getText()) != null && argument.trim().length() > 0) {
            sb.append("(");
            sb.append(argument.replace("\\", "\\\\").replace("(", "\\(").replace(")", "\\)"));
            sb.append(")");
        }
        if (commandType == CommandType.ANTSCRIPT || commandType == CommandType.EXECUTABLE) {
            sb.append(",");
            sb.append(this.retryCountSpinner.getSelection());
            sb.append(",");
            sb.append(this.retryWaitSpinner.getSelection());
            sb.append(",");
            if (this.successQualiferCombo.getSelectionIndex() == 0) {
                sb.append("<");
            } else if (this.successQualiferCombo.getSelectionIndex() == 2) {
                sb.append("!");
            } else if (this.successQualiferCombo.getSelectionIndex() == 3) {
                sb.append(">");
            }
            sb.append(this.successQualiferSpinner.getSelection());
        }
        return sb.toString();
    }

    private Combo createCombo(Composite comp, int style, ControlGroup cg) {
        Combo c = new Combo(comp, style);
        c.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (cg != null) {
            cg.add((Control)c);
        }
        return c;
    }

    public void setAgentDetails(AgentDetails agentDetails) {
        this.agentDetails = agentDetails;
    }

    private static enum CommandOptions {
        NONE(false, false, false, null, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_NONE_TYPE),
        EXEC(true, true, false, CommandType.EXECUTABLE, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_EXEC_TYPE),
        ANT(true, false, true, CommandType.ANTSCRIPT, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_ANT_TYPE),
        JCL(true, false, false, CommandType.JCL, Elements.UI_WIZARD_V2_NEW_TRANSFER_CALL_OUT_JCL_TYPE);

        private final boolean requiresCommand;
        private final boolean requiresArgument;
        private final boolean requiresTargetProps;
        private final CommandType commandType;
        private final String fullName;

        private CommandOptions(boolean requiresCommand, boolean requiresArgument, boolean requiresTargetProps, CommandType commandType, String fullName) {
            this.requiresCommand = requiresCommand;
            this.requiresArgument = requiresArgument;
            this.requiresTargetProps = requiresTargetProps;
            this.commandType = commandType;
            this.fullName = fullName;
        }

        public boolean isCommandRequired() {
            return this.requiresCommand;
        }

        public String getFullname() {
            return this.fullName;
        }

        public CommandType getCommandType() {
            return this.commandType;
        }

        public boolean isRequiresArgument() {
            return this.requiresArgument;
        }

        public boolean isRequiresTargetProps() {
            return this.requiresTargetProps;
        }

        public static CommandOptions getByName(String name) {
            CommandOptions[] commandOptionsArray = CommandOptions.values();
            int n = commandOptionsArray.length;
            int n2 = 0;
            while (n2 < n) {
                CommandOptions co = commandOptionsArray[n2];
                if (co.fullName.equalsIgnoreCase(name)) {
                    return co;
                }
                ++n2;
            }
            return null;
        }

        public static CommandOptions getByCommandTypeName(CommandType ct) {
            CommandOptions[] commandOptionsArray = CommandOptions.values();
            int n = commandOptionsArray.length;
            int n2 = 0;
            while (n2 < n) {
                CommandOptions co = commandOptionsArray[n2];
                if (co.commandType == ct) {
                    return co;
                }
                ++n2;
            }
            return null;
        }
    }

    private class PropertiesContentProvider
    implements IStructuredContentProvider {
        private PropertiesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).entrySet().toArray();
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    private class PropertiesLabelProvider
    implements ITableLabelProvider {
        private PropertiesLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Map.Entry) {
                String result = columnIndex == 0 ? ((Map.Entry)element).getKey().toString() : ((Map.Entry)element).getValue().toString();
                return result;
            }
            if (element instanceof String) {
                return (String)element;
            }
            return null;
        }
    }
}

