/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.data;

import com.ibm.mq.jmqi.MQCBC;
import com.ibm.mq.jmqi.MQConsumer;
import com.ibm.mq.jmqi.MQGMO;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.wmqfte.api.ConfigurationException;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.objects.TransferTemplate;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TransferTemplateProvider
extends Observable {
    final Queue<TransferTemplate> templates = new ConcurrentLinkedQueue<TransferTemplate>();

    public TransferTemplateProvider() {
        Subscription.addTransferTemplateConsumer(new MQConsumer(){

            public void consumer(Hconn hconn, MQMD mqmd, MQGMO getMsgOpts, ByteBuffer pBuffer, MQCBC mqcbc) {
                int callBackType = mqcbc.getCallType();
                int rc = mqcbc.getReason();
                if (callBackType == 6 && rc == 0 && pBuffer != null) {
                    try {
                        final TransferTemplate tt = TransferTemplate.fromXML((byte[])pBuffer.array());
                        if (tt != null) {
                            if (TransferTemplateProvider.this.countObservers() == 0) {
                                TransferTemplateProvider.this.templates.add(tt);
                            } else {
                                TransferTemplateProvider.this.setChanged();
                                new Thread(TransferTemplateProvider.class + "#notifyObservers()"){

                                    @Override
                                    public void run() {
                                        TransferTemplateProvider.this.notifyObservers(tt);
                                    }
                                }.run();
                            }
                        }
                    }
                    catch (ConfigurationException configurationException) {}
                }
            }

            public String toString() {
                return "TransferTemplateConsumer";
            }

            public int getMaxMessages() {
                return 0;
            }
        });
    }

    @Override
    public void addObserver(Observer observer) {
        super.addObserver(observer);
        if (this.countObservers() > 0) {
            this.templates.clear();
        }
    }

    public synchronized List<TransferTemplate> getTransferTemplates() {
        ArrayList<TransferTemplate> results = new ArrayList<TransferTemplate>(this.templates);
        return results;
    }
}

