/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.data;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.CorePlugin;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.passwords.PwUtils;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.JmqiUtils;
import com.ibm.mq.jmqi.MQCBC;
import com.ibm.mq.jmqi.MQConsumer;
import com.ibm.mq.jmqi.MQGMO;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.MQOD;
import com.ibm.mq.jmqi.MQPMO;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.wmqfte.api.AbstractCommand;
import com.ibm.wmqfte.api.ApiException;
import com.ibm.wmqfte.api.FTEPropertyStore;
import com.ibm.wmqfte.api.FTEPropertyStoreFactory;
import com.ibm.wmqfte.api.InternalException;
import com.ibm.wmqfte.configuration.FTEConfigurationException;
import com.ibm.wmqfte.configuration.FTEProperties;
import com.ibm.wmqfte.configuration.FTEPropertiesFactory;
import com.ibm.wmqfte.connect.impl.SSLConnectionData;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.Messages;
import com.ibm.wmqfte.explorer.data.AgentStatusDetailsProvider;
import com.ibm.wmqfte.explorer.data.AuditProvider;
import com.ibm.wmqfte.explorer.data.MonitorProvider;
import com.ibm.wmqfte.explorer.data.ScheduleProvider;
import com.ibm.wmqfte.explorer.data.TransferStatusProvider;
import com.ibm.wmqfte.explorer.data.TransferTemplateProvider;
import com.ibm.wmqfte.explorer.treenode.MFTETreeNodeFactory;
import com.ibm.wmqfte.explorer.wizards.v2.FTEConfigurationWizardSettings;
import com.ibm.wmqfte.userexits.UserExitsFactory;
import com.ibm.wmqfte.utils.AgentType;
import com.ibm.wmqfte.utils.CredentialsFileException;
import com.ibm.wmqfte.utils.CredentialsUserPass;
import com.ibm.wmqfte.utils.CredentialsUserPassHelper;
import com.ibm.wmqfte.utils.FTEPropConstant;
import com.ibm.wmqfte.utils.KeyFileUtils;
import com.ibm.wmqfte.utils.ProductVersion;
import com.ibm.wmqfte.wmqiface.RFHMessageFactory;
import com.ibm.wmqfte.wmqiface.WMQApi;
import com.ibm.wmqfte.wmqiface.WMQApiException;
import com.ibm.wmqfte.wmqiface.WMQApiFactory;
import com.ibm.wmqfte.wmqiface.WMQApiFailureException;
import com.ibm.wmqfte.wmqiface.WMQApiWarningException;
import com.ibm.wmqfte.wmqiface.WMQConnection;
import com.ibm.wmqfte.wmqiface.WMQConnectionData;
import com.ibm.wmqfte.wmqiface.WMQMessage;
import com.ibm.wmqfte.wmqiface.WMQProductInstallInfo;
import com.ibm.wmqfte.wmqiface.WMQPublicationData;
import com.ibm.wmqfte.wmqiface.WMQQueue;
import com.ibm.wmqfte.wmqiface.WMQSubscription;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class Subscription {
    private static WMQConnection conn;
    private static WMQConnection agentStatusConn;
    private static WMQConnection monitorStatusConn;
    private static WMQConnection transferStatusConn;
    private static IDialogSettings settings;
    private static final String AUDIT_SUBNAME_KEY = "LOG_SUBNAME";
    private static final String AGENTS_TOPIC_PREFIX = "Agents/";
    public static String SYSTEM_FTE;
    private static WMQSubscription statusSub;
    private static WMQSubscription auditSub;
    private static WMQSubscription templateSub;
    private static WMQSubscription monitorSub;
    private static WMQSubscription scheduleSub;
    private static WMQSubscription agentStatusSub;
    private static int reasonCode;
    private static Exception propException;
    private static Exception coordinationException;
    private static Exception commandException;
    private static WMQConnectionData cmdConnectionData;
    private static String dynamicQueuePrefix;
    private static String modelQueueName;
    private static WMQConnectionData coordConnectionData;
    private static FTEPropertyStore propertyFiles;
    private static AgentStatusDetailsProvider agentStatusDetailsProvider;
    private static AuditProvider auditProvider;
    private static MonitorProvider monitorProvider;
    private static ScheduleProvider scheduleProvider;
    private static TransferStatusProvider transferStatusProvider;
    private static TransferTemplateProvider transferTemplateProvider;
    private static boolean isDurable;
    private static String subNamePrefix;
    private static Date qmTimeBase;
    private static Date localTimeBase;

    static {
        SYSTEM_FTE = "SYSTEM.FTE";
        reasonCode = 0;
        coordinationException = null;
        commandException = null;
        isDurable = true;
        subNamePrefix = "MQExplorer_MFT_Plugin_";
    }

    public static synchronized FTEPropertyStore getPropertyFiles() throws FTEConfigurationException {
        if (propertyFiles == null) {
            try {
                propException = null;
                new WMQProductInstallInfo();
                propertyFiles = FTEPropertyStoreFactory.getInstance().getPropertyStore();
            }
            catch (ApiException e) {
                propException = e;
            }
        }
        return propertyFiles;
    }

    public static synchronized void updateProperties(String propertySet) {
        if (conn != null) {
            Subscription.shutdown();
        }
        try {
            String subscriptionTopic;
            if (propertyFiles == null) {
                propException = null;
                propertyFiles = FTEPropertyStoreFactory.getInstance().getPropertyStore();
            }
            FTEProperties connectionProps = propertyFiles.getCommandProperties(propertySet);
            String credKeyFilePathCmds = KeyFileUtils.getInstance().getCredentialsKeyFilePath(connectionProps, FTEPropConstant.ConnectionType.CONNECTION);
            UserExitsFactory.initialise();
            String connectionCredentialsFilePath = connectionProps.getPropertyAsString(FTEPropConstant.ConnectionType.CONNECTION.getAuthenticationCredentialsProperty());
            boolean isConnectionCredentialsFilePathDefault = !connectionProps.isPropertyPresent(FTEPropConstant.ConnectionType.CONNECTION.getAuthenticationCredentialsProperty());
            CredentialsUserPassHelper.initialise((String)connectionCredentialsFilePath, (boolean)isConnectionCredentialsFilePathDefault, (String)credKeyFilePathCmds);
            commandException = CredentialsUserPassHelper.getException();
            cmdConnectionData = AbstractCommand.getConnectionData((FTEProperties)connectionProps, (FTEPropConstant.ConnectionType)FTEPropConstant.ConnectionType.CONNECTION, (String)ProductVersion.getExplorerPluginRAPPLTAGPrefix());
            cmdConnectionData.lockInCup();
            dynamicQueuePrefix = connectionProps.getPropertyAsString(FTEPropConstant.dynamicQueuePrefix);
            modelQueueName = connectionProps.getPropertyAsString(FTEPropConstant.modelQueueName);
            FTEProperties coordProps = propertyFiles.getCoordinationProperties(propertySet);
            String credKeyFilePathCord = KeyFileUtils.getInstance().getCredentialsKeyFilePath(coordProps, FTEPropConstant.ConnectionType.COORDINATION);
            String coordCredentialsFilePath = coordProps.getPropertyAsString(FTEPropConstant.ConnectionType.COORDINATION.getAuthenticationCredentialsProperty());
            boolean isCoordCredentialsFilePathDefault = !coordProps.isPropertyPresent(FTEPropConstant.ConnectionType.COORDINATION.getAuthenticationCredentialsProperty());
            CredentialsUserPassHelper.initialise((String)coordCredentialsFilePath, (boolean)isCoordCredentialsFilePathDefault, (String)credKeyFilePathCord);
            coordinationException = CredentialsUserPassHelper.getException();
            coordConnectionData = AbstractCommand.getConnectionData((FTEProperties)coordProps, (FTEPropConstant.ConnectionType)FTEPropConstant.ConnectionType.COORDINATION, (String)ProductVersion.getExplorerPluginRAPPLTAGPrefix());
            coordConnectionData.lockInCup();
            SYSTEM_FTE = subscriptionTopic = coordProps.getPropertyAsString(FTEPropConstant.adminSubscriptionTopic);
            if (Trace.isTracing) {
                Trace.data((Level)Level.FINEST, (String)"Subscription", (String)"updateProperties", (String)("Updated subscription topic to: " + SYSTEM_FTE));
            }
            if (!coordConnectionData.useBindings()) {
                coordConnectionData.setOptions(coordConnectionData.getOptions() | 0x2000000);
            }
            boolean isFIPSEnabled = UiPlugin.isFIPSEnabled();
            boolean coordQmgrFipsMissmatch = false;
            boolean cmdQmgrFipsMissmatch = false;
            if (!coordConnectionData.useBindings()) {
                SSLConnectionData sslCoord = coordConnectionData.getSslConnectionData();
                if (Trace.isTracing) {
                    Trace.data((Level)Level.FINEST, (String)"Subscription", (String)"updateProperties", (String)("MQExplorer FIPS Enabled? " + isFIPSEnabled), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
                if (sslCoord != null) {
                    if (Trace.isTracing) {
                        Trace.data((Level)Level.FINEST, (String)"Subscription", (String)"updateProperties", (String)("WMQFTE Plugin to Coordination QMgr FIPS Enabled? " + sslCoord.isFipsEnabled()), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                    }
                    if (isFIPSEnabled != sslCoord.isFipsEnabled()) {
                        if (Trace.isTracing) {
                            Trace.data((Level)Level.FINEST, (String)"Subscription", (String)"updateProperties", (String)Messages.BFGUI0003_CONNECTION_SSL_FIPS_MISMATCH, (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                        }
                        coordQmgrFipsMissmatch = true;
                    }
                } else if (isFIPSEnabled && Trace.isTracing) {
                    Trace.data((Level)Level.FINEST, (String)"Subscription", (String)"updateProperties", (String)"Unable to acquire SSL connection data for Coordination QMgr", (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
            }
            if (!cmdConnectionData.useBindings()) {
                SSLConnectionData sslCmd = cmdConnectionData.getSslConnectionData();
                if (sslCmd != null) {
                    if (Trace.isTracing) {
                        Trace.data((Level)Level.FINEST, (String)"Subscription", (String)"updateProperties", (String)("WMQFTE Plugin to Connection QMgr FIPS Enabled? " + sslCmd.isFipsEnabled()), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                    }
                    if (isFIPSEnabled != sslCmd.isFipsEnabled()) {
                        if (Trace.isTracing) {
                            Trace.data((Level)Level.FINEST, (String)"Subscription", (String)"updateProperties", (String)Messages.BFGUI0003_CONNECTION_SSL_FIPS_MISMATCH, (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                        }
                        cmdQmgrFipsMissmatch = true;
                    }
                } else if (isFIPSEnabled && Trace.isTracing) {
                    Trace.data((Level)Level.FINEST, (String)"Subscription", (String)"updateProperties", (String)"Unable to acquire SSL connection data for Connection QMgr", (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
            }
            if (coordQmgrFipsMissmatch || cmdQmgrFipsMissmatch) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Elements.UI_CONNECTION_SSL_FIPS_MISMATCH_TITLE, (String)Messages.BFGUI0003_CONNECTION_SSL_FIPS_MISMATCH);
            }
            isDurable = "DURABLE".equals(ExplorerPlugin.getTransferLogSubscriptionType());
        }
        catch (ApiException e) {
            propException = e;
        }
        catch (CredentialsFileException cfe) {
            propException = cfe;
        }
    }

    public static synchronized void updateProperties(FTEConfigurationWizardSettings configuration) throws SubscriptionException {
        boolean useCCDT;
        String credKeyFilePathCord;
        SSLConnectionData sslData;
        String credKeyFilePathCmds;
        FTEProperties connectionProps;
        UiQueueManager commandQueueManager;
        QueueManagerHandle qmh;
        Trace t = Trace.getInstance();
        if (!FTEPropertiesFactory.isLoaded()) {
            FTEPropertiesFactory.initialise(new HashMap());
        }
        boolean useBindings = (qmh = (commandQueueManager = configuration.getCommandQueueManager()).getDmQueueManagerObject().getConnectionHandle().getQueueManagerHandle(t)).getConnectionType() == 1;
        boolean useCCDT2 = qmh.getConnectionType() == 4;
        SSLConnectionData sslCommandQMgr = Subscription.createSSLConnectData(t, commandQueueManager);
        if (Trace.isTracing) {
            Trace.data((Level)Level.INFO, (String)"Subscription", (String)"updateProperties", (String)("useBindings=" + useBindings + ", useCCDT=" + useCCDT2), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
        }
        if (propertyFiles != null) {
            connectionProps = propertyFiles.getCommandProperties(null);
            credKeyFilePathCmds = KeyFileUtils.getInstance().getCredentialsKeyFilePath(connectionProps, FTEPropConstant.ConnectionType.CONNECTION);
        } else {
            connectionProps = null;
            credKeyFilePathCmds = null;
        }
        UserExitsFactory.initialise();
        CredentialsUserPassHelper.initialise((CredentialsUserPass)Subscription.getExplorerCredentials(t, commandQueueManager));
        if (useBindings) {
            cmdConnectionData = new WMQConnectionData(qmh.getQueueManagerName(), true, null, null, 0, null, null, CorePlugin.getCCSID(), null, null, credKeyFilePathCmds);
        } else if (useCCDT2) {
            URL ccdtURL;
            String channelDefTable = qmh.getChannelDefTable();
            try {
                ccdtURL = new URL(channelDefTable);
            }
            catch (MalformedURLException mue) {
                throw new SubscriptionException(qmh.getQueueManagerName(), null, mue);
            }
            cmdConnectionData = new WMQConnectionData(qmh.getQueueManagerName(), ccdtURL, sslCommandQMgr, CorePlugin.getCCSID(), credKeyFilePathCmds);
            cmdConnectionData.setUseJavaUserName(true);
        } else {
            cmdConnectionData = new WMQConnectionData(qmh.getQueueManagerName(), useBindings, sslCommandQMgr, qmh.getHostName(t), qmh.getPortAddress(t), qmh.getChannel(), null, CorePlugin.getCCSID(), null, null, null, ProductVersion.getExplorerPluginRAPPLTAGPrefix(), credKeyFilePathCmds);
            cmdConnectionData.setUseJavaUserName(true);
        }
        try {
            cmdConnectionData.lockInCup();
        }
        catch (InternalException e) {
            commandException = e;
        }
        UiQueueManager coordQueueManager = configuration.getCoordQueueManager();
        qmh = coordQueueManager.getDmQueueManagerObject().getConnectionHandle().getQueueManagerHandle(t);
        SSLConnectionData sSLConnectionData = sslData = configuration.isSameQmgr() ? sslCommandQMgr : Subscription.createSSLConnectData(t, coordQueueManager);
        if (propertyFiles != null) {
            FTEProperties connectionProps2 = propertyFiles.getCommandProperties(null);
            credKeyFilePathCord = KeyFileUtils.getInstance().getCredentialsKeyFilePath(connectionProps2, FTEPropConstant.ConnectionType.CONNECTION);
        } else {
            Object connectionProps3 = null;
            credKeyFilePathCord = null;
        }
        CredentialsUserPassHelper.initialise((CredentialsUserPass)Subscription.getExplorerCredentials(t, coordQueueManager));
        boolean useBindings2 = qmh.getConnectionType() == 1;
        boolean bl = useCCDT = qmh.getConnectionType() == 4;
        if (useBindings2) {
            coordConnectionData = new WMQConnectionData(qmh.getQueueManagerName(), true, null, null, 0, null, null, CorePlugin.getCCSID(), null, null, credKeyFilePathCord);
        } else if (useCCDT) {
            URL ccdtURL;
            String channelDefTable = qmh.getChannelDefTable();
            try {
                ccdtURL = new URL(channelDefTable);
            }
            catch (MalformedURLException mue) {
                throw new SubscriptionException(qmh.getQueueManagerName(), null, mue);
            }
            coordConnectionData = new WMQConnectionData(qmh.getQueueManagerName(), ccdtURL, sslData, CorePlugin.getCCSID(), credKeyFilePathCord);
            coordConnectionData.setUseJavaUserName(true);
        } else {
            coordConnectionData = new WMQConnectionData(qmh.getQueueManagerName(), useBindings2, sslData, useBindings2 ? null : qmh.getHostName(t), (useBindings2 ? null : Integer.valueOf(qmh.getPortAddress(t))).intValue(), useBindings2 ? null : qmh.getChannel(), null, CorePlugin.getCCSID(), null, null, null, ProductVersion.getExplorerPluginRAPPLTAGPrefix(), credKeyFilePathCord);
            coordConnectionData.setUseJavaUserName(true);
        }
        try {
            coordConnectionData.lockInCup();
        }
        catch (InternalException e) {
            coordinationException = e;
        }
        dynamicQueuePrefix = FTEPropConstant.dynamicQueuePrefix.defaultAsString(AgentType.STANDARD);
        modelQueueName = FTEPropConstant.modelQueueName.defaultAsString(AgentType.STANDARD);
        isDurable = "DURABLE".equals(configuration.getSubscriptionType());
    }

    public static WMQConnectionData getCmdConnectionData() {
        return cmdConnectionData;
    }

    public static String getDynamicQueuePrefix() {
        return dynamicQueuePrefix;
    }

    public static String getModelQueueName() {
        return modelQueueName;
    }

    public static WMQConnectionData getAdminConnectionData() {
        return coordConnectionData;
    }

    public static Exception getPropException() {
        return propException;
    }

    public static Exception getCommandException() {
        return commandException;
    }

    public static Exception getCoordinationException() {
        return coordinationException;
    }

    private static String getSubNamePrefix() {
        String hostName;
        String userId;
        String subscriptionNamePrefix;
        block2: {
            subscriptionNamePrefix = subNamePrefix;
            userId = "";
            hostName = "";
            try {
                userId = coordConnectionData.getCredentialsUserPass().getUserId();
                hostName = String.valueOf(hostName) + InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex) {
                if (!Trace.isTracing) break block2;
                Trace.data((Level)Level.WARNING, (String)"Subscription", (String)"getSubNamePrefix", (String)ex.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
            }
        }
        subscriptionNamePrefix = String.valueOf(subscriptionNamePrefix) + hostName + "_" + userId + "_" + UUID.randomUUID().toString();
        return subscriptionNamePrefix;
    }

    public static synchronized void connect() throws WMQApiException {
        block10: {
            if (coordConnectionData == null) {
                Subscription.updateProperties(null);
            }
            if (coordConnectionData != null) {
                try {
                    conn = WMQApiFactory.getWMQApi().connect(coordConnectionData);
                    agentStatusConn = WMQApiFactory.getWMQApi().connect(coordConnectionData);
                    monitorStatusConn = WMQApiFactory.getWMQApi().connect(coordConnectionData);
                    transferStatusConn = WMQApiFactory.getWMQApi().connect(coordConnectionData);
                    Subscription.getCoordQmTime();
                    conn.getSubscription(Subscription.getSubNamePrefix(), SYSTEM_FTE, "EVENT_HANDLER", false).addConsumer(new MQConsumer(){

                        public void consumer(Hconn hconn, MQMD mqmd, MQGMO getMsgOpts, ByteBuffer pBuffer, MQCBC mqcbc) {
                            int callBackType = mqcbc.getCallType();
                            int rc = mqcbc.getReason();
                            mqcbc.getState();
                            if (callBackType == 5 && Subscription.isBadConnectionRC(rc)) {
                                MFTETreeNodeFactory.disconnectCoordination();
                            }
                        }

                        public int getMaxMessages() {
                            return 0;
                        }
                    }, 2);
                    Subscription.getAuditProvider();
                    conn.startConsuming();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    conn.stopConsuming();
                    Subscription.getScheduleProvider();
                    conn.startConsuming();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    conn.stopConsuming();
                    Subscription.getTransferTemplateProvider();
                    conn.startConsuming();
                    Subscription.getAgentStatusDetailsProvider();
                    agentStatusConn.startConsuming();
                    Subscription.getTransferStatusProvider();
                    transferStatusConn.startConsuming();
                    Subscription.getMonitorProvider();
                    monitorStatusConn.startConsuming();
                }
                catch (JmqiException e) {
                    if (Trace.isTracing) {
                        Trace.data((Level)Level.WARNING, (String)"Subscription", (String)"connect", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                    }
                }
                catch (CredentialsFileException e1) {
                    if (!Trace.isTracing) break block10;
                    Trace.data((Level)Level.WARNING, (String)"Subscription", (String)"connect", (String)e1.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
            }
        }
    }

    private static boolean isBadConnectionRC(int rc) {
        return rc == 2009 || rc == 2202 || rc == 2059 || rc == 2161 || rc == 2162;
    }

    public static String getCallTypeName(int callType) {
        String name = null;
        switch (callType) {
            case 1: {
                name = "MQCBCT_START_CALL";
                break;
            }
            case 2: {
                name = "MQCBCT_STOP_CALL";
                break;
            }
            case 3: {
                name = "MQCBCT_REGISTER_CALL";
                break;
            }
            case 4: {
                name = "MQCBCT_DEREGISTER_CALL";
                break;
            }
            case 5: {
                name = "MQCBCT_EVENT_CALL";
                break;
            }
            case 6: {
                name = "MQCBCT_MSG_REMOVED";
                break;
            }
            case 7: {
                name = "MQCBCT_MSG_NOT_REMOVED";
                break;
            }
            default: {
                name = "(" + callType + ")";
            }
        }
        return name;
    }

    protected static synchronized void addTransferStatusConsumer(MQConsumer consumer) {
        block8: {
            try {
                if (transferStatusConn != null) {
                    if (statusSub == null) {
                        statusSub = transferStatusConn.getSubscription(Subscription.getSubNamePrefix(), SYSTEM_FTE, "Transfers/#", false);
                    }
                    if (statusSub != null) {
                        statusSub.addConsumer(consumer);
                    }
                }
            }
            catch (WMQApiException e) {
                if (Subscription.isBadConnectionRC(e.getReasonCode())) {
                    MFTETreeNodeFactory.connectCoordination();
                }
                if (e.getReasonCode() == 2018) {
                    statusSub = null;
                }
                if (e.getReasonCode() == 2033) break block8;
                if (Trace.isTracing) {
                    Trace.data((Level)Level.WARNING, (String)"Subscription", (String)"addTransferStatusConsumer", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
                e.printStackTrace();
            }
        }
    }

    protected static synchronized void addAuditConsumer(MQConsumer consumer) {
        block7: {
            try {
                if (conn != null) {
                    Subscription.checkAuditSub();
                    if (auditSub != null) {
                        auditSub.addConsumer(consumer);
                    }
                }
            }
            catch (WMQApiException e) {
                if (Subscription.isBadConnectionRC(e.getReasonCode())) {
                    MFTETreeNodeFactory.connectCoordination();
                }
                if (e.getReasonCode() == 2018) {
                    auditSub = null;
                }
                if (e.getReasonCode() == 2033 || e.getReasonCode() == 2437) break block7;
                if (Trace.isTracing) {
                    Trace.data((Level)Level.WARNING, (String)"Subscription", (String)"addAuditConsumer", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
                e.printStackTrace();
            }
        }
    }

    private static synchronized void checkAuditSub() throws WMQApiFailureException, WMQApiWarningException {
        if (auditSub == null && conn != null) {
            String subName = Subscription.getAuditSubName();
            auditSub = conn.getSubscription(subName, SYSTEM_FTE, "Log/#", isDurable);
        }
    }

    private static synchronized String getAuditSubName() {
        String subName;
        IDialogSettings dialogSettings = ExplorerPlugin.getDefault().getDialogSettings();
        settings = dialogSettings.getSection("UI_SETTINGS_SUBSCRIPTIONS");
        if (settings == null) {
            settings = dialogSettings.addNewSection("UI_SETTINGS_SUBSCRIPTIONS");
        }
        if ((subName = settings.get(AUDIT_SUBNAME_KEY)) == null) {
            subName = Subscription.getSubNamePrefix();
            Subscription.saveAuditSubName(AUDIT_SUBNAME_KEY, subName);
        }
        return subName;
    }

    private static void saveAuditSubName(String key, String value) {
        if (value == null || value.equals("") || settings == null) {
            return;
        }
        settings.put(key, value);
    }

    protected static synchronized void addTransferTemplateConsumer(MQConsumer consumer) {
        block8: {
            try {
                if (conn != null) {
                    if (templateSub == null) {
                        templateSub = conn.getSubscription(Subscription.getSubNamePrefix(), SYSTEM_FTE, "Templates/#", false);
                    }
                    if (templateSub != null) {
                        templateSub.addConsumer(consumer);
                    }
                }
            }
            catch (WMQApiException e) {
                if (Subscription.isBadConnectionRC(e.getReasonCode())) {
                    MFTETreeNodeFactory.connectCoordination();
                }
                if (e.getReasonCode() == 2018) {
                    templateSub = null;
                }
                if (e.getReasonCode() == 2033 || e.getReasonCode() == 2437) break block8;
                if (Trace.isTracing) {
                    Trace.data((Level)Level.WARNING, (String)"Subscription", (String)"addTransferTemplateConsumer", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
                e.printStackTrace();
            }
        }
    }

    protected static synchronized void addMonitorConsumer(MQConsumer consumer) {
        block8: {
            try {
                if (monitorStatusConn != null) {
                    if (monitorSub == null) {
                        monitorSub = monitorStatusConn.getSubscription(Subscription.getSubNamePrefix(), SYSTEM_FTE, "monitors/#", false);
                    }
                    if (monitorSub != null) {
                        monitorSub.addConsumer(consumer);
                    }
                }
            }
            catch (WMQApiException e) {
                if (Subscription.isBadConnectionRC(e.getReasonCode())) {
                    MFTETreeNodeFactory.connectCoordination();
                }
                if (e.getReasonCode() == 2018) {
                    monitorSub = null;
                }
                if (e.getReasonCode() == 2033 || e.getReasonCode() == 2437) break block8;
                if (Trace.isTracing) {
                    Trace.data((Level)Level.WARNING, (String)"Subscription", (String)"addMonitorConsumer", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
                e.printStackTrace();
            }
        }
    }

    protected static synchronized void addScheduleConsumer(MQConsumer consumer) {
        block8: {
            try {
                if (conn != null) {
                    if (scheduleSub == null) {
                        scheduleSub = conn.getSubscription(Subscription.getSubNamePrefix(), SYSTEM_FTE, "Scheduler/#", false);
                    }
                    if (scheduleSub != null) {
                        scheduleSub.addConsumer(consumer);
                    }
                }
            }
            catch (WMQApiException e) {
                if (Subscription.isBadConnectionRC(e.getReasonCode())) {
                    MFTETreeNodeFactory.connectCoordination();
                }
                if (e.getReasonCode() == 2018) {
                    scheduleSub = null;
                }
                if (e.getReasonCode() == 2033 || e.getReasonCode() == 2437) break block8;
                if (Trace.isTracing) {
                    Trace.data((Level)Level.WARNING, (String)"Subscription", (String)"addScheduleConsumer", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
                e.printStackTrace();
            }
        }
    }

    protected static synchronized void addAgentStatusConsumer(MQConsumer consumer) {
        block10: {
            try {
                if (agentStatusConn != null) {
                    if (Trace.isTracing) {
                        Trace.data((Level)Level.FINEST, (String)"Subscription", (String)"addAgentStatusConsumer", (String)("currently connected to " + conn.getQueueManagerName()), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                    }
                    if (agentStatusSub == null) {
                        if (Trace.isTracing) {
                            Trace.data((Level)Level.FINEST, (String)"Subscription", (String)"addAgentStatusConsumer", (String)"Creating a new subscription", (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                        }
                        agentStatusSub = agentStatusConn.getSubscription(Subscription.getSubNamePrefix(), SYSTEM_FTE, "Agents/#", false);
                    }
                    if (agentStatusSub != null) {
                        if (Trace.isTracing) {
                            Trace.data((Level)Level.FINEST, (String)"Subscription", (String)"addAgentStatusConsumer", (String)("Adding a subscription " + consumer.toString()), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                        }
                        agentStatusSub.addConsumer(consumer);
                    }
                }
            }
            catch (WMQApiException e) {
                if (Subscription.isBadConnectionRC(e.getReasonCode())) {
                    MFTETreeNodeFactory.connectCoordination();
                }
                if (e.getReasonCode() == 2018) {
                    agentStatusSub = null;
                }
                if (e.getReasonCode() == 2033 || e.getReasonCode() == 2437) break block10;
                e.printStackTrace();
            }
        }
    }

    public static synchronized void shutdown() {
        block17: {
            if (agentStatusDetailsProvider != null) {
                agentStatusDetailsProvider.clear();
            }
            agentStatusDetailsProvider = null;
            auditProvider = null;
            monitorProvider = null;
            scheduleProvider = null;
            transferStatusProvider = null;
            transferTemplateProvider = null;
            auditSub = null;
            statusSub = null;
            templateSub = null;
            monitorSub = null;
            scheduleSub = null;
            agentStatusSub = null;
            try {
                try {
                    if (conn != null) {
                        try {
                            conn.stopConsuming();
                            conn.disconnect();
                        }
                        catch (WMQApiException wMQApiException) {}
                    }
                    if (monitorStatusConn != null) {
                        try {
                            monitorStatusConn.stopConsuming();
                            monitorStatusConn.disconnect();
                        }
                        catch (WMQApiException wMQApiException) {}
                    }
                    if (transferStatusConn != null) {
                        try {
                            transferStatusConn.stopConsuming();
                            transferStatusConn.disconnect();
                        }
                        catch (WMQApiException wMQApiException) {}
                    }
                    if (agentStatusConn == null) break block17;
                    try {
                        agentStatusConn.stopConsuming();
                        agentStatusConn.disconnect();
                    }
                    catch (WMQApiException wMQApiException) {
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    conn = null;
                    agentStatusConn = null;
                    monitorStatusConn = null;
                    transferStatusConn = null;
                }
            }
            finally {
                conn = null;
                agentStatusConn = null;
                monitorStatusConn = null;
                transferStatusConn = null;
            }
        }
    }

    public static synchronized int getReasonCode() {
        return reasonCode;
    }

    public static String getAdminQmgrName() {
        return coordConnectionData.getQueueManagerName();
    }

    public static String getAdminQmgrHostname() {
        String hostname;
        String string = hostname = coordConnectionData.getHostname() == null ? "localhost" : coordConnectionData.getHostname();
        if (!coordConnectionData.useBindings() && coordConnectionData.getPort() > 0) {
            hostname = String.valueOf(hostname) + "(" + coordConnectionData.getPort() + ")";
        }
        return hostname;
    }

    public static AgentStatusDetailsProvider getAgentStatusDetailsProvider() {
        if (agentStatusDetailsProvider == null) {
            agentStatusDetailsProvider = new AgentStatusDetailsProvider();
        }
        return agentStatusDetailsProvider;
    }

    public static AuditProvider getAuditProvider() {
        if (auditProvider == null) {
            auditProvider = new AuditProvider();
        }
        return auditProvider;
    }

    public static MonitorProvider getMonitorProvider() {
        if (monitorProvider == null) {
            monitorProvider = new MonitorProvider();
        }
        return monitorProvider;
    }

    public static ScheduleProvider getScheduleProvider() {
        if (scheduleProvider == null) {
            scheduleProvider = new ScheduleProvider();
        }
        return scheduleProvider;
    }

    public static TransferStatusProvider getTransferStatusProvider() {
        if (transferStatusProvider == null) {
            transferStatusProvider = new TransferStatusProvider();
        }
        return transferStatusProvider;
    }

    public static TransferTemplateProvider getTransferTemplateProvider() {
        if (transferTemplateProvider == null) {
            transferTemplateProvider = new TransferTemplateProvider();
        }
        return transferTemplateProvider;
    }

    public static Date getCoordQmTime() {
        if (qmTimeBase == null) {
            try {
                WMQApi api = WMQApiFactory.getWMQApi();
                WMQMessage msg = api.createMessage();
                MQPMO pmo = api.createPMO();
                pmo.setOptions(8192);
                WMQQueue queue = agentStatusConn.openTemporaryQueue(8208, Subscription.getDynamicQueuePrefix(), Subscription.getModelQueueName());
                queue.put(msg, pmo);
                localTimeBase = new Date();
                queue.close();
                String date = msg.getMQMD().getPutDate();
                String time = msg.getMQMD().getPutTime();
                qmTimeBase = Subscription.parseTime(date, time);
            }
            catch (Exception exception) {
                localTimeBase = new Date();
            }
            return qmTimeBase;
        }
        long millisSinceCheck = new Date().getTime() - localTimeBase.getTime();
        Date now = new Date(qmTimeBase.getTime() + millisSinceCheck);
        return now;
    }

    private static Date parseTime(String utcDate, String utcTime) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        int year = Integer.parseInt(utcDate.substring(0, 4));
        int month = Integer.parseInt(utcDate.substring(4, 6));
        int day = Integer.parseInt(utcDate.substring(6, 8));
        int hour = Integer.parseInt(utcTime.substring(0, 2));
        int minute = Integer.parseInt(utcTime.substring(2, 4));
        int second = Integer.parseInt(utcTime.substring(4, 6));
        calendar.set(year, month - 1, day, hour, minute, second);
        Date date = calendar.getTime();
        return date;
    }

    public static void publishXML(String topicString, String topic, String messageBody, WMQPublicationData publicationData) throws UnsupportedEncodingException, WMQApiException {
        Subscription.publishXML(topicString, topic, messageBody, -1, publicationData);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void publishXML(String topicString, String topic, String messageBody, int expiry, WMQPublicationData publicationData) throws UnsupportedEncodingException, WMQApiException {
        WMQApi wmqApi = WMQApiFactory.getWMQApi();
        WMQMessage message = RFHMessageFactory.createRFHMessage((String)topic, (String)topicString, (String)messageBody, (boolean)true, (boolean)true, (boolean)false, null, null, (int)publicationData.getCcsid(), (String)publicationData.getCcsidName());
        message.getMQMD().setExpiry(expiry);
        MQOD mqod = wmqApi.createMQOD();
        mqod.setObjectName(topic);
        mqod.setObjectQMgrName(Subscription.getAdminQmgrName());
        MQPMO pmo = wmqApi.createPMO();
        WMQConnection pubconn = null;
        try {
            try {
                pubconn = WMQApiFactory.getWMQApi().connect(coordConnectionData);
                pubconn.put1(message, mqod, pmo);
                return;
            }
            catch (WMQApiException e) {
                if (Trace.isTracing) {
                    Trace.data((Level)Level.WARNING, (String)"Subscription", (String)"publishXML", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
                if (!Subscription.isBadConnectionRC(e.getReasonCode())) {
                    throw e;
                }
                MFTETreeNodeFactory.connectCoordination();
                if (pubconn == null) return;
                pubconn.disconnect();
                return;
            }
            catch (JmqiException e) {
                if (Trace.isTracing) {
                    Trace.data((Level)Level.WARNING, (String)"Subscription", (String)"publishXML", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
                if (pubconn == null) return;
                pubconn.disconnect();
                return;
            }
            catch (CredentialsFileException e) {
                if (Trace.isTracing) {
                    Trace.data((Level)Level.WARNING, (String)"Subscription", (String)"publishXML", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
                if (pubconn == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                pubconn.disconnect();
                return;
            }
        }
        finally {
            if (pubconn != null) {
                pubconn.disconnect();
            }
        }
    }

    private static CredentialsUserPass getExplorerCredentials(Trace t, UiQueueManager uQM) {
        CredentialsUserPass cup;
        block4: {
            DmQueueManager dmqm = (DmQueueManager)uQM.getDmObject();
            QueueManagerHandle qmh = dmqm.getConnectionHandle().getQueueManagerHandle(t);
            cup = null;
            try {
                if (PwUtils.getPasswords((Trace)t, (DmQueueManager)dmqm)) {
                    Hashtable s = qmh.getSecurityOptions(t);
                    String userId = (String)s.get("userID");
                    String password = (String)s.get("password");
                    if (userId != null && userId.length() > 0) {
                        int compatModeEnabled = qmh.getCompatMode();
                        boolean useMQCSPAuthentication = compatModeEnabled != 1;
                        cup = CredentialsUserPass.createClear((String)userId, (String)password, (boolean)useMQCSPAuthentication);
                    }
                }
            }
            catch (DmCoreException e) {
                if (!Trace.isTracing) break block4;
                Trace.data((Level)Level.FINEST, (String)"Subscription", (String)"getExplorerCredentials", (String)("DmCoreException: " + e.getLocalizedMessage()), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
            }
        }
        return cup;
    }

    public static SSLConnectionData createSSLConnectData(Trace t, UiQueueManager uQM) throws SubscriptionException {
        boolean trustStorePresent;
        DmQueueManager dmqm = (DmQueueManager)uQM.getDmObject();
        QueueManagerHandle qmh = dmqm.getConnectionHandle().getQueueManagerHandle(t);
        SSLConnectionData sslData = null;
        boolean personalStorePresent = qmh.getSSLPersonalStore() != null && qmh.getSSLPersonalStore().length() > 0;
        boolean bl = trustStorePresent = qmh.getSSLTrustedStore() != null && qmh.getSSLTrustedStore().length() > 0;
        if (personalStorePresent || trustStorePresent) {
            if (PwUtils.getPasswords((Trace)t, (DmQueueManager)dmqm)) {
                try {
                    String personalStorePassword = qmh.getMFTSSLPersonalStorePassword(t);
                    String personalStore = Subscription.empty2Null(qmh.getSSLPersonalStore());
                    String trustStorePassword = qmh.getMFTSSLTrustedStorePassword(t);
                    String trustStore = Subscription.empty2Null(qmh.getSSLTrustedStore());
                    sslData = new SSLConnectionData(JmqiUtils.toCipherSpec((String)qmh.getSSLCipherSuite()), qmh.getSSLCipherSuite(), qmh.getSSLPeerName(), personalStore, personalStorePassword, "jks", trustStore, trustStorePassword, "jks", qmh.getSSLFIPSRequired() == 1);
                }
                catch (Exception ex) {
                    SubscriptionException se = new SubscriptionException(qmh.getCommandQueueName(), qmh.getHostName(t), ex);
                    if (Trace.isTracing) {
                        Trace.data((Level)Level.WARNING, (String)"Subscription", (String)"createSSLConnectData", (String)se.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                    }
                    throw se;
                }
            } else {
                throw new SubscriptionUserCancelException();
            }
        }
        return sslData;
    }

    private static String empty2Null(String s) {
        return s == null || s.length() == 0 ? null : s;
    }

    public static class SubscriptionException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private String qmgrName;
        private String hostName;

        public SubscriptionException(String qmgrName, String hostName, Throwable ex) {
            super(ex.getLocalizedMessage(), ex);
            this.qmgrName = qmgrName;
            this.hostName = hostName;
        }

        public void setQmgrName(String qmgrName) {
            this.qmgrName = qmgrName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public String getQmgrName() {
            return this.qmgrName;
        }

        public String getHostName() {
            return this.hostName;
        }
    }

    public static class SubscriptionUserCancelException
    extends SubscriptionException {
        private static final long serialVersionUID = 1L;

        public SubscriptionUserCancelException() {
            super(null, null, new Exception());
        }
    }
}

