/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.data;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.jmqi.MQCBC;
import com.ibm.mq.jmqi.MQConsumer;
import com.ibm.mq.jmqi.MQGMO;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.utils.FTEUtils;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;

public class ScheduleProvider
extends Observable {
    final Queue<FTEUtils.XMLData> schedules = new ConcurrentLinkedQueue<FTEUtils.XMLData>();

    public ScheduleProvider() {
        Subscription.addScheduleConsumer(new MQConsumer(){

            public void consumer(Hconn hconn, MQMD mqmd, MQGMO getMsgOpts, ByteBuffer pBuffer, MQCBC mqcbc) {
                int callBackType = mqcbc.getCallType();
                int rc = mqcbc.getReason();
                if (callBackType == 6 && rc == 0 && pBuffer != null) {
                    try {
                        final FTEUtils.XMLData scheduleXML = new FTEUtils.XMLData(pBuffer.array(), "UTF-8", true);
                        if (ScheduleProvider.this.countObservers() == 0) {
                            ScheduleProvider.this.schedules.add(scheduleXML);
                        } else {
                            ScheduleProvider.this.setChanged();
                            new Thread(ScheduleProvider.class + "#notifyObservers()"){

                                @Override
                                public void run() {
                                    ScheduleProvider.this.notifyObservers(scheduleXML);
                                }
                            }.run();
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        if (Trace.isTracing) {
                            Trace.data((Level)Level.WARNING, (String)"ScheduleProvider", (String)"consumer", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                        }
                        e.printStackTrace();
                    }
                }
            }

            public String toString() {
                return "ScheduleConsumer";
            }

            public int getMaxMessages() {
                return 0;
            }
        });
    }

    @Override
    public void addObserver(Observer observer) {
        super.addObserver(observer);
        if (this.countObservers() > 0) {
            this.schedules.clear();
        }
    }

    public synchronized List<FTEUtils.XMLData> getSchedules() {
        ArrayList<FTEUtils.XMLData> results = new ArrayList<FTEUtils.XMLData>();
        while (!this.schedules.isEmpty()) {
            results.add(this.schedules.remove());
        }
        return results;
    }
}

