/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.data;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.jmqi.MQCBC;
import com.ibm.mq.jmqi.MQConsumer;
import com.ibm.mq.jmqi.MQGMO;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.wmqfte.api.InternalException;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.data.GUIListMonitorResult;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.utils.FTEUtils;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;

public class MonitorProvider
extends Observable {
    final Queue<GUIListMonitorResult> monitors = new ConcurrentLinkedQueue<GUIListMonitorResult>();

    public MonitorProvider() {
        Subscription.addMonitorConsumer(new MQConsumer(){

            public void consumer(Hconn hconn, MQMD mqmd, MQGMO getMsgOpts, ByteBuffer pBuffer, MQCBC mqcbc) {
                int callBackType = mqcbc.getCallType();
                int rc = mqcbc.getReason();
                if (callBackType == 6 && rc == 0 && pBuffer != null) {
                    try {
                        FTEUtils.XMLData cpba = new FTEUtils.XMLData(pBuffer.array(), "UTF-8", true);
                        final GUIListMonitorResult monitor = new GUIListMonitorResult(cpba);
                        if (MonitorProvider.this.countObservers() == 0) {
                            MonitorProvider.this.monitors.add(monitor);
                        } else {
                            MonitorProvider.this.setChanged();
                            new Thread(MonitorProvider.class + "#notifyObservers()"){

                                @Override
                                public void run() {
                                    MonitorProvider.this.notifyObservers((Object)monitor);
                                }
                            }.run();
                        }
                    }
                    catch (InternalException e) {
                        if (Trace.isTracing) {
                            Trace.data((Level)Level.WARNING, (String)"MonitorProvider", (String)"consumer", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                        }
                        e.printStackTrace();
                    }
                    catch (UnsupportedEncodingException e) {
                        if (Trace.isTracing) {
                            Trace.data((Level)Level.WARNING, (String)"MonitorProvider", (String)"consumer", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                        }
                        e.printStackTrace();
                    }
                }
            }

            public String toString() {
                return "MonitorConsumer";
            }

            public int getMaxMessages() {
                return 0;
            }
        });
    }

    @Override
    public void addObserver(Observer observer) {
        super.addObserver(observer);
        if (this.countObservers() > 0) {
            this.monitors.clear();
        }
    }

    public synchronized List<GUIListMonitorResult> getMonitors() {
        ArrayList<GUIListMonitorResult> results = new ArrayList<GUIListMonitorResult>(this.monitors);
        return results;
    }
}

