/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.data;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.wizards.v2.FTEConfigurationWizardSettings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;

public class FTEConfigurationPersistence {
    private static final Map<String, FTEConfigurationWizardSettings> configurationSets = new HashMap<String, FTEConfigurationWizardSettings>();
    private static final String KEY_NAME = "FTEConfigurationPersistence";
    private static boolean loadedSuccessfully = false;

    public static void add(FTEConfigurationWizardSettings set) {
        configurationSets.put(set.getConfigurationName(), set);
    }

    public static void remove(FTEConfigurationWizardSettings set) {
        configurationSets.remove(set.getConfigurationName());
    }

    public static void remove(String configurationName) {
        configurationSets.remove(configurationName);
    }

    public static Map<String, FTEConfigurationWizardSettings> getConfigurationSets() {
        return configurationSets;
    }

    /*
     * Exception decompiling
     */
    public static void load() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void save() throws IOException {
        Trace t = Trace.getInstance();
        File dir = ExplorerPlugin.getDefault().getStateLocationFile();
        File persistFile = new File(dir, "FTEConfigurationPersistence.xml");
        if (persistFile.exists() && !loadedSuccessfully && configurationSets.isEmpty()) {
            return;
        }
        try (OutputStreamWriter writer = null;){
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(persistFile), "UTF-8");
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.write(Common.LINE_SEPARATOR);
            writer.write("<FTEConfigurationPersistence>");
            writer.write(Common.LINE_SEPARATOR);
            for (Map.Entry<String, FTEConfigurationWizardSettings> entry : configurationSets.entrySet()) {
                FTEConfigurationWizardSettings configuration = entry.getValue();
                writer.write("<configuration name=\"" + configuration.getConfigurationName() + "\"");
                if (configuration.getCoordQueueManager() != null) {
                    writer.write(" coordQmgr=\"" + configuration.getCoordQueueManager().getUUID(t) + "\"");
                }
                if (configuration.getCommandQueueManager() != null) {
                    writer.write(" commandQmgr=\"" + configuration.getCommandQueueManager().getUUID(t) + "\"");
                }
                if (configuration.getSubscriptionType() != null) {
                    writer.write(" subscriptionType=\"" + configuration.getSubscriptionType() + "\"");
                }
                writer.write(" />");
                writer.write(Common.LINE_SEPARATOR);
            }
            writer.write("</FTEConfigurationPersistence>");
            writer.write(Common.LINE_SEPARATOR);
        }
    }
}

