/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.data;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.jmqi.MQCBC;
import com.ibm.mq.jmqi.MQConsumer;
import com.ibm.mq.jmqi.MQGMO;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.data.Subscription;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;

public class AuditProvider
extends Observable {
    final Queue<String> audit = new ConcurrentLinkedQueue<String>();

    public AuditProvider() {
        Subscription.addAuditConsumer(new MQConsumer(){

            public void consumer(Hconn hconn, MQMD mqmd, MQGMO getMsgOpts, ByteBuffer pBuffer, MQCBC mqcbc) {
                int callBackType = mqcbc.getCallType();
                int rc = mqcbc.getReason();
                if (callBackType == 6 && rc == 0 && pBuffer != null) {
                    try {
                        final String auditXML = new String(pBuffer.array(), "UTF-8").trim();
                        int observerCount = AuditProvider.this.countObservers();
                        if (Trace.isTracing) {
                            Trace.data((Level)Level.FINEST, (String)"AuditProvider", (String)"consumer", (String)("Observer count:" + observerCount));
                        }
                        if (observerCount == 0) {
                            AuditProvider.this.audit.add(auditXML);
                            if (Trace.isTracing) {
                                Trace.data((Level)Level.FINEST, (String)"AuditProvider", (String)"consumer", (String)"Added auditXML to audit queue", (String)auditXML);
                                Trace.data((Level)Level.FINEST, (String)"AuditProvider", (String)"consumer", (String)("Number of objects in the audit queue: " + AuditProvider.this.audit.size()));
                            }
                        } else {
                            AuditProvider.this.setChanged();
                            new Thread(AuditProvider.class + "#notifyObservers()"){

                                @Override
                                public void run() {
                                    AuditProvider.this.notifyObservers(auditXML);
                                }
                            }.run();
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        if (Trace.isTracing) {
                            Trace.data((Level)Level.WARNING, (String)"AuditProvider", (String)"consumer", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                        }
                        e.printStackTrace();
                    }
                }
            }

            public String toString() {
                return "AuditConsumer";
            }

            public int getMaxMessages() {
                return 0;
            }
        });
    }

    @Override
    public void addObserver(Observer observer) {
        super.addObserver(observer);
        if (Trace.isTracing) {
            int observerCount = this.countObservers();
            Trace.data((Level)Level.FINEST, (String)"AuditProvider", (String)"addObserver", (String)("Number of observers: " + observerCount));
        }
    }

    public synchronized List<String> getAudit() {
        ArrayList<String> results = new ArrayList<String>();
        if (Trace.isTracing) {
            Trace.data((Level)Level.FINEST, (String)"AuditProvider", (String)"getAudit", (String)("Number of auditXML items currently in the audit queue: " + this.audit.size()));
        }
        while (!this.audit.isEmpty()) {
            results.add(this.audit.remove());
        }
        if (Trace.isTracing) {
            Trace.data((Level)Level.FINEST, (String)"AuditProvider", (String)"getAudit", (String)("Number of auditXML items being returned: " + results.size()));
            Trace.data((Level)Level.FINEST, (String)"AuditProvider", (String)"getAudit", (String)("Size of audit queue: " + this.audit.size()));
        }
        return results;
    }
}

