/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.data;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.jmqi.MQCBC;
import com.ibm.mq.jmqi.MQConsumer;
import com.ibm.mq.jmqi.MQGMO;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.utils.AgentDetailsFactory;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Observable;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;

public class AgentStatusDetailsProvider
extends Observable {
    private final Set<AgentStatusDetails> availableAgents = Collections.synchronizedSet(new TreeSet());

    public AgentStatusDetailsProvider() {
        Subscription.addAgentStatusConsumer(new MQConsumer(){

            public void consumer(Hconn hconn, MQMD mqmd, MQGMO getMsgOpts, ByteBuffer pBuffer, MQCBC mqcbc) {
                int callBackType = mqcbc.getCallType();
                int rc = mqcbc.getReason();
                mqcbc.getState();
                if (callBackType == 6 && rc == 0 && pBuffer != null) {
                    try {
                        AgentStatusDetails agent = AgentDetailsFactory.createInstance((byte[])pBuffer.array());
                        AgentStatusDetailsProvider.this.updateAvailableAgents(agent);
                    }
                    catch (UnsupportedEncodingException e) {
                        if (Trace.isTracing) {
                            Trace.data((Level)Level.WARNING, (String)"AgentStatusDetailsProvider", (String)"consumer", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                        }
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        if (Trace.isTracing) {
                            Trace.data((Level)Level.WARNING, (String)"AgentStatusDetailsProvider", (String)"consumer", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                        }
                        e.printStackTrace();
                    }
                }
            }

            public String toString() {
                return "AgentStatusConsumer";
            }

            public int getMaxMessages() {
                return 0;
            }
        });
    }

    public synchronized Set<AgentStatusDetails> getAvailableAgents() {
        return this.availableAgents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAvailableAgents(final AgentStatusDetails agent) {
        AgentStatusDetailsProvider agentStatusDetailsProvider = this;
        synchronized (agentStatusDetailsProvider) {
            this.availableAgents.remove(agent);
            this.availableAgents.add(agent);
        }
        this.setChanged();
        new Thread(AgentStatusDetailsProvider.class + "#notifyObservers()"){

            @Override
            public void run() {
                AgentStatusDetailsProvider.this.notifyObservers(agent);
            }
        }.run();
    }

    public synchronized void clear() {
        this.availableAgents.clear();
    }
}

