/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.wmqfte.objects.TransferTemplate;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ItemSpecification;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.TreeColumn;

public abstract class TransferTemplatesSorterPage
extends ViewerSorter {
    private boolean direction = true;
    public static final DateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");

    public void setColumn(TreeViewer tv, TreeColumn column) {
        ViewerSorter currentSorter = tv.getSorter();
        if (currentSorter != null && currentSorter.equals((Object)this)) {
            this.direction = !this.direction;
        } else {
            tv.setSorter((ViewerSorter)this);
            this.direction = true;
        }
        tv.getTree().setSortColumn(column);
        tv.getTree().setSortDirection(this.direction ? 1024 : 128);
    }

    public int applyDirection(int rc) {
        return this.direction ? rc : -rc;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        if (o1 instanceof TransferTemplate && o2 instanceof TransferTemplate) {
            TransferTemplate tt1 = (TransferTemplate)o1;
            TransferTemplate tt2 = (TransferTemplate)o2;
            return this.compare(tt1, tt2);
        }
        if (o1 instanceof ItemSpecification && o2 instanceof ItemSpecification) {
            ItemSpecification is1 = (ItemSpecification)o1;
            ItemSpecification is2 = (ItemSpecification)o2;
            return this.compare(is1, is2);
        }
        return 0;
    }

    public abstract int compare(TransferTemplate var1, TransferTemplate var2);

    public abstract int compare(ItemSpecification var1, ItemSpecification var2);

    public int compare(String s1, String s2) {
        if (s1 == null) {
            return this.applyDirection(-1);
        }
        if (s2 == null) {
            return this.applyDirection(1);
        }
        int rc = s1.compareTo(s2);
        return this.applyDirection(rc);
    }

    public int compare(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return 0;
        }
        if (date1 == null && date2 != null) {
            return this.applyDirection(-1);
        }
        if (date1 != null && date2 == null) {
            return this.applyDirection(1);
        }
        int rc = date1.compareTo(date2);
        return this.applyDirection(rc);
    }
}

