/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.wmqfte.api.ApiException;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.content.ColumnTitleEnumeration;
import com.ibm.wmqfte.explorer.content.IFTEContentPage;
import com.ibm.wmqfte.explorer.content.MFTContentPage;
import com.ibm.wmqfte.explorer.content.TransferTemplateDestinationAgentLabelProvider;
import com.ibm.wmqfte.explorer.content.TransferTemplateDestinationAgentSorter;
import com.ibm.wmqfte.explorer.content.TransferTemplateNameLabelProvider;
import com.ibm.wmqfte.explorer.content.TransferTemplateNameSorter;
import com.ibm.wmqfte.explorer.content.TransferTemplateScheduleLabelProvider;
import com.ibm.wmqfte.explorer.content.TransferTemplateScheduleSorter;
import com.ibm.wmqfte.explorer.content.TransferTemplateSourceAgentLabelProvider;
import com.ibm.wmqfte.explorer.content.TransferTemplateSourceAgentSorter;
import com.ibm.wmqfte.explorer.content.TransferTemplateTriggerLabelProvider;
import com.ibm.wmqfte.explorer.content.TransferTemplateTriggerSorter;
import com.ibm.wmqfte.explorer.content.TransferTemplatesContentProvider;
import com.ibm.wmqfte.explorer.content.TransferTemplatesSorterPage;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.data.TransferTemplateProvider;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.utils.ProviderSorter;
import com.ibm.wmqfte.explorer.wizards.v2.TransferWizardStarterV2;
import com.ibm.wmqfte.objects.TransferTemplate;
import com.ibm.wmqfte.wmqiface.WMQConnectionData;
import com.ibm.wmqfte.wmqiface.WMQPublicationData;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TransferTemplatesPage
extends MFTContentPage
implements IFTEContentPage,
Observer {
    static final Map<String, TransferTemplate> templates = new LinkedHashMap<String, TransferTemplate>();
    static final LinkedList<String> deleted = new LinkedList();
    private static TreeViewer tv;
    public static final DateFormat df;
    public static final DateFormat iso8601;
    private static final String TRANSFER_TEMPLATE_PANEL_SETTINGS = "TRANSFER_TEMPLATE_PANEL_SETTINGS";
    private static final ProviderSorter ps;
    private static final TransferTemplateColumns[] DEFAULT_COLUMNS;
    private static final String[] DEFAULT_COLUMNS_AS_STRING;

    static {
        df = DateFormat.getDateTimeInstance(3, 2);
        iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        ps = new ProviderSorter();
        ps.add(Elements.UI_CONTENT_TRANSFER_TEMPLATES_NAME_TITLE, new TransferTemplateNameLabelProvider(), new TransferTemplateNameSorter());
        ps.add(Elements.UI_CONTENT_SRC_TITLE, new TransferTemplateSourceAgentLabelProvider(), new TransferTemplateSourceAgentSorter());
        ps.add(Elements.UI_CONTENT_DEST_TITLE, new TransferTemplateDestinationAgentLabelProvider(), new TransferTemplateDestinationAgentSorter());
        ps.add(Elements.UI_CONTENT_TRANSFER_TEMPLATES_SCHEDULED_START_TITLE, new TransferTemplateScheduleLabelProvider(), new TransferTemplateScheduleSorter());
        ps.add(Elements.UI_CONTENT_TRANSFER_TEMPLATES_TRIGGERS_TITLE, new TransferTemplateTriggerLabelProvider(), new TransferTemplateTriggerSorter());
        DEFAULT_COLUMNS = new TransferTemplateColumns[]{TransferTemplateColumns.NAME, TransferTemplateColumns.SOURCE, TransferTemplateColumns.DESTINATION, TransferTemplateColumns.SCHEDULED_START, TransferTemplateColumns.TRIGGER_EVENTS};
        DEFAULT_COLUMNS_AS_STRING = new String[]{TransferTemplateColumns.NAME.toString(), TransferTemplateColumns.SOURCE.toString(), TransferTemplateColumns.DESTINATION.toString(), TransferTemplateColumns.SCHEDULED_START.toString(), TransferTemplateColumns.TRIGGER_EVENTS.toString()};
    }

    @Override
    List<String> getColumnTitlesWithTimeZone() {
        return new ArrayList<String>();
    }

    @Override
    TransferTemplateColumns findColumnByPersistedString(String str) {
        return TransferTemplateColumns.findByPersistedString(str);
    }

    @Override
    TransferTemplateColumns findColumnByColumnTitle(String str) {
        return TransferTemplateColumns.findByColumnTitle(str);
    }

    TransferTemplateColumns[] getDefaultColumns() {
        return DEFAULT_COLUMNS;
    }

    public TransferTemplatesPage(Composite parent, int style) {
        super(parent, style);
    }

    public String getId() {
        return "com.ibm.wmqfte.explorer.transfertemplates";
    }

    public void init() {
        ColumnTitleEnumeration[] displayColumns;
        this.setVisible(false);
        final Display display = this.getDisplay();
        int numColumns = 1;
        this.setLayout((Layout)new GridLayout(numColumns, true));
        ContentTitleBar contentTitleBar = new ContentTitleBar((Composite)this, 0);
        contentTitleBar.setText(Elements.UI_CONTENT_TRANSFER_TEMPLATES_TITLE);
        GridData titleBarData = new GridData(768);
        titleBarData.horizontalSpan = numColumns;
        contentTitleBar.setLayoutData((Object)titleBarData);
        Label label = new Label((Composite)this, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = numColumns;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = numColumns;
        gridData.heightHint = 5;
        label.setLayoutData((Object)gridData);
        tv = new TreeViewer((Composite)this, 68354);
        tv.setContentProvider((IContentProvider)new TransferTemplatesContentProvider());
        final Tree tree = tv.getTree();
        ColumnTitleEnumeration[] columnTitleEnumerationArray = displayColumns = this.loadDefaultColumns();
        int n = displayColumns.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnTitleEnumeration col = columnTitleEnumerationArray[n2];
            this.addColumn(ps.adjustColumnName(col.getColumnTitle()), ps.getProvider(col.getColumnTitle()), ps.getSorter(col.getColumnTitle()));
            ++n2;
        }
        tv.setInput(templates);
        tv.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                this.updateTree();
            }

            public void treeExpanded(TreeExpansionEvent event) {
                this.updateTree();
            }

            private void updateTree() {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        tv.refresh();
                        Tree tree = tv.getTree();
                        if (!tree.isDisposed()) {
                            PageUtils.setupTree(tree);
                        }
                    }
                });
            }
        });
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        PageUtils.setupTree(tree);
        this.addContextMenu(tv);
        this.setVisible(true);
        ExplorerPlugin.setHelp((Control)this, "com.ibm.wmqfte.explorer.context.UI_TransferTemplateHelp");
        tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                Object o;
                ISelection s = tv.getSelection();
                if (s instanceof IStructuredSelection && (o = ((IStructuredSelection)s).getFirstElement()) instanceof TransferTemplate) {
                    TransferTemplate t = (TransferTemplate)o;
                    TransferWizardStarterV2.editTemplate(tree.getShell(), t);
                }
            }
        });
        columnTitleEnumerationArray = tv.getTree().getColumns();
        n = columnTitleEnumerationArray.length;
        n2 = 0;
        while (n2 < n) {
            ColumnTitleEnumeration c = columnTitleEnumerationArray[n2];
            c.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                    TransferTemplatesPage.this.saveDefaultColumns();
                }

                public void controlResized(ControlEvent e) {
                }
            });
            ++n2;
        }
        this.saveDefaultColumns();
    }

    private void addColumn(String title, ColumnLabelProvider l, ViewerSorter v) {
        TreeViewerColumn tvc = new TreeViewerColumn(tv, 16384);
        tvc.setLabelProvider((CellLabelProvider)l);
        final TreeColumn c = tvc.getColumn();
        c.setMoveable(true);
        c.setResizable(true);
        c.setText(title);
        c.addControlListener(PageUtils.minWidthControlListener);
        if (v != null && v instanceof TransferTemplatesSorterPage) {
            final TransferTemplatesSorterPage tlSorter = (TransferTemplatesSorterPage)v;
            c.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    tlSorter.setColumn(tv, c);
                    TransferTemplatesPage.this.refresh();
                }
            });
        }
    }

    @Override
    public void update(Observable observable, Object data) {
        if (data instanceof TransferTemplate) {
            TransferTemplate tt = (TransferTemplate)data;
            templates.remove(tt.getUUID());
            if (tt != null && tt.getName() != null && !tt.getName().isEmpty() && !deleted.contains(tt.getUUID())) {
                String uuid = tt.getUUID();
                templates.put(uuid, tt);
                this.refresh();
            } else if (tt.getName() == null || tt.getName().isEmpty()) {
                deleted.remove(tt.getUUID());
                this.refresh();
            }
        }
    }

    private ColumnTitleEnumeration[] loadDefaultColumns() {
        String[] savedColumnOrder = PageUtils.loadDefaultColumns(TRANSFER_TEMPLATE_PANEL_SETTINGS, DEFAULT_COLUMNS_AS_STRING);
        return this.convertColumns(savedColumnOrder);
    }

    private void saveDefaultColumns() {
        PageUtils.saveDefaultColumns(TRANSFER_TEMPLATE_PANEL_SETTINGS, this, (Viewer)tv);
    }

    private void addContextMenu(final TreeViewer tv) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TransferTemplatesPage.this.fillContextMenu(tv, manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)tv.getTree());
        tv.getTree().setMenu(menu);
    }

    private void fillContextMenu(TreeViewer tableViewer, IMenuManager manager) {
        TransferTemplatesPage.addTransferTemplatesMenus(tableViewer.getTree().getShell(), manager, false);
    }

    public static void addTransferTemplatesMenus(final Shell shell, IMenuManager manager, boolean isNode) {
        boolean hasSelection;
        boolean bl = hasSelection = tv != null && tv.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)tv.getSelection()).toList().size() > 0;
        if (isNode || !hasSelection) {
            Action newTemplate = new Action(){

                public void run() {
                    TransferWizardStarterV2.createTemplate(shell);
                }
            };
            newTemplate.setText(String.valueOf(Elements.UI_CONTENT_TRANSFER_TEMPLATES_NEW_TEMPLATE_BUTTON) + "...");
            manager.add((IAction)newTemplate);
        } else {
            boolean enabled = true;
            boolean canSubmit = true;
            List selectionList = ((IStructuredSelection)tv.getSelection()).toList();
            for (Object o : selectionList) {
                if (!(o instanceof TransferTemplate)) {
                    enabled = false;
                    break;
                }
                if (((TransferTemplate)o).isComplete()) continue;
                canSubmit = false;
            }
            Action submit = new Action(){

                public void run() {
                    ISelection s = tv.getSelection();
                    if (s instanceof IStructuredSelection) {
                        for (Object o : ((IStructuredSelection)s).toList()) {
                            if (!(o instanceof TransferTemplate)) continue;
                            TransferTemplate t = (TransferTemplate)o;
                            try {
                                t.submit(Subscription.getCmdConnectionData());
                            }
                            catch (ApiException e) {
                                MessageDialog.openError((Shell)shell, (String)Elements.UI_CONTENT_TRANSFER_TEMPLATES_TITLE, (String)e.getLocalizedMessage());
                            }
                        }
                    }
                }
            };
            submit.setText(Elements.UI_CONTENT_TRANSFER_TEMPLATES_SUBMIT_BUTTON);
            submit.setEnabled(enabled && canSubmit);
            manager.add((IAction)submit);
            manager.add((IContributionItem)new Separator());
            Action edit = new Action(){

                public void run() {
                    ISelection s = tv.getSelection();
                    if (s instanceof IStructuredSelection) {
                        for (Object o : ((IStructuredSelection)s).toList()) {
                            if (!(o instanceof TransferTemplate)) continue;
                            TransferTemplate t = (TransferTemplate)o;
                            TransferWizardStarterV2.editTemplate(shell, t);
                        }
                    }
                }
            };
            edit.setText(Elements.UI_CONTENT_TRANSFER_TEMPLATES_EDIT_BUTTON);
            edit.setEnabled(enabled);
            manager.add((IAction)edit);
            Action editAs = new Action(){

                public void run() {
                    ISelection s = tv.getSelection();
                    if (s instanceof IStructuredSelection) {
                        for (Object o : ((IStructuredSelection)s).toList()) {
                            if (!(o instanceof TransferTemplate)) continue;
                            TransferTemplate t = (TransferTemplate)o;
                            TransferWizardStarterV2.useTemplate(shell, t);
                        }
                    }
                }
            };
            editAs.setText(Elements.UI_CONTENT_TRANSFER_TEMPLATES_EDIT_AS_NEW_TRANSFER_BUTTON);
            editAs.setEnabled(enabled);
            manager.add((IAction)editAs);
            Action duplicate = new Action(){

                public void run() {
                    ISelection s = tv.getSelection();
                    if (s instanceof IStructuredSelection) {
                        for (Object o : ((IStructuredSelection)s).toList()) {
                            if (!(o instanceof TransferTemplate)) continue;
                            String oldName = ((TransferTemplate)o).getName();
                            String newName = String.valueOf(oldName) + " (" + Elements.UI_WIZARD_TEMPLATE_COPY_LABEL + ')';
                            ((TransferTemplate)o).copy(newName);
                            TransferWizardStarterV2.copyTemplate(shell, (TransferTemplate)o);
                        }
                    }
                }
            };
            duplicate.setText(Elements.UI_CONTENT_TRANSFER_TEMPLATES_DUPLICATE_BUTTON);
            duplicate.setEnabled(enabled);
            manager.add((IAction)duplicate);
            manager.add((IContributionItem)new Separator());
            Action delete = new Action(){

                public void run() {
                    ISelection s = tv.getSelection();
                    if (s instanceof IStructuredSelection) {
                        for (Object o : ((IStructuredSelection)s).toList()) {
                            if (!(o instanceof TransferTemplate)) continue;
                            TransferTemplate t = (TransferTemplate)o;
                            try {
                                String uuid = t.getUUID();
                                deleted.add(uuid);
                                WMQConnectionData adminData = Subscription.getAdminConnectionData();
                                WMQPublicationData pubData = new WMQPublicationData(adminData.getQueueManagerName(), adminData.getCcsid(), adminData.getCcsidName());
                                Subscription.publishXML("Templates/" + uuid, "SYSTEM.FTE", "", 75, pubData);
                                Subscription.publishXML("Templates/" + uuid, "SYSTEM.FTE", "", 75, pubData);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            templates.remove(t.getUUID());
                        }
                        while (deleted.size() > 999) {
                            deleted.removeFirst();
                        }
                        tv.refresh();
                    }
                }
            };
            delete.setText(Elements.UI_CONTENT_TRANSFER_TEMPLATES_DELETE_BUTTON);
            delete.setEnabled(enabled);
            manager.add((IAction)delete);
        }
    }

    public void clear() {
        if (templates != null) {
            templates.clear();
        }
        this.refresh();
    }

    public boolean isTemplatePresent(String templateName) {
        for (Map.Entry<String, TransferTemplate> entry : templates.entrySet()) {
            if (!entry.getValue().getName().equalsIgnoreCase(templateName)) continue;
            return true;
        }
        return false;
    }

    public void instanceDeleted(Object object) {
    }

    public boolean isEnableRefreshAction() {
        return true;
    }

    public boolean isEnableSystemObjectsAction() {
        return false;
    }

    public void refresh() {
        if (this.getDisplay() != null && !this.getDisplay().isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (tv != null) {
                        tv.refresh();
                        Tree tree = tv.getTree();
                        if (!tree.isDisposed()) {
                            PageUtils.setupTree(tree);
                        }
                    }
                }
            });
        }
    }

    public void repaint() {
    }

    public void setObject(MQExtObject object) {
    }

    public void showSystemObjects(boolean show) {
    }

    public void updatePage() {
    }

    @Override
    public void startup() {
        TransferTemplateProvider transferTemplateProvider = Subscription.getTransferTemplateProvider();
        for (TransferTemplate template : transferTemplateProvider.getTransferTemplates()) {
            this.update(null, template);
        }
        transferTemplateProvider.addObserver(this);
    }

    @Override
    public void shutdown() {
        this.clear();
    }

    static enum TransferTemplateColumns implements ColumnTitleEnumeration
    {
        NAME(Elements.UI_CONTENT_TRANSFER_TEMPLATES_NAME_TITLE),
        SOURCE(Elements.UI_CONTENT_SRC_TITLE),
        DESTINATION(Elements.UI_CONTENT_DEST_TITLE),
        SCHEDULED_START(Elements.UI_CONTENT_TRANSFER_TEMPLATES_SCHEDULED_START_TITLE),
        TRIGGER_EVENTS(Elements.UI_CONTENT_TRANSFER_TEMPLATES_TRIGGERS_TITLE);

        private final String columnTitle;

        private TransferTemplateColumns(String columnTitle) {
            this.columnTitle = columnTitle;
        }

        @Override
        public String getColumnTitle() {
            return this.columnTitle;
        }

        public static TransferTemplateColumns findByPersistedString(String str) {
            TransferTemplateColumns[] transferTemplateColumnsArray = TransferTemplateColumns.values();
            int n = transferTemplateColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransferTemplateColumns col = transferTemplateColumnsArray[n2];
                if (col.toString().equals(str)) {
                    return col;
                }
                ++n2;
            }
            return null;
        }

        public static TransferTemplateColumns findByColumnTitle(String title) {
            TransferTemplateColumns[] transferTemplateColumnsArray = TransferTemplateColumns.values();
            int n = transferTemplateColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransferTemplateColumns col = transferTemplateColumnsArray[n2];
                if (col.columnTitle.equals(title)) {
                    return col;
                }
                ++n2;
            }
            return null;
        }
    }
}

