/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.wmqfte.api.CommandScheduleSpecification;
import com.ibm.wmqfte.explorer.content.TransferTemplatesPage;
import com.ibm.wmqfte.objects.TransferTemplate;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ItemSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.TriggerParameterSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.TriggerSpecification;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

class TransferTemplatesLabelProvider
implements ITableLabelProvider {
    TransferTemplatesLabelProvider() {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result;
        block19: {
            block18: {
                result = "";
                if (!(element instanceof TransferTemplate)) break block18;
                TransferTemplate tt = (TransferTemplate)element;
                switch (columnIndex) {
                    case 0: {
                        result = tt.getName();
                        break;
                    }
                    case 1: {
                        result = tt.getSourceAgent() == null ? null : tt.getSourceAgent().getAgentName();
                        break;
                    }
                    case 2: {
                        result = tt.getDestinationAgent() == null ? null : tt.getDestinationAgent().getAgentName();
                        break;
                    }
                    case 3: {
                        CommandScheduleSpecification ss = tt.getScheduleSpec();
                        if (ss != null) {
                            try {
                                Date date = TransferTemplatesPage.iso8601.parse(ss.getStartSchedule());
                                result = String.valueOf(TransferTemplatesPage.df.format(date)) + " " + ss.getTimeBase().toUpperCase();
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                        }
                        break block19;
                    }
                    case 4: {
                        TriggerSpecification triggerSpec = tt.getTriggerSpec();
                        if (triggerSpec != null) {
                            List triggers = triggerSpec.getTriggerSet();
                            int numTriggers = triggers.size();
                            int i = 0;
                            while (i < numTriggers) {
                                TriggerParameterSpecification t = (TriggerParameterSpecification)triggers.get(i);
                                result = String.valueOf(result) + t.getCheck().name() + ' ' + t.getComparison().name() + ' ' + t.getQualifier() + ' ' + t.getXMLNameList();
                                if (numTriggers > 1 && i != numTriggers - 1) {
                                    result = String.valueOf(result) + '\n';
                                }
                                ++i;
                            }
                        }
                        break block19;
                    }
                }
                break block19;
            }
            if (element instanceof ItemSpecification) {
                ItemSpecification ts = (ItemSpecification)element;
                switch (columnIndex) {
                    case 1: {
                        result = ts.getSourceName();
                        break;
                    }
                    case 2: {
                        result = ts.getDestinationName();
                    }
                }
            }
        }
        return String.valueOf(result) + "    ";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

