/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.wmqfte.api.AbstractCommand;
import com.ibm.wmqfte.api.DeleteScheduledTransfer;
import com.ibm.wmqfte.api.FTEScheduleDOMParser;
import com.ibm.wmqfte.api.InternalException;
import com.ibm.wmqfte.api.ScheduleInformation;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.content.ColumnTitleEnumeration;
import com.ibm.wmqfte.explorer.content.IFTEContentPage;
import com.ibm.wmqfte.explorer.content.MFTContentPage;
import com.ibm.wmqfte.explorer.content.TransferScheduleContentProvider;
import com.ibm.wmqfte.explorer.content.TransferScheduleDestinationAgentProvider;
import com.ibm.wmqfte.explorer.content.TransferScheduleDestinationAgentSorter;
import com.ibm.wmqfte.explorer.content.TransferScheduleJobNameProvider;
import com.ibm.wmqfte.explorer.content.TransferScheduleJobNameSorter;
import com.ibm.wmqfte.explorer.content.TransferScheduleNameProvider;
import com.ibm.wmqfte.explorer.content.TransferScheduleNameSorter;
import com.ibm.wmqfte.explorer.content.TransferScheduleNextSorter;
import com.ibm.wmqfte.explorer.content.TransferScheduleNextTransferProvider;
import com.ibm.wmqfte.explorer.content.TransferScheduleRepeatCountProvider;
import com.ibm.wmqfte.explorer.content.TransferScheduleRepeatCountSorter;
import com.ibm.wmqfte.explorer.content.TransferScheduleRepeatFrequencyProvider;
import com.ibm.wmqfte.explorer.content.TransferScheduleRepeatFrequencySorter;
import com.ibm.wmqfte.explorer.content.TransferScheduleRepeatIntervalProvider;
import com.ibm.wmqfte.explorer.content.TransferScheduleRepeatIntervalSorter;
import com.ibm.wmqfte.explorer.content.TransferScheduleSorterPage;
import com.ibm.wmqfte.explorer.content.TransferScheduleSourceAgentProvider;
import com.ibm.wmqfte.explorer.content.TransferScheduleSourceAgentSorter;
import com.ibm.wmqfte.explorer.content.TransferScheduleStartProvider;
import com.ibm.wmqfte.explorer.content.TransferScheduleStartSorter;
import com.ibm.wmqfte.explorer.data.ScheduleProvider;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.utils.ProviderSorter;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import com.ibm.wmqfte.utils.FTEUtils;
import com.ibm.wmqfte.wmqiface.WMQConnectionData;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TransferSchedulePage
extends MFTContentPage
implements IFTEContentPage,
Observer {
    private TableViewer tv;
    private static final Map<String, Set<ScheduleInformation>> schedules = new HashMap<String, Set<ScheduleInformation>>();
    private static FTEScheduleDOMParser domParser = new FTEScheduleDOMParser();
    public static final DateFormat df = DateFormat.getDateTimeInstance(3, 1);
    public static final DateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmz");
    private TableColumn start;
    private TableColumn next;
    private static final String TRANSFER_SCHEDULE_SETTINGS = "UI_SETTINGS_TRANSFER_SCHEDULE";
    private static final List<String> COLUMNS_WITH_TIMEZONE;
    private static final ProviderSorter ps;
    private static final TransferScheduleColumns[] DEFAULT_COLUMNS;
    private static final String[] DEFAULT_COLUMNS_AS_STRING;
    private final IPropertyChangeListener timeZoneChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            Object val;
            if ("com.ibm.wmqfte.explorer.timezone".equals(event.getProperty()) && (val = event.getNewValue()) instanceof String) {
                String oldTz = String.valueOf(df.getTimeZone().getID()) + ')';
                String newTz = (String)event.getNewValue();
                TableColumn[] tableColumnArray = new TableColumn[]{TransferSchedulePage.this.start, TransferSchedulePage.this.next};
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn c = tableColumnArray[n2];
                    String t = c.getText();
                    if (t != null && t.endsWith(oldTz)) {
                        c.setText(t.replace(oldTz, String.valueOf(newTz) + ')'));
                    }
                    ++n2;
                }
                df.setTimeZone(TimeZone.getTimeZone(newTz));
                TransferSchedulePage.this.tv.refresh();
                Table table = TransferSchedulePage.this.tv.getTable();
                if (!table.isDisposed()) {
                    TransferSchedulePage.this.setupTable(table);
                }
            }
        }
    };

    static {
        iso8601.setTimeZone(TimeZone.getTimeZone("UTC"));
        df.setTimeZone(ExplorerPlugin.getTimeZone());
        COLUMNS_WITH_TIMEZONE = new ArrayList<String>();
        COLUMNS_WITH_TIMEZONE.add(Elements.UI_CONTENT_TRANSFER_TEMPLATES_SCHEDULED_START_TITLE);
        COLUMNS_WITH_TIMEZONE.add(Elements.UI_CONTENT_TRANSFER_SCHEDULE_NEXT_TRANSFER_TITLE);
        ps = new ProviderSorter(COLUMNS_WITH_TIMEZONE);
        ps.add(Elements.UI_CONTENT_TRANSFER_TEMPLATES_NAME_TITLE, new TransferScheduleNameProvider(), new TransferScheduleNameSorter());
        ps.add(Elements.UI_CONTENT_JOB_NAME, new TransferScheduleJobNameProvider(), new TransferScheduleJobNameSorter());
        ps.add(Elements.UI_CONTENT_SRC_TITLE, new TransferScheduleSourceAgentProvider(), new TransferScheduleSourceAgentSorter());
        ps.add(Elements.UI_CONTENT_DEST_TITLE, new TransferScheduleDestinationAgentProvider(), new TransferScheduleDestinationAgentSorter());
        ps.add(Elements.UI_CONTENT_TRANSFER_TEMPLATES_SCHEDULED_START_TITLE, new TransferScheduleStartProvider(), new TransferScheduleStartSorter());
        ps.add(Elements.UI_CONTENT_TRANSFER_SCHEDULE_REPEAT_EVERY_TITLE, new TransferScheduleRepeatFrequencyProvider(), new TransferScheduleRepeatFrequencySorter());
        ps.add(Elements.UI_CONTENT_TRANSFER_SCHEDULE_REPEAT_TYPE_TITLE, new TransferScheduleRepeatIntervalProvider(), new TransferScheduleRepeatIntervalSorter());
        ps.add(Elements.UI_CONTENT_TRANSFER_SCHEDULE_REPEAT_UNTIL_TITLE, new TransferScheduleRepeatCountProvider(), new TransferScheduleRepeatCountSorter());
        ps.add(Elements.UI_CONTENT_TRANSFER_SCHEDULE_NEXT_TRANSFER_TITLE, new TransferScheduleNextTransferProvider(), new TransferScheduleNextSorter());
        DEFAULT_COLUMNS = new TransferScheduleColumns[]{TransferScheduleColumns.NAME, TransferScheduleColumns.JOB_NAME, TransferScheduleColumns.SOURCE, TransferScheduleColumns.DESTINATION, TransferScheduleColumns.START_TIME, TransferScheduleColumns.REPEAT_EVERY, TransferScheduleColumns.REPEAT_TYPE, TransferScheduleColumns.REPEAT_UNTIL, TransferScheduleColumns.NEXT_TRANSFER};
        DEFAULT_COLUMNS_AS_STRING = new String[]{TransferScheduleColumns.NAME.toString(), TransferScheduleColumns.JOB_NAME.toString(), TransferScheduleColumns.SOURCE.toString(), TransferScheduleColumns.DESTINATION.toString(), TransferScheduleColumns.START_TIME.toString(), TransferScheduleColumns.REPEAT_EVERY.toString(), TransferScheduleColumns.REPEAT_TYPE.toString(), TransferScheduleColumns.REPEAT_UNTIL.toString(), TransferScheduleColumns.NEXT_TRANSFER.toString()};
    }

    @Override
    List<String> getColumnTitlesWithTimeZone() {
        return COLUMNS_WITH_TIMEZONE;
    }

    @Override
    TransferScheduleColumns findColumnByPersistedString(String str) {
        return TransferScheduleColumns.findByPersistedString(str);
    }

    @Override
    TransferScheduleColumns findColumnByColumnTitle(String str) {
        return TransferScheduleColumns.findByColumnTitle(str);
    }

    TransferScheduleColumns[] getDefaultColumns() {
        return DEFAULT_COLUMNS;
    }

    public TransferSchedulePage(Composite parent, int style) {
        super(parent, style);
    }

    public String getId() {
        return "com.ibm.wmqfte.explorer.transfertemplates";
    }

    public void init() {
        ColumnTitleEnumeration[] displayColumns;
        this.setVisible(false);
        int numColumns = 1;
        this.setLayout((Layout)new GridLayout(numColumns, true));
        ContentTitleBar contentTitleBar = new ContentTitleBar((Composite)this, 0);
        contentTitleBar.setText(Elements.UI_CONTENT_TRANSFER_SCHEDULE_TITLE);
        GridData titleBarData = new GridData(768);
        titleBarData.horizontalSpan = numColumns;
        contentTitleBar.setLayoutData((Object)titleBarData);
        Label label = new Label((Composite)this, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = numColumns;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = numColumns;
        gridData.heightHint = 5;
        label.setLayoutData((Object)gridData);
        this.tv = new TableViewer((Composite)this, 68354);
        this.tv.setContentProvider((IContentProvider)new TransferScheduleContentProvider());
        Table table = this.tv.getTable();
        ColumnTitleEnumeration[] columnTitleEnumerationArray = displayColumns = this.loadDefaultColumns();
        int n = displayColumns.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnTitleEnumeration col = columnTitleEnumerationArray[n2];
            this.addColumn(ps.adjustColumnName(col.getColumnTitle()), ps.getProvider(col.getColumnTitle()), ps.getSorter(col.getColumnTitle()));
            ++n2;
        }
        this.tv.setInput(schedules);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setupTable(table);
        this.addContextMenu(this.tv);
        this.setVisible(true);
        ExplorerPlugin.setHelp((Control)this, "com.ibm.wmqfte.explorer.context.UI_PendingTransferHelp");
        ExplorerPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.timeZoneChangeListener);
        columnTitleEnumerationArray = this.tv.getTable().getColumns();
        n = columnTitleEnumerationArray.length;
        n2 = 0;
        while (n2 < n) {
            ColumnTitleEnumeration c = columnTitleEnumerationArray[n2];
            c.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                    TransferSchedulePage.this.saveDefaultColumns();
                }

                public void controlResized(ControlEvent e) {
                }
            });
            ++n2;
        }
        this.saveDefaultColumns();
    }

    private void addColumn(String title, ColumnLabelProvider l, ViewerSorter vs) {
        TableViewerColumn tvc = new TableViewerColumn(this.tv, 16384);
        tvc.setLabelProvider((CellLabelProvider)l);
        final TableColumn tc = tvc.getColumn();
        tc.setText(title);
        tc.setResizable(true);
        tc.setMoveable(true);
        tc.addControlListener(PageUtils.minWidthControlListener);
        if (title.equals(ps.adjustColumnName(Elements.UI_CONTENT_TRANSFER_TEMPLATES_SCHEDULED_START_TITLE))) {
            this.start = tc;
        } else if (title.equals(ps.adjustColumnName(Elements.UI_CONTENT_TRANSFER_SCHEDULE_NEXT_TRANSFER_TITLE))) {
            this.next = tc;
        }
        if (vs != null && vs instanceof TransferScheduleSorterPage) {
            final TransferScheduleSorterPage tsSorter = (TransferScheduleSorterPage)vs;
            tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    tsSorter.setColumn(TransferSchedulePage.this.tv, tc);
                    TransferSchedulePage.this.refresh();
                }
            });
        }
    }

    public void clear() {
        if (schedules != null) {
            schedules.clear();
        }
        this.refresh();
    }

    public void dispose() {
        ExplorerPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.timeZoneChangeListener);
        super.dispose();
    }

    @Override
    public void update(Observable observable, Object scheduleXML) {
        block3: {
            if (scheduleXML instanceof FTEUtils.XMLData) {
                LinkedHashSet result = new LinkedHashSet();
                try {
                    StringBuffer buf = new StringBuffer();
                    domParser.parseXML((FTEUtils.XMLData)scheduleXML, result, buf);
                    String agentName = buf.toString();
                    schedules.put(agentName, result);
                    this.refresh();
                }
                catch (InternalException e) {
                    if (!Trace.isTracing) break block3;
                    Trace.data((Level)Level.WARNING, (String)"TransferSchedulePage", (String)"update", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
            }
        }
    }

    private void addContextMenu(final TableViewer tableViewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TransferSchedulePage.this.fillContextMenu(tableViewer, manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)tableViewer.getTable());
        tableViewer.getTable().setMenu(menu);
    }

    private void fillContextMenu(TableViewer tableViewer, IMenuManager manager) {
        Action cancel = new Action(){

            public void run() {
                ISelection s = TransferSchedulePage.this.tv.getSelection();
                if (s instanceof IStructuredSelection) {
                    for (Object o : ((IStructuredSelection)s).toList()) {
                        if (!(o instanceof ScheduleInformation)) continue;
                        ScheduleInformation i = (ScheduleInformation)o;
                        try {
                            String agentName = i.getSourceAgentName();
                            WMQConnectionData cmd = Subscription.getCmdConnectionData();
                            for (AgentStatusDetails agent : Subscription.getAgentStatusDetailsProvider().getAvailableAgents()) {
                                if (!agentName.equals(agent.getAgentName())) continue;
                                DeleteScheduledTransfer.deleteScheduledTransfer((String)agentName, (String)agent.getQueueManagerName(), (WMQConnectionData)cmd, (String)Subscription.getDynamicQueuePrefix(), (String)Subscription.getModelQueueName(), (String)AbstractCommand.getHostName(), (String)AbstractCommand.getUserId(), (String)i.getIdentifier());
                            }
                            schedules.remove(i);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        cancel.setText(Elements.UI_WIZARD_SCHEDULE_CANCEL);
        boolean enabled = this.tv.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)this.tv.getSelection()).toList().size() > 0;
        cancel.setEnabled(enabled);
        manager.add((IAction)cancel);
    }

    public void setupTable(Table table) {
        GC g = new GC((Drawable)table);
        g.setFont(table.getFont());
        int columnCount = table.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            TableColumn column = table.getColumn(i);
            if (column.getWidth() == 0 || !column.getResizable()) {
                int longestWidth = g.stringExtent((String)column.getText()).x;
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    String text = tableItem.getText(i);
                    int width = g.stringExtent((String)text).x;
                    if (width > longestWidth) {
                        longestWidth = width;
                    }
                    ++n2;
                }
                column.setWidth(longestWidth + 25);
                if (column.equals(table.getSortColumn())) {
                    column.setWidth(column.getWidth() + 25);
                }
            }
            ++i;
        }
        g.dispose();
    }

    public void instanceDeleted(Object object) {
    }

    public boolean isEnableRefreshAction() {
        return true;
    }

    public boolean isEnableSystemObjectsAction() {
        return false;
    }

    public void refresh() {
        if (this.getDisplay() != null && !this.getDisplay().isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TransferSchedulePage.this.tv != null) {
                        TransferSchedulePage.this.tv.refresh();
                        Table table = TransferSchedulePage.this.tv.getTable();
                        if (!table.isDisposed()) {
                            TransferSchedulePage.this.setupTable(table);
                        }
                    }
                }
            });
        }
    }

    public void repaint() {
    }

    public void setObject(MQExtObject object) {
    }

    public void showSystemObjects(boolean show) {
    }

    public void updatePage() {
    }

    @Override
    public void startup() {
        ScheduleProvider scheduleProvider = Subscription.getScheduleProvider();
        for (FTEUtils.XMLData scheduleXML : scheduleProvider.getSchedules()) {
            this.update(null, scheduleXML);
        }
        scheduleProvider.addObserver(this);
    }

    @Override
    public void shutdown() {
        this.clear();
    }

    private ColumnTitleEnumeration[] loadDefaultColumns() {
        String[] savedColumnOrder = PageUtils.loadDefaultColumns(TRANSFER_SCHEDULE_SETTINGS, DEFAULT_COLUMNS_AS_STRING);
        return this.convertColumns(savedColumnOrder);
    }

    private void saveDefaultColumns() {
        PageUtils.saveDefaultColumns(TRANSFER_SCHEDULE_SETTINGS, this, (Viewer)this.tv);
    }

    static enum TransferScheduleColumns implements ColumnTitleEnumeration
    {
        NAME(Elements.UI_CONTENT_TRANSFER_TEMPLATES_NAME_TITLE),
        JOB_NAME(Elements.UI_CONTENT_JOB_NAME),
        SOURCE(Elements.UI_CONTENT_SRC_TITLE),
        DESTINATION(Elements.UI_CONTENT_DEST_TITLE),
        START_TIME(Elements.UI_CONTENT_TRANSFER_TEMPLATES_SCHEDULED_START_TITLE),
        REPEAT_EVERY(Elements.UI_CONTENT_TRANSFER_SCHEDULE_REPEAT_EVERY_TITLE),
        REPEAT_TYPE(Elements.UI_CONTENT_TRANSFER_SCHEDULE_REPEAT_TYPE_TITLE),
        REPEAT_UNTIL(Elements.UI_CONTENT_TRANSFER_SCHEDULE_REPEAT_UNTIL_TITLE),
        NEXT_TRANSFER(Elements.UI_CONTENT_TRANSFER_SCHEDULE_NEXT_TRANSFER_TITLE);

        private final String columnTitle;

        private TransferScheduleColumns(String columnTitle) {
            this.columnTitle = columnTitle;
        }

        @Override
        public String getColumnTitle() {
            return this.columnTitle;
        }

        public static TransferScheduleColumns findByPersistedString(String str) {
            TransferScheduleColumns[] transferScheduleColumnsArray = TransferScheduleColumns.values();
            int n = transferScheduleColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransferScheduleColumns col = transferScheduleColumnsArray[n2];
                if (col.toString().equals(str)) {
                    return col;
                }
                ++n2;
            }
            return null;
        }

        public static TransferScheduleColumns findByColumnTitle(String title) {
            TransferScheduleColumns[] transferScheduleColumnsArray = TransferScheduleColumns.values();
            int n = transferScheduleColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransferScheduleColumns col = transferScheduleColumnsArray[n2];
                if (col.columnTitle.equals(title)) {
                    return col;
                }
                ++n2;
            }
            return null;
        }
    }
}

