/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.wmqfte.api.ScheduleInformation;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.content.TransferSchedulePage;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ScheduleSpecification;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

class TransferScheduleLabelProvider
implements ITableLabelProvider {
    TransferScheduleLabelProvider() {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof ScheduleInformation) {
            ScheduleInformation s = (ScheduleInformation)element;
            switch (columnIndex) {
                case 0: {
                    text = s.getIdentifier();
                    break;
                }
                case 1: {
                    text = s.getSourceAgentName();
                    break;
                }
                case 2: {
                    text = s.getDestinationAgentName();
                    break;
                }
                case 3: {
                    String startSchedule = s.getScheduleStart();
                    try {
                        Date utc = TransferSchedulePage.iso8601.parse(startSchedule);
                        text = TransferSchedulePage.df.format(utc);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        text = startSchedule;
                    }
                    break;
                }
                case 4: {
                    text = s.getRepeatFrequency() > 0 ? Integer.toString(s.getRepeatFrequency()) : "";
                    break;
                }
                case 5: {
                    text = s.getRepeatInterval().toUpperCase();
                    if (text.length() <= 0) break;
                    ScheduleSpecification.RepeatInterval ri = Enum.valueOf(ScheduleSpecification.RepeatInterval.class, text);
                    if (ScheduleSpecification.RepeatInterval.MINUTES.equals((Object)ri)) {
                        text = Elements.UI_WIZARD_SCHEDULE_MINUTES;
                        break;
                    }
                    if (ScheduleSpecification.RepeatInterval.HOURS.equals((Object)ri)) {
                        text = Elements.UI_WIZARD_SCHEDULE_HOURS;
                        break;
                    }
                    if (ScheduleSpecification.RepeatInterval.DAYS.equals((Object)ri)) {
                        text = Elements.UI_WIZARD_SCHEDULE_DAYS;
                        break;
                    }
                    if (ScheduleSpecification.RepeatInterval.WEEKS.equals((Object)ri)) {
                        text = Elements.UI_WIZARD_SCHEDULE_WEEKS;
                        break;
                    }
                    if (ScheduleSpecification.RepeatInterval.MONTHS.equals((Object)ri)) {
                        text = Elements.UI_WIZARD_SCHEDULE_MONTHS;
                        break;
                    }
                    if (!ScheduleSpecification.RepeatInterval.YEARS.equals((Object)ri)) break;
                    text = Elements.UI_WIZARD_SCHEDULE_YEARS;
                    break;
                }
                case 6: {
                    if (s.getRepeatCount() > 0) {
                        text = String.valueOf(s.getRepeatCount()) + " " + Elements.UI_WIZARD_SCHEDULE_REPETITIONS;
                        break;
                    }
                    if (s.getScheduleEnd().length() <= 0) break;
                    try {
                        Date utc = TransferSchedulePage.iso8601.parse(s.getScheduleEnd());
                        text = TransferSchedulePage.df.format(utc);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        text = s.getScheduleEnd();
                    }
                    break;
                }
                case 7: {
                    String nextTransfer = s.getNextTransferTime();
                    try {
                        Date utc = TransferSchedulePage.iso8601.parse(nextTransfer);
                        text = TransferSchedulePage.df.format(utc);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        text = nextTransfer;
                    }
                    break;
                }
            }
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

