/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.wmqfte.api.AbstractCommand;
import com.ibm.wmqfte.api.CancelTransfer;
import com.ibm.wmqfte.api.ConfigurationException;
import com.ibm.wmqfte.api.FTEPropertySet;
import com.ibm.wmqfte.api.FTEPropertyStore;
import com.ibm.wmqfte.api.ParameterException;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.Messages;
import com.ibm.wmqfte.explorer.content.AuditTimeLabelProvider;
import com.ibm.wmqfte.explorer.content.CDPNodeLabelProvider;
import com.ibm.wmqfte.explorer.content.CDProcessNameLabelProvider;
import com.ibm.wmqfte.explorer.content.CDProcessNumberLabelProvider;
import com.ibm.wmqfte.explorer.content.CDSNodeLabelProvider;
import com.ibm.wmqfte.explorer.content.ColumnTitleEnumeration;
import com.ibm.wmqfte.explorer.content.ConfigureColumnsAction;
import com.ibm.wmqfte.explorer.content.DestinationLabelProvider;
import com.ibm.wmqfte.explorer.content.DestinationTypeLabelProvider;
import com.ibm.wmqfte.explorer.content.IFTEContentPage;
import com.ibm.wmqfte.explorer.content.JobNameLabelProvider;
import com.ibm.wmqfte.explorer.content.MFTContentPage;
import com.ibm.wmqfte.explorer.content.OriginatorLabelProvider;
import com.ibm.wmqfte.explorer.content.SourceLabelProvider;
import com.ibm.wmqfte.explorer.content.SourceTypeLabelProvider;
import com.ibm.wmqfte.explorer.content.StartTimeLabelProvider;
import com.ibm.wmqfte.explorer.content.StateLabelProvider;
import com.ibm.wmqfte.explorer.content.TransferLogCDPrimaryNodeSorter;
import com.ibm.wmqfte.explorer.content.TransferLogCDProcessNameSorter;
import com.ibm.wmqfte.explorer.content.TransferLogCDProcessNumberSorter;
import com.ibm.wmqfte.explorer.content.TransferLogCDSecondaryNodeSorter;
import com.ibm.wmqfte.explorer.content.TransferLogCompletionSorter;
import com.ibm.wmqfte.explorer.content.TransferLogContentProvider;
import com.ibm.wmqfte.explorer.content.TransferLogDestinationSorter;
import com.ibm.wmqfte.explorer.content.TransferLogDestinationTypeSorter;
import com.ibm.wmqfte.explorer.content.TransferLogFilter;
import com.ibm.wmqfte.explorer.content.TransferLogJobNameSorter;
import com.ibm.wmqfte.explorer.content.TransferLogOwnerSorter;
import com.ibm.wmqfte.explorer.content.TransferLogSorterPage;
import com.ibm.wmqfte.explorer.content.TransferLogSourceSorter;
import com.ibm.wmqfte.explorer.content.TransferLogSourceTypeSorter;
import com.ibm.wmqfte.explorer.content.TransferLogStartedSorter;
import com.ibm.wmqfte.explorer.content.TransferLogStateRecordedSorter;
import com.ibm.wmqfte.explorer.content.TransferLogTransferIDSorter;
import com.ibm.wmqfte.explorer.content.UUIDLabelProvider;
import com.ibm.wmqfte.explorer.data.AuditProvider;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.objects.Call;
import com.ibm.wmqfte.explorer.objects.TransferLog;
import com.ibm.wmqfte.explorer.objects.TransferLogStateUtils;
import com.ibm.wmqfte.explorer.treenode.CoordTreeNode;
import com.ibm.wmqfte.explorer.treenode.MFTETreeNodeFactory;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.utils.ProviderSorter;
import com.ibm.wmqfte.explorer.views.TransferProgressView;
import com.ibm.wmqfte.statestore.FTEStateType;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import com.ibm.wmqfte.utils.AgentType;
import com.ibm.wmqfte.utils.FTETransferStatusInfo;
import com.ibm.wmqfte.utils.reply.FTEReply;
import com.ibm.wmqfte.utils.xmlmessage.audit.FTEAuditFileNamePair;
import com.ibm.wmqfte.utils.xmlmessage.audit.FTEAuditFileResultCode;
import com.ibm.wmqfte.utils.xmlmessage.audit.FTEAuditStatus;
import com.ibm.wmqfte.wmqiface.WMQConnectionData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TransferLogPage
extends MFTContentPage
implements IShellProvider,
IFTEContentPage,
Observer {
    private static final Map<String, TransferLog> logs = Collections.synchronizedMap(new LinkedHashMap());
    private static final String TRANSFER_LOG_SETTINGS = "UI_SETTINGS_TRANSFER_LOG";
    private TreeViewer tv;
    private Thread pollingThread;
    private static final String TRANSFERLOG_BIN = "transferlog.bin";
    private Action clearCompleted;
    private Action collapseAll;
    private List<TreeViewerColumn> displayedColumns;
    private final List<TreeViewerColumn> availableColumns;
    private TreeViewerColumn emptyTVC;
    private ConfigureColumnsAction configureColumns;
    private final Map<TreeColumn, Boolean> columnVisibility;
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private DocumentBuilder db;
    private static final XPath xPath = XPathFactory.newInstance().newXPath();
    private static XPathExpression xPathType;
    private static XPathExpression xPathVersion;
    private static XPathExpression xPathID;
    private static XPathExpression xPathAgentRole;
    private static XPathExpression xPathSrcAgent;
    private static XPathExpression xPathSrcAgentType;
    private static XPathExpression xPathSrcAgentCDBridgeNode;
    private static XPathExpression xPathSrcAgentCDPNode;
    private static XPathExpression xPathSrcAgentCDSNode;
    private static XPathExpression xPathSrcWebGateway;
    private static XPathExpression xPathSrcBridgeURL;
    private static XPathExpression xPathSrcAgentQmgr;
    private static XPathExpression xPathDestAgent;
    private static XPathExpression xPathDestAgentType;
    private static XPathExpression xPathDestAgentCDBridgeNode;
    private static XPathExpression xPathDestAgentCDPNode;
    private static XPathExpression xPathDestAgentCDSNode;
    private static XPathExpression xPathDestBridgeURL;
    private static XPathExpression xPathDestWebGateway;
    private static XPathExpression xPathDestWebGatewayAgent;
    private static XPathExpression xPathDestAgentQmgr;
    private static XPathExpression xPathActionTime;
    private static XPathExpression xPathAction;
    private static XPathExpression xPathUserID;
    private static XPathExpression xPathUserHost;
    private static XPathExpression xPathRC;
    private static XPathExpression xPathStartTime;
    private static XPathExpression xPathTotal;
    private static XPathExpression xPathJob;
    protected static final DateFormat df;
    protected static final DateFormat iso8601nano;
    protected static final DateFormat iso8601;
    private int transferLogMax;
    private static final List<String> COLUMNS_WITH_TIMEZONE;
    private static final ProviderSorter ps;
    private static final TransferLogColumns[] DEFAULT_COLUMNS;
    private static final String[] DEFAULT_COLUMNS_AS_STRING;
    private final IPropertyChangeListener transferLogPrefsListener;
    final Calendar cal;
    static final Pattern newline;
    private volatile long lastRefreshCompletedTime;
    private volatile int refreshRequestQueuedCount;
    private Object refreshRequestLock;

    static {
        df = DateFormat.getDateTimeInstance(3, 1);
        iso8601nano = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz");
        iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        iso8601.setTimeZone(TimeZone.getTimeZone("UTC"));
        iso8601nano.setTimeZone(TimeZone.getTimeZone("UTC"));
        df.setTimeZone(ExplorerPlugin.getTimeZone());
        COLUMNS_WITH_TIMEZONE = new ArrayList<String>();
        COLUMNS_WITH_TIMEZONE.add(Elements.UI_CONTENT_STARTED_TITLE);
        COLUMNS_WITH_TIMEZONE.add(Elements.UI_CONTENT_RECORD_TIME);
        ps = new ProviderSorter(COLUMNS_WITH_TIMEZONE);
        ps.add(Elements.UI_CONTENT_SRC_TITLE, new SourceLabelProvider(), new TransferLogSourceSorter());
        ps.add(Elements.UI_CONTENT_DEST_TITLE, new DestinationLabelProvider(), new TransferLogDestinationSorter());
        ps.add(Elements.UI_CONTENT_COMPLETION_TITLE, new StateLabelProvider(), new TransferLogCompletionSorter());
        ps.add(Elements.UI_CONTENT_OWNER_TITLE, new OriginatorLabelProvider(), new TransferLogOwnerSorter());
        ps.add(Elements.UI_CONTENT_STARTED_TITLE, new StartTimeLabelProvider(), new TransferLogStartedSorter());
        ps.add(Elements.UI_CONTENT_RECORD_TIME, new AuditTimeLabelProvider(), new TransferLogStateRecordedSorter());
        ps.add(Elements.UI_CONTENT_JOB_NAME, new JobNameLabelProvider(), new TransferLogJobNameSorter());
        ps.add(Elements.UI_CONTENT_TRANSFER_ID, new UUIDLabelProvider(), new TransferLogTransferIDSorter());
        ps.add(Elements.UI_CONTENT_SRC_TYPE, new SourceTypeLabelProvider(), new TransferLogSourceTypeSorter());
        ps.add(Elements.UI_CONTENT_DEST_TYPE, new DestinationTypeLabelProvider(), new TransferLogDestinationTypeSorter());
        ps.add(Elements.UI_CONTENT_CD_PRIMARY_NODE, new CDPNodeLabelProvider(), new TransferLogCDPrimaryNodeSorter());
        ps.add(Elements.UI_CONTENT_CD_SECONDARY_NODE, new CDSNodeLabelProvider(), new TransferLogCDSecondaryNodeSorter());
        ps.add(Elements.UI_CONTENT_CD_PROCESS_NAME, new CDProcessNameLabelProvider(), new TransferLogCDProcessNameSorter());
        ps.add(Elements.UI_CONTENT_CD_PROCESS_NUMBER, new CDProcessNumberLabelProvider(), new TransferLogCDProcessNumberSorter());
        DEFAULT_COLUMNS = new TransferLogColumns[]{TransferLogColumns.SOURCE, TransferLogColumns.DESTINATION, TransferLogColumns.COMPLETION, TransferLogColumns.OWNER, TransferLogColumns.STARTED};
        DEFAULT_COLUMNS_AS_STRING = new String[]{TransferLogColumns.SOURCE.toString(), TransferLogColumns.DESTINATION.toString(), TransferLogColumns.COMPLETION.toString(), TransferLogColumns.OWNER.toString(), TransferLogColumns.STARTED.toString()};
        newline = Pattern.compile("\n");
    }

    @Override
    List<String> getColumnTitlesWithTimeZone() {
        return COLUMNS_WITH_TIMEZONE;
    }

    @Override
    TransferLogColumns findColumnByPersistedString(String str) {
        return TransferLogColumns.findByPersistedString(str);
    }

    @Override
    TransferLogColumns findColumnByColumnTitle(String str) {
        return TransferLogColumns.findByColumnTitle(str);
    }

    TransferLogColumns[] getDefaultColumns() {
        return DEFAULT_COLUMNS;
    }

    public List<TreeViewerColumn> getDisplayedColumns() {
        return this.displayedColumns;
    }

    public List<TreeViewerColumn> getAvailableColumns() {
        return this.availableColumns;
    }

    public void setDisplayedColumns(List<TreeViewerColumn> columns) {
        Tree tree = this.tv.getTree();
        GC g = new GC((Drawable)tree);
        g.setFont(tree.getFont());
        for (TreeViewerColumn tvc : this.availableColumns) {
            TreeColumn c = tvc.getColumn();
            if (columns.contains(tvc)) {
                this.columnVisibility.put(c, Boolean.TRUE);
                c.setWidth(g.stringExtent((String)c.getText()).x + 25);
                continue;
            }
            this.columnVisibility.put(c, Boolean.FALSE);
            c.setWidth(0);
        }
        this.displayedColumns.clear();
        this.displayedColumns.add(this.emptyTVC);
        this.displayedColumns.addAll(columns);
        this.saveDefaultColumns();
        g.dispose();
        this.refresh();
    }

    public TransferLogPage(Composite parent, int style) {
        block5: {
            block4: {
                super(parent, style);
                this.displayedColumns = new LinkedList<TreeViewerColumn>();
                this.availableColumns = new LinkedList<TreeViewerColumn>();
                this.columnVisibility = new HashMap<TreeColumn, Boolean>();
                this.transferLogMax = ExplorerPlugin.getTransferLogMax();
                this.transferLogPrefsListener = new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        if ("com.ibm.wmqfte.explorer.timezone".equals(event.getProperty())) {
                            Object val = event.getNewValue();
                            if (val instanceof String) {
                                String oldTz = String.valueOf(df.getTimeZone().getID()) + ')';
                                String newTz = (String)event.getNewValue();
                                for (TreeViewerColumn c : TransferLogPage.this.availableColumns) {
                                    String t = c.getColumn().getText();
                                    if (t == null || !t.endsWith(oldTz)) continue;
                                    c.getColumn().setText(t.replace(oldTz, String.valueOf(newTz) + ')'));
                                }
                                df.setTimeZone(TimeZone.getTimeZone(newTz));
                                TransferLogPage.this.tv.refresh();
                                Tree tree = TransferLogPage.this.tv.getTree();
                                if (!tree.isDisposed()) {
                                    TransferLogPage.this.setupTree(tree);
                                }
                            }
                        } else if ("com.ibm.wmqfte.explorer.transferlog.max".equals(event.getProperty())) {
                            Object val = event.getNewValue();
                            if (val instanceof Integer) {
                                TransferLogPage.this.transferLogMax = (Integer)val;
                                TransferLogPage.this.checkMaxLogs();
                            }
                        } else if ("com.ibm.wmqfte.explorer.transferlog.subscription.type".equals(event.getProperty()) && !event.getOldValue().equals(event.getNewValue()) && MFTETreeNodeFactory.getConnectedCoordQmgr() != null) {
                            MFTETreeNodeFactory.getConnectedCoordQmgr().connect();
                        }
                    }
                };
                this.cal = Calendar.getInstance();
                this.lastRefreshCompletedTime = 0L;
                this.refreshRequestQueuedCount = 0;
                this.refreshRequestLock = new Object();
                try {
                    xPathType = xPath.compile("name(/*)");
                    xPathVersion = xPath.compile("/*/@version");
                    xPathID = xPath.compile("/*/@ID");
                    xPathAgentRole = xPath.compile("/*/@agentRole");
                    xPathSrcAgent = xPath.compile("//attribute::agent[ancestor::agent or ancestor::sourceAgent]");
                    xPathSrcAgentType = xPath.compile("//attribute::agentType[ancestor::agent or ancestor::sourceAgent]");
                    xPathSrcAgentCDBridgeNode = xPath.compile("//attribute::bridgeNode[ancestor::agent or ancestor::sourceAgent]");
                    xPathSrcAgentCDPNode = xPath.compile("//attribute::pnode[ancestor::agent or ancestor::sourceAgent]");
                    xPathSrcAgentCDSNode = xPath.compile("//attribute::snode[ancestor::agent or ancestor::sourceAgent]");
                    xPathSrcWebGateway = xPath.compile("//attribute::webGatewayName[ancestor::sourceWebGateway or ancestor::sourceWebUser]");
                    xPathSrcBridgeURL = xPath.compile("//attribute::bridgeURL[ancestor::agent or ancestor::sourceAgent]");
                    xPathSrcAgentQmgr = xPath.compile("//attribute::QMgr[ancestor::agent or ancestor::sourceAgent]");
                    xPathDestAgent = xPath.compile("/*/destinationAgent/@agent");
                    xPathDestAgentType = xPath.compile("//attribute::agentType[ancestor::agent or ancestor::destinationAgent]");
                    xPathDestAgentCDBridgeNode = xPath.compile("//attribute::bridgeNode[ancestor::agent or ancestor::destinationAgent]");
                    xPathDestAgentCDPNode = xPath.compile("//attribute::pnode[ancestor::agent or ancestor::destinationAgent]");
                    xPathDestAgentCDSNode = xPath.compile("//attribute::snode[ancestor::agent or ancestor::destinationAgent]");
                    xPathDestWebGateway = xPath.compile("//attribute::webGatewayName[ancestor::destinationWebGateway or ancestor::destinationWebUser]");
                    xPathDestWebGatewayAgent = xPath.compile("/*/destinationWebGateway/@webGatewayAgentName");
                    xPathDestBridgeURL = xPath.compile("//attribute::bridgeURL[ancestor::agent or ancestor::destinationAgent]");
                    xPathDestAgentQmgr = xPath.compile("/*/destinationAgent/@QMgr");
                    xPathActionTime = xPath.compile("/*/action/@time");
                    xPathAction = xPath.compile("/*/action");
                    xPathUserID = xPath.compile("/*/originator/userID");
                    xPathUserHost = xPath.compile("/*/originator/hostName");
                    xPathRC = xPath.compile("/*/status/@resultCode");
                    xPathStartTime = xPath.compile("/*/transferSet/@startTime");
                    xPathTotal = xPath.compile("/*/transferSet/@total");
                    xPathJob = xPath.compile("/*/job/name");
                }
                catch (XPathExpressionException e) {
                    if (!Trace.isTracing) break block4;
                    Trace.data((Level)Level.WARNING, (String)"TransferLogPage", (String)"TransferLogPage", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                }
            }
            try {
                this.db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                if (!Trace.isTracing) break block5;
                Trace.data((Level)Level.WARNING, (String)"TransferLogPage", (String)"TransferLogPage", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
            }
        }
    }

    public String getId() {
        return "com.ibm.wmqfte.explorer.transferlog";
    }

    private void addColumn(String title, ColumnLabelProvider l, ViewerSorter vs, boolean display) {
        TreeViewerColumn tvc = new TreeViewerColumn(this.tv, 16384);
        tvc.setLabelProvider((CellLabelProvider)l);
        final TreeColumn c = tvc.getColumn();
        c.setMoveable(true);
        c.setResizable(false);
        c.setText(title);
        this.availableColumns.add(tvc);
        if (display) {
            this.columnVisibility.put(c, Boolean.TRUE);
            this.displayedColumns.add(tvc);
        } else {
            this.columnVisibility.put(c, Boolean.FALSE);
            c.setWidth(0);
        }
        if (vs != null && vs instanceof TransferLogSorterPage) {
            final TransferLogSorterPage tlSorter = (TransferLogSorterPage)vs;
            c.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    tlSorter.setColumn(TransferLogPage.this.tv, c);
                    TransferLogPage.this.refresh();
                }
            });
        }
    }

    public void init() {
        this.setVisible(false);
        final Shell shell = this.getShell();
        final Display display = this.getDisplay();
        final Composite parent = this.getParent();
        int numColumns = 1;
        this.setLayout((Layout)new GridLayout(numColumns, true));
        ContentTitleBar contentTitleBar = new ContentTitleBar((Composite)this, 0);
        contentTitleBar.setText(Elements.UI_CONTENT_TRANSFER_LOG_TITLE);
        GridData titleBarData = new GridData(768);
        titleBarData.horizontalSpan = numColumns;
        contentTitleBar.setLayoutData((Object)titleBarData);
        Label label = new Label((Composite)this, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = numColumns;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = numColumns;
        gridData.heightHint = 5;
        label.setLayoutData((Object)gridData);
        this.tv = new TreeViewer((Composite)this, 68354);
        this.tv.setContentProvider((IContentProvider)new TransferLogContentProvider());
        this.emptyTVC = new TreeViewerColumn(this.tv, 16384);
        this.emptyTVC.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return null;
            }

            public Color getBackground(Object element) {
                return TransferLogPage.getBackground(element);
            }
        });
        TreeColumn empty = this.emptyTVC.getColumn();
        empty.setText("");
        empty.setWidth(0);
        empty.setMoveable(false);
        empty.setResizable(false);
        this.columnVisibility.put(empty, Boolean.TRUE);
        this.displayedColumns.add(this.emptyTVC);
        this.addDefaultColumns();
        this.tv.setInput(logs);
        this.tv.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                this.updateTree();
            }

            public void treeExpanded(TreeExpansionEvent event) {
                this.updateTree();
            }

            private void updateTree() {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Tree tree = TransferLogPage.this.tv.getTree();
                        if (!tree.isDisposed()) {
                            TransferLogPage.this.setupTree(tree);
                        }
                    }
                });
            }
        });
        Tree tree = this.tv.getTree();
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setupTree(tree);
        Label label2 = new Label((Composite)this, 258);
        label2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, numColumns, 1));
        final TransferLogFilter filter = new TransferLogFilter();
        this.tv.addFilter((ViewerFilter)filter);
        Label filterLabel = new Label((Composite)this, 0);
        filterLabel.setText(Elements.UI_CONTENT_AUDIT_FILTER_LABEL);
        final Text filterText = new Text((Composite)this, 2052);
        filterText.setText("*");
        filter.setFilter(filterText.getText());
        filterText.setLayoutData((Object)new GridData(4, -1, true, false));
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                filter.setFilter(filterText.getText());
                TransferLogPage.this.tv.refresh();
                Tree tree = TransferLogPage.this.tv.getTree();
                if (!tree.isDisposed()) {
                    TransferLogPage.this.setupTree(tree);
                }
            }
        });
        this.addContextMenu(this.tv);
        this.addDoubleClickListener(this.tv);
        this.setVisible(true);
        this.pollingThread = new Thread("TransferLogPage"){

            @Override
            public void run() {
                while (!shell.isDisposed()) {
                    if (parent.isDisposed() || parent.getDisplay().isDisposed()) {
                        return;
                    }
                    TransferLogPage.this.requestRefresh(false);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.pollingThread.start();
        this.clearCompleted = new Action(){

            public void run() {
                ArrayList temp = new ArrayList(logs.values());
                for (TransferLog log : temp) {
                    if (!log.isCompleted() || FTEReply.ReplyResultCode.SUCCESSFUL.getValue() != log.getReturnCode()) continue;
                    logs.remove(log.getId());
                }
                if (temp.size() > 0 && !parent.getDisplay().isDisposed()) {
                    parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TransferLogPage.this.tv.refresh();
                            Tree tree = TransferLogPage.this.tv.getTree();
                            if (!tree.isDisposed()) {
                                TransferLogPage.this.setupTree(tree);
                            }
                        }
                    });
                }
            }
        };
        this.clearCompleted.setText(Elements.UI_CONTENT_REMOVE_COMPLETE_BUTTON);
        this.clearCompleted.setToolTipText(Elements.UI_CONTENT_REMOVE_COMPLETE_BUTTON);
        this.clearCompleted.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.debug.ui", (String)"$nl$/icons/full/elcl16/rem_all_co.gif"));
        this.clearCompleted.setId("CLEAR_COMPLETED_ACTION");
        this.collapseAll = new Action(){

            public void run() {
                TransferLogPage.this.tv.collapseAll();
            }
        };
        this.collapseAll.setText(Elements.UI_CONTENT_COLLAPSE_ALL_BUTTON);
        this.collapseAll.setToolTipText(Elements.UI_CONTENT_COLLAPSE_ALL_BUTTON);
        this.collapseAll.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/elcl16/collapseall.gif"));
        this.collapseAll.setId("COLLAPSE_ALL_ACTION");
        this.configureColumns = new ConfigureColumnsAction(this);
        ExplorerPlugin.setHelp((Control)this, "com.ibm.wmqfte.explorer.context.UI_TransferLogHelp");
        ExplorerPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.transferLogPrefsListener);
        TreeColumn[] treeColumnArray = this.tv.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn c = treeColumnArray[n2];
            c.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                    TransferLogPage.this.saveDefaultColumns();
                }

                public void controlResized(ControlEvent e) {
                }
            });
            ++n2;
        }
        this.saveDefaultColumns();
    }

    public void dispose() {
        ExplorerPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.transferLogPrefsListener);
        super.dispose();
    }

    private void addContextMenu(final TreeViewer treeViewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TransferLogPage.this.fillContextMenu(treeViewer, manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(menu);
    }

    private void fillContextMenu(TreeViewer treeViewer, IMenuManager manager) {
        boolean hasSelection;
        final List selectionList = ((IStructuredSelection)this.tv.getSelection()).toList();
        boolean bl = hasSelection = this.tv.getSelection() instanceof IStructuredSelection && selectionList.size() > 0;
        if (hasSelection) {
            Action cancel = new Action(){

                public void run() {
                    ISelection s = TransferLogPage.this.tv.getSelection();
                    if (s instanceof IStructuredSelection) {
                        for (Object o : ((IStructuredSelection)s).toList()) {
                            if (!(o instanceof TransferLog)) continue;
                            TransferLog t = (TransferLog)o;
                            if ("completed".equals(t.getState())) {
                                MessageDialog.openError((Shell)TransferLogPage.this.tv.getControl().getShell(), (String)Elements.UI_WIZARD_TRANSFER_CANCEL_TITLE, (String)Messages.BFGUI0002_CANCEL_ALREADY_COMPLETE_TRANSFER);
                                continue;
                            }
                            WMQConnectionData conn = Subscription.getCmdConnectionData();
                            try {
                                String cancelAgentName = t.getSrcAgentName();
                                String cancelAgentQmgr = t.getSrcAgentQmgr();
                                if (cancelAgentName == null || cancelAgentName.length() == 0 || cancelAgentQmgr == null || cancelAgentQmgr.length() == 0) {
                                    cancelAgentName = t.getDestAgentName();
                                    cancelAgentQmgr = t.getDestAgentQmgr();
                                }
                                CancelTransfer.cancelTransfer((String)cancelAgentName, (String)cancelAgentQmgr, (WMQConnectionData)conn, (String)Subscription.getDynamicQueuePrefix(), (String)Subscription.getModelQueueName(), (String)AbstractCommand.getHostName(), (String)AbstractCommand.getUserId(), (String)t.getId());
                            }
                            catch (Exception e) {
                                MessageDialog.openError((Shell)TransferLogPage.this.tv.getControl().getShell(), (String)Elements.UI_WIZARD_TRANSFER_CANCEL_TITLE, (String)e.getLocalizedMessage());
                            }
                        }
                    }
                }
            };
            cancel.setText(Elements.UI_WIZARD_TRANSFER_CANCEL_TITLE);
            Action delete = new Action(){

                public void run() {
                    ISelection s = TransferLogPage.this.tv.getSelection();
                    if (s instanceof IStructuredSelection) {
                        for (Object o : ((IStructuredSelection)s).toList()) {
                            if (!(o instanceof TransferLog)) continue;
                            TransferLog t = (TransferLog)o;
                            logs.remove(t.getId());
                        }
                        TransferLogPage.this.tv.refresh();
                    }
                }
            };
            delete.setText(Elements.UI_CONTENT_TRANSFER_TEMPLATES_DELETE_BUTTON);
            Action copyID = new Action(){

                public void run() {
                    Object o;
                    ISelection s = TransferLogPage.this.tv.getSelection();
                    if (s instanceof IStructuredSelection && (o = selectionList.get(0)) instanceof TransferLog) {
                        TransferLog t = (TransferLog)o;
                        Clipboard clipboard = new Clipboard(TransferLogPage.this.tv.getControl().getDisplay());
                        clipboard.setContents((Object[])new String[]{t.getId()}, new Transfer[]{TextTransfer.getInstance()});
                        clipboard.dispose();
                    }
                }
            };
            copyID.setText(Elements.UI_CONTENT_TRANSFER_LOG_COPY_ID_BUTTON);
            boolean enabled = false;
            for (Object o : selectionList) {
                if (!(o instanceof TransferLog)) continue;
                enabled = true;
                break;
            }
            cancel.setEnabled(enabled);
            delete.setEnabled(enabled);
            PropertyDialogAction propertyDialog = new PropertyDialogAction((IShellProvider)this, (ISelectionProvider)this.tv);
            propertyDialog.setEnabled(false);
            copyID.setEnabled(false);
            if (selectionList.size() == 1) {
                Object o = selectionList.get(0);
                propertyDialog.setEnabled(o instanceof TransferLog || o instanceof Call);
                copyID.setEnabled(o instanceof TransferLog || o instanceof Call);
            }
            for (Object o : selectionList) {
                String s;
                if (!(o instanceof TransferLog) || !"completed".equals(s = ((TransferLog)o).getState()) && !"cancelled".equals(s)) continue;
                cancel.setEnabled(false);
                break;
            }
            manager.add((IAction)cancel);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)delete);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)copyID);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)propertyDialog);
        }
    }

    private void addDoubleClickListener(final TreeViewer tv) {
        tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o;
                ISelection s = tv.getSelection();
                if (s instanceof IStructuredSelection && ((o = ((IStructuredSelection)s).getFirstElement()) instanceof TransferLog || o instanceof Call)) {
                    PropertyDialogAction propertyDialog = new PropertyDialogAction((IShellProvider)new SameShellProvider(tv.getControl()), (ISelectionProvider)tv);
                    propertyDialog.run();
                }
            }
        });
    }

    private void addDefaultColumns() {
        ColumnTitleEnumeration[] displayColumns = this.loadDefaultColumns();
        ArrayList<String> displayColumnsAsString = new ArrayList<String>();
        ColumnTitleEnumeration[] columnTitleEnumerationArray = displayColumns;
        int n = displayColumns.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnTitleEnumeration col = columnTitleEnumerationArray[n2];
            ColumnLabelProvider provider = ps.getProvider(col.getColumnTitle());
            ViewerSorter sorter = ps.getSorter(col.getColumnTitle());
            if (provider != null && sorter != null) {
                this.addColumn(ps.adjustColumnName(col.getColumnTitle()), provider, sorter, true);
                displayColumnsAsString.add(col.getColumnTitle());
            }
            ++n2;
        }
        List<String> nonDisplayColumns = ps.missingList(displayColumnsAsString);
        for (String item : nonDisplayColumns) {
            ColumnLabelProvider provider = ps.getProvider(item);
            ViewerSorter sorter = ps.getSorter(item);
            if (provider == null || sorter == null) continue;
            this.addColumn(ps.adjustColumnName(item), provider, sorter, false);
        }
    }

    private ColumnTitleEnumeration[] loadDefaultColumns() {
        String[] savedColumnOrder = PageUtils.loadDefaultColumns(TRANSFER_LOG_SETTINGS, DEFAULT_COLUMNS_AS_STRING);
        return this.convertColumns(savedColumnOrder);
    }

    private void saveDefaultColumns() {
        PageUtils.saveDefaultColumns(TRANSFER_LOG_SETTINGS, this, (Viewer)this.tv);
    }

    public void setActive(boolean isActive) {
        super.setActive(isActive);
        IActionBars bars = this.getViewPart().getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        if (isActive) {
            manager.insertAfter("com.ibm.mq.explorer.content.toolbar.action", (IAction)this.collapseAll);
            manager.insertAfter(this.collapseAll.getId(), (IAction)this.clearCompleted);
            manager.insertAfter(this.clearCompleted.getId(), (IAction)this.configureColumns);
        } else {
            manager.remove(this.collapseAll.getId());
            manager.remove(this.clearCompleted.getId());
            manager.remove(this.configureColumns.getId());
        }
        manager.update(true);
        bars.updateActionBars();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable observable, Object data) {
        if (data instanceof AgentStatusDetails) {
            AgentStatusDetails agent = (AgentStatusDetails)data;
            String states = String.valueOf(agent.getSourceTransferStates()) + " " + agent.getDestinationTransferStates();
            if (states.trim().length() == 0) {
                return;
            }
            FTETransferStatusInfo info = new FTETransferStatusInfo(states);
            Map stateMap = info.getTransferStates();
            TransferLogPage transferLogPage = this;
            synchronized (transferLogPage) {
                Calendar statusCal = agent.getPublishedTime();
                if (statusCal == null) {
                    this.cal.setTimeInMillis(System.currentTimeMillis());
                }
                Date statusTime = statusCal == null ? this.cal.getTime() : statusCal.getTime();
                for (Map.Entry e : stateMap.entrySet()) {
                    TransferLog log = logs.get(e.getKey());
                    if (log == null || !TransferLogStateUtils.updateTransferLogStateIfValidStateChange(log, (FTEStateType)e.getValue())) continue;
                    log.setAuditTime(statusTime);
                    logs.put((String)e.getKey(), log);
                }
                this.checkMaxLogs();
            }
            this.requestRefresh(false);
        }
        if (data instanceof String) {
            TransferLogPage transferLogPage = this;
            synchronized (transferLogPage) {
                block17: {
                    try {
                        String xml = (String)data;
                        InputSource is = new InputSource(new StringReader(xml));
                        Document doc = this.db.parse(is);
                        String type = xPathType.evaluate(doc);
                        if (type == null || type.length() == 0) {
                            return;
                        }
                        String ppXML = PageUtils.printXML(doc);
                        Trace.data((Level)Level.FINEST, (String)"TransferLogPage", (String)"update", (String)ppXML, (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                        if ("transaction".equals(type)) {
                            this.parseTransactionXML(doc, ppXML);
                        } else if ("malformed".equals(type)) {
                            this.parseMalformedXML(doc, ppXML);
                        }
                        this.checkMaxLogs();
                        this.requestRefresh(false);
                        TransferProgressView.refreshView(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        if (!Trace.isTracing) break block17;
                        Trace.data((Level)Level.WARNING, (String)"TransferLogPage", (String)"update", (String)e.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
                    }
                }
            }
        }
    }

    private void parseTransactionXML(Document doc, String ppXML) throws XPathExpressionException, ParseException {
        NodeList items;
        TransferLog transferLog;
        String bridgeNode;
        String dest;
        AgentType destAgentType;
        String src;
        AgentType srcAgentType;
        if (xPathID.evaluate(doc) == null || xPathID.evaluate(doc).length() == 0) {
            return;
        }
        String version = xPathVersion.evaluate(doc);
        String id = xPathID.evaluate(doc);
        String role = xPathAgentRole.evaluate(doc);
        String srcAgent = xPathSrcAgent.evaluate(doc);
        String srcWebGatewayAgent = xPathSrcWebGateway.evaluate(doc);
        String srcBridgeAgent = xPathSrcBridgeURL.evaluate(doc);
        String srcAgentTypeVal = xPathSrcAgentType.evaluate(doc);
        if (srcBridgeAgent != null && srcBridgeAgent.length() > 0) {
            srcAgentType = AgentType.BRIDGE;
            src = srcAgent;
        } else if (srcWebGatewayAgent != null && srcWebGatewayAgent.length() > 0) {
            srcAgentType = AgentType.WEB_GATEWAY;
            src = srcWebGatewayAgent;
        } else if (srcAgentTypeVal != null && AgentType.CD_BRIDGE.toString().equals(srcAgentTypeVal)) {
            srcAgentType = AgentType.CD_BRIDGE;
            src = srcAgent;
        } else {
            srcAgentType = AgentType.STANDARD;
            src = srcAgent;
        }
        String srcQmgr = xPathSrcAgentQmgr.evaluate(doc);
        String destAgent = xPathDestAgent.evaluate(doc);
        String destWebGateway = xPathDestWebGateway.evaluate(doc);
        String destWebGatewayAgent = xPathDestWebGatewayAgent.evaluate(doc);
        String destBridgeAgent = xPathDestBridgeURL.evaluate(doc);
        String destAgentTypeVal = xPathDestAgentType.evaluate(doc);
        if (destBridgeAgent != null && destBridgeAgent.length() > 0) {
            destAgentType = AgentType.BRIDGE;
            dest = destAgent;
        } else if (destWebGateway != null && destWebGateway.length() > 0) {
            destAgentType = AgentType.WEB_GATEWAY;
            dest = destWebGateway;
        } else if (destWebGatewayAgent != null && destWebGatewayAgent.length() > 0) {
            destAgentType = AgentType.WEB_GATEWAY;
            dest = destWebGatewayAgent;
        } else if (destAgentTypeVal != null && AgentType.CD_BRIDGE.toString().equals(destAgentTypeVal)) {
            destAgentType = AgentType.CD_BRIDGE;
            dest = destAgent;
        } else {
            destAgentType = AgentType.STANDARD;
            dest = destAgent;
        }
        String destQmgr = xPathDestAgentQmgr.evaluate(doc);
        String auditTimeStr = xPathActionTime.evaluate(doc).replace("Z", "+0000");
        Date auditTime = iso8601nano.parse(auditTimeStr);
        String state = xPathAction.evaluate(doc);
        String originator = String.valueOf(xPathUserID.evaluate(doc)) + " @ " + xPathUserHost.evaluate(doc);
        String startTimeStr = xPathStartTime.evaluate(doc).replace("Z", "+0000");
        Date startTime = iso8601nano.parse(startTimeStr);
        String totalStr = xPathTotal.evaluate(doc);
        int total = Integer.parseInt(totalStr);
        String cdPNode = null;
        String cdSNode = null;
        boolean bridgeIsPNODE = false;
        if (AgentType.CD_BRIDGE.equals((Object)srcAgentType)) {
            cdPNode = xPathSrcAgentCDPNode.evaluate(doc);
            cdSNode = xPathSrcAgentCDSNode.evaluate(doc);
            if (cdPNode != null && cdSNode != null) {
                bridgeNode = xPathSrcAgentCDBridgeNode.evaluate(doc);
                bridgeIsPNODE = cdPNode.equals(bridgeNode);
            }
        } else if (AgentType.CD_BRIDGE.equals((Object)destAgentType)) {
            cdPNode = xPathDestAgentCDPNode.evaluate(doc);
            cdSNode = xPathDestAgentCDSNode.evaluate(doc);
            if (cdPNode != null && cdSNode != null) {
                bridgeNode = xPathDestAgentCDBridgeNode.evaluate(doc);
                bridgeIsPNODE = cdPNode.equals(bridgeNode);
            }
        }
        if ((transferLog = logs.get(id)) == null) {
            transferLog = new TransferLog(version, id, role, src, srcAgent, srcAgentType, srcQmgr, dest, destAgent, destAgentType, destQmgr, startTime, auditTime, state, originator, total, cdPNode, cdSNode, bridgeIsPNODE);
            String jobName = xPathJob.evaluate(doc);
            if (jobName != null) {
                transferLog.setJobName(jobName);
            }
        } else {
            if (TransferLogStateUtils.updateTransferLogStateIfValidStateChange(transferLog, state, true)) {
                transferLog.setAuditTime(auditTime);
            }
            if (destAgentType == AgentType.WEB_GATEWAY) {
                transferLog.setDest(dest);
            }
            transferLog.setDestAgentType(destAgentType);
            transferLog.setCDPNode(cdPNode);
            transferLog.setCDSNode(cdSNode);
            transferLog.setBridgeIsPNODE(bridgeIsPNODE);
        }
        if (("progress".equals(state) || "deleted".equals(state)) && (items = (NodeList)xPath.compile("/*/transferSet/item[*]").evaluate(doc, XPathConstants.NODESET)).getLength() > 0) {
            int failures = 0;
            int warnings = 0;
            int i = 0;
            while (i < items.getLength()) {
                TransferLog.FTEAuditAgentFileNamePairImpl fp = new TransferLog.FTEAuditAgentFileNamePairImpl();
                try {
                    fp.fromXMLImpl(items.item(i));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                fp.setSrcAgentType(srcAgentType);
                fp.setDestAgentType(destAgentType);
                if ("deleted".equals(state)) {
                    fp.setDestAgent(null);
                    fp.setDestName(String.valueOf(fp.getDestName()) + " (" + Elements.UI_STATUS_AGENT_DELETED.toLowerCase() + ")");
                }
                transferLog.addFileNamePair(fp);
                FTEAuditStatus status = fp.getStatus();
                if (status == null || status.getResultCode() == FTEAuditFileResultCode.Failed.getValue() || status.getResultCode() >= 40) {
                    ++failures;
                } else if (status.getResultCode() == FTEAuditFileResultCode.Warning.getValue() || status.getResultCode() >= 20) {
                    ++warnings;
                }
                ++i;
            }
            TransferLog.Status currentFileStatus = transferLog.getFileStatus();
            if (failures >= items.getLength() && (currentFileStatus == TransferLog.Status.UNKNOWN || currentFileStatus == TransferLog.Status.FAILURE)) {
                transferLog.setFilesStatus(TransferLog.Status.FAILURE);
            } else if (failures > 0 || warnings > 0 || currentFileStatus == TransferLog.Status.PARTIAL) {
                transferLog.setFilesStatus(TransferLog.Status.PARTIAL);
            } else {
                transferLog.setFilesStatus(TransferLog.Status.SUCCESS);
            }
        }
        if ("completed".equals(state)) {
            String rcStr = xPathRC.evaluate(doc);
            if (rcStr != null && rcStr.length() > 0) {
                int rc = Integer.valueOf(rcStr);
                transferLog.setReturnCode(rc);
                if (rc >= 40) {
                    transferLog.setFilesStatus(TransferLog.Status.FAILURE);
                } else if (rc >= 20) {
                    transferLog.setFilesStatus(TransferLog.Status.PARTIAL);
                } else if (rc == 0) {
                    transferLog.setFilesStatus(TransferLog.Status.SUCCESS);
                }
                NodeList items2 = (NodeList)xPath.compile("/*/status/supplement").evaluate(doc, XPathConstants.NODESET);
                int i = 0;
                while (i < items2.getLength()) {
                    Node supplement = items2.item(i);
                    transferLog.addSupplement(supplement.getTextContent());
                    ++i;
                }
            }
            NodeList metadata = (NodeList)xPath.compile("/*/transferSet/metaDataSet/node()").evaluate(doc, XPathConstants.NODESET);
            int i = 0;
            while (i < metadata.getLength()) {
                NamedNodeMap attr;
                Node md = metadata.item(i);
                if (md.getNodeType() == 1 && (attr = md.getAttributes()) != null && attr.getNamedItem("key") != null) {
                    transferLog.addMetaData(attr.getNamedItem("key").getNodeValue(), md.getTextContent());
                }
                ++i;
            }
            NodeList tsChildren = (NodeList)xPath.compile("/*/transferSet/*/callResult/ancestor::*[1]").evaluate(doc, XPathConstants.NODESET);
            int i2 = 0;
            while (i2 < tsChildren.getLength()) {
                Node tsChild = tsChildren.item(i2);
                transferLog.addCall(tsChild.getNodeName(), tsChild);
                ++i2;
            }
        }
        if ("cancelled".equals(state)) {
            items = (NodeList)xPath.compile("//*/supplement").evaluate(doc, XPathConstants.NODESET);
            int i = 0;
            while (i < items.getLength()) {
                Node supplement = items.item(i);
                transferLog.addSupplement(supplement.getTextContent());
                ++i;
            }
        }
        transferLog.addXML(auditTime, "# " + TransferLogStateUtils.getStateLocalised(state, transferLog).toUpperCase() + "\n\n" + ppXML + "\n\n----\n\n");
        logs.put(id, transferLog);
        if (Trace.isTracing) {
            Trace.data((Level)Level.FINEST, (String)"TransferLogPage", (String)"parseTransactionXML", (String)logs.toString(), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
        }
    }

    private void parseMalformedXML(Document doc, String ppXML) throws XPathExpressionException, ParseException {
        String rcStr;
        if (xPathID.evaluate(doc) == null || xPathID.evaluate(doc).length() == 0) {
            return;
        }
        String version = xPathVersion.evaluate(doc);
        String id = xPathID.evaluate(doc);
        String role = xPathAgentRole.evaluate(doc);
        String src = xPathSrcAgent.evaluate(doc);
        String srcQmgr = xPathSrcAgentQmgr.evaluate(doc);
        String auditTimeStr = xPathActionTime.evaluate(doc).replace("Z", "+0000");
        Date auditTime = iso8601nano.parse(auditTimeStr);
        String state = xPathAction.evaluate(doc);
        Date startTime = auditTime;
        TransferLog transferLog = logs.get(id);
        if (transferLog == null) {
            transferLog = new TransferLog(version, id, role, src, src, null, srcQmgr, "", "", null, "", startTime, auditTime, state, "", 0, null, null, false);
        } else {
            transferLog.setAuditTime(auditTime);
            transferLog.setState(state);
        }
        if ("malformed".equals(state) && (rcStr = xPathRC.evaluate(doc)) != null && rcStr.length() > 0) {
            int rc = Integer.valueOf(rcStr);
            transferLog.setReturnCode(rc);
            if (rc > 0) {
                NodeList items = (NodeList)xPath.compile("/*/status/supplement").evaluate(doc, XPathConstants.NODESET);
                int i = 0;
                while (i < items.getLength()) {
                    Node supplement = items.item(i);
                    transferLog.addSupplement(supplement.getTextContent());
                    ++i;
                }
            }
        }
        transferLog.addXML(auditTime, "# " + TransferLogStateUtils.getStateLocalised(state, transferLog).toUpperCase() + "\n\n" + ppXML + "\n\n----\n\n");
        logs.put(id, transferLog);
    }

    private void checkMaxLogs() {
        int s = logs.size();
        if (s > this.transferLogMax) {
            String[] keySet = logs.keySet().toArray(new String[0]);
            int i = 0;
            while (i < s - this.transferLogMax) {
                logs.remove(keySet[i]);
                ++i;
            }
        }
    }

    public static Color getBackground(Object element) {
        if (element instanceof TransferLog) {
            TransferLog log = (TransferLog)element;
            TransferLog.Status fileStatus = log.getFileStatus();
            if (log.getReturnCode() >= 40 || fileStatus == TransferLog.Status.FAILURE) {
                return PageUtils.getListBackgroundColor(3);
            }
            if (log.getReturnCode() >= 20 || fileStatus == TransferLog.Status.PARTIAL || log.isRecovering()) {
                return PageUtils.getListBackgroundColor(7);
            }
            return PageUtils.getListBackgroundColor(5);
        }
        if (element instanceof FTEAuditFileNamePair) {
            FTEAuditStatus status = ((FTEAuditFileNamePair)element).getStatus();
            if (status == null || status.getResultCode() == FTEAuditFileResultCode.Failed.getValue() || status.getResultCode() >= 40) {
                return PageUtils.getListBackgroundColor(3);
            }
            if (status.getResultCode() == FTEAuditFileResultCode.Warning.getValue() || status.getResultCode() >= 20) {
                return PageUtils.getListBackgroundColor(7);
            }
            return PageUtils.getListBackgroundColor(5);
        }
        if (element instanceof Call) {
            String callOutcome = ((Call)element).getOutcome();
            if (callOutcome == null || "failure".equals(callOutcome) || "error".equals(callOutcome)) {
                return PageUtils.getListBackgroundColor(3);
            }
            return PageUtils.getListBackgroundColor(5);
        }
        return null;
    }

    private void setupTree(Tree tree) {
        GC g = new GC((Drawable)tree);
        g.setFont(tree.getFont());
        Object data = tree.getData();
        if (data instanceof Map) {
            int columnCount = tree.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                TreeColumn column = tree.getColumn(i);
                if (this.columnVisibility.get(column).booleanValue() && (column.getWidth() == 0 || !column.getResizable())) {
                    int longestWidth = g.stringExtent((String)column.getText()).x;
                    int j = 0;
                    while (j < tree.getItemCount()) {
                        TreeItem treeItem = tree.getItem(j);
                        int width = PageUtils.getWidth(treeItem, g, i);
                        if (width > longestWidth) {
                            longestWidth = width;
                        }
                        if (treeItem.getExpanded()) {
                            TreeItem[] treeItemArray = treeItem.getItems();
                            int n = treeItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TreeItem child = treeItemArray[n2];
                                width = PageUtils.getWidth(child, g, i) + 25;
                                if (width > longestWidth) {
                                    longestWidth = width;
                                }
                                ++n2;
                            }
                        }
                        ++j;
                    }
                    column.setWidth(longestWidth + 25);
                    if (column.equals(tree.getSortColumn())) {
                        column.setWidth(column.getWidth() + 25);
                    }
                } else {
                    column.setWidth(0);
                }
                ++i;
            }
        }
        g.dispose();
    }

    /*
     * Exception decompiling
     */
    public void loadPreviousAuditLogs() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void saveCurrentAuditLogs() {
        CoordTreeNode connectedCoordQmgr = MFTETreeNodeFactory.getConnectedCoordQmgr();
        if (logs == null || connectedCoordQmgr == null) {
            return;
        }
        try {
            String filename;
            if (connectedCoordQmgr.getConfiguration() == null) {
                FTEPropertyStore p = Subscription.getPropertyFiles();
                FTEPropertySet propertySet = p.getPropertySet(connectedCoordQmgr.getName());
                filename = String.valueOf(propertySet.getPath()) + File.separatorChar + TRANSFERLOG_BIN;
            } else {
                filename = new File(ExplorerPlugin.getDefault().getStateLocationFile(), String.valueOf(connectedCoordQmgr.getName()) + '-' + TRANSFERLOG_BIN).getAbsolutePath();
            }
            if (logs.isEmpty()) {
                new File(filename).delete();
            } else {
                FileOutputStream fos = null;
                ObjectOutputStream oos = null;
                try {
                    fos = new FileOutputStream(filename);
                    oos = new ObjectOutputStream(fos);
                    oos.writeObject(logs);
                    oos.close();
                    fos.close();
                    logs.clear();
                    this.refresh();
                }
                catch (IOException io) {
                    io.printStackTrace(System.err);
                }
            }
        }
        catch (ConfigurationException e) {
            e.printStackTrace(System.err);
        }
        catch (ParameterException e) {
            e.printStackTrace(System.err);
        }
    }

    public static String getLogStateLocalised(String id) {
        String state;
        TransferLog log = logs.get(id);
        String string = state = log == null ? "" : log.getState();
        if (log != null && TransferLogStateUtils.isFinalisedState(state)) {
            return log.getStateLocalised();
        }
        return null;
    }

    public static boolean isFinalisedId(String id) {
        String state;
        TransferLog log = logs.get(id);
        String string = state = log == null ? null : log.getState();
        return state != null && TransferLogStateUtils.isFinalisedState(state);
    }

    public void instanceDeleted(Object object) {
    }

    public boolean isEnableRefreshAction() {
        return true;
    }

    public boolean isEnableSystemObjectsAction() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (!this.isDisposed() && this.getDisplay() != null && !this.getDisplay().isDisposed()) {
            Object object = this.refreshRequestLock;
            synchronized (object) {
                ++this.refreshRequestQueuedCount;
            }
            this.getDisplay().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (TransferLogPage.this.tv != null && !TransferLogPage.this.tv.getControl().isDisposed()) {
                            TransferLogPage.this.tv.refresh();
                            Tree tree = TransferLogPage.this.tv.getTree();
                            if (!tree.isDisposed()) {
                                TransferLogPage.this.setupTree(tree);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object object = TransferLogPage.this.refreshRequestLock;
                        synchronized (object) {
                            TransferLogPage transferLogPage = TransferLogPage.this;
                            transferLogPage.refreshRequestQueuedCount = transferLogPage.refreshRequestQueuedCount - 1;
                            TransferLogPage.this.lastRefreshCompletedTime = System.currentTimeMillis();
                        }
                        throw throwable;
                    }
                    Object object = TransferLogPage.this.refreshRequestLock;
                    synchronized (object) {
                        TransferLogPage transferLogPage = TransferLogPage.this;
                        transferLogPage.refreshRequestQueuedCount = transferLogPage.refreshRequestQueuedCount - 1;
                        TransferLogPage.this.lastRefreshCompletedTime = System.currentTimeMillis();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestRefresh(boolean forceRefresh) {
        Object object = this.refreshRequestLock;
        synchronized (object) {
            long currentTime = System.currentTimeMillis();
            long timeElapsedSinceLastRefresh = currentTime - this.lastRefreshCompletedTime;
            if (forceRefresh || this.refreshRequestQueuedCount == 0 && timeElapsedSinceLastRefresh > 2000L) {
                this.refresh();
            } else if (Trace.isTracing) {
                Trace.data((Level)Level.WARNING, (String)"TransferLogPage", (String)"requestRefresh(boolean)", (String)("Refresh request aborted, time elapsed since last = " + timeElapsedSinceLastRefresh + "ms, Refresh Count = " + this.refreshRequestQueuedCount), (String)ExplorerPlugin.BUNDLE_SHORT_NAME);
            }
        }
    }

    public void repaint() {
    }

    public void setObject(MQExtObject object) {
    }

    public void showSystemObjects(boolean show) {
    }

    public void updatePage() {
    }

    @Override
    public synchronized void startup() {
        this.loadPreviousAuditLogs();
        AuditProvider auditProvider = Subscription.getAuditProvider();
        auditProvider.addObserver(this);
        for (String auditXML : auditProvider.getAudit()) {
            this.update(null, auditXML);
        }
        Subscription.getAgentStatusDetailsProvider().addObserver(this);
    }

    @Override
    public void shutdown() {
        this.saveCurrentAuditLogs();
        logs.clear();
    }

    static enum TransferLogColumns implements ColumnTitleEnumeration
    {
        SOURCE(Elements.UI_CONTENT_SRC_TITLE),
        DESTINATION(Elements.UI_CONTENT_DEST_TITLE),
        COMPLETION(Elements.UI_CONTENT_COMPLETION_TITLE),
        OWNER(Elements.UI_CONTENT_OWNER_TITLE),
        STARTED(Elements.UI_CONTENT_STARTED_TITLE),
        RECORD_TIME(Elements.UI_CONTENT_RECORD_TIME),
        JOB(Elements.UI_CONTENT_JOB_NAME),
        TRANSFER_ID(Elements.UI_CONTENT_TRANSFER_ID),
        SOURCE_TYPE(Elements.UI_CONTENT_SRC_TYPE),
        DESTINATION_TYPE(Elements.UI_CONTENT_DEST_TYPE),
        CD_PRIMARY_NODE(Elements.UI_CONTENT_CD_PRIMARY_NODE),
        CD_SECONDARY_NODE(Elements.UI_CONTENT_CD_SECONDARY_NODE),
        CD_PROCESS_NAME(Elements.UI_CONTENT_CD_PROCESS_NAME),
        CD_PROCESS_NUMBER(Elements.UI_CONTENT_CD_PROCESS_NUMBER);

        private final String columnTitle;

        private TransferLogColumns(String columnTitle) {
            this.columnTitle = columnTitle;
        }

        @Override
        public String getColumnTitle() {
            return this.columnTitle;
        }

        public static TransferLogColumns findByPersistedString(String str) {
            TransferLogColumns[] transferLogColumnsArray = TransferLogColumns.values();
            int n = transferLogColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransferLogColumns col = transferLogColumnsArray[n2];
                if (col.toString().equals(str)) {
                    return col;
                }
                ++n2;
            }
            return null;
        }

        public static TransferLogColumns findByColumnTitle(String title) {
            TransferLogColumns[] transferLogColumnsArray = TransferLogColumns.values();
            int n = transferLogColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransferLogColumns col = transferLogColumnsArray[n2];
                if (col.columnTitle.equals(title)) {
                    return col;
                }
                ++n2;
            }
            return null;
        }
    }
}

