/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.wmqfte.explorer.content.StateLabelProvider;
import com.ibm.wmqfte.explorer.content.TransferLogPage;
import com.ibm.wmqfte.explorer.objects.Call;
import com.ibm.wmqfte.explorer.objects.TransferLog;
import com.ibm.wmqfte.utils.FilespaceItem;
import com.ibm.wmqfte.utils.xmlmessage.audit.FTEAuditFileNamePair;
import com.ibm.wmqfte.utils.xmlmessage.audit.FTEAuditFileNamePairImpl;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

class TransferLogFilter
extends ViewerFilter {
    private Pattern pattern;

    TransferLogFilter() {
    }

    public void setFilter(String filter) {
        if (filter.trim().length() == 0) {
            this.pattern = null;
        } else {
            String f = filter;
            f = f.replace("\\", "\\\\");
            f = f.replace(".", "\\.");
            f = f.replace("*", ".*");
            this.pattern = Pattern.compile(f, 2);
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.pattern == null) {
            return true;
        }
        if (element instanceof TransferLog) {
            if (this.isMatching((TransferLog)element)) {
                return true;
            }
            List<FTEAuditFileNamePair> files = ((TransferLog)element).getFiles();
            for (FTEAuditFileNamePair fp : files) {
                if (!this.isMatching(fp)) continue;
                return true;
            }
            for (String s : ((TransferLog)element).getSupplements()) {
                if (!this.pattern.matcher(s).matches()) continue;
                return true;
            }
        }
        if (element instanceof FTEAuditFileNamePairImpl) {
            if (this.isMatching((FTEAuditFileNamePair)((FTEAuditFileNamePairImpl)element))) {
                return true;
            }
            if (parentElement instanceof TransferLog && this.isMatching((TransferLog)parentElement)) {
                return true;
            }
        }
        if (element instanceof Call) {
            if (this.isMatching((Call)element)) {
                return true;
            }
            if (parentElement instanceof TransferLog && this.isMatching((TransferLog)parentElement)) {
                return true;
            }
        }
        if (element instanceof String) {
            String val = (String)element;
            if (this.pattern.matcher(val).matches()) {
                return true;
            }
            if (parentElement instanceof TransferLog && this.isMatching((TransferLog)parentElement)) {
                return true;
            }
        }
        return false;
    }

    private boolean isMatching(FTEAuditFileNamePair fp) {
        FilespaceItem sourceFileSpace = ((FTEAuditFileNamePairImpl)fp).getSourceFileSpace();
        String sourceMatch = sourceFileSpace == null ? ((FTEAuditFileNamePairImpl)fp).getSourceName() : String.valueOf(sourceFileSpace.getName()) + ":" + sourceFileSpace.getAlias();
        FilespaceItem destFileSpace = ((FTEAuditFileNamePairImpl)fp).getDestFileSpace();
        String destMatch = destFileSpace == null ? ((FTEAuditFileNamePairImpl)fp).getSourceName() : String.valueOf(destFileSpace.getName()) + ":" + destFileSpace.getAlias();
        return this.pattern.matcher(sourceMatch).matches() || this.pattern.matcher(destMatch).matches() || this.pattern.matcher(StateLabelProvider.getText(fp)).matches() || this.pattern.matcher(StateLabelProvider.getText(fp)).matches();
    }

    private boolean isMatching(Call call) {
        return this.pattern.matcher(call.getCommandName()).matches() || this.pattern.matcher(call.getType()).matches() || this.pattern.matcher(call.getOutcome()).matches();
    }

    private boolean isMatching(TransferLog log) {
        return log.getSrc() != null && this.pattern.matcher(log.getSrc()).matches() || log.getDest() != null && this.pattern.matcher(log.getDest()).matches() || this.pattern.matcher(log.getId()).matches() || this.pattern.matcher(log.getOriginator()).matches() || this.pattern.matcher(StateLabelProvider.getText(log)).matches() || this.pattern.matcher(TransferLogPage.df.format(log.getStartTime())).matches() || this.pattern.matcher(log.getJobName()).matches();
    }
}

