/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.content.TransferLogPage;
import com.ibm.wmqfte.explorer.objects.Call;
import com.ibm.wmqfte.explorer.objects.TransferLog;
import com.ibm.wmqfte.utils.xmlmessage.audit.FTEAuditFileNamePair;
import com.ibm.wmqfte.utils.xmlmessage.audit.FTEAuditFileResultCode;
import com.ibm.wmqfte.utils.xmlmessage.audit.FTEAuditStatus;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;

class StateLabelProvider
extends ColumnLabelProvider {
    private static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());

    StateLabelProvider() {
    }

    public static String getText(TransferLog log) {
        return log.getStateLocalised();
    }

    public static String getText(FTEAuditFileNamePair fp) {
        String result = "";
        FTEAuditStatus status = fp.getStatus();
        if (status != null) {
            int resultCode = status.getResultCode();
            if (resultCode == FTEAuditFileResultCode.Successful.getValue()) {
                result = Elements.UI_CONTENT_AUDIT_COMPLETED_SUCCESS_LABEL;
            } else {
                int i;
                if (resultCode == FTEAuditFileResultCode.Warning.getValue()) {
                    result = Elements.UI_CONTENT_AUDIT_WARNING_LABEL;
                    i = 0;
                    while (i < status.getNumSupplements()) {
                        result = String.valueOf(result) + " - " + status.getSupplementValue(i);
                        ++i;
                    }
                } else {
                    result = Elements.UI_CONTENT_AUDIT_FAILED_LABEL;
                    i = 0;
                    while (i < status.getNumSupplements()) {
                        result = String.valueOf(result) + " - " + status.getSupplementValue(i);
                        ++i;
                    }
                }
                if (IS_GTK && result.length() > 100) {
                    int newlines = result.length() / 100;
                    int start = 0;
                    int i2 = 1;
                    while (i2 <= newlines) {
                        if (100 + start < result.length()) {
                            int endIndex;
                            StringBuilder sb = new StringBuilder(result);
                            int insertion = sb.lastIndexOf(" ", 100 + start);
                            if (insertion > 0) {
                                result = sb.insert(insertion, "\n  ").toString();
                                start = insertion + 3;
                            }
                            if ((endIndex = sb.indexOf("at com.ibm.wmqfte", start)) > 0 && endIndex < 100 + start) break;
                        }
                        ++i2;
                    }
                }
            }
        }
        return result;
    }

    public String getText(Object element) {
        String result = "";
        if (element instanceof TransferLog) {
            return StateLabelProvider.getText((TransferLog)element);
        }
        String string = result = IS_GTK ? "  " : "";
        if (element instanceof FTEAuditFileNamePair) {
            result = String.valueOf(result) + StateLabelProvider.getText((FTEAuditFileNamePair)element);
        } else if (element instanceof Call) {
            String outcome = ((Call)element).getOutcomeLocalised();
            if (((Call)element).getError().length() > 0 && outcome != null) {
                result = String.valueOf(result) + outcome;
                result = String.valueOf(result) + " - " + ((Call)element).getError();
            } else {
                result = String.valueOf(result) + (outcome == null ? "" : outcome);
            }
        }
        return result;
    }

    public Color getBackground(Object element) {
        return TransferLogPage.getBackground(element);
    }
}

