/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.Icons;
import com.ibm.wmqfte.explorer.content.TransferLogPage;
import com.ibm.wmqfte.explorer.content.TransferTypeAccessibleAdapter;
import com.ibm.wmqfte.explorer.objects.Call;
import com.ibm.wmqfte.explorer.objects.TransferLog;
import com.ibm.wmqfte.utils.AgentType;
import com.ibm.wmqfte.utils.FilespaceItem;
import com.ibm.wmqfte.utils.transfer.FTETransferType;
import com.ibm.wmqfte.utils.xmlmessage.audit.FTEAuditFileNamePairImpl;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

class SourceLabelProvider
extends ColumnLabelProvider {
    private static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());

    SourceLabelProvider() {
    }

    public String getText(Object element) {
        String result = "";
        if (element instanceof TransferLog) {
            String pnode;
            String snode;
            TransferLog transfer = (TransferLog)element;
            String src = ((TransferLog)element).getSrc();
            result = AgentType.CD_BRIDGE.equals((Object)transfer.getSrcAgentType()) ? (transfer.getBridgeIsPNODE() ? ((snode = transfer.getCDSNode()) != null && snode.length() > 0 ? String.valueOf(result) + snode + " (" + Elements.UI_CONTENT_CD_VIA + " " + src + ")" : String.valueOf(result) + src) : ((pnode = transfer.getCDPNode()) != null && pnode.length() > 0 ? String.valueOf(result) + pnode + " (" + Elements.UI_CONTENT_CD_VIA + " " + src + ")" : String.valueOf(result) + src)) : String.valueOf(result) + src;
            result = String.valueOf(result) + (IS_GTK ? "        " : "    ");
        } else {
            String string = result = IS_GTK ? "  " : "";
            if (element instanceof FTEAuditFileNamePairImpl) {
                FilespaceItem fileSpace = ((FTEAuditFileNamePairImpl)element).getSourceFileSpace();
                if (fileSpace == null || fileSpace.getName() == null || fileSpace.getName().length() == 0) {
                    String sourceName = ((FTEAuditFileNamePairImpl)element).getSourceAlias();
                    if (sourceName == null) {
                        sourceName = ((FTEAuditFileNamePairImpl)element).getSourceName();
                    }
                    result = String.valueOf(result) + (sourceName == null ? "" : sourceName);
                } else {
                    result = String.valueOf(result) + fileSpace.getName() + " (" + Elements.UI_WIZARD_DEST_FILESPACE_TYPE.toLowerCase() + ")";
                }
            } else if (element instanceof Call) {
                String type = ((Call)element).getType();
                String cmdName = ((Call)element).getCommandName();
                result = String.valueOf(result) + (type == null ? "" : String.valueOf('[') + type + ']');
                result = String.valueOf(result) + (cmdName == null ? "" : " " + cmdName);
            } else if (element instanceof String) {
                result = String.valueOf(result) + (String)element;
                if (IS_GTK && result.length() > 80) {
                    int newlines = result.length() / 80;
                    int start = 0;
                    int i = 1;
                    while (i <= newlines) {
                        if (80 + start < result.length()) {
                            StringBuilder sb = new StringBuilder(result);
                            int insertion = sb.lastIndexOf(" ", 80 + start);
                            result = sb.insert(insertion, "\n  ").toString();
                            start = insertion;
                        }
                        ++i;
                    }
                }
            }
        }
        return result;
    }

    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof FTEAuditFileNamePairImpl) {
            FilespaceItem fileSpace;
            FTETransferType type = ((FTEAuditFileNamePairImpl)element).getSourceType();
            image = FTETransferType.QUEUENAME.equals((Object)type) ? Icons.localQueueObj : ((fileSpace = ((FTEAuditFileNamePairImpl)element).getSourceFileSpace()) == null || fileSpace.getName() == null || fileSpace.getName().length() == 0 ? Icons.fileObj : Icons.filespaceObj);
        }
        return image;
    }

    public Color getBackground(Object element) {
        return TransferLogPage.getBackground(element);
    }

    public void update(ViewerCell cell) {
        super.update(cell);
        Object element = cell.getElement();
        if (element instanceof FTEAuditFileNamePairImpl) {
            FTETransferType type = ((FTEAuditFileNamePairImpl)element).getSourceType();
            cell.getControl().getAccessible().addAccessibleListener((AccessibleListener)new TransferTypeAccessibleAdapter(type));
        }
    }
}

