/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.wmqfte.api.ClearMonitorHistoryRequest;
import com.ibm.wmqfte.api.ConfigurationException;
import com.ibm.wmqfte.api.DeleteMonitorRequest;
import com.ibm.wmqfte.api.InternalException;
import com.ibm.wmqfte.api.TransferDefinitionParser;
import com.ibm.wmqfte.api.TransportException;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.Icons;
import com.ibm.wmqfte.explorer.Messages;
import com.ibm.wmqfte.explorer.content.ColumnTitleEnumeration;
import com.ibm.wmqfte.explorer.content.IFTEContentPage;
import com.ibm.wmqfte.explorer.content.MFTContentPage;
import com.ibm.wmqfte.explorer.content.MonitorAgentNameLabelProvider;
import com.ibm.wmqfte.explorer.content.MonitorAgentNameSorter;
import com.ibm.wmqfte.explorer.content.MonitorBatchSizeLabelProvider;
import com.ibm.wmqfte.explorer.content.MonitorBatchSizeSorter;
import com.ibm.wmqfte.explorer.content.MonitorContentSorterPage;
import com.ibm.wmqfte.explorer.content.MonitorExcludePatternLabelProvider;
import com.ibm.wmqfte.explorer.content.MonitorExcludePatternSorter;
import com.ibm.wmqfte.explorer.content.MonitorNameLabelProvider;
import com.ibm.wmqfte.explorer.content.MonitorNameSorter;
import com.ibm.wmqfte.explorer.content.MonitorPatternLabelProvider;
import com.ibm.wmqfte.explorer.content.MonitorPatternSorter;
import com.ibm.wmqfte.explorer.content.MonitorPollIntervalLabelProvider;
import com.ibm.wmqfte.explorer.content.MonitorPollIntervalSorter;
import com.ibm.wmqfte.explorer.content.MonitorResourceSorter;
import com.ibm.wmqfte.explorer.content.MonitorResourceTypeLabelProvider;
import com.ibm.wmqfte.explorer.content.MonitorStatusLabelProvider;
import com.ibm.wmqfte.explorer.content.MonitorStatusSorter;
import com.ibm.wmqfte.explorer.content.MonitorTriggerLabelProvider;
import com.ibm.wmqfte.explorer.content.MonitorTriggerSorter;
import com.ibm.wmqfte.explorer.data.GUIListMonitorResult;
import com.ibm.wmqfte.explorer.data.MonitorProvider;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.utils.ProviderSorter;
import com.ibm.wmqfte.explorer.utils.v2.Tools;
import com.ibm.wmqfte.explorer.wizards.v2.TransferWizardStarterV2;
import com.ibm.wmqfte.monitor.MonitorStatus;
import com.ibm.wmqfte.monitor.impl.MonitorRequest;
import com.ibm.wmqfte.objects.TransferTemplate;
import com.ibm.wmqfte.utils.AgentDetailsFactory;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import com.ibm.wmqfte.utils.ProductVersion;
import com.ibm.wmqfte.utils.xmlmessage.transfer.AgentClientSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.AgentSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ItemSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.ManagedTransferSpecification;
import com.ibm.wmqfte.utils.xmlmessage.transfer.TransferSetSpecification;
import com.ibm.wmqfte.wmqiface.WMQApiException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;

public class MonitorContentPage
extends MFTContentPage
implements IShellProvider,
IFTEContentPage,
Observer {
    private Set<GUIListMonitorResult> monitors = new LinkedHashSet<GUIListMonitorResult>();
    private TreeViewer tv;
    private final Set<AgentStatusDetails> agents = Subscription.getAgentStatusDetailsProvider().getAvailableAgents();
    private static final ProviderSorter ps = new ProviderSorter();
    private static final MonitorColumns[] DEFAULT_COLUMNS;
    private static final String[] DEFAULT_COLUMNS_AS_STRING;
    private static final String MONITOR_PANEL_SETTINGS = "MONITOR_PANEL_SETTINGS";

    static {
        ps.add(Elements.UI_CONTENT_TRANSFER_TEMPLATES_NAME_TITLE, new MonitorNameLabelProvider(), new MonitorNameSorter());
        ps.add(Elements.UI_WIZARD_HOST_LABEL, new MonitorAgentNameLabelProvider(), new MonitorAgentNameSorter());
        ps.add(Elements.UI_WIZARD_MONITOR_RESOURCE_TITLE, new MonitorResourceTypeLabelProvider(), new MonitorResourceSorter());
        ps.add(Elements.UI_WIZARD_POLL_INTERVAL, new MonitorPollIntervalLabelProvider(), new MonitorPollIntervalSorter());
        ps.add(Elements.UI_WIZARD_BATCH_SIZE, new MonitorBatchSizeLabelProvider(), new MonitorBatchSizeSorter());
        ps.add(Elements.UI_CONTENT_TRANSFER_TEMPLATES_TRIGGERS_TITLE, new MonitorTriggerLabelProvider(), new MonitorTriggerSorter());
        ps.add(Elements.UI_WIZARD_FILE_PATTERN_LABEL, new MonitorPatternLabelProvider(), new MonitorPatternSorter());
        ps.add(Elements.UI_WIZARD_IGNORE_PATTERN_LABEL, new MonitorExcludePatternLabelProvider(), new MonitorExcludePatternSorter());
        ps.add(Elements.UI_CONTENT_MONITOR_STATUS, new MonitorStatusLabelProvider(), new MonitorStatusSorter());
        DEFAULT_COLUMNS = new MonitorColumns[]{MonitorColumns.NAME, MonitorColumns.AGENT, MonitorColumns.RESOURCE, MonitorColumns.POLL_INTERVAL, MonitorColumns.BATCH_SIZE, MonitorColumns.TRIGGER_PATTERN, MonitorColumns.FILE_PATTERN, MonitorColumns.EXCLUDE_PATTERN, MonitorColumns.STATUS};
        DEFAULT_COLUMNS_AS_STRING = new String[]{MonitorColumns.NAME.toString(), MonitorColumns.AGENT.toString(), MonitorColumns.RESOURCE.toString(), MonitorColumns.POLL_INTERVAL.toString(), MonitorColumns.BATCH_SIZE.toString(), MonitorColumns.TRIGGER_PATTERN.toString(), MonitorColumns.FILE_PATTERN.toString(), MonitorColumns.EXCLUDE_PATTERN.toString(), MonitorColumns.STATUS.toString()};
    }

    @Override
    List<String> getColumnTitlesWithTimeZone() {
        return new ArrayList<String>();
    }

    @Override
    MonitorColumns findColumnByPersistedString(String str) {
        return MonitorColumns.findByPersistedString(str);
    }

    @Override
    MonitorColumns findColumnByColumnTitle(String str) {
        return MonitorColumns.findByColumnTitle(str);
    }

    MonitorColumns[] getDefaultColumns() {
        return DEFAULT_COLUMNS;
    }

    public MonitorContentPage(Composite parent, int style) {
        super(parent, style);
    }

    public String getId() {
        return "com.ibm.wmqfte.explorer.monitors";
    }

    public void init() {
        ColumnTitleEnumeration[] displayColumns;
        final Display display = this.getDisplay();
        int numColumns = 1;
        this.setLayout((Layout)new GridLayout(numColumns, true));
        ContentTitleBar contentTitleBar = new ContentTitleBar((Composite)this, 0);
        contentTitleBar.setText(Elements.UI_CONTENT_MONITORS_TITLE);
        contentTitleBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false, numColumns, 1));
        Label label = new Label((Composite)this, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, numColumns, 1));
        label = new Label((Composite)this, 0);
        GridData gridData = new GridData(4, 0x1000000, false, false, numColumns, 1);
        gridData.heightHint = 5;
        label.setLayoutData((Object)gridData);
        this.tv = new TreeViewer((Composite)this, 68354);
        this.tv.setContentProvider((IContentProvider)new MonitorContentProvider());
        final Tree tree = this.tv.getTree();
        this.tv.setSorter((ViewerSorter)new MonitorAgentNameSorter());
        ColumnTitleEnumeration[] columnTitleEnumerationArray = displayColumns = this.loadDefaultColumns();
        int n = displayColumns.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnTitleEnumeration col = columnTitleEnumerationArray[n2];
            ColumnLabelProvider clp = ps.getProvider(col.getColumnTitle());
            ViewerSorter vs = ps.getSorter(col.getColumnTitle());
            this.addColumn(ps.adjustColumnName(col.getColumnTitle()), clp, vs);
            ++n2;
        }
        this.tv.setInput(this.monitors);
        this.tv.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                this.updateTree();
            }

            public void treeExpanded(TreeExpansionEvent event) {
                this.updateTree();
            }

            private void updateTree() {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MonitorContentPage.this.tv.refresh();
                        Tree tree = MonitorContentPage.this.tv.getTree();
                        if (!tree.isDisposed()) {
                            PageUtils.setupTree(tree);
                        }
                    }
                });
            }
        });
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        PageUtils.setupTree(tree);
        this.addContextMenu(this.tv);
        this.layout(true);
        ExplorerPlugin.setHelp((Control)this, "com.ibm.wmqfte.explorer.context.UI_MonitorHelp");
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doubleClick(DoubleClickEvent arg0) {
                Object o;
                ISelection s = MonitorContentPage.this.tv.getSelection();
                if (s instanceof IStructuredSelection && (o = ((IStructuredSelection)s).getFirstElement()) instanceof GUIListMonitorResult && MonitorContentPage.this.agents != null) {
                    String agentName = ((GUIListMonitorResult)((Object)o)).getAgentName();
                    Set set = MonitorContentPage.this.agents;
                    synchronized (set) {
                        for (AgentStatusDetails agent : MonitorContentPage.this.agents) {
                            if (!agent.getAgentName().equals(agentName)) continue;
                            String agentInterfaceLevel = agent.getAgentInterfaceLevel();
                            if (agentInterfaceLevel == null || !ProductVersion.ProductInterfaceVersion.fromValue((String)agentInterfaceLevel).greaterOrEqual(ProductVersion.ProductInterfaceVersion.V500)) break;
                            MonitorContentPage.this.editMonitor(tree.getShell(), (GUIListMonitorResult)((Object)o), false);
                            break;
                        }
                    }
                }
            }
        });
        columnTitleEnumerationArray = this.tv.getTree().getColumns();
        n = columnTitleEnumerationArray.length;
        n2 = 0;
        while (n2 < n) {
            ColumnTitleEnumeration c = columnTitleEnumerationArray[n2];
            c.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                    MonitorContentPage.this.saveDefaultColumns();
                }

                public void controlResized(ControlEvent e) {
                }
            });
            ++n2;
        }
        this.saveDefaultColumns();
    }

    private void addColumn(String title, ColumnLabelProvider l, ViewerSorter v) {
        int length = title.length();
        if (':' == title.charAt(length - 1)) {
            title = title.substring(0, length - 1);
        }
        TreeViewerColumn tvc = new TreeViewerColumn(this.tv, 16384);
        tvc.setLabelProvider((CellLabelProvider)l);
        final TreeColumn c = tvc.getColumn();
        c.setMoveable(true);
        c.setResizable(true);
        c.addControlListener(PageUtils.minWidthControlListener);
        c.setText(title);
        if (v != null && v instanceof MonitorContentSorterPage) {
            final MonitorContentSorterPage tlSorter = (MonitorContentSorterPage)v;
            c.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    tlSorter.setColumn(MonitorContentPage.this.tv, c);
                    MonitorContentPage.this.refresh();
                }
            });
        }
    }

    @Override
    public void update(Observable observable, Object data) {
        if (data instanceof GUIListMonitorResult) {
            GUIListMonitorResult monitor = (GUIListMonitorResult)((Object)data);
            this.monitors.remove((Object)monitor);
            if (!MonitorStatus.DELETED.getXML().equals(monitor.getStatus())) {
                this.monitors.add(monitor);
            }
            this.refresh();
        } else if (data instanceof AgentStatusDetails) {
            this.agents.remove(data);
            this.agents.add((AgentStatusDetails)data);
        }
    }

    public boolean isMonitorPresent(String agentName, String monitorName) {
        for (GUIListMonitorResult monitor : this.monitors) {
            if (!agentName.equals(monitor.getAgentName()) || !monitorName.equals(monitor.getMonitorName())) continue;
            return true;
        }
        return false;
    }

    private ColumnTitleEnumeration[] loadDefaultColumns() {
        String[] savedColumnOrder = PageUtils.loadDefaultColumns(MONITOR_PANEL_SETTINGS, DEFAULT_COLUMNS_AS_STRING);
        return this.convertColumns(savedColumnOrder);
    }

    private void saveDefaultColumns() {
        PageUtils.saveDefaultColumns(MONITOR_PANEL_SETTINGS, this, (Viewer)this.tv);
    }

    public boolean isEnableRefreshAction() {
        return true;
    }

    public void refresh() {
        if (this.getDisplay() != null && !this.getDisplay().isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (MonitorContentPage.this.tv != null && !MonitorContentPage.this.tv.getControl().isDisposed()) {
                        MonitorContentPage.this.tv.refresh();
                        Tree tree = MonitorContentPage.this.tv.getTree();
                        if (!tree.isDisposed()) {
                            PageUtils.setupTree(tree);
                        }
                    }
                }
            });
        }
    }

    private void addContextMenu(final TreeViewer tv) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MonitorContentPage.this.fillContextMenu(tv, manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)tv.getTree());
        tv.getTree().setMenu(menu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillContextMenu(final TreeViewer viewer, IMenuManager manager) {
        boolean hasSelection;
        List selectionList = ((IStructuredSelection)this.tv.getSelection()).toList();
        boolean bl = hasSelection = this.tv.getSelection() instanceof IStructuredSelection && selectionList.size() > 0;
        if (hasSelection) {
            Object o;
            boolean enabled = true;
            for (Object o2 : selectionList) {
                if (o2 instanceof GUIListMonitorResult) continue;
                enabled = false;
                break;
            }
            Action edit = new Action(){

                public void run() {
                    ISelection s = MonitorContentPage.this.tv.getSelection();
                    if (s instanceof IStructuredSelection) {
                        for (Object o : ((IStructuredSelection)s).toList()) {
                            if (!(o instanceof GUIListMonitorResult)) continue;
                            MonitorContentPage.this.editMonitor(viewer.getControl().getShell(), (GUIListMonitorResult)((Object)o), false);
                        }
                        MonitorContentPage.this.tv.refresh();
                    }
                }
            };
            edit.setText(Elements.UI_WIZARD_V2_MONITORS_EDIT);
            edit.setEnabled(false);
            if (this.agents != null && selectionList.size() == 1 && (o = selectionList.get(0)) instanceof GUIListMonitorResult) {
                String agentName = ((GUIListMonitorResult)((Object)o)).getAgentName();
                Set<AgentStatusDetails> set = this.agents;
                synchronized (set) {
                    for (AgentStatusDetails agent : this.agents) {
                        if (!agent.getAgentName().equals(agentName)) continue;
                        String agentInterfaceLevel = agent.getAgentInterfaceLevel();
                        if (agentInterfaceLevel == null || !ProductVersion.ProductInterfaceVersion.fromValue((String)agentInterfaceLevel).greaterOrEqual(ProductVersion.ProductInterfaceVersion.V500)) break;
                        edit.setEnabled(true);
                        break;
                    }
                }
            }
            manager.add((IAction)edit);
            Action editAsNew = new Action(){

                public void run() {
                    ISelection s = MonitorContentPage.this.tv.getSelection();
                    if (s instanceof IStructuredSelection) {
                        for (Object o : ((IStructuredSelection)s).toList()) {
                            if (!(o instanceof GUIListMonitorResult)) continue;
                            MonitorContentPage.this.editMonitor(viewer.getControl().getShell(), (GUIListMonitorResult)((Object)o), true);
                        }
                        MonitorContentPage.this.tv.refresh();
                    }
                }
            };
            editAsNew.setText(Elements.UI_WIZARD_V2_MONITORS_EDIT_AS_NEW);
            editAsNew.setEnabled(selectionList.size() == 1);
            manager.add((IAction)editAsNew);
            manager.add((IContributionItem)new Separator());
            Action delete = new Action(){

                public void run() {
                    ISelection s = MonitorContentPage.this.tv.getSelection();
                    if (s instanceof IStructuredSelection) {
                        for (Object o : ((IStructuredSelection)s).toList()) {
                            if (!(o instanceof GUIListMonitorResult)) continue;
                            GUIListMonitorResult m = (GUIListMonitorResult)((Object)o);
                            MonitorContentPage.this.delete(m);
                        }
                        MonitorContentPage.this.tv.refresh();
                    }
                }
            };
            delete.setText(Elements.UI_CONTENT_TRANSFER_TEMPLATES_DELETE_BUTTON);
            delete.setEnabled(enabled);
            manager.add((IAction)delete);
            manager.add((IContributionItem)new Separator());
            Action clearHistory = new Action(){

                public void run() {
                    ISelection s = MonitorContentPage.this.tv.getSelection();
                    if (s instanceof IStructuredSelection) {
                        for (Object o : ((IStructuredSelection)s).toList()) {
                            if (!(o instanceof GUIListMonitorResult)) continue;
                            GUIListMonitorResult m = (GUIListMonitorResult)((Object)o);
                            MonitorContentPage.this.clearHistory(m);
                        }
                        MonitorContentPage.this.tv.refresh();
                    }
                }
            };
            clearHistory.setText(Elements.UI_WIZARD_V2_MONITORS_CLEAR_HISTORY);
            clearHistory.setEnabled(enabled);
            manager.add((IAction)clearHistory);
            PropertyDialogAction propertyDialog = new PropertyDialogAction((IShellProvider)this, (ISelectionProvider)this.tv);
            propertyDialog.setEnabled(false);
            if (selectionList.size() == 1) {
                Object o3 = selectionList.get(0);
                boolean hasProperty = false;
                if (o3 instanceof GUIListMonitorResult) {
                    GUIListMonitorResult m = (GUIListMonitorResult)((Object)o3);
                    hasProperty = m.get1stTaskXML() != null && m.get1stTaskXML().length() > 0;
                }
                propertyDialog.setEnabled(hasProperty);
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)propertyDialog);
        }
    }

    private void editMonitor(Shell shell, GUIListMonitorResult m, boolean copy) {
        MonitorRequest monitor = m.getMonitorRequest();
        String taskXML = m.get1stTaskEscapedXML();
        TransferDefinitionParser parser = new TransferDefinitionParser(taskXML);
        try {
            ManagedTransferSpecification transferSpec = parser.parse();
            if (transferSpec == null) {
                if (taskXML.contains("<managedCall>")) {
                    String message = MessageFormat.format(Messages.BFGUI0001_CANNOT_EDIT_MONITOR_WITH_MANAGED_CALL, m.getMonitorName(), "<managedCall>");
                    MessageDialog.openError((Shell)shell, (String)Elements.UI_WIZARD_V2_SUB_TITLE_MONITOR_EDIT, (String)message);
                    return;
                }
                String message = MessageFormat.format(Elements.UI_WIZARD_V2_INTERR_MONITOR_MISSING_MANAGEDTRANSFER, "<managedTransfer>");
                throw new ConfigurationException(message);
            }
            AgentSpecification sourceAgent = transferSpec.getSourceAgent();
            AgentClientSpecification destinationAgent = transferSpec.getDestinationAgent();
            TransferSetSpecification transferSet = transferSpec.getTransferSet();
            AgentStatusDetails srcAgent = AgentDetailsFactory.createInstance((String)sourceAgent.getAgentName(), null, null, null, (int)-1, null, null);
            AgentStatusDetails destAgent = AgentDetailsFactory.createInstance((String)destinationAgent.getAgentName(), null, (String)destinationAgent.getAgentQMgr(), (String)destinationAgent.getHostName(), (int)(destinationAgent.getPortNumber() == null ? 1414 : Integer.parseInt(destinationAgent.getPortNumber())), (String)destinationAgent.getChannel(), null);
            TransferTemplate t = new TransferTemplate(UUID.randomUUID().toString(), monitor.getMonitorName(), srcAgent, destAgent, transferSet.getTransferItems(), transferSpec.getJobReference(), null, null, transferSet.getMetaDataSet(), transferSet.getTransferPriority(), monitor, transferSet.getPreSourceCall(), transferSet.getPostSourceCall(), transferSet.getPreDestinationCall(), transferSet.getPostDestinationCall(), null);
            if (copy) {
                TransferWizardStarterV2.copyMonitor(shell, t);
            } else {
                TransferWizardStarterV2.editMonitor(shell, t);
            }
        }
        catch (ConfigurationException e) {
            Tools.internalError(e, e.getLocalizedMessage(), new Object[0]);
        }
        catch (InternalException e) {
            Tools.internalError(e, e.getLocalizedMessage().replace("{", "\\{").replace("}", "\\}"), new Object[0]);
        }
    }

    private void delete(GUIListMonitorResult m) {
        for (AgentStatusDetails agent : Subscription.getAgentStatusDetailsProvider().getAvailableAgents()) {
            if (!agent.getAgentName().equals(m.getAgentName())) continue;
            try {
                DeleteMonitorRequest delete = new DeleteMonitorRequest(m.getMonitorName(), m.getAgentName());
                delete.send(Subscription.getCmdConnectionData(), agent.getQueueManagerName());
                this.monitors.remove((Object)m);
            }
            catch (TransportException e) {
                WMQApiException mqe = (WMQApiException)e.getCause();
                Display display = PlatformUI.getWorkbench().getDisplay();
                String error = MessageFormat.format(Messages.BFGUI0012_DELETE_MONITOR_FAILED, Integer.toString(mqe.getReasonCode()));
                String mqrc = MessageFormat.format(Elements.UI_WIZARD_WMQ_RC, Integer.toString(mqe.getReasonCode()));
                final MultiStatus msg = new MultiStatus("com.ibm.wmqfte.explorer", 1, error, null);
                msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", error));
                msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", mqrc));
                msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", Messages.BFGUI0012_DELETE_MONITOR_FAILED$explanation));
                msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", Messages.BFGUI0012_DELETE_MONITOR_FAILED$useraction));
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Display display = Display.getCurrent();
                        ErrorDialog.openError((Shell)display.getActiveShell(), (String)Elements.UI_CONTENT_MONITORS_DELETE_FAILED_TITLE, null, (IStatus)msg);
                    }
                });
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (InternalException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void clearHistory(GUIListMonitorResult m) {
        for (AgentStatusDetails agent : Subscription.getAgentStatusDetailsProvider().getAvailableAgents()) {
            if (!agent.getAgentName().equals(m.getAgentName())) continue;
            try {
                ClearMonitorHistoryRequest clearHistory = new ClearMonitorHistoryRequest(m.getMonitorName(), m.getAgentName());
                clearHistory.send(Subscription.getCmdConnectionData(), agent.getQueueManagerName());
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Display display = Display.getCurrent();
                        MessageDialog.openInformation((Shell)display.getActiveShell(), (String)Elements.UI_CONTENT_MONITORS_CLEAR_HISTORY_SUCCESS_TITLE, (String)Messages.BFGUI0017_CLEAR_MONITOR_HISTORY_SUCCESS);
                    }
                });
            }
            catch (TransportException e) {
                WMQApiException mqe = (WMQApiException)e.getCause();
                Display display = PlatformUI.getWorkbench().getDisplay();
                String error = MessageFormat.format(Messages.BFGUI0016_CLEAR_MONITOR_HISTORY_FAILED, Integer.toString(mqe.getReasonCode()));
                String mqrc = MessageFormat.format(Elements.UI_WIZARD_WMQ_RC, Integer.toString(mqe.getReasonCode()));
                final MultiStatus msg = new MultiStatus("com.ibm.wmqfte.explorer", 1, error, null);
                msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", error));
                msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", mqrc));
                msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", Messages.BFGUI0016_CLEAR_MONITOR_HISTORY_FAILED$explanation));
                msg.add((IStatus)new Status(4, "com.ibm.wmqfte.explorer", Messages.BFGUI0016_CLEAR_MONITOR_HISTORY_FAILED$useraction));
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Display display = Display.getCurrent();
                        ErrorDialog.openError((Shell)display.getActiveShell(), (String)Elements.UI_CONTENT_MONITORS_CLEAR_HISTORY_FAILED_TITLE, null, (IStatus)msg);
                    }
                });
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (InternalException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void clear() {
        if (this.monitors != null) {
            this.monitors.clear();
        }
        this.refresh();
    }

    @Override
    public void startup() {
        MonitorProvider monitorProvider = Subscription.getMonitorProvider();
        for (GUIListMonitorResult monitor : monitorProvider.getMonitors()) {
            this.update(null, (Object)monitor);
        }
        monitorProvider.addObserver(this);
        Subscription.getAgentStatusDetailsProvider().addObserver(this);
    }

    @Override
    public void shutdown() {
        this.clear();
    }

    public void instanceDeleted(Object object) {
    }

    public boolean isEnableSystemObjectsAction() {
        return false;
    }

    public void repaint() {
    }

    public void setObject(MQExtObject object) {
    }

    public void showSystemObjects(boolean show) {
    }

    public void updatePage() {
    }

    static enum MonitorColumns implements ColumnTitleEnumeration
    {
        NAME(Elements.UI_CONTENT_TRANSFER_TEMPLATES_NAME_TITLE),
        AGENT(Elements.UI_WIZARD_HOST_LABEL),
        RESOURCE(Elements.UI_WIZARD_MONITOR_RESOURCE_TITLE),
        POLL_INTERVAL(Elements.UI_WIZARD_POLL_INTERVAL),
        BATCH_SIZE(Elements.UI_WIZARD_BATCH_SIZE),
        TRIGGER_PATTERN(Elements.UI_CONTENT_TRANSFER_TEMPLATES_TRIGGERS_TITLE),
        FILE_PATTERN(Elements.UI_WIZARD_FILE_PATTERN_LABEL),
        EXCLUDE_PATTERN(Elements.UI_WIZARD_IGNORE_PATTERN_LABEL),
        STATUS(Elements.UI_CONTENT_MONITOR_STATUS);

        private final String columnTitle;

        private MonitorColumns(String columnTitle) {
            this.columnTitle = columnTitle;
        }

        @Override
        public String getColumnTitle() {
            return this.columnTitle;
        }

        public static MonitorColumns findByPersistedString(String str) {
            MonitorColumns[] monitorColumnsArray = MonitorColumns.values();
            int n = monitorColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                MonitorColumns col = monitorColumnsArray[n2];
                if (col.toString().equals(str) || col.toString().equals(String.valueOf(str) + ":")) {
                    return col;
                }
                ++n2;
            }
            return null;
        }

        public static MonitorColumns findByColumnTitle(String title) {
            MonitorColumns[] monitorColumnsArray = MonitorColumns.values();
            int n = monitorColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                MonitorColumns col = monitorColumnsArray[n2];
                if (col.columnTitle.equals(title) || col.columnTitle.equals(String.valueOf(title) + ":")) {
                    return col;
                }
                ++n2;
            }
            return null;
        }
    }

    private class MonitorContentProvider
    implements ITreeContentProvider {
        private MonitorContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object arg0) {
            return null;
        }

        public boolean hasChildren(Object arg0) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).values().toArray();
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    class MonitorLabelProvider
    implements ITableLabelProvider {
        MonitorLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof GUIListMonitorResult && columnIndex == 2) {
                GUIListMonitorResult m = (GUIListMonitorResult)((Object)element);
                MonitorRequest.MonitorResourceType resourceType = m.getResourceType();
                if (resourceType == MonitorRequest.MonitorResourceType.QUEUE) {
                    return Icons.localQueueObj;
                }
                return Icons.directoryObj;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            if (element instanceof GUIListMonitorResult) {
                GUIListMonitorResult m = (GUIListMonitorResult)((Object)element);
                switch (columnIndex) {
                    case 0: {
                        result = m.getMonitorName();
                        break;
                    }
                    case 1: {
                        result = m.getAgentName();
                        break;
                    }
                    case 2: {
                        result = m.getResourceName();
                        break;
                    }
                    case 3: {
                        if (m.getPollUnits() == null) {
                            result = "";
                            break;
                        }
                        result = String.valueOf(m.getPollInterval()) + " " + m.getPollUnits().getXML();
                        break;
                    }
                    case 4: {
                        result = "" + m.getBatchSize();
                        break;
                    }
                    case 5: {
                        result = m.get1stTrigger();
                        break;
                    }
                    case 6: {
                        result = m.get1stPatternStr();
                        break;
                    }
                    case 7: {
                        result = m.getExcludePatternStr();
                        break;
                    }
                    case 8: {
                        result = m.getStatus();
                    }
                }
            } else if (element instanceof ItemSpecification) {
                ItemSpecification ts = (ItemSpecification)element;
                switch (columnIndex) {
                    case 1: {
                        result = ts.getSourceName();
                        break;
                    }
                    case 2: {
                        result = ts.getDestinationName();
                    }
                }
            }
            return String.valueOf(result) + "    ";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

