/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.Icons;
import com.ibm.wmqfte.explorer.content.TransferLogPage;
import com.ibm.wmqfte.explorer.content.TransferTypeAccessibleAdapter;
import com.ibm.wmqfte.explorer.objects.TransferLog;
import com.ibm.wmqfte.utils.AgentType;
import com.ibm.wmqfte.utils.FilespaceItem;
import com.ibm.wmqfte.utils.transfer.FTETransferType;
import com.ibm.wmqfte.utils.xmlmessage.audit.FTEAuditFileNamePairImpl;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

class DestinationLabelProvider
extends ColumnLabelProvider {
    private static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());

    DestinationLabelProvider() {
    }

    public String getText(Object element) {
        String result = "";
        if (element instanceof TransferLog) {
            TransferLog transfer = (TransferLog)element;
            String dest = transfer.getDest();
            if (dest != null) {
                result = AgentType.CD_BRIDGE.equals((Object)transfer.getDestAgentType()) ? (transfer.getBridgeIsPNODE() ? String.valueOf(result) + transfer.getCDSNode() + "(" + Elements.UI_CONTENT_CD_VIA + " " + dest + ")" : String.valueOf(result) + transfer.getCDPNode() + "(" + Elements.UI_CONTENT_CD_VIA + " " + dest + ")") : String.valueOf(result) + dest;
                result = String.valueOf(result) + (IS_GTK ? "        " : "    ");
            }
        } else {
            result = String.valueOf(result) + (IS_GTK ? "  " : "");
            if (element instanceof FTEAuditFileNamePairImpl) {
                FilespaceItem fileSpace = ((FTEAuditFileNamePairImpl)element).getDestFileSpace();
                if (fileSpace == null || fileSpace.getName() == null || fileSpace.getName().length() == 0) {
                    String destName = ((FTEAuditFileNamePairImpl)element).getDestinationAlias();
                    if (destName == null) {
                        destName = ((FTEAuditFileNamePairImpl)element).getDestName();
                    }
                    result = String.valueOf(result) + (destName == null ? "" : destName);
                } else {
                    result = String.valueOf(result) + fileSpace.getName() + " (" + Elements.UI_WIZARD_DEST_FILESPACE_TYPE.toLowerCase() + ")";
                }
            }
        }
        return result;
    }

    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof TransferLog.FTEAuditAgentFileNamePairImpl) {
            FTEAuditFileNamePairImpl fp = (FTEAuditFileNamePairImpl)element;
            FTETransferType type = fp.getDestType();
            if (FTETransferType.QUEUENAME.equals((Object)type)) {
                String destName = fp.getDestName();
                if (destName.indexOf("@") != -1) {
                    String destQmgr = destName.split("@")[1];
                    if (fp instanceof TransferLog.FTEAuditAgentFileNamePairImpl && destQmgr.equalsIgnoreCase(((TransferLog.FTEAuditAgentFileNamePairImpl)fp).getDestAgentQmgr())) {
                        image = Icons.localQueueObj;
                    }
                    image = Icons.remoteQueueObj;
                }
                return Icons.localQueueObj;
            }
            image = FTETransferType.FILESPACE.equals((Object)type) ? Icons.filespaceObj : Icons.fileObj;
        }
        return image;
    }

    public Color getBackground(Object element) {
        return TransferLogPage.getBackground(element);
    }

    public void update(ViewerCell cell) {
        super.update(cell);
        Object element = cell.getElement();
        if (element instanceof FTEAuditFileNamePairImpl) {
            FTETransferType type = ((FTEAuditFileNamePairImpl)element).getSourceType();
            cell.getControl().getAccessible().addAccessibleListener((AccessibleListener)new TransferTypeAccessibleAdapter(type));
        }
    }
}

