/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.mq.explorer.ui.extensions.ContentPage;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.wmqfte.api.AbstractCommand;
import com.ibm.wmqfte.api.ConfigurationException;
import com.ibm.wmqfte.api.FTEPropertyStore;
import com.ibm.wmqfte.api.FTEPropertyStoreFactory;
import com.ibm.wmqfte.api.InternalException;
import com.ibm.wmqfte.api.ParameterException;
import com.ibm.wmqfte.configuration.FTEProperties;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.objects.ConfigurationSetMQExtObject;
import com.ibm.wmqfte.explorer.wizards.pages.NewTransferMetadataPage;
import com.ibm.wmqfte.explorer.wizards.v2.FTEConfigurationWizardSettings;
import com.ibm.wmqfte.utils.FTEPropConstant;
import com.ibm.wmqfte.utils.ProductVersion;
import com.ibm.wmqfte.wmqiface.WMQConnectionData;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class CoordContentPage
extends ContentPage {
    private MQExtObject object;
    private ContentTitleBar titleLabel;
    private TableViewer tbv;

    public CoordContentPage(Composite parent, int style) {
        super(parent, style);
    }

    public void init() {
        this.setLayout((Layout)new GridLayout(3, false));
        this.titleLabel = new ContentTitleBar((Composite)this, 0);
        this.titleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Composite viewer = new Composite((Composite)this, 0);
        viewer.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        viewer.setLayout((Layout)tableColumnLayout);
        Table table = new Table(viewer, 68354);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.tbv = new TableViewer(table);
        this.tbv.setContentProvider((IContentProvider)new NewTransferMetadataPage.MetaDataContentProvider());
        this.tbv.setLabelProvider((IBaseLabelProvider)new NewTransferMetadataPage.MetaDataLabelProvider());
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setText(Elements.UI_WIZARD_ATTRIBUTE_NAME_LABEL);
        tableColumnLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(50));
        TableColumn valueColumn = new TableColumn(table, 16384);
        valueColumn.setText(Elements.UI_WIZARD_ATTRIBUTE_VALUE_LABEL);
        tableColumnLayout.setColumnData((Widget)valueColumn, (ColumnLayoutData)new ColumnWeightData(50));
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        this.layout();
    }

    public String getId() {
        return "com.ibm.wmqfte.explorer.coordination";
    }

    public void setObject(MQExtObject object) {
        this.object = object;
    }

    public void updatePage() {
        if (this.object instanceof ConfigurationSetMQExtObject) {
            ConfigurationSetMQExtObject configurationObj = (ConfigurationSetMQExtObject)this.object;
            FTEConfigurationWizardSettings settings = configurationObj.getSettings();
            LinkedHashMap<String, String> propsMap = new LinkedHashMap<String, String>();
            if (settings == null) {
                FTEPropertyStoreFactory instance = FTEPropertyStoreFactory.getInstance();
                try {
                    FTEPropertyStore propertyFiles = instance.getPropertyStore();
                    FTEProperties connectionProps = propertyFiles.getCommandProperties(configurationObj.getName());
                    WMQConnectionData cmdConnectionData = AbstractCommand.getConnectionData((FTEProperties)connectionProps, (FTEPropConstant.ConnectionType)FTEPropConstant.ConnectionType.CONNECTION, (String)ProductVersion.getExplorerPluginRAPPLTAGPrefix());
                    FTEProperties coordProps = propertyFiles.getCoordinationProperties(configurationObj.getName());
                    WMQConnectionData coordConnectionData = AbstractCommand.getConnectionData((FTEProperties)coordProps, (FTEPropConstant.ConnectionType)FTEPropConstant.ConnectionType.COORDINATION, (String)ProductVersion.getExplorerPluginRAPPLTAGPrefix());
                    this.titleLabel.setText(MessageFormat.format(Elements.UI_CONTENT_CONFIGURATION_SET, configurationObj.getName()));
                    propsMap.put(Elements.UI_WIZARD_NEW_CONFIGURATION_NAME_LABEL, configurationObj.getName());
                    propsMap.put(Elements.UI_WIZARD_NEW_CONFIGURATION_LOG_SUBSCRIPTION_LABEL, ExplorerPlugin.getTransferLogSubscriptionType());
                    if (coordConnectionData.useBindings()) {
                        propsMap.put(Elements.UI_WIZARD_NEW_CONFIGURATION_COORD_QM_NAME_LABEL, coordConnectionData.getQueueManagerName());
                    } else {
                        propsMap.put(Elements.UI_WIZARD_NEW_CONFIGURATION_COORD_QM_NAME_LABEL, String.valueOf(coordConnectionData.getQueueManagerName()) + " " + Elements.UI_WIZARD_NEW_CONFIGURATION_CONNECTION_ON_LABEL + " '" + coordConnectionData.getHostname() + '(' + coordConnectionData.getPort() + ")'");
                    }
                    if (cmdConnectionData.useBindings()) {
                        propsMap.put(Elements.UI_WIZARD_NEW_CONFIGURATION_COMMAND_QM_NAME_LABEL, cmdConnectionData.getQueueManagerName());
                    } else {
                        propsMap.put(Elements.UI_WIZARD_NEW_CONFIGURATION_COMMAND_QM_NAME_LABEL, String.valueOf(cmdConnectionData.getQueueManagerName()) + " " + Elements.UI_WIZARD_NEW_CONFIGURATION_CONNECTION_ON_LABEL + " '" + cmdConnectionData.getHostname() + '(' + cmdConnectionData.getPort() + ")'");
                    }
                    propsMap.put(Elements.UI_WIZARD_NEW_CONFIGURATION_TYPE_LABEL, Elements.UI_NODE_USING_GLOBAL_CONFIGURATION_LABEL);
                    propsMap.put(Elements.UI_WIZARD_NEW_CONFIGURATION_PATH_LABEL, propertyFiles.getPropertySet(configurationObj.getName()).getPath());
                }
                catch (ParameterException parameterException) {
                }
                catch (ConfigurationException configurationException) {
                }
                catch (InternalException internalException) {}
            } else {
                this.titleLabel.setText(MessageFormat.format(Elements.UI_CONTENT_CONFIGURATION_SET, settings.getConfigurationName()));
                propsMap.put(Elements.UI_WIZARD_NEW_CONFIGURATION_NAME_LABEL, settings.getConfigurationName());
                propsMap.put(Elements.UI_WIZARD_NEW_CONFIGURATION_LOG_SUBSCRIPTION_LABEL, settings.getSubscriptionType());
                if (settings.getCoordQueueManager() != null) {
                    propsMap.put(Elements.UI_WIZARD_NEW_CONFIGURATION_COORD_QM_NAME_LABEL, settings.getCoordQueueManager().getTreeName());
                }
                if (settings.getCommandQueueManager() == null) {
                    propsMap.put(Elements.UI_WIZARD_NEW_CONFIGURATION_COMMAND_QM_NAME_LABEL, String.valueOf('<') + Elements.UI_WIZARD_NEW_CONFIGURATION_NOT_SELECTED_LABEL + '>');
                } else {
                    propsMap.put(Elements.UI_WIZARD_NEW_CONFIGURATION_COMMAND_QM_NAME_LABEL, settings.getCommandQueueManager().getTreeName());
                }
                propsMap.put(Elements.UI_WIZARD_NEW_CONFIGURATION_TYPE_LABEL, Elements.UI_NODE_USING_LOCAL_CONFIGURATION_LABEL);
            }
            this.tbv.setInput(propsMap);
            this.tbv.refresh();
            this.layout(true);
        }
    }

    public void refresh() {
        this.updatePage();
    }

    public void repaint() {
        this.layout(true);
    }

    public boolean isEnableRefreshAction() {
        return false;
    }

    public boolean isEnableSystemObjectsAction() {
        return false;
    }

    public void showSystemObjects(boolean show) {
    }

    public void instanceDeleted(Object object) {
    }
}

