/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.Icons;
import com.ibm.wmqfte.explorer.content.TransferLogPage;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class ConfigureColumnsAction
extends Action {
    private final TransferLogPage transferLog;

    public ConfigureColumnsAction(TransferLogPage transferLog) {
        this.transferLog = transferLog;
        this.setId("CONFIGURE_COLUMNS_ACTION");
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)Icons.columnPicker));
        this.setToolTipText(Elements.UI_CONTENT_TRANSFER_LOG_CHOOSE_COLUMNS_TITLE);
    }

    public void run() {
        List<TreeViewerColumn> displayedColumns = this.transferLog.getDisplayedColumns();
        ListSelectionDialog dialog = new ListSelectionDialog(this.transferLog.getShell(), this.transferLog.getAvailableColumns(), (IStructuredContentProvider)new ColumnContentProvider(), (ILabelProvider)new ColumnLabelProvider(), Elements.UI_CONTENT_TRANSFER_LOG_CHOOSE_COLUMNS_DESC);
        dialog.setTitle(Elements.UI_CONTENT_TRANSFER_LOG_CHOOSE_COLUMNS_TITLE);
        dialog.setInitialElementSelections(displayedColumns);
        dialog.create();
        ExplorerPlugin.setHelp((Control)dialog.getShell(), "com.ibm.wmqfte.explorer.context.UI_ConfigureLogHelp");
        int rc = dialog.open();
        if (rc == 0) {
            Object[] objs = dialog.getResult();
            TreeViewerColumn[] cols = new TreeViewerColumn[objs.length];
            System.arraycopy(objs, 0, cols, 0, objs.length);
            this.transferLog.setDisplayedColumns(Arrays.asList(cols));
        }
    }

    class ColumnContentProvider
    implements IStructuredContentProvider {
        ColumnContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ColumnLabelProvider
    extends LabelProvider {
        ColumnLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof TreeViewerColumn) {
                return ((TreeViewerColumn)element).getColumn().getImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof TreeViewerColumn) {
                return ((TreeViewerColumn)element).getColumn().getText();
            }
            return null;
        }
    }
}

