/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.wmqfte.explorer.utils.AgentStatus;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

class AgentStatusFilter
extends ViewerFilter {
    private static final String INVISIBLE_SEP = "\u00ff";
    private Pattern pattern;

    AgentStatusFilter() {
    }

    public void setFilter(String filter) {
        if (filter.trim().length() == 0) {
            this.pattern = null;
        } else {
            String f = filter;
            f = f.replace("\\", "\\\\");
            f = f.replace(".", "\\.");
            f = f.replace("*", ".*");
            this.pattern = Pattern.compile(INVISIBLE_SEP + f + INVISIBLE_SEP, 2);
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean result = true;
        if (this.pattern != null) {
            AgentStatus agentStatus = (AgentStatus)((Object)element);
            String compressed = agentStatus.generateCompressedString(INVISIBLE_SEP);
            Matcher m = this.pattern.matcher(compressed);
            result = m.find();
        }
        return result;
    }
}

