/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.content.AgentBridgeHostSorter;
import com.ibm.wmqfte.explorer.content.AgentBridgeTypeSorter;
import com.ibm.wmqfte.explorer.content.AgentBuildLevelSorter;
import com.ibm.wmqfte.explorer.content.AgentCDBridgeNodeHostLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentCDBridgeNodeHostSorter;
import com.ibm.wmqfte.explorer.content.AgentCDBridgeNodeNameLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentCDBridgeNodeNameSorter;
import com.ibm.wmqfte.explorer.content.AgentConfigureColumnsAction;
import com.ibm.wmqfte.explorer.content.AgentContentProvider;
import com.ibm.wmqfte.explorer.content.AgentContentSorterPage;
import com.ibm.wmqfte.explorer.content.AgentDescLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentDescriptionSorter;
import com.ibm.wmqfte.explorer.content.AgentDestTransferLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentDestintionTransferSorter;
import com.ibm.wmqfte.explorer.content.AgentNameLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentNameSorter;
import com.ibm.wmqfte.explorer.content.AgentOSLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentOSSorter;
import com.ibm.wmqfte.explorer.content.AgentQMgrChannelSorter;
import com.ibm.wmqfte.explorer.content.AgentQMgrHostSorter;
import com.ibm.wmqfte.explorer.content.AgentQMgrLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentQMgrNameSorter;
import com.ibm.wmqfte.explorer.content.AgentQMgrPortSorter;
import com.ibm.wmqfte.explorer.content.AgentQMgrStandbySorter;
import com.ibm.wmqfte.explorer.content.AgentQMgrTypeLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentQMgrTypeSorter;
import com.ibm.wmqfte.explorer.content.AgentQmgrChannelLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentQmgrHostLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentQmgrPortLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentSourceTransferSorter;
import com.ibm.wmqfte.explorer.content.AgentSrcTransferLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentStartTimeLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentStartTimeSorter;
import com.ibm.wmqfte.explorer.content.AgentStatusAgeLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentStatusAgeSorter;
import com.ibm.wmqfte.explorer.content.AgentStatusDestTransferLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentStatusFilter;
import com.ibm.wmqfte.explorer.content.AgentStatusPublishBridgeServerHostLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentStatusPublishBridgeTypeLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentStatusPublishBuildlevelLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentStatusPublishQMgrStandbyLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentStatusSorter;
import com.ibm.wmqfte.explorer.content.AgentTimeZoneLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentTimeZoneSorter;
import com.ibm.wmqfte.explorer.content.AgentTypeLabelProvider;
import com.ibm.wmqfte.explorer.content.AgentTypeSorter;
import com.ibm.wmqfte.explorer.content.ColumnTitleEnumeration;
import com.ibm.wmqfte.explorer.content.IFTEContentPage;
import com.ibm.wmqfte.explorer.content.MFTContentPage;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.treenode.MFTETreeNodeFactory;
import com.ibm.wmqfte.explorer.utils.AgentStatus;
import com.ibm.wmqfte.explorer.utils.AgentStatusFFDC;
import com.ibm.wmqfte.explorer.utils.PageUtils;
import com.ibm.wmqfte.explorer.utils.ProviderSorter;
import com.ibm.wmqfte.explorer.wizards.AgentControlWizard;
import com.ibm.wmqfte.utils.AgentStatusDetails;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.forms.FormColors;

public class AgentContentPage
extends MFTContentPage
implements IShellProvider,
IFTEContentPage,
Observer {
    private static final String AGENT_SETTINGS = "UI_SETTINGS_AGENT";
    private static final String MQ_TOOLBAR = "com.ibm.mq.explorer.content.toolbar.action";
    private static final int AGENT_STATUS_POLL_TIME = 30000;
    private TableViewer tv;
    private final Set<AgentStatus> agents = Collections.synchronizedSet(new LinkedHashSet());
    private List<TableViewerColumn> displayedColumns = new LinkedList<TableViewerColumn>();
    private final List<TableViewerColumn> availableColumns = new LinkedList<TableViewerColumn>();
    private final Map<TableColumn, Boolean> columnVisibility = new LinkedHashMap<TableColumn, Boolean>();
    private AgentConfigureColumnsAction configureColumnsToolBarButton;
    private boolean initialised = false;
    private String agentCoordination = null;
    private static final ProviderSorter ps = new ProviderSorter();
    private static final AgentColumns[] DEFAULT_COLUMNS;
    private static final String[] DEFAULT_COLUMNS_AS_STRING;

    static {
        ps.add(Elements.UI_CONTENT_AGENT_NAME, new AgentNameLabelProvider(), new AgentNameSorter());
        ps.add(Elements.UI_CONTENT_AGENT_DESC, new AgentDescLabelProvider(), new AgentDescriptionSorter());
        ps.add(Elements.UI_CONTENT_AGENT_TYPE, new AgentTypeLabelProvider(), new AgentTypeSorter());
        ps.add(Elements.UI_CONTENT_AGENT_QMGR, new AgentQMgrLabelProvider(), new AgentQMgrNameSorter());
        ps.add(Elements.UI_CONTENT_AGENT_STATUS, new AgentStatusDestTransferLabelProvider(), new AgentStatusSorter());
        ps.add(Elements.UI_CONTENT_AGENT_QMGR_TYPE, new AgentQMgrTypeLabelProvider(), new AgentQMgrTypeSorter());
        ps.add(Elements.UI_CONTENT_AGENT_HOST, new AgentQmgrHostLabelProvider(), new AgentQMgrHostSorter());
        ps.add(Elements.UI_CONTENT_AGENT_PORT, new AgentQmgrPortLabelProvider(), new AgentQMgrPortSorter());
        ps.add(Elements.UI_CONTENT_AGENT_CHANNEL, new AgentQmgrChannelLabelProvider(), new AgentQMgrChannelSorter());
        ps.add(Elements.UI_CONTENT_AGENT_QMGR_STANDBY, new AgentStatusPublishQMgrStandbyLabelProvider(), new AgentQMgrStandbySorter());
        ps.add(Elements.UI_CONTENT_AGENT_TIMEZONE, new AgentTimeZoneLabelProvider(), new AgentTimeZoneSorter());
        ps.add(Elements.UI_CONTENT_AGENT_OS, new AgentOSLabelProvider(), new AgentOSSorter());
        ps.add(Elements.UI_CONTENT_AGENT_SRC_TRANSFERS, new AgentSrcTransferLabelProvider(), new AgentSourceTransferSorter());
        ps.add(Elements.UI_CONTENT_AGENT_DEST_TRANSFERS, new AgentDestTransferLabelProvider(), new AgentDestintionTransferSorter());
        ps.add(Elements.UI_CONTENT_AGENT_BUILD_LEVEL, new AgentStatusPublishBuildlevelLabelProvider(), new AgentBuildLevelSorter());
        ps.add(Elements.UI_CONTENT_AGENT_BRIDGE_TYPE, new AgentStatusPublishBridgeTypeLabelProvider(), new AgentBridgeTypeSorter());
        ps.add(Elements.UI_CONTENT_AGENT_BRIDGE_SERVER_HOST, new AgentStatusPublishBridgeServerHostLabelProvider(), new AgentBridgeHostSorter());
        ps.add(Elements.UI_CONTENT_AGENT_CD_BRIDGE_NODE_NAME, new AgentCDBridgeNodeNameLabelProvider(), new AgentCDBridgeNodeNameSorter());
        ps.add(Elements.UI_CONTENT_AGENT_CD_BRIDGE_NODE_HOST, new AgentCDBridgeNodeHostLabelProvider(), new AgentCDBridgeNodeHostSorter());
        ps.add(Elements.UI_CONTENT_AGENT_STATUS_AGE, new AgentStatusAgeLabelProvider(), new AgentStatusAgeSorter());
        ps.add(Elements.UI_CONTENT_AGENT_START_TIME, new AgentStartTimeLabelProvider(), new AgentStartTimeSorter());
        DEFAULT_COLUMNS = new AgentColumns[]{AgentColumns.AGENT_NAME, AgentColumns.DESCRIPTION, AgentColumns.STATUS, AgentColumns.SOURCE_TRANSFERS, AgentColumns.DESTINATION_TRANSFERS, AgentColumns.STATUS_AGE};
        DEFAULT_COLUMNS_AS_STRING = new String[]{AgentColumns.AGENT_NAME.toString(), AgentColumns.DESCRIPTION.toString(), AgentColumns.STATUS.toString(), AgentColumns.SOURCE_TRANSFERS.toString(), AgentColumns.DESTINATION_TRANSFERS.toString(), AgentColumns.STATUS_AGE.toString()};
    }

    @Override
    List<String> getColumnTitlesWithTimeZone() {
        return new ArrayList<String>();
    }

    @Override
    AgentColumns findColumnByPersistedString(String str) {
        return AgentColumns.findByPersistedString(str);
    }

    @Override
    AgentColumns findColumnByColumnTitle(String str) {
        return AgentColumns.findByColumnTitle(str);
    }

    AgentColumns[] getDefaultColumns() {
        return DEFAULT_COLUMNS;
    }

    public AgentContentPage(Composite parent, int style) {
        super(parent, style);
    }

    public String getId() {
        return "com.ibm.wmqfte.explorer.agents";
    }

    public void init() {
        this.setVisible(false);
        int numColumns = 1;
        this.setLayout((Layout)new GridLayout(numColumns, true));
        ContentTitleBar contentTitleBar = new ContentTitleBar((Composite)this, 0);
        contentTitleBar.setText(MessageFormat.format(Elements.UI_CONTENT_AGENTS_TITLE, this.agentCoordination));
        GridData titleBarData = new GridData(768);
        titleBarData.horizontalSpan = numColumns;
        contentTitleBar.setLayoutData((Object)titleBarData);
        Label label = new Label((Composite)this, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = numColumns;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = numColumns;
        gridData.heightHint = 5;
        label.setLayoutData((Object)gridData);
        ExplorerPlugin.setHelp((Control)this, "com.ibm.wmqfte.explorer.context.UI_AgentStatusHelp");
        if (this.environmentCheck()) {
            this.tv = new TableViewer((Composite)this, 68354);
            this.tv.setContentProvider((IContentProvider)new AgentContentProvider());
            this.defineColumns();
            this.tv.setSorter((ViewerSorter)new AgentNameSorter());
            this.tv.setInput(this.agents);
            Table table = this.tv.getTable();
            table.setHeaderVisible(true);
            table.setLayoutData((Object)new GridData(4, 4, true, true));
            table.setData(this.tv.getInput());
            this.setupTable(table);
            Label label2 = new Label((Composite)this, 258);
            label2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, numColumns, 1));
            final AgentStatusFilter filter = new AgentStatusFilter();
            this.tv.addFilter((ViewerFilter)filter);
            Label filterLabel = new Label((Composite)this, 0);
            filterLabel.setText(Elements.UI_CONTENT_STATUS_FILTER_LABEL);
            final Text filterText = new Text((Composite)this, 2052);
            filterText.setText("*");
            filter.setFilter(filterText.getText());
            filterText.setLayoutData((Object)new GridData(4, -1, true, false));
            filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    filter.setFilter(filterText.getText());
                    AgentContentPage.this.tv.refresh();
                    Table table = AgentContentPage.this.tv.getTable();
                    if (!table.isDisposed()) {
                        AgentContentPage.this.setupTable(table);
                    }
                }
            });
            this.addContextMenu(this.tv);
            this.addDoubleClickListener(this.tv);
            this.configureColumnsToolBarButton = new AgentConfigureColumnsAction(this);
            this.setVisible(true);
            this.startPollingRefresh();
            TableColumn[] tableColumnArray = this.tv.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn c = tableColumnArray[n2];
                c.addControlListener(new ControlListener(){

                    public void controlMoved(ControlEvent e) {
                        AgentContentPage.this.saveDefaultColumns();
                    }

                    public void controlResized(ControlEvent e) {
                    }
                });
                ++n2;
            }
            this.saveDefaultColumns();
            this.initialised = true;
        }
    }

    private void addContextMenu(final TableViewer tv) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AgentContentPage.this.fillContextMenu(tv, manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)tv.getTable());
        tv.getTable().setMenu(menu);
    }

    private void fillContextMenu(TableViewer viewer, IMenuManager manager) {
        List selectionList = ((IStructuredSelection)this.tv.getSelection()).toList();
        final AgentStatus selectedItem = this.getSingleAgentStatus(selectionList);
        Action controlAgent = new Action(){

            public void run() {
                AgentControlWizard wizard = new AgentControlWizard(selectedItem);
                WizardDialog dialog = new WizardDialog(AgentContentPage.this.getShell(), (IWizard)wizard){

                    protected void createButtonsForButtonBar(Composite parent) {
                        super.createButtonsForButtonBar(parent);
                        Button finishButton = this.getButton(16);
                        finishButton.setText(IDialogConstants.CLOSE_LABEL);
                        Button cancelButton = this.getButton(1);
                        cancelButton.setEnabled(false);
                        cancelButton.setVisible(false);
                    }
                };
                try {
                    dialog.create();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                dialog.setBlockOnOpen(false);
                dialog.open();
            }
        };
        controlAgent.setText(Elements.UI_CONTENT_CONTROL_AGENT_BUTTON);
        controlAgent.setEnabled(selectionList.size() == 1);
        manager.add((IAction)controlAgent);
        manager.add((IContributionItem)new Separator());
        PropertyDialogAction propertyDialog = new PropertyDialogAction((IShellProvider)this, (ISelectionProvider)this.tv);
        propertyDialog.setEnabled(selectedItem != null);
        propertyDialog.setText(Elements.UI_STATUS_PROPERTY);
        manager.add((IAction)propertyDialog);
    }

    private void addDoubleClickListener(final TableViewer tv) {
        tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o;
                ISelection s = tv.getSelection();
                if (s instanceof IStructuredSelection && (o = ((IStructuredSelection)s).getFirstElement()) instanceof AgentStatus) {
                    PropertyDialogAction propertyDialog = new PropertyDialogAction((IShellProvider)new SameShellProvider(tv.getControl()), (ISelectionProvider)tv);
                    propertyDialog.run();
                }
            }
        });
    }

    private void addColumn(String title, ColumnLabelProvider provider, ViewerSorter sorter, boolean display) {
        if (provider != null) {
            TableViewerColumn tvc = new TableViewerColumn(this.tv, 16384);
            tvc.setLabelProvider((CellLabelProvider)provider);
            final TableColumn c = tvc.getColumn();
            c.setMoveable(true);
            c.setResizable(true);
            c.addControlListener(PageUtils.minWidthControlListener);
            c.setText(title);
            this.availableColumns.add(tvc);
            if (display) {
                this.columnVisibility.put(c, Boolean.TRUE);
                this.displayedColumns.add(tvc);
            } else {
                this.columnVisibility.put(c, Boolean.FALSE);
                c.setWidth(0);
            }
            if (sorter != null && sorter instanceof AgentContentSorterPage) {
                final AgentContentSorterPage agentSorter = (AgentContentSorterPage)sorter;
                c.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        agentSorter.setColumn(AgentContentPage.this.tv, c);
                        AgentContentPage.this.refresh();
                    }
                });
            }
        }
    }

    private void saveDefaultColumns() {
        PageUtils.saveDefaultColumns(AGENT_SETTINGS, this, (Viewer)this.getTableViewer());
    }

    private boolean environmentCheck() {
        boolean result = true;
        return result;
    }

    public void setActive(boolean isActive) {
        super.setActive(isActive);
        if (this.initialised) {
            IActionBars bars = this.getViewPart().getViewSite().getActionBars();
            IToolBarManager manager = bars.getToolBarManager();
            if (isActive) {
                manager.insertAfter(MQ_TOOLBAR, (IAction)this.configureColumnsToolBarButton);
            } else {
                manager.remove(this.configureColumnsToolBarButton.getId());
            }
            manager.update(true);
            bars.updateActionBars();
        }
    }

    public void clear() {
        if (this.agents != null) {
            this.agents.clear();
        }
        this.refresh();
    }

    private void defineColumns() {
        ColumnTitleEnumeration[] displayColumns = this.loadDefaultColumns();
        ArrayList<String> displayColumnsAsString = new ArrayList<String>();
        ColumnTitleEnumeration[] columnTitleEnumerationArray = displayColumns;
        int n = displayColumns.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnTitleEnumeration col = columnTitleEnumerationArray[n2];
            ColumnLabelProvider provider = ps.getProvider(col.getColumnTitle());
            ViewerSorter sorter = ps.getSorter(col.getColumnTitle());
            if (provider != null && sorter != null) {
                this.addColumn(ps.adjustColumnName(col.getColumnTitle()), provider, sorter, true);
                displayColumnsAsString.add(col.getColumnTitle());
            }
            ++n2;
        }
        List<String> nonDisplayColumns = ps.missingList(displayColumnsAsString);
        for (String item : nonDisplayColumns) {
            ColumnLabelProvider provider = ps.getProvider(item);
            ViewerSorter sorter = ps.getSorter(item);
            if (provider == null || sorter == null) continue;
            this.addColumn(ps.adjustColumnName(item), provider, sorter, false);
        }
    }

    private ColumnTitleEnumeration[] loadDefaultColumns() {
        String[] savedColumnOrder = PageUtils.loadDefaultColumns(AGENT_SETTINGS, DEFAULT_COLUMNS_AS_STRING);
        return this.convertColumns(savedColumnOrder);
    }

    public TableViewer getTableViewer() {
        return this.tv;
    }

    public void setupTable(Table table) {
        GC g = new GC((Drawable)table);
        g.setFont(table.getFont());
        int columnCount = table.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            TableColumn column = table.getColumn(i);
            if (this.columnVisibility.get(column).booleanValue() && column.getWidth() == 0 || !column.getResizable()) {
                int longestWidth = g.stringExtent((String)column.getText()).x;
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    String text = tableItem.getText(i);
                    int width = g.stringExtent((String)text).x;
                    if (width > longestWidth) {
                        longestWidth = width;
                    }
                    ++n2;
                }
                column.setWidth(longestWidth + 25);
                if (column.equals(table.getSortColumn())) {
                    column.setWidth(column.getWidth() + 25);
                }
            }
            ++i;
        }
        i = 0;
        while (i < table.getItemCount()) {
            TableItem row = table.getItem(i);
            Object o = row.getData();
            if (o instanceof AgentStatus) {
                AgentStatusDetails.AgentOnLineStatus status = ((AgentStatus)((Object)o)).interpretAgentStatus();
                if (status.doesRequireAttention()) {
                    row.setBackground(this.getListBackgroundColor(3));
                } else if (status.isOnLine()) {
                    row.setBackground(this.getListBackgroundColor(5));
                } else {
                    row.setBackground(this.getListBackgroundColor(7));
                }
            }
            ++i;
        }
        g.dispose();
    }

    private Color getListBackgroundColor(int color) {
        Display display = Display.getCurrent();
        Color bg = display.getSystemColor(25);
        if (display.getHighContrast()) {
            return bg;
        }
        RGB blend = FormColors.blend((RGB)display.getSystemColor(color).getRGB(), (RGB)bg.getRGB(), (int)15);
        return new Color((Device)display, blend);
    }

    public void setDisplayedColumns(List<TableViewerColumn> columns) {
        GC g = new GC((Drawable)this.tv.getTable());
        g.setFont(this.tv.getTable().getFont());
        for (TableViewerColumn tvc : this.availableColumns) {
            TableColumn c = tvc.getColumn();
            c.removeControlListener(PageUtils.minWidthControlListener);
            if (columns.contains(tvc)) {
                this.columnVisibility.put(c, Boolean.TRUE);
                c.setWidth(Math.max(c.getWidth(), g.stringExtent((String)c.getText()).x + 25));
            } else {
                this.columnVisibility.put(c, Boolean.FALSE);
                c.setWidth(0);
            }
            c.addControlListener(PageUtils.minWidthControlListener);
        }
        this.displayedColumns = columns;
        g.dispose();
        this.saveDefaultColumns();
        if (!Display.getCurrent().isDisposed()) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AgentContentPage.this.tv.refresh();
                    Table table = AgentContentPage.this.tv.getTable();
                    if (!table.isDisposed()) {
                        AgentContentPage.this.setupTable(table);
                    }
                }
            });
        }
    }

    public List<TableViewerColumn> getDisplayedColumns() {
        return this.displayedColumns;
    }

    public List<TableViewerColumn> getAvailableColumns() {
        return this.availableColumns;
    }

    public void instanceDeleted(Object object) {
    }

    public boolean isEnableRefreshAction() {
        return true;
    }

    public boolean isEnableSystemObjectsAction() {
        return false;
    }

    public void refresh() {
        if (!this.isDisposed() && this.getDisplay() != null && !this.getDisplay().isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AgentContentPage.this.tv != null) {
                        AgentContentPage.this.tv.refresh();
                        Table table = AgentContentPage.this.tv.getTable();
                        if (!table.isDisposed()) {
                            AgentContentPage.this.setupTable(table);
                        }
                    }
                }
            });
        }
    }

    public void startPollingRefresh() {
        final Display display = this.getDisplay();
        Runnable timer = new Runnable(){

            @Override
            public void run() {
                if (display != null && !display.isDisposed()) {
                    AgentContentPage.this.refresh();
                    display.timerExec(30000, (Runnable)this);
                }
            }
        };
        display.timerExec(30000, timer);
    }

    public void repaint() {
    }

    public void setObject(MQExtObject object) {
    }

    public void showSystemObjects(boolean show) {
    }

    public void updatePage() {
    }

    @Override
    public synchronized void startup() {
        Subscription.getAgentStatusDetailsProvider().addObserver(this);
        TreeSet<AgentStatusDetails> availableAgents = new TreeSet<AgentStatusDetails>(Subscription.getAgentStatusDetailsProvider().getAvailableAgents());
        for (AgentStatusDetails agentStatusDetails : availableAgents) {
            try {
                AgentStatus as = new AgentStatus(agentStatusDetails.toBytes());
                if (Trace.isTracing) {
                    Trace.data((Level)Level.FINEST, (String)"AgentContentPage", (String)"startup", (String)("Adding agent " + as.toString() + " to agent set."));
                }
                this.agents.add(as);
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void shutdown() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable observable, Object data) {
        if (data instanceof AgentStatusDetails) {
            try {
                AgentContentPage agentContentPage = this;
                synchronized (agentContentPage) {
                    this.agentCoordination = MFTETreeNodeFactory.getConnectedCoordQmgr().toString();
                    AgentStatus updatedAgent = new AgentStatus(((AgentStatusDetails)data).toBytes());
                    if (this.agents.contains((Object)updatedAgent)) {
                        this.agents.remove((Object)updatedAgent);
                        updatedAgent.setTimeShift();
                    }
                    if (updatedAgent.hasAgentName() && !updatedAgent.isDeleted()) {
                        if (Trace.isTracing) {
                            Trace.data((Level)Level.FINEST, (String)"AgentContentPage", (String)"update", (String)("Adding agent " + updatedAgent.toString() + " to agent set."));
                        }
                        this.agents.add(updatedAgent);
                    }
                }
                this.refresh();
            }
            catch (UnsupportedEncodingException ex) {
                AgentStatusFFDC.capture(this, "update", "FFDC_001", ex);
            }
            catch (IOException ex) {
                AgentStatusFFDC.capture(this, "update", "FFDC_002", ex);
            }
        }
    }

    private AgentStatus getSingleAgentStatus(List<?> selectionList) {
        AgentStatus a;
        Object o;
        AgentStatus item = null;
        if (selectionList.size() == 1 && (o = selectionList.get(0)) instanceof AgentStatus && (a = (AgentStatus)((Object)o)).toXML() != null && a.toXML().length() > 0) {
            item = a;
        }
        return item;
    }

    static enum AgentColumns implements ColumnTitleEnumeration
    {
        AGENT_NAME(Elements.UI_CONTENT_AGENT_NAME),
        DESCRIPTION(Elements.UI_CONTENT_AGENT_DESC),
        TYPE(Elements.UI_CONTENT_AGENT_TYPE),
        QMGR(Elements.UI_CONTENT_AGENT_QMGR),
        STATUS(Elements.UI_CONTENT_AGENT_STATUS),
        QMGR_TYPE(Elements.UI_CONTENT_AGENT_QMGR_TYPE),
        HOST(Elements.UI_CONTENT_AGENT_HOST),
        PORT(Elements.UI_CONTENT_AGENT_PORT),
        CHANNEL(Elements.UI_CONTENT_AGENT_CHANNEL),
        QMGR_STANDBY(Elements.UI_CONTENT_AGENT_QMGR_STANDBY),
        TIMEZONE(Elements.UI_CONTENT_AGENT_TIMEZONE),
        OS(Elements.UI_CONTENT_AGENT_OS),
        SOURCE_TRANSFERS(Elements.UI_CONTENT_AGENT_SRC_TRANSFERS),
        DESTINATION_TRANSFERS(Elements.UI_CONTENT_AGENT_DEST_TRANSFERS),
        BUILD_LEVEL(Elements.UI_CONTENT_AGENT_BUILD_LEVEL),
        BRIDGE_TYPE(Elements.UI_CONTENT_AGENT_BRIDGE_TYPE),
        BRIDGE_SERVER_HOST(Elements.UI_CONTENT_AGENT_BRIDGE_SERVER_HOST),
        CD_BRIDGE_NODE_NAME(Elements.UI_CONTENT_AGENT_CD_BRIDGE_NODE_NAME),
        CD_BRIDGE_NODE_HOST(Elements.UI_CONTENT_AGENT_CD_BRIDGE_NODE_HOST),
        STATUS_AGE(Elements.UI_CONTENT_AGENT_STATUS_AGE),
        START_TIME(Elements.UI_CONTENT_AGENT_START_TIME);

        private final String columnTitle;

        private AgentColumns(String columnTitle) {
            this.columnTitle = columnTitle;
        }

        @Override
        public String getColumnTitle() {
            return this.columnTitle;
        }

        public static AgentColumns findByPersistedString(String str) {
            AgentColumns[] agentColumnsArray = AgentColumns.values();
            int n = agentColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                AgentColumns col = agentColumnsArray[n2];
                if (col.toString().equals(str)) {
                    return col;
                }
                ++n2;
            }
            return null;
        }

        public static AgentColumns findByColumnTitle(String title) {
            AgentColumns[] agentColumnsArray = AgentColumns.values();
            int n = agentColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                AgentColumns col = agentColumnsArray[n2];
                if (col.columnTitle.equals(title)) {
                    return col;
                }
                ++n2;
            }
            return null;
        }
    }
}

