/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer.content;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.Icons;
import com.ibm.wmqfte.explorer.content.AgentContentPage;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class AgentConfigureColumnsAction
extends Action {
    private final AgentContentPage agentContent;

    public AgentConfigureColumnsAction(AgentContentPage agentContent) {
        this.agentContent = agentContent;
        this.setId("CONFIGURE_COLUMNS_ACTION");
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)Icons.columnPicker));
        this.setToolTipText(Elements.UI_CONTENT_AGENT_CHOOSE_COLUMNS_TITLE);
    }

    public void run() {
        List<TableViewerColumn> displayedColumns = this.agentContent.getDisplayedColumns();
        ListSelectionDialog dialog = new ListSelectionDialog(this.agentContent.getShell(), this.agentContent.getAvailableColumns(), (IStructuredContentProvider)new ColumnContentProvider(), (ILabelProvider)new ColumnLabelProvider(), Elements.UI_CONTENT_AGENT_CHOOSE_COLUMNS_DESC);
        dialog.setTitle(Elements.UI_CONTENT_STATUS_CHOOSE_COLUMNS_TITLE);
        dialog.setInitialElementSelections(displayedColumns);
        dialog.create();
        ExplorerPlugin.setHelp((Control)dialog.getShell(), "com.ibm.wmqfte.explorer.context.UI_ConfigureStatusHelp");
        int rc = dialog.open();
        if (rc == 0) {
            Object[] objs = dialog.getResult();
            TableViewerColumn[] cols = new TableViewerColumn[objs.length];
            System.arraycopy(objs, 0, cols, 0, objs.length);
            this.agentContent.setDisplayedColumns(Arrays.asList(cols));
        } else {
            this.agentContent.setDisplayedColumns(displayedColumns);
        }
    }

    class ColumnContentProvider
    implements IStructuredContentProvider {
        ColumnContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ColumnLabelProvider
    extends LabelProvider {
        ColumnLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof TableViewerColumn) {
                return ((TableViewerColumn)element).getColumn().getImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof TableViewerColumn) {
                return ((TableViewerColumn)element).getColumn().getText();
            }
            return null;
        }
    }
}

