/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer;

import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ExplorerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static String[] availableIDs;
    private static final List<String> usefulIDs;
    final List<String> subTypes = Arrays.asList("DURABLE", "NON_DURABLE");
    private static final IPreferenceStore ps;
    private Combo timezone;
    private Spinner maxTransferLog;
    private Spinner maxTransferProgress;
    private Combo subscriptionType;

    static {
        String[] availableIDs;
        usefulIDs = new LinkedList<String>();
        ps = ExplorerPlugin.getDefault().getPreferenceStore();
        String[] stringArray = availableIDs = TimeZone.getAvailableIDs();
        int n = availableIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            usefulIDs.add(id);
            ++n2;
        }
        Collections.sort(usefulIDs);
        ExplorerPreferencePage.availableIDs = usefulIDs.toArray(new String[0]);
    }

    protected Control createContents(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, true));
        c.setLayoutData((Object)new GridData(4, 1, true, false));
        ExplorerPlugin.setHelp((Control)c, "com.ibm.wmqfte.explorer.context.UI_PreferencePageHelp");
        ExplorerPlugin.setHelp(this.getControl(), "com.ibm.wmqfte.explorer.context.UI_PreferencePageHelp");
        Group g = new Group(c, 0);
        g.setText(Elements.UI_PREFS_TITLE);
        g.setLayout((Layout)new GridLayout(2, false));
        g.setLayoutData((Object)new GridData(4, 1, true, false));
        Label timezoneLabel = new Label((Composite)g, 0);
        timezoneLabel.setText(Elements.UI_PREFS_TIMEZONE_TITLE);
        timezoneLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.timezone = new Combo((Composite)g, 8);
        this.timezone.setItems(availableIDs);
        this.timezone.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.selectCurrentTimeZone();
        Label spacer = new Label((Composite)g, 0);
        spacer.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 2, 1));
        spacer.setVisible(false);
        Composite maxLimits = new Composite((Composite)g, 0);
        maxLimits.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        GridLayout gl = new GridLayout(4, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        maxLimits.setLayout((Layout)gl);
        Label maxTransferLogLabel = new Label(maxLimits, 0);
        maxTransferLogLabel.setText(String.valueOf(Elements.UI_PREFS_MAX_TRANSFER_LOG_LABEL) + ':');
        maxTransferLogLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.maxTransferLog = new Spinner(maxLimits, 2048);
        this.maxTransferLog.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.maxTransferLog.setMinimum(1);
        this.maxTransferLog.setIncrement(1);
        this.maxTransferLog.setMaximum(9999);
        this.selectCurrentMaxTransferLog();
        Label maxTransferProgressLabel = new Label(maxLimits, 0);
        maxTransferProgressLabel.setText(String.valueOf(Elements.UI_PREFS_MAX_TRANSFER_PROGRESS_LABEL) + ':');
        maxTransferProgressLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.maxTransferProgress = new Spinner(maxLimits, 2048);
        this.maxTransferProgress.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.maxTransferProgress.setMinimum(1);
        this.maxTransferProgress.setIncrement(1);
        this.maxTransferProgress.setMaximum(9999);
        this.selectCurrentMaxTransferProgress();
        g = new Group(c, 0);
        g.setText(Elements.UI_GLOBAL_CONFIGURATION_SUBSCRIPTION_TYPE_TITLE);
        g.setLayout((Layout)new GridLayout(2, false));
        g.setLayoutData((Object)new GridData(4, 1, true, false));
        Text subscriptionText = new Text((Composite)g, 74);
        subscriptionText.setText(Elements.UI_PREFERENCES_PAGE_GLOBAL_SUBSCRIPTION_DESC);
        subscriptionText.setBackground(Display.getCurrent().getSystemColor(22));
        GridData gd = new GridData(4, 0x1000000, false, false, 2, 1);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        subscriptionText.setLayoutData((Object)gd);
        Label subscriptionLabel = new Label((Composite)g, 0);
        subscriptionLabel.setText(String.valueOf(Elements.UI_PREFS_TRANSFER_LOG_SUBSCRIPTION_LABEL) + ':');
        subscriptionLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.subscriptionType = new Combo((Composite)g, 8);
        this.subscriptionType.setItems(this.subTypes.toArray(new String[0]));
        this.subscriptionType.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.selectCurrentSubscriptionType();
        Composite noteComposite = new Composite((Composite)g, 0);
        GridLayout noteLayout = new GridLayout(2, false);
        noteLayout.marginWidth = 0;
        noteLayout.marginHeight = 0;
        noteComposite.setLayout((Layout)noteLayout);
        GridData gd2 = new GridData(4, 0x1000000, false, false, 2, 1);
        noteComposite.setLayoutData((Object)gd2);
        Label noteLabel = new Label(noteComposite, 0);
        noteLabel.setText(Elements.UI_PREFERENCES_PAGE_NOTE);
        noteLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        noteLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        Text messageLabel = new Text(noteComposite, 74);
        messageLabel.setText(Elements.UI_PREFERENCES_PAGE_GLOBAL_SUBSCRIPTION_WARNING);
        messageLabel.setBackground(Display.getCurrent().getSystemColor(22));
        GridData gd3 = new GridData(4, 0x1000000, false, false);
        gd3.widthHint = this.convertWidthInCharsToPixels(80);
        messageLabel.setLayoutData((Object)gd3);
        return c;
    }

    private void selectCurrentTimeZone() {
        String value = ps.getString("com.ibm.wmqfte.explorer.timezone");
        if (value == null) {
            value = ps.getDefaultString("com.ibm.wmqfte.explorer.timezone");
        }
        this.timezone.select(Collections.binarySearch(usefulIDs, value));
    }

    private void selectCurrentMaxTransferLog() {
        int value = ps.getInt("com.ibm.wmqfte.explorer.transferlog.max");
        if (value == 0) {
            value = ps.getDefaultInt("com.ibm.wmqfte.explorer.transferlog.max");
        }
        this.maxTransferLog.setSelection(value);
    }

    private void selectCurrentMaxTransferProgress() {
        int value = ps.getInt("com.ibm.wmqfte.explorer.transferprogress.max");
        if (value == 0) {
            value = ps.getDefaultInt("com.ibm.wmqfte.explorer.transferprogress.max");
        }
        this.maxTransferProgress.setSelection(value);
    }

    private void selectCurrentSubscriptionType() {
        String value = ps.getString("com.ibm.wmqfte.explorer.transferlog.subscription.type");
        if (value == null) {
            value = ps.getDefaultString("com.ibm.wmqfte.explorer.transferlog.subscription.type");
        }
        this.subscriptionType.select(Collections.binarySearch(this.subTypes, value));
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ExplorerPlugin.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        ps.setValue("com.ibm.wmqfte.explorer.timezone", ps.getDefaultString("com.ibm.wmqfte.explorer.timezone"));
        ps.setValue("com.ibm.wmqfte.explorer.transferlog.max", ps.getDefaultInt("com.ibm.wmqfte.explorer.transferlog.max"));
        ps.setValue("com.ibm.wmqfte.explorer.transferprogress.max", ps.getDefaultInt("com.ibm.wmqfte.explorer.transferprogress.max"));
        ps.setValue("com.ibm.wmqfte.explorer.transferlog.subscription.type", ps.getDefaultString("com.ibm.wmqfte.explorer.transferlog.subscription.type"));
        this.selectCurrentTimeZone();
        this.selectCurrentMaxTransferLog();
        this.selectCurrentMaxTransferProgress();
        this.selectCurrentSubscriptionType();
    }

    public boolean performOk() {
        ps.setValue("com.ibm.wmqfte.explorer.timezone", this.timezone.getText());
        ps.setValue("com.ibm.wmqfte.explorer.transferlog.max", this.maxTransferLog.getSelection());
        ps.setValue("com.ibm.wmqfte.explorer.transferprogress.max", this.maxTransferProgress.getSelection());
        ps.setValue("com.ibm.wmqfte.explorer.transferlog.subscription.type", this.subscriptionType.getText());
        return super.performOk();
    }
}

