/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.RASProperties;
import com.ibm.mq.explorer.trace.weaving.TraceAspect;
import com.ibm.wmqfte.explorer.content.TransferLogFactory;
import com.ibm.wmqfte.explorer.content.TransferLogPage;
import com.ibm.wmqfte.explorer.data.FTEConfigurationPersistence;
import com.ibm.wmqfte.explorer.data.Subscription;
import com.ibm.wmqfte.explorer.ras.ExplorerTraceHandler;
import com.ibm.wmqfte.ras.RAS;
import com.ibm.wmqfte.ras.RASEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.TimeZone;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ExplorerPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.wmqfte.explorer";
    public static final String COORD_ID = "com.ibm.wmqfte.explorer.coordination";
    public static final String CONTEXT_ID = "com.ibm.wmqfte.explorer.context";
    public static final String TIMEZONE_PREFERENCE = "com.ibm.wmqfte.explorer.timezone";
    public static final String TRANSFERLOG_MAX_PREFERENCE = "com.ibm.wmqfte.explorer.transferlog.max";
    public static final String TRANSFERPROGRESS_MAX_PREFERENCE = "com.ibm.wmqfte.explorer.transferprogress.max";
    public static final String TRANSFERLOG_SUBSCRIPTION_TYPE_PREFERENCE = "com.ibm.wmqfte.explorer.transferlog.subscription.type";
    public static final String ITEM_TRANSFER_MODE = "com.ibm.wmqfte.explorer.7041.item.transferMode.type";
    public static final String ITEM_SOURCE_DISPOSITION = "com.ibm.wmqfte.explorer.7041.item.sourceDisposition.type";
    public static final String ITEM_DESTINATION_DISPOSITION = "com.ibm.wmqfte.explorer.7041.item.destinationDisposition.type";
    public static final String ITEM_CHECKSUM = "com.ibm.wmqfte.explorer.7041.item.checksum.type";
    public static final String UI_WIZARD_NEW_TRANSFER_SETTINGS = "UI_WIZARD_NEW_TRANSFER_SETTINGS";
    public static final String UI_WIZARD_QUEUE_TEMPLATES_SECTION = "UI_WIZARD_QUEUE_TEMPLATES_SECTION";
    public static final String UI_WIZARD_QUEUE_TEMPLATES = "UI_WIZARD_QUEUE_TEMPLATES";
    public static final String UI_WIZARD_DATASET_TEMPLATES_SECTION = "UI_WIZARD_DATASET_TEMPLATES_SECTION";
    public static final String UI_WIZARD_DATASET_TEMPLATES = "UI_WIZARD_DATASET_TEMPLATES";
    public static final String UI_WIZARD_NEW_MONITOR_SETTINGS = "UI_WIZARD_NEW_MONITOR_SETTINGS";
    public static final String UI_SETTINGS_SUBSCRIPTIONS = "UI_SETTINGS_SUBSCRIPTIONS";
    public static final String UI_SETTINGS_FIRSTRUN = "UI_SETTINGS_FIRSTRUN";
    public static final String BUNDLE_SHORT_NAME = TraceAspect.getBundleShortName((String)"com.ibm.wmqfte.explorer");
    private static ExplorerPlugin instance;
    private static IPreferenceStore ps;
    private File stateLocationFile;

    static {
        ps = null;
    }

    public ExplorerPlugin() {
        if (instance == null) {
            instance = this;
        }
    }

    public ExplorerPlugin(IPreferenceStore prefStore) {
        this();
        ps = prefStore;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        try {
            String installLocation = ExplorerPlugin.getInstallLocation();
            System.setProperty("com.ibm.wmqfte.product.root", installLocation);
        }
        catch (IOException iOException) {
            System.setProperty("com.ibm.wmqfte.product.root", System.getProperty("user.dir"));
        }
        RAS.initialize((RASEnvironment)RASEnvironment.EXPLORER);
        RASProperties rasProperties = CommonServices.getRASProperties();
        if (rasProperties.isFFDCPathnameValid()) {
            String ffdcPathname = rasProperties.getFFDCPathname();
            if (Trace.isTracing) {
                Trace.data((Level)Level.INFO, (String)"ExplorerPlugin", (String)"start", (String)("Diagnostics.Java.FFDC.Destination.Pathname=" + ffdcPathname), (String)BUNDLE_SHORT_NAME);
            }
            RAS.setFFDCPath((String)ffdcPathname);
        }
        if (Trace.isTracing) {
            String level;
            RAS.setTraceHandler((Handler)new ExplorerTraceHandler());
            RAS.setLogDirectoryName(null);
            RAS.setRootName((String)rasProperties.getTracePathname());
            switch (rasProperties.getTraceDetail()) {
                case -2147483648: {
                    level = "com.ibm=verbose";
                    break;
                }
                case 400: {
                    level = "com.ibm=moderate";
                    break;
                }
                case 500: {
                    level = "com.ibm=flow";
                    break;
                }
                default: {
                    level = "";
                }
            }
            RAS.setLevel((String)level);
            Trace.data((Level)Level.INFO, (String)"ExplorerPlugin", (String)"start", (String)("RAS.getRootName()=" + RAS.getRootName()), (String)BUNDLE_SHORT_NAME);
            Trace.data((Level)Level.INFO, (String)"ExplorerPlugin", (String)"start", (String)("RAS.getLevel()=" + level), (String)BUNDLE_SHORT_NAME);
        }
        this.stateLocationFile = this.getStateLocation().toFile();
    }

    public File getStateLocationFile() {
        return this.stateLocationFile;
    }

    private void checkDebugLevel() {
        String level = Platform.getDebugOption((String)"com.ibm.wmqfte.explorer/debug/level");
        if (level != null) {
            RAS.setLevel((String)level);
        }
    }

    public static String getInstallLocation() throws IOException {
        String mqInstallRootDir;
        Trace.data((Level)Level.INFO, (String)"ExplorerPlugin", (String)"start", (String)("osgi.install.area=" + System.getProperty("osgi.install.area")), (String)BUNDLE_SHORT_NAME);
        String installArea = System.getenv("MQ_INSTALLATION_PATH");
        if (installArea != null && !installArea.trim().isEmpty()) {
            mqInstallRootDir = installArea;
            Trace.data((Level)Level.INFO, (String)"ExplorerPlugin", (String)"start", (String)("MQ_INSTALLATION_PATH=" + mqInstallRootDir), (String)BUNDLE_SHORT_NAME);
        } else {
            installArea = System.getProperty("osgi.install.area").substring(5);
            File eclipseDir = new File(installArea).getCanonicalFile();
            Trace.data((Level)Level.INFO, (String)"ExplorerPlugin", (String)"start", (String)("eclipseDir=" + eclipseDir.getAbsolutePath()), (String)BUNDLE_SHORT_NAME);
            mqInstallRootDir = eclipseDir.getParentFile().getParent();
            Trace.data((Level)Level.INFO, (String)"ExplorerPlugin", (String)"start", (String)("mqInstallRootDir=" + mqInstallRootDir), (String)BUNDLE_SHORT_NAME);
        }
        String mqftInstallDir = String.valueOf(mqInstallRootDir) + File.separatorChar + "mqft";
        Trace.data((Level)Level.INFO, (String)"ExplorerPlugin", (String)"start", (String)("mqftInstallDir=" + mqftInstallDir), (String)BUNDLE_SHORT_NAME);
        return mqftInstallDir;
    }

    public static ExplorerPlugin getDefault() {
        return instance;
    }

    public static TimeZone getTimeZone() {
        IPreferenceStore ps = instance.getPreferenceStore();
        String id = ps.getString(TIMEZONE_PREFERENCE);
        if (id == null) {
            id = ps.getDefaultString(TIMEZONE_PREFERENCE);
        }
        return TimeZone.getTimeZone(id);
    }

    public static int getTransferLogMax() {
        IPreferenceStore ps = instance.getPreferenceStore();
        int max = ps.getInt(TRANSFERLOG_MAX_PREFERENCE);
        if (max == 0) {
            max = ps.getDefaultInt(TRANSFERLOG_MAX_PREFERENCE);
        }
        return max;
    }

    public static int getTransferProgressMax() {
        IPreferenceStore ps = instance.getPreferenceStore();
        int max = ps.getInt(TRANSFERPROGRESS_MAX_PREFERENCE);
        if (max == 0) {
            max = ps.getDefaultInt(TRANSFERPROGRESS_MAX_PREFERENCE);
        }
        return max;
    }

    public static String getTransferLogSubscriptionType() {
        IPreferenceStore ps = instance.getPreferenceStore();
        String type = ps.getString(TRANSFERLOG_SUBSCRIPTION_TYPE_PREFERENCE);
        if (type == null) {
            type = ps.getDefaultString(TRANSFERLOG_SUBSCRIPTION_TYPE_PREFERENCE);
        }
        return type;
    }

    public static void setHelp(IAction action, String contextId) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp(action, contextId);
    }

    public static void setHelp(Control control, String contextId) {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
            helpSystem.setHelp(control, contextId);
        }
    }

    public static void cleanup() {
        Subscription.shutdown();
        TransferLogPage transferLogPage = TransferLogFactory.getTransferLogPage();
        if (transferLogPage != null) {
            transferLogPage.shutdown();
        }
        try {
            FTEConfigurationPersistence.save();
        }
        catch (IOException iOException) {}
    }

    public IPreferenceStore getPreferenceStore() {
        if (ps != null) {
            return ps;
        }
        return super.getPreferenceStore();
    }
}

