/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer;

import com.ibm.mq.commonservices.Common;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.ui.extensions.ExplorerNotifyEvent;
import com.ibm.mq.explorer.ui.extensions.IExplorerNotifyAdapter;
import com.ibm.mq.explorer.ui.extensions.MQQmgrExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.wmqfte.explorer.Elements;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import com.ibm.wmqfte.explorer.Messages;
import com.ibm.wmqfte.explorer.data.FTEConfigurationPersistence;
import com.ibm.wmqfte.explorer.treenode.CoordTreeNode;
import com.ibm.wmqfte.explorer.treenode.MFTETreeNodeFactory;
import com.ibm.wmqfte.explorer.wizards.v2.FTEConfigurationWizardSettings;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ExplorerNotify
extends IExplorerNotifyAdapter {
    private static final boolean cancelEvent = true;
    private static final boolean allowEvent = false;

    public void explorerClosing() {
        super.explorerClosing();
        ExplorerPlugin.cleanup();
    }

    public void pluginDisabled(ExplorerNotifyEvent event) {
        super.pluginDisabled(event);
    }

    public void pluginEnabled(ExplorerNotifyEvent event) {
        super.pluginEnabled(event);
    }

    public boolean isPreventRemoveQueueManager(ExplorerNotifyEvent event) {
        return this.isPreventDeleteQueueManager(event);
    }

    public boolean isPreventDeleteQueueManager(ExplorerNotifyEvent event) {
        CoordTreeNode coordNode;
        TreeNode node;
        TreeNode[] treeNodeArray;
        ArrayList<String> removeList = new ArrayList<String>();
        ArrayList<String> disableList = new ArrayList<String>();
        Object object = event.getObject();
        if (object instanceof MQQmgrExtObject) {
            MQQmgrExtObject qmgr = (MQQmgrExtObject)object;
            String qmgrUniqueId = this.getUniqueId(qmgr);
            for (FTEConfigurationWizardSettings settings : FTEConfigurationPersistence.getConfigurationSets().values()) {
                String explanation;
                String title;
                UiQueueManager coordQueueManager = settings.getCoordQueueManager();
                UiQueueManager commandQueueManager = settings.getCommandQueueManager();
                if (settings.getCoordQueueManager() != null && this.getUniqueId(coordQueueManager).equals(qmgrUniqueId)) {
                    title = MessageFormat.format(Elements.UI_CONTENT_ACTIONS_REMOVE_FILE_TRANSFER_CONFIG_TITLE, settings.getConfigurationName());
                    explanation = MessageFormat.format(Elements.UI_CONTENT_ACTIONS_REMOVE_FILE_TRANSFER_CONFIG_CONFIRM_LABEL, settings.getConfigurationName(), qmgr.getName());
                    if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)(String.valueOf(explanation) + Common.LINE_SEPARATOR + Common.LINE_SEPARATOR + Messages.BFGUI0008_CONFIRM_DELETE_CONFIGURATION))) {
                        removeList.add(settings.getConfigurationName());
                        continue;
                    }
                    return true;
                }
                if (settings.getCommandQueueManager() == null || !this.getUniqueId(commandQueueManager).equals(qmgrUniqueId)) continue;
                title = MessageFormat.format(Elements.UI_CONTENT_ACTIONS_BREAK_FILE_TRANSFER_CONFIG_TITLE, settings.getConfigurationName());
                explanation = MessageFormat.format(Elements.UI_CONTENT_ACTIONS_BREAK_FILE_TRANSFER_CONFIG_CONFIRM_LABEL, settings.getConfigurationName(), qmgr.getName());
                if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)(String.valueOf(explanation) + Common.LINE_SEPARATOR + Common.LINE_SEPARATOR + Messages.BFGUI0009_CONFIRM_BREAK_CONFIGURATION))) {
                    disableList.add(settings.getConfigurationName());
                    continue;
                }
                return true;
            }
        }
        TreeNode baseNode = MFTETreeNodeFactory.getBaseNode();
        TreeNode[] children = baseNode.getChildren();
        if (!removeList.isEmpty()) {
            for (String configurationName : removeList) {
                treeNodeArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    node = treeNodeArray[n2];
                    if (node instanceof CoordTreeNode && (coordNode = (CoordTreeNode)node).getConfiguration() != null && configurationName.equals(coordNode.getConfiguration().getConfigurationName())) {
                        if (coordNode.isConnected()) {
                            coordNode.disconnect();
                        }
                        FTEConfigurationPersistence.remove(configurationName);
                        baseNode.removeChildFromNode(node);
                        baseNode.refresh();
                    }
                    ++n2;
                }
            }
            try {
                FTEConfigurationPersistence.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!disableList.isEmpty()) {
            for (String configurationName : disableList) {
                treeNodeArray = children;
                int n = children.length;
                int n3 = 0;
                while (n3 < n) {
                    node = treeNodeArray[n3];
                    if (node instanceof CoordTreeNode && (coordNode = (CoordTreeNode)node).getConfiguration() != null && configurationName.equals(coordNode.getConfiguration().getConfigurationName())) {
                        if (coordNode.isConnected()) {
                            coordNode.disconnect();
                        }
                        coordNode.getConfiguration().setCommandQueueManager(null);
                        FTEConfigurationPersistence.add(coordNode.getConfiguration());
                        baseNode.refresh();
                    }
                    ++n3;
                }
            }
            try {
                FTEConfigurationPersistence.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        baseNode.getParent().refresh();
        return false;
    }

    private String getUniqueId(UiQueueManager qmgrObj) {
        String uniqueId;
        Trace t = Trace.getInstance();
        DmQueueManager dmQmgrObj = qmgrObj.getDmQueueManagerObject();
        QueueManagerHandle queueManagerHandle = dmQmgrObj.getConnectionHandle().getQueueManagerHandle(t);
        int connectionType = queueManagerHandle.getConnectionType();
        switch (connectionType) {
            case 1: {
                uniqueId = dmQmgrObj.getTitle();
                break;
            }
            case 2: 
            case 5: {
                uniqueId = String.valueOf(dmQmgrObj.getTitle()) + "/" + queueManagerHandle.getHostName(t) + "/" + queueManagerHandle.getPortAddress(t) + "/" + queueManagerHandle.getChannel();
                break;
            }
            case 4: {
                uniqueId = String.valueOf(dmQmgrObj.getTitle()) + "/" + queueManagerHandle.getChannelDefTable();
                break;
            }
            case 3: {
                uniqueId = String.valueOf(dmQmgrObj.getTitle()) + "/" + queueManagerHandle.getViaQueueManagerName() + "/" + qmgrObj.getUUID(Trace.getInstance());
                break;
            }
            default: {
                uniqueId = dmQmgrObj.getTitle();
            }
        }
        return uniqueId;
    }

    private String getUniqueId(MQQmgrExtObject qmgrObj) {
        String uniqueId;
        int connectionType = qmgrObj.getConnectionType();
        switch (connectionType) {
            case 1: {
                uniqueId = qmgrObj.getName();
                break;
            }
            case 2: 
            case 5: {
                uniqueId = String.valueOf(qmgrObj.getName()) + "/" + qmgrObj.getHostName() + "/" + qmgrObj.getPortAddress() + "/" + qmgrObj.getChannelName();
                break;
            }
            case 4: {
                uniqueId = String.valueOf(qmgrObj.getName()) + "/" + qmgrObj.getChannelDefinitionTable();
                break;
            }
            case 3: {
                UiQueueManager uiObj = (UiQueueManager)qmgrObj.getInternalObject();
                uniqueId = String.valueOf(qmgrObj.getName()) + "/" + qmgrObj.getViaCommandQueueName() + "/" + uiObj.getUUID(Trace.getInstance());
                break;
            }
            default: {
                uniqueId = qmgrObj.getName();
            }
        }
        return uniqueId;
    }
}

