/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wmqfte.explorer;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.IExplorerRuntimeImportExport;
import com.ibm.wmqfte.explorer.ExplorerPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ExplorerImportExportPrefsFileTransfer
implements IExplorerRuntimeImportExport,
IExecutableExtension {
    public static final String SUBCATEGORY_ID_PREFS_MANAGED_FILE_TRANSFER = "com.ibm.mq.explorer.ui.subcategory.prefs.managedfiletransfer";
    protected static final String ROOT_NODE = "Preferences";
    private static final String MAIN_NODE = "Main";
    protected static final String VERSION_KEY = "FileVersion";
    protected static final String THIS_VERSION = "1.0.0";

    public boolean importData(String categoryId, String subcategoryId, IMemento input) {
        IMemento child;
        boolean result = false;
        if (categoryId.compareTo("com.ibm.mq.explorer.ui.category.preferences") == 0 && subcategoryId.compareTo(SUBCATEGORY_ID_PREFS_MANAGED_FILE_TRANSFER) == 0 && (child = input.getChild(MAIN_NODE)) != null) {
            IPreferenceStore preferenceStore = ExplorerPlugin.getDefault().getPreferenceStore();
            preferenceStore.setValue("com.ibm.wmqfte.explorer.timezone", this.getStringPreferenceValue(child, preferenceStore, "com.ibm.wmqfte.explorer.timezone"));
            preferenceStore.setValue("com.ibm.wmqfte.explorer.transferlog.max", this.getIntPreferenceValue(child, preferenceStore, "com.ibm.wmqfte.explorer.transferlog.max"));
            preferenceStore.setValue("com.ibm.wmqfte.explorer.transferprogress.max", this.getIntPreferenceValue(child, preferenceStore, "com.ibm.wmqfte.explorer.transferprogress.max"));
            preferenceStore.setValue("com.ibm.wmqfte.explorer.transferlog.subscription.type", this.getStringPreferenceValue(child, preferenceStore, "com.ibm.wmqfte.explorer.transferlog.subscription.type"));
            result = true;
        }
        return result;
    }

    public IMemento exportData(String categoryId, String subcategoryId) {
        XMLMemento rootWrite = null;
        if (categoryId.compareTo("com.ibm.mq.explorer.ui.category.preferences") == 0 && subcategoryId.compareTo(SUBCATEGORY_ID_PREFS_MANAGED_FILE_TRANSFER) == 0) {
            rootWrite = XMLMemento.createWriteRoot((String)ROOT_NODE);
            rootWrite.putString(VERSION_KEY, THIS_VERSION);
            IMemento mainWrite = ExplorerImportExportPrefsFileTransfer.openChild(Trace.getInstance(), (IMemento)rootWrite, MAIN_NODE);
            IPreferenceStore preferenceStore = ExplorerPlugin.getDefault().getPreferenceStore();
            mainWrite.putString("com.ibm.wmqfte.explorer.timezone", preferenceStore.getString("com.ibm.wmqfte.explorer.timezone"));
            mainWrite.putString("com.ibm.wmqfte.explorer.transferlog.max", preferenceStore.getString("com.ibm.wmqfte.explorer.transferlog.max"));
            mainWrite.putString("com.ibm.wmqfte.explorer.transferprogress.max", preferenceStore.getString("com.ibm.wmqfte.explorer.transferprogress.max"));
            mainWrite.putString("com.ibm.wmqfte.explorer.transferlog.subscription.type", preferenceStore.getString("com.ibm.wmqfte.explorer.transferlog.subscription.type"));
        }
        return rootWrite;
    }

    protected static IMemento openChild(Trace t, IMemento parent, String childName) {
        IMemento child = null;
        child = parent.getChild(childName);
        if (child == null) {
            child = parent.createChild(childName);
        }
        return child;
    }

    public String getStringPreferenceValue(IMemento xmlChild, IPreferenceStore preferenceStore, String preferenceKey) {
        String value = xmlChild.getString(preferenceKey);
        if (value == null) {
            value = preferenceStore.getDefaultString(preferenceKey);
        }
        return value;
    }

    public int getIntPreferenceValue(IMemento xmlChild, IPreferenceStore preferenceStore, String preferenceKey) {
        Integer value = xmlChild.getInteger(preferenceKey);
        if (value == null) {
            value = preferenceStore.getDefaultInt(preferenceKey);
        }
        return value;
    }

    public boolean persistData() {
        return true;
    }

    public boolean isDestructiveImport() {
        return true;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

