/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.cluster.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.cluster.Messages;
import com.ibm.mq.explorer.tests.coretests.cluster.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class FullRepositories
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests.cluster/src/com/ibm/mq/explorer/tests/coretests/cluster/internal/tests/FullRepositories.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    private static final String UNRESOLVED = "SYSTEM.TEMPQMGR.";
    private HashMap<String, HashSet<String>> fullreposqms;
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    private int NUMBER_OF_TEST_STAGES = 0;
    DmObjectFilter query = new DmObjectFilter(Trace.getDefault(), 70);

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.fullreposqms = new HashMap();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList qmgrs = this.getFilteredClusterQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 2;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = (DmQueueManager)qmgrs.get(i);
            ArrayList clusterMembers = this.syncDataModelQuery(t, nextQm, this.query);
            if (clusterMembers == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < clusterMembers.size()) {
                DmClusterQueueManager clusmbr = (DmClusterQueueManager)clusterMembers.get(j);
                this.storeClusterMember(t, clusmbr);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.analyseClusterMembers(t);
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void storeClusterMember(Trace t, DmClusterQueueManager mbr) {
        int repostype = FullRepositories.getAttr(t, (DmObject)mbr, 1085);
        if (repostype == 1) {
            String qmgrname;
            String clustername = mbr.getAttributeValue(t, 2029, 0);
            if (clustername == null) {
                clustername = "";
            }
            if ((qmgrname = mbr.getAttributeValue(t, 2031, 0)) == null) {
                qmgrname = UNRESOLVED;
            }
            if (!qmgrname.startsWith(UNRESOLVED)) {
                HashSet<String> full_repositories = this.fullreposqms.get(clustername);
                if (full_repositories == null) {
                    full_repositories = new HashSet();
                }
                full_repositories.add(qmgrname);
                this.fullreposqms.put(clustername, full_repositories);
            }
        }
    }

    private void analyseClusterMembers(Trace t) {
        Set<Map.Entry<String, HashSet<String>>> entries = this.fullreposqms.entrySet();
        for (Map.Entry<String, HashSet<String>> entry : entries) {
            String clustername = entry.getKey();
            HashSet<String> value = entry.getValue();
            if (value.size() != 1) continue;
            String qmgrname = value.iterator().next();
            this.testresults.add(new WMQTestResult(1, Messages.getString(t, "FullRepositories.onlyOne", new String[]{qmgrname, clustername}), qmgrname, this.getTestSubCategory()));
        }
    }
}

