/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.cluster.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmNamelist;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.CommonUtilities;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.cluster.Messages;
import com.ibm.mq.explorer.tests.coretests.cluster.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClusterNames
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests.cluster/src/com/ibm/mq/explorer/tests/coretests/cluster/internal/tests/ClusterNames.java";
    private ArrayList testresults = new ArrayList();
    private DmObjectFilter queuequery = null;
    private DmObjectFilter chansquery = null;
    private DmObjectFilter nlistsquery = null;
    private static final int NUMBER_OF_STAGES_PER_QMGR = 7;
    private int NUMBER_OF_TEST_STAGES = 0;
    private HashMap clusterNames;
    private ArrayList namelistNames;

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        this.clusterNames = new HashMap();
        int numqmgrs = 0;
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList qmgrs = this.getFilteredClusterQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 7;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            ArrayList namelists;
            ArrayList channels;
            ArrayList queues;
            this.namelistNames = new ArrayList();
            DmQueueManager nextQm = (DmQueueManager)qmgrs.get(i);
            if (this.queuequery == null) {
                this.queuequery = new DmObjectFilter(t, 13);
            }
            if ((queues = this.syncDataModelQuery(t, nextQm, this.queuequery)) == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < queues.size()) {
                DmObject nxtq = (DmObject)queues.get(j);
                this.analyseObject(t, nxtq, nextQm);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            if (this.chansquery == null) {
                this.chansquery = new DmObjectFilter(t, 25);
            }
            if ((channels = this.syncDataModelQuery(t, nextQm, this.chansquery)) == null) break;
            this.getGUIMonitor().worked(1);
            int j2 = 0;
            while (j2 < channels.size()) {
                DmObject nxtchan = (DmObject)channels.get(j2);
                this.analyseObject(t, nxtchan, nextQm);
                ++j2;
            }
            this.getGUIMonitor().worked(1);
            this.analyseQmgrAttrs(t, nextQm);
            this.getGUIMonitor().worked(1);
            if (this.nlistsquery == null) {
                this.nlistsquery = new DmObjectFilter(t, 36);
            }
            if ((namelists = this.syncDataModelQuery(t, nextQm, this.nlistsquery)) == null) break;
            this.getGUIMonitor().worked(1);
            this.analyseNamelists(t, namelists, nextQm);
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseObject(Trace t, DmObject obj, DmQueueManager qmgr) {
        String clusname = obj.getAttributeValue(t, 2029, 0);
        if (clusname == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ClusterNames.attrError", obj.getTitle()), ClusterNames.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "ClusterNames.analyseObject", 900, "Error encountered while getting cluster attr from object definition " + obj.getTitle());
            }
        } else if (clusname.equals("[not_found]") || clusname.length() == 0) {
            String clusnl = obj.getAttributeValue(t, 2030, 0);
            if (clusnl == null) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ClusterNames.namelistAttrError", obj.getTitle()), ClusterNames.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                if (Trace.isTracing) {
                    t.data(66, "ClusterNames.analyseObject", 900, "Error encountered while getting cluster namelist attr from object definition " + obj.getTitle());
                }
            } else if (!clusnl.equals("[not_found]") && clusnl.length() > 0) {
                this.namelistNames.add(clusnl);
            }
        } else {
            this.checkClusterName(t, clusname, obj, qmgr);
        }
    }

    private void analyseQmgrAttrs(Trace t, DmQueueManager qmgr) {
        String clusname = qmgr.getAttributeValue(t, 2035, 0);
        if (clusname == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ClusterNames.clusAttrErr", ClusterNames.getQueueManagerName(t, qmgr)), ClusterNames.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "ClusterNames.analyseQmgrAttrs", 900, "Error encountered while getting cluster attr from " + ClusterNames.getQueueManagerName(t, qmgr));
            }
        } else if (clusname.equals("[not_found]") || clusname.length() == 0) {
            String clusnl = qmgr.getAttributeValue(t, 2036, 0);
            if (clusnl == null) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ClusterNames.clusnlAttrErr", ClusterNames.getQueueManagerName(t, qmgr)), ClusterNames.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                if (Trace.isTracing) {
                    t.data(66, "ClusterNames.analyseQmgrAttrs", 900, "Error encountered while getting cluster namelist attr from " + ClusterNames.getQueueManagerName(t, qmgr));
                }
            } else if (!clusnl.equals("[not_found]") && clusnl.length() > 0) {
                this.namelistNames.add(clusnl);
            }
        } else {
            this.checkClusterName(t, clusname, (DmObject)qmgr, qmgr);
        }
    }

    private void checkClusterName(Trace t, String clusname, DmObject obj, DmQueueManager qmgr) {
        boolean seenThisBefore = false;
        Set entries = this.clusterNames.entrySet();
        for (Map.Entry entry : entries) {
            String clustername = (String)entry.getKey();
            if (clusname.equals(clustername)) {
                seenThisBefore = true;
                continue;
            }
            if (!clusname.equalsIgnoreCase(clustername)) continue;
            String occurence = (String)entry.getValue();
            String msg = Messages.getString(t, "ClusterNames.smilar", new String[]{clustername, occurence, clusname, obj.getTitle()});
            this.testresults.add(new WMQTestResult(1, msg, ClusterNames.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        }
        if (!seenThisBefore) {
            String new_occurence = obj.getTitle().equals(qmgr.getTitle()) ? Messages.getString(t, "ClusterNames.occurance", qmgr.getTitle()) : Messages.getString(t, "ClusterNames.clusteronqmgr", new String[]{obj.getTitle(), qmgr.getTitle()});
            this.clusterNames.put(clusname, new_occurence);
        }
    }

    private void analyseNamelists(Trace t, ArrayList objects, DmQueueManager qmgr) {
        int i = 0;
        while (i < this.namelistNames.size()) {
            String nlistcontents;
            String nxtNmlist = (String)this.namelistNames.get(i);
            DmNamelist nlistObj = this.getNamelist(t, nxtNmlist, objects);
            if (nlistObj != null && (nlistcontents = nlistObj.getAttributeValue(t, 2020, 0)).length() > 0) {
                String[] clusnames = CommonUtilities.convert((Trace)Trace.getDefault(), (String)nlistcontents, (String)",");
                int j = 0;
                while (j < clusnames.length) {
                    this.checkClusterName(t, clusnames[j], (DmObject)nlistObj, qmgr);
                    ++j;
                }
            }
            ++i;
        }
    }
}

