/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.cluster.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.cluster.Messages;
import com.ibm.mq.explorer.tests.coretests.cluster.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClusterAttr
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests.cluster/src/com/ibm/mq/explorer/tests/coretests/cluster/internal/tests/ClusterAttr.java";
    private ArrayList<WMQTestResult> testresults = new ArrayList();
    DmObjectFilter clussdrqry = new DmObjectFilter(Trace.getDefault(), 25, 9);
    DmObjectFilter clusrcvqry = new DmObjectFilter(Trace.getDefault(), 25, 8);
    private static final int NUMBER_OF_STAGES_PER_QMGR = 4;
    private int NUMBER_OF_TEST_STAGES = 0;
    private boolean includeSystemObjects = false;

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList qmgrs = this.getFilteredClusterQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 4;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = (DmQueueManager)qmgrs.get(i);
            ArrayList clusSdrChans = this.syncDataModelQuery(t, nextQm, this.clussdrqry);
            if (clusSdrChans == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < clusSdrChans.size()) {
                DmChannel nextChannel = (DmChannel)clusSdrChans.get(j);
                this.analyseChannel(t, nextChannel, nextQm);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ArrayList clusRcvChans = this.syncDataModelQuery(t, nextQm, this.clusrcvqry);
            if (clusRcvChans == null) break;
            this.getGUIMonitor().worked(1);
            int j2 = 0;
            while (j2 < clusRcvChans.size()) {
                DmChannel nextChannel = (DmChannel)clusRcvChans.get(j2);
                this.analyseChannel(t, nextChannel, nextQm);
                ++j2;
            }
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseChannel(Trace t, DmChannel channel, DmQueueManager qmgr) {
        String channelName = channel.getTitle();
        if (!this.includeSystemObjects && channelName.startsWith("SYSTEM.")) {
            return;
        }
        String clusattr = channel.getAttributeValue(t, 2029, 0);
        String clusnlattr = channel.getAttributeValue(t, 2030, 0);
        if (clusattr == null || clusnlattr == null) {
            this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ClusterAttr.attrError", channelName), ClusterAttr.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        } else if ((clusattr.equals("[not_found]") || clusattr.length() == 0) && (clusnlattr.equals("[not_found]") || clusnlattr.length() == 0)) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ClusterAttr.clusandNLmissing", channelName), ClusterAttr.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
        }
    }
}

