/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.cluster.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmNamelist;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.cluster.Messages;
import com.ibm.mq.explorer.tests.coretests.cluster.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.pcf.event.PCFFilter;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClusNamelists
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests.cluster/src/com/ibm/mq/explorer/tests/coretests/cluster/internal/tests/ClusNamelists.java";
    private ArrayList testresults = new ArrayList();
    PCFFilter clusnl = PCFFilter.getFilter((int)2030, (PCFFilter.Operation)PCFFilter.NOT_EQUAL, (String)"");
    DmObjectFilter nlist_query = new DmObjectFilter(Trace.getDefault(), 36);
    DmObjectFilter clusq_query = new DmObjectFilter(Trace.getDefault(), 13);
    DmObjectFilter sdrchanquery = new DmObjectFilter(Trace.getDefault(), 25, 9);
    DmObjectFilter rcvchanquery = new DmObjectFilter(Trace.getDefault(), 25, 8);
    private static final int NUMBER_OF_STAGES_PER_QMGR = 8;
    private int NUMBER_OF_TEST_STAGES = 0;
    private boolean includeSystemObjects = false;
    private ArrayList namelists = new ArrayList();

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.includeSystemObjects = PreferenceStoreManager.getIncludeSysObjsPreference();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList qmgrs = this.getFilteredClusterQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 8;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = (DmQueueManager)qmgrs.get(i);
            this.namelists = this.syncDataModelQuery(t, nextQm, this.nlist_query);
            if (this.namelists == null) break;
            this.getGUIMonitor().worked(1);
            ArrayList sdrChans = this.syncDataModelQuery(t, nextQm, this.sdrchanquery);
            if (sdrChans == null) break;
            this.getGUIMonitor().worked(1);
            int j = 0;
            while (j < sdrChans.size()) {
                DmChannel senderChannel = (DmChannel)sdrChans.get(j);
                this.analyseChannel(t, senderChannel, nextQm);
                ++j;
            }
            this.getGUIMonitor().worked(1);
            ArrayList rcvChans = this.syncDataModelQuery(t, nextQm, this.rcvchanquery);
            if (rcvChans == null) break;
            this.getGUIMonitor().worked(1);
            int j2 = 0;
            while (j2 < rcvChans.size()) {
                DmChannel receiverChannel = (DmChannel)rcvChans.get(j2);
                this.analyseChannel(t, receiverChannel, nextQm);
                ++j2;
            }
            this.getGUIMonitor().worked(1);
            ArrayList clusQueues = this.syncDataModelQuery(t, nextQm, this.clusq_query);
            if (clusQueues == null) break;
            this.getGUIMonitor().worked(1);
            int j3 = 0;
            while (j3 < clusQueues.size()) {
                DmQueue clusQueue = (DmQueue)clusQueues.get(j3);
                this.analyseQueue(t, clusQueue, nextQm);
                ++j3;
            }
            this.getGUIMonitor().worked(1);
            this.analyseQueueManager(t, nextQm);
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseChannel(Trace t, DmChannel channel, DmQueueManager qmgr) {
        String channelName = channel.getTitle();
        if (!this.includeSystemObjects && channelName.startsWith("SYSTEM.")) {
            return;
        }
        String clusnlname = channel.getAttributeValue(t, 2030, 0);
        if (clusnlname == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ClusNamelists.clusnlFromChannelAttrErr", channelName), ClusNamelists.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "ClusNamelists.analyseChannel", 900, "Error encountered while getting cluster namelist attr from channel definition " + channelName);
            }
        } else if (!clusnlname.equals("[not_found]") && clusnlname.length() != 0) {
            DmNamelist nlObj = this.getNamelist(t, clusnlname, this.namelists);
            if (nlObj == null) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ClusNamelists.namelistNotExistChannel", new String[]{channelName, clusnlname}), ClusNamelists.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            } else {
                String nlistcontents = nlObj.getAttributeValue(t, 2020, 0);
                if (nlistcontents.length() == 0) {
                    this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ClusNamelists.namelistEmptyChannel", new String[]{clusnlname, channelName}), ClusNamelists.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                }
            }
        }
    }

    private void analyseQueue(Trace t, DmQueue queue, DmQueueManager qmgr) {
        String queueName = queue.getTitle();
        if (!this.includeSystemObjects && queueName.startsWith("SYSTEM.")) {
            return;
        }
        String clusnlname = queue.getAttributeValue(t, 2030, 0);
        if (clusnlname == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ClusNamelists.clusnlFromQueueAttrErr", queueName), ClusNamelists.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "ClusNamelists.analyseQueue", 900, "Error encountered while getting cluster namelist attr from queue definition " + queueName);
            }
        } else if (!clusnlname.equals("[not_found]") && clusnlname.length() != 0) {
            DmNamelist nlObj = this.getNamelist(t, clusnlname, this.namelists);
            if (nlObj == null) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ClusNamelists.namelistNotExistQueue", new String[]{queueName, clusnlname}), ClusNamelists.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            } else {
                String nlistcontents = nlObj.getAttributeValue(t, 2020, 0);
                if (nlistcontents.length() == 0) {
                    this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ClusNamelists.namelistEmptyQueue", new String[]{clusnlname, queueName}), ClusNamelists.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                }
            }
        }
    }

    private void analyseQueueManager(Trace t, DmQueueManager qmgr) {
        String reposnl = qmgr.getAttributeValue(t, 2036, 0);
        if (reposnl == null) {
            this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ClusNamelists.clusnlFromReposNlErr", ClusNamelists.getQueueManagerName(t, qmgr)), ClusNamelists.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            if (Trace.isTracing) {
                t.data(66, "ClusNamelists.analyseQueueManager", 900, "Error encountered while getting reposnl attribute from " + ClusNamelists.getQueueManagerName(t, qmgr));
            }
        } else if (!reposnl.equals("[not_found]") && reposnl.length() != 0) {
            DmNamelist nlObj = this.getNamelist(t, reposnl, this.namelists);
            if (nlObj == null) {
                this.testresults.add(new WMQTestResult(2, Messages.getString(t, "ClusNamelists.namelistNotExistRepos", new String[]{qmgr.getTitle(), reposnl}), ClusNamelists.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
            } else {
                String nlistcontents = nlObj.getAttributeValue(t, 2020, 0);
                if (nlistcontents.length() == 0) {
                    this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ClusNamelists.namelistEmptyRepos", reposnl), ClusNamelists.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                }
            }
        }
    }
}

