/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.cluster.internal.tests;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueue;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.PreferenceStoreManager;
import com.ibm.mq.explorer.tests.coretests.cluster.Messages;
import com.ibm.mq.explorer.tests.coretests.cluster.internal.objects.WMQInternalTest;
import com.ibm.mq.explorer.tests.internal.actions.WMQTestEngine;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClusDefbind
extends WMQInternalTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests.cluster/src/com/ibm/mq/explorer/tests/coretests/cluster/internal/tests/ClusDefbind.java";
    private ArrayList testresults = new ArrayList();
    private static final int NUMBER_OF_STAGES_PER_QMGR = 2;
    private int NUMBER_OF_TEST_STAGES = 0;
    DmObjectFilter query = new DmObjectFilter(Trace.getDefault(), 1004);
    private HashMap<String, ArrayList<String>> alreadyreported = new HashMap();

    public void runTest(WMQTestEngine callback, IProgressMonitor guimonitor, MQExtObject[] contextObjects, TreeNode treenode) {
        Trace t = Trace.getDefault();
        super.runTest(callback, guimonitor, contextObjects, treenode);
        this.testresults = new ArrayList();
        int numqmgrs = 0;
        this.alreadyreported = new HashMap();
        boolean visibleQmgrsOnly = !PreferenceStoreManager.getIncludeHiddenQmgrsPreference();
        ArrayList qmgrs = this.getFilteredClusterQueueManagers(t, contextObjects, false, true, true, visibleQmgrsOnly, false);
        numqmgrs = qmgrs.size();
        this.NUMBER_OF_TEST_STAGES = numqmgrs * 2;
        guimonitor.beginTask(this.getTestName(), this.NUMBER_OF_TEST_STAGES);
        int i = 0;
        while (i < numqmgrs) {
            DmQueueManager nextQm = (DmQueueManager)qmgrs.get(i);
            ArrayList clusterQueues = this.syncDataModelQuery(t, nextQm, this.query);
            if (clusterQueues == null) break;
            this.getGUIMonitor().worked(1);
            this.analyseQueues(t, clusterQueues, nextQm);
            this.getGUIMonitor().worked(1);
            ++i;
        }
        this.testComplete(this.testresults.toArray(new WMQTestResult[this.testresults.size()]));
    }

    private void analyseQueues(Trace t, ArrayList clusqs, DmQueueManager qmgr) {
        String clustername;
        HashMap processedClusterQueues = new HashMap();
        int i = 0;
        while (i < clusqs.size()) {
            DmClusterQueue nxtQueue = (DmClusterQueue)clusqs.get(i);
            String queueName = nxtQueue.getTitle();
            clustername = nxtQueue.getAttributeValue(t, 2029, 0);
            String hostqmgrname = nxtQueue.getAttributeValue(t, 2031, 0);
            int defbindattr = ClusDefbind.getAttr(t, (DmObject)nxtQueue, 61);
            int defprtyattr = ClusDefbind.getAttr(t, (DmObject)nxtQueue, 6);
            int defpsistatt = ClusDefbind.getAttr(t, (DmObject)nxtQueue, 5);
            if (clustername != null && hostqmgrname != null && !clustername.equals("[not_found]") && clustername.length() > 0 && !hostqmgrname.equals("[not_found]") && hostqmgrname.length() > 0) {
                HashMap<String, Integer[]> queueStates;
                HashMap queueNames = (HashMap)processedClusterQueues.get(clustername);
                if (queueNames == null) {
                    queueNames = new HashMap();
                }
                if ((queueStates = (HashMap<String, Integer[]>)queueNames.get(queueName)) == null) {
                    queueStates = new HashMap<String, Integer[]>();
                }
                Integer[] attrs = new Integer[]{defbindattr, defprtyattr, defpsistatt};
                queueStates.put(hostqmgrname, attrs);
                queueNames.put(queueName, queueStates);
                processedClusterQueues.put(clustername, queueNames);
            }
            ++i;
        }
        Set entries = processedClusterQueues.entrySet();
        for (Map.Entry entry : entries) {
            clustername = (String)entry.getKey();
            HashMap queueNames = (HashMap)entry.getValue();
            Set qentries = queueNames.entrySet();
            for (Map.Entry qentry : qentries) {
                String queuename = (String)qentry.getKey();
                HashMap qInstances = (HashMap)qentry.getValue();
                ArrayList<String> repQueueNames = this.alreadyreported.get(clustername);
                if (repQueueNames == null) {
                    repQueueNames = new ArrayList();
                }
                if (repQueueNames.contains(queuename)) continue;
                int num_defbind_open = 0;
                int num_defbind_nfxd = 0;
                int num_defpsist_pers = 0;
                int num_defpsist_notp = 0;
                int num_defprty_0 = 0;
                int num_defprty_1 = 0;
                int num_defprty_2 = 0;
                int num_defprty_3 = 0;
                int num_defprty_4 = 0;
                int num_defprty_5 = 0;
                int num_defprty_6 = 0;
                int num_defprty_7 = 0;
                int num_defprty_8 = 0;
                int num_defprty_9 = 0;
                Set qmentries = qInstances.entrySet();
                for (Map.Entry qmentry : qmentries) {
                    Integer[] attrs = (Integer[])qmentry.getValue();
                    int defbindint = attrs[0];
                    if (defbindint == 0) {
                        ++num_defbind_open;
                    } else if (defbindint == 1) {
                        ++num_defbind_nfxd;
                    }
                    int defprtyint = attrs[1];
                    switch (defprtyint) {
                        case 0: {
                            ++num_defprty_0;
                            break;
                        }
                        case 1: {
                            ++num_defprty_1;
                            break;
                        }
                        case 2: {
                            ++num_defprty_2;
                            break;
                        }
                        case 3: {
                            ++num_defprty_3;
                            break;
                        }
                        case 4: {
                            ++num_defprty_4;
                            break;
                        }
                        case 5: {
                            ++num_defprty_5;
                            break;
                        }
                        case 6: {
                            ++num_defprty_6;
                            break;
                        }
                        case 7: {
                            ++num_defprty_7;
                            break;
                        }
                        case 8: {
                            ++num_defprty_8;
                            break;
                        }
                        case 9: {
                            ++num_defprty_9;
                        }
                    }
                    int defpsistint = attrs[2];
                    if (defpsistint == 1) {
                        ++num_defpsist_pers;
                        continue;
                    }
                    if (defpsistint != 0) continue;
                    ++num_defpsist_notp;
                }
                boolean reported = false;
                if (num_defbind_open > 0 && num_defbind_nfxd > 0) {
                    this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ClusDefbind.notFixedandOpen", new String[]{queuename, clustername, "" + num_defbind_open, "" + num_defbind_nfxd}), ClusDefbind.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                    reported = true;
                }
                int valsOverZero = 0;
                if (num_defprty_0 > 0) {
                    ++valsOverZero;
                }
                if (num_defprty_1 > 0) {
                    ++valsOverZero;
                }
                if (num_defprty_2 > 0) {
                    ++valsOverZero;
                }
                if (num_defprty_3 > 0) {
                    ++valsOverZero;
                }
                if (num_defprty_4 > 0) {
                    ++valsOverZero;
                }
                if (num_defprty_5 > 0) {
                    ++valsOverZero;
                }
                if (num_defprty_6 > 0) {
                    ++valsOverZero;
                }
                if (num_defprty_7 > 0) {
                    ++valsOverZero;
                }
                if (num_defprty_8 > 0) {
                    ++valsOverZero;
                }
                if (num_defprty_9 > 0) {
                    ++valsOverZero;
                }
                if (valsOverZero > 1) {
                    this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ClusDefbind.varyingDefPriority", new String[]{queuename, clustername}), ClusDefbind.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                    reported = true;
                }
                if (num_defpsist_pers > 0 && num_defpsist_notp > 0) {
                    this.testresults.add(new WMQTestResult(1, Messages.getString(t, "ClusDefbind.mismatchDefPersist", new String[]{queuename, clustername, "" + num_defpsist_pers, "" + num_defpsist_notp}), ClusDefbind.getQueueManagerName(t, qmgr), this.getTestSubCategory()));
                    reported = true;
                }
                if (!reported) continue;
                repQueueNames.add(queuename);
                this.alreadyreported.put(clustername, repQueueNames);
            }
        }
    }
}

