/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.tests.coretests.cluster.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.clusterplugin.internal.clusqmgr.UiClusterQueueManager;
import com.ibm.mq.explorer.clusterplugin.internal.objects.ClusterObject;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueue;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmNamelist;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmProcess;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.tests.WMQTest;
import com.ibm.mq.explorer.tests.coretests.cluster.Messages;
import com.ibm.mq.explorer.tests.internal.objects.WMQTestResult;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;

public abstract class WMQInternalTest
extends WMQTest {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.tests.coretests.cluster/src/com/ibm/mq/explorer/tests/coretests/cluster/internal/objects/WMQInternalTest.java";
    public static final String MQNAME_REGEXP = "[A-Za-z0-9._%]{1}[A-Za-z0-9./_%]*";

    public synchronized ArrayList syncDataModelQuery(Trace t, DmQueueManager qmgr, DmObjectFilter query) {
        ArrayList res = null;
        try {
            res = qmgr.getObjects(t, query, true);
        }
        catch (DmCoreException e1) {
            t.FFST(66, "WMQInternalTest.syncDataModelQuery", 0, 50016, 0, 0, "event returned from datamodel contained an exception", e1.getMessage(), "");
        }
        return res;
    }

    protected DmObject getDmObject(Trace t, String name, ArrayList objects) {
        DmObject res = null;
        int i = 0;
        while (i < objects.size()) {
            DmObject nxtObject = (DmObject)objects.get(i);
            if (name.equals(nxtObject.getTitle())) {
                res = nxtObject;
                break;
            }
            ++i;
        }
        return res;
    }

    protected DmQueue getQueue(Trace t, String qname, ArrayList queues) {
        DmQueue res = null;
        int i = 0;
        while (i < queues.size()) {
            DmQueue nxtQueue = (DmQueue)queues.get(i);
            if (qname.equals(nxtQueue.getTitle())) {
                res = nxtQueue;
                break;
            }
            ++i;
        }
        return res;
    }

    protected DmClusterQueue getClusterQueue(Trace t, String qname, ArrayList queues) {
        DmClusterQueue res = null;
        int i = 0;
        while (i < queues.size()) {
            DmClusterQueue nxtQueue = (DmClusterQueue)queues.get(i);
            if (qname.equals(nxtQueue.getTitle())) {
                res = nxtQueue;
                break;
            }
            ++i;
        }
        return res;
    }

    protected DmNamelist getNamelist(Trace t, String nlname, ArrayList namelists) {
        DmNamelist res = null;
        int i = 0;
        while (i < namelists.size()) {
            DmNamelist nxtNamelist = (DmNamelist)namelists.get(i);
            if (nlname.equals(nxtNamelist.getTitle())) {
                res = nxtNamelist;
            }
            ++i;
        }
        return res;
    }

    protected DmProcess getProcess(Trace t, String procname, ArrayList processes) {
        DmProcess res = null;
        int i = 0;
        while (i < processes.size()) {
            DmProcess nxtProcess = (DmProcess)processes.get(i);
            if (procname.equals(nxtProcess.getTitle())) {
                res = nxtProcess;
            }
            ++i;
        }
        return res;
    }

    protected DmChannel getChannel(Trace t, String channame, ArrayList channels) {
        DmChannel res = null;
        int i = 0;
        while (i < channels.size()) {
            DmChannel nxtChannel = (DmChannel)channels.get(i);
            if (channame.equals(nxtChannel.getTitle())) {
                res = nxtChannel;
                break;
            }
            ++i;
        }
        return res;
    }

    protected DmQueueManager getQueueManager(Trace t, String qmname, ArrayList qmgrs) {
        DmQueueManager res = null;
        int i = 0;
        while (i < qmgrs.size()) {
            DmQueueManager nxtQueueManager = (DmQueueManager)qmgrs.get(i);
            if (qmname.equals(nxtQueueManager.getTitle())) {
                res = nxtQueueManager;
                break;
            }
            ++i;
        }
        return res;
    }

    public static ArrayList getObjectTitles(Trace t, ArrayList objects) {
        ArrayList<String> names = new ArrayList<String>();
        int numItems = objects.size();
        int i = 0;
        while (i < numItems) {
            DmObject object = (DmObject)objects.get(i);
            names.add(object.getTitle());
            ++i;
        }
        return names;
    }

    public ArrayList getFilteredQueueManagers(Trace t, MQExtObject[] contextObjects, boolean localOnly, boolean runningOnly, boolean connectedOnly, boolean visibleOnly, boolean nonZOSonly) {
        ArrayList<DmQueueManager> allqmgrs = new ArrayList<DmQueueManager>();
        int k = 0;
        while (k < contextObjects.length) {
            UiQueueManager uiqm;
            DmQueueManager dmqm;
            MQExtObject ob = contextObjects[k];
            Object internal = ob.getInternalObject();
            if (internal != null && internal instanceof UiQueueManager && (dmqm = (uiqm = (UiQueueManager)internal).getDmQueueManagerObject()) != null) {
                allqmgrs.add(dmqm);
            }
            ++k;
        }
        ArrayList qmgrs = this.filterQueueManager(t, allqmgrs, localOnly, runningOnly, connectedOnly, visibleOnly, nonZOSonly);
        return qmgrs;
    }

    private ArrayList filterQueueManager(Trace t, ArrayList allqmgrs, boolean localOnly, boolean runningOnly, boolean connectedOnly, boolean visibleOnly, boolean nonZOSonly) {
        ArrayList<DmQueueManager> qmgrs = new ArrayList<DmQueueManager>();
        int i = 0;
        while (i < allqmgrs.size()) {
            boolean zosOkay;
            boolean connectedOkay;
            DmQueueManager nxtQmgr = (DmQueueManager)allqmgrs.get(i);
            boolean localOkay = !localOnly || nxtQmgr.isLocal();
            boolean runningOkay = !runningOnly || nxtQmgr.isRunning();
            boolean bl = connectedOkay = !connectedOnly || nxtQmgr.isConnected();
            if (!connectedOkay) {
                WMQTestResult res = new WMQTestResult(1, Messages.getString(t, "General.QmgrDisconnected", new String[]{this.getTestName(), nxtQmgr.getTreeName(t)}), WMQInternalTest.getQueueManagerName(t, nxtQmgr), this.getTestSubCategory());
                this.addTestResult(res);
            }
            boolean visibleOkay = !visibleOnly || nxtQmgr.isVisible(Trace.getDefault());
            boolean bl2 = zosOkay = !nonZOSonly || !nxtQmgr.isZos();
            if (localOkay && runningOkay && connectedOkay && visibleOkay && zosOkay) {
                qmgrs.add(nxtQmgr);
            }
            ++i;
        }
        return qmgrs;
    }

    public ArrayList getFilteredClusterQueueManagers(Trace t, MQExtObject[] contextObjects, boolean localOnly, boolean runningOnly, boolean connectedOnly, boolean visibleOnly, boolean nonZOSonly) {
        ArrayList res = new ArrayList();
        ArrayList<DmQueueManager> qmgrs = new ArrayList<DmQueueManager>();
        ArrayList<MQExtObject> nonClusterQmgrs = new ArrayList<MQExtObject>();
        int k = 0;
        while (k < contextObjects.length) {
            if (contextObjects[k] instanceof ClusterObject) {
                ClusterObject clObj = (ClusterObject)contextObjects[k];
                ArrayList clusterQms = new ArrayList(clObj.getFullRepositoryContainer().getClusterQueueManagers());
                ArrayList partialQms = new ArrayList(clObj.getPartRepositoryContainer().getClusterQueueManagers());
                clusterQms.addAll(partialQms);
                for (Object o : clusterQms) {
                    DmQueueManager dmQm;
                    UiClusterQueueManager uiClusQm;
                    DmClusterQueueManager dmClusQm;
                    if (!(o instanceof UiClusterQueueManager) || (dmClusQm = (uiClusQm = (UiClusterQueueManager)o).getDmClusterQueueManagerObject()) == null || (dmQm = dmClusQm.getRealQueueManager(t)) == null) continue;
                    qmgrs.add(dmQm);
                }
            } else {
                nonClusterQmgrs.add(contextObjects[k]);
            }
            ++k;
        }
        res.addAll(this.filterQueueManager(t, qmgrs, localOnly, runningOnly, connectedOnly, visibleOnly, nonZOSonly));
        if (nonClusterQmgrs.size() > 0) {
            res.addAll(this.getFilteredQueueManagers(t, nonClusterQmgrs.toArray(new MQExtObject[nonClusterQmgrs.size()]), localOnly, runningOnly, connectedOnly, visibleOnly, nonZOSonly));
        }
        return res;
    }

    public static String getQueueManagerName(Trace t, DmQueueManager qmgr) {
        String qmgrname = qmgr.getTreeName(t);
        return qmgrname;
    }

    public static int getAttr(Trace t, DmObject object, int attributeid) {
        int value = -1;
        Attr attrobject = object.getAttribute(t, attributeid, 0);
        if (attrobject == null) {
            String attrId = Integer.toString(attributeid);
            t.FFST(66, "WMQInternalTest.getAttr", 0, 50016, 0, 0, "failed to get the attribute", attrId, "");
        } else {
            Object typeattrInt = attrobject.getValue(t);
            if (typeattrInt != null) {
                value = (Integer)typeattrInt;
            }
        }
        return value;
    }
}

