/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.treenodes;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.pubsub.core.internal.base.PsDataModel;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiBrokerFactory;
import com.ibm.mq.explorer.pubsub.ui.internal.treenodes.PsTopicTreeNode;
import com.ibm.mq.explorer.ui.extensions.ITreeNodeFactory;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;

public class PsTopicTreeNodeFactory
implements ITreeNodeFactory {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/treenodes/PsTopicTreeNodeFactory.java";

    public void addChildrenToTreeNode(TreeNode parent) {
        UiQueueManager uiQM;
        MQExtObject extObj;
        Object internalObj;
        Trace t = Trace.getDefault();
        String parentId = parent.getId();
        if (parentId.startsWith("com.ibm.mq.explorer.treenode.qm.") && (internalObj = (extObj = (MQExtObject)parent.getObject()).getInternalObject()) instanceof UiQueueManager && (uiQM = (UiQueueManager)internalObj).isConnected() && !parent.isChildExist("com.ibm.mq.explorer.pubsub.ui.internal.treenodes.topics")) {
            DmQueueManager qm = uiQM.getDmQueueManagerObject();
            int commandLevel = qm.getCommandLevel();
            int platform = qm.getPlatform();
            if (Trace.isTracing) {
                t.data(66, "PsTopicTreeNodeFactory.addChildrenToTreeNode", 300, "Considering adding 'Topics' folder for qm=" + qm.getTitle() + ",cmdlevel=" + commandLevel + ",platform=" + platform);
            }
            if (platform != 1 && commandLevel >= 600 && commandLevel < 700) {
                PsBroker broker = PsDataModel.getPsBroker(t, qm);
                PsUiBrokerFactory factory = new PsUiBrokerFactory((UiMQObject)uiQM);
                UiMQObject obj = factory.create(t, broker, (UiMQObject)uiQM);
                MQExtObject brokerObj = obj.getExternalObject();
                PsTopicTreeNode topicTreeNode = new PsTopicTreeNode(parent, brokerObj);
                parent.addChildToNode((TreeNode)topicTreeNode, 0);
                if (Trace.isTracing) {
                    t.data(66, "PsTopicTreeNodeFactory.addChildrenToTreeNode", 300, "Folder 'Topics' added");
                }
            }
        }
    }
}

