/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsTopic;
import com.ibm.mq.explorer.pubsub.internal.base.PsPlugin;
import com.ibm.mq.explorer.pubsub.internal.util.PsError;
import com.ibm.mq.explorer.pubsub.ui.internal.dialogs.PsNewObjectWiz;
import com.ibm.mq.explorer.pubsub.ui.internal.dialogs.PsPublishTestDialog;
import com.ibm.mq.explorer.pubsub.ui.internal.dialogs.PsSubscribeTestDialog;
import com.ibm.mq.explorer.pubsub.ui.internal.menuactions.PsViewAction;
import com.ibm.mq.explorer.pubsub.ui.internal.menuactions.PsViewPublicationAction;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsPublisherNewObjectProvider;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsSubscriberNewObjectProvider;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiBroker;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiMQBrokerObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWizDlg;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.IDialogClosedListener;
import com.ibm.mq.explorer.ui.internal.properties.PropertyDlg;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PsUiTopic
extends PsUiMQBrokerObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/objects/PsUiTopic.java";

    public PsUiTopic(Trace t, IDmObject dmObj, PsUiBroker uiBroker) {
        super(t, dmObj);
        this.setOwningUiBroker(uiBroker);
        this.objectType = PsPlugin.getMessage(t, "Ps.Object.Type.Topic");
    }

    public int getDataModelObjectType(Trace t) {
        return 1501;
    }

    public String getId() {
        return "com.ibm.mq.explorer.pubsub.topic.topic";
    }

    public String toString() {
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            return dmObj.getTitle();
        }
        return "";
    }

    public void appendToContextMenu(Shell s, IMenuManager manager, Object contextObject) {
        Trace t = Trace.getDefault();
        final Shell thisShell = s;
        final PsUiTopic uiTopic = this;
        PsViewAction viewPublishers = new PsViewAction(t, 1, this);
        if (!((PsTopic)this.getDmObject()).isWildcardName()) {
            viewPublishers.setText(PsPlugin.getMessage(t, "Ps.Menu.ViewPublishers"));
            UiPlugin.getHelpSystem().setHelp((IAction)viewPublishers, "com.ibm.mq.explorer.pubsub.infopop.PS_ActionPublishers");
        } else {
            viewPublishers.setText(PsPlugin.getMessage(t, "Ps.Menu.IndirectPublishers"));
            UiPlugin.getHelpSystem().setHelp((IAction)viewPublishers, "com.ibm.mq.explorer.pubsub.infopop.PS_ActionIndirectPublishers");
        }
        PsViewAction viewSubscribers = new PsViewAction(t, 2, this);
        viewSubscribers.setText(PsPlugin.getMessage(t, "Ps.Menu.ViewSubscribers"));
        UiPlugin.getHelpSystem().setHelp((IAction)viewSubscribers, "com.ibm.mq.explorer.pubsub.infopop.PS_ActionSubscribers");
        Action registerPublisher = new Action(){

            public void run() {
                Trace t1 = Trace.getDefault();
                PsPublisherNewObjectProvider newPublisher = new PsPublisherNewObjectProvider(uiTopic);
                PsNewObjectWiz newPublisherWiz = new PsNewObjectWiz(t1, newPublisher);
                NewObjectWizDlg newObjectWizDlg = new NewObjectWizDlg(UiPlugin.getShell(), (IWizard)newPublisherWiz);
                newObjectWizDlg.create();
                newObjectWizDlg.open();
            }
        };
        registerPublisher.setText(PsPlugin.getMessage(t, "Ps.Menu.RegisterPublisher"));
        UiPlugin.getHelpSystem().setHelp((IAction)registerPublisher, "com.ibm.mq.explorer.pubsub.infopop.PS_ActionRegisterPublisherTopic");
        Action registerSubscriber = new Action(){

            public void run() {
                Trace t1 = Trace.getDefault();
                PsSubscriberNewObjectProvider newSubscriber = new PsSubscriberNewObjectProvider(uiTopic);
                PsNewObjectWiz newTopicWiz = new PsNewObjectWiz(t1, newSubscriber);
                NewObjectWizDlg newObjectWizDlg = new NewObjectWizDlg(UiPlugin.getShell(), (IWizard)newTopicWiz);
                newObjectWizDlg.create();
                newObjectWizDlg.open();
            }
        };
        registerSubscriber.setText(PsPlugin.getMessage(t, "Ps.Menu.RegisterSubscriber"));
        UiPlugin.getHelpSystem().setHelp((IAction)registerSubscriber, "com.ibm.mq.explorer.pubsub.infopop.PS_ActionRegisterSubscriberTopic");
        PsViewPublicationAction viewPublications = new PsViewPublicationAction(t, this);
        viewPublications.setText(PsPlugin.getMessage(t, "Ps.Menu.ViewPublication"));
        UiPlugin.getHelpSystem().setHelp((IAction)viewPublications, "com.ibm.mq.explorer.pubsub.infopop.PS_ActionViewRetainedPublication");
        Action clearPublication = new Action(){

            public void run() {
                Trace t1 = Trace.getDefault();
                int rc = 1;
                String msg = Message.format((String)PsPlugin.getMessage(t1, "Ps.ClearRetained.Message"), (String)uiTopic.getDmObject().toString(t1));
                rc = MessageBox.showYesNoMessage((Trace)t1, (Shell)thisShell, (String)msg, (int)1, null);
                if (rc == 0) {
                    if (((PsTopic)PsUiTopic.this.getDmObject()).isWildcardName()) {
                        msg = PsPlugin.getMessage(t1, "Ps.ClearRetained.Wildcard.Message");
                        rc = MessageBox.showYesNoMessage((Trace)t1, (Shell)thisShell, (String)msg, (int)1, null);
                        if (rc == 0) {
                            PsUiTopic.this.deletePublication(t1);
                        }
                    } else {
                        PsUiTopic.this.deletePublication(t1);
                    }
                }
            }
        };
        clearPublication.setText(PsPlugin.getMessage(t, "Ps.Menu.ClearPublication"));
        UiPlugin.getHelpSystem().setHelp((IAction)clearPublication, "com.ibm.mq.explorer.pubsub.infopop.PS_ActionClearRetainedPublication");
        Action publish = new Action(){

            public void run() {
                Trace t1 = Trace.getDefault();
                PsUiTopic.this.openPublishDialog(t1);
            }
        };
        publish.setText(PsPlugin.getMessage(t, "Ps.Menu.PublishMessage"));
        UiPlugin.getHelpSystem().setHelp((IAction)publish, "com.ibm.mq.explorer.pubsub.infopop.PS_ActionPublishTestMessage");
        Action subscribe = new Action(){

            public void run() {
                Trace t1 = Trace.getDefault();
                PsUiTopic.this.openSubscribeDialog(t1);
            }
        };
        subscribe.setText(PsPlugin.getMessage(t, "Ps.Menu.Subscribe"));
        UiPlugin.getHelpSystem().setHelp((IAction)subscribe, "com.ibm.mq.explorer.pubsub.infopop.PS_ActionSubscribe");
        Action properties = new Action(){

            public void run() {
                Trace t1 = Trace.getDefault();
                PropertyDlg propertyDlg = new PropertyDlg(t1, thisShell, 0);
                propertyDlg.addDialogClosedListener((IDialogClosedListener)uiTopic);
                propertyDlg.open(t1, (UiMQObject)uiTopic, !PsUiTopic.this.isChangeProperties(t1));
            }
        };
        properties.setText(PsPlugin.getMessage(t, "Ps.Menu.Properties"));
        UiPlugin.getHelpSystem().setHelp((IAction)properties, "com.ibm.mq.explorer.pubsub.infopop.PS_ActionProperties");
        manager.add((IAction)registerPublisher);
        if (((PsTopic)this.getDmObject()).isWildcardName()) {
            registerPublisher.setEnabled(false);
        }
        manager.add((IAction)registerSubscriber);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)viewPublishers);
        manager.add((IAction)viewSubscribers);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)viewPublications);
        manager.add((IAction)clearPublication);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)publish);
        if (((PsTopic)this.getDmObject()).isWildcardName()) {
            publish.setEnabled(false);
        }
        manager.add((IAction)subscribe);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)properties);
    }

    public void openPublishDialog(Trace t) {
        PsPublishTestDialog dialog = new PsPublishTestDialog(t, UiPlugin.getShell());
        dialog.open(t, this, "com.ibm.mq.explorer.pubsub.infopop.PS_TopicPublishTestMessageDialog");
    }

    public void openSubscribeDialog(Trace t) {
        PsSubscribeTestDialog dialog = new PsSubscribeTestDialog(t, UiPlugin.getShell());
        dialog.open(t, this, "com.ibm.mq.explorer.pubsub.infopop.PS_TopicSubscribeDialog");
    }

    public void deletePublication(Trace t) {
        this.busyDialog = new BusyDialog(this.shell, PsPlugin.getMessage(t, "Ps.ClearRetained.Busy"));
        ((PsTopic)this.getDmObject()).actionDeletePublication(t, (DmActionListener)this, 0);
        this.busyDialog.showDialog(t);
    }

    @Override
    public void dmActionDone(DmActionEvent event) {
        final Trace t = Trace.getDefault();
        final int rc = event.getReasonCode();
        final DmCoreException exc = event.getException();
        final int command = event.getCommand();
        final PsUiTopic uiTopic = this;
        if (Trace.isTracing) {
            t.data(66, "PsUiTopic.dmActionDone", 300, "dmActionDone event received: " + command + " completed with return code " + rc);
        }
        if (!UiPlugin.getShell().isDisposed()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Trace trace = Trace.getDefault();
                    PsUiTopic.this.busyDialog.closeDialog(trace);
                    switch (command) {
                        case 60: {
                            if (rc == 0) {
                                MessageBox.showSystemMessageById((Trace)trace, (Shell)UiPlugin.getShell(), (String)"AMQ4538", (String[])new String[]{uiTopic.getDmObject().toString(t)});
                                break;
                            }
                            String error = null;
                            error = PsError.getErrorMsg(t, rc);
                            if (error != null) {
                                MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)error);
                                break;
                            }
                            if (exc != null) {
                                MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)exc);
                                break;
                            }
                            MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)new DmCoreException("Reason code: " + rc, "Unknown", rc, 0, 1));
                            break;
                        }
                    }
                }
            });
        }
    }
}

