/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsSubscription;
import com.ibm.mq.explorer.pubsub.internal.base.PsPlugin;
import com.ibm.mq.explorer.pubsub.ui.internal.dialogs.PsSubIdentityDialog;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiBroker;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiMQBrokerObject;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiSubscriber;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.IDialogClosedListener;
import com.ibm.mq.explorer.ui.internal.properties.PropertyDlg;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Shell;

public class PsUiSubscription
extends PsUiMQBrokerObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/objects/PsUiSubscription.java";
    private Action deRegister = null;

    public PsUiSubscription(Trace t, IDmObject dmObj, PsUiBroker uiBroker) {
        super(t, dmObj);
        this.setOwningUiBroker(uiBroker);
        this.objectType = PsPlugin.getMessage(t, "Ps.Object.Type.Subscription");
    }

    public int getDataModelObjectType(Trace t) {
        return 1503;
    }

    public String getId() {
        return "com.ibm.mq.explorer.pubsub.topic.subscription";
    }

    public String toString() {
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            return dmObj.getTitle();
        }
        return "";
    }

    public void appendToContextMenu(Shell shell, IMenuManager manager, Object contextObject) {
        Trace t = Trace.getDefault();
        final Object context = contextObject;
        final Shell thisShell = shell;
        final PsUiSubscription uiSubscription = this;
        if (this.deRegister == null) {
            this.deRegister = new Action(){

                public void run() {
                    Trace t1 = Trace.getDefault();
                    PsUiSubscription.this.deregister(t1, context);
                }
            };
        }
        this.deRegister.setText(PsPlugin.getMessage(t, "Ps.Menu.Unsubscribe"));
        UiUtils.setHelp((IAction)this.deRegister, (String)"com.ibm.mq.explorer.pubsub.infopop.PS_ActionUnsubscribe");
        Action removeSubIdentity = new Action(){

            public void run() {
                Trace t1 = Trace.getDefault();
                PsUiSubscription.this.removeSubIdentity(t1, context);
            }
        };
        removeSubIdentity.setText(PsPlugin.getMessage(t, "Ps.Menu.RemoveSubIdentity"));
        UiUtils.setHelp((IAction)removeSubIdentity, (String)"com.ibm.mq.explorer.pubsub.infopop.PS_ActionRemoveSubIdentity");
        Action properties = new Action(){

            public void run() {
                Trace t1 = Trace.getDefault();
                PropertyDlg propertyDlg = new PropertyDlg(t1, thisShell, 0);
                propertyDlg.addDialogClosedListener((IDialogClosedListener)uiSubscription);
                propertyDlg.open(t1, (UiMQObject)uiSubscription, !PsUiSubscription.this.isChangeProperties(t1));
            }
        };
        properties.setText(PsPlugin.getMessage(t, "Ps.Menu.Properties"));
        UiUtils.setHelp((IAction)properties, (String)"com.ibm.mq.explorer.pubsub.infopop.PS_ActionProperties");
        manager.add((IAction)this.deRegister);
        manager.add((IAction)removeSubIdentity);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)properties);
    }

    public void deregister(Trace t, Object context) {
        int parms = 0;
        String msg = PsPlugin.getMessage(t, "Ps.Unsubscribe.Message");
        this.deleteMenuAction(t, msg, parms, ((PsObject)this.getDmObject()).getTopicName(t));
    }

    public void removeSubIdentity(Trace t, Object context) {
        if (context instanceof PsUiSubscriber) {
            if (!this.getDmObject().getAttribute(t, 3055, 0).toString(t).equals("")) {
                PsSubIdentityDialog dialog = new PsSubIdentityDialog(t, UiPlugin.getShell());
                dialog.open(t, (PsSubscription)this.getDmObject(), (PsUiSubscriber)((Object)context));
            } else {
                MessageBox.showSystemMessageById((Trace)t, (Shell)UiPlugin.getShell(), (String)"AMQ4537");
            }
        } else if (Trace.isTracing) {
            t.data(66, "PsUiSubscription.removeSubIdentity", 900, "Invalid context - Cannot remove any sub identities as this was not called from a subscriber context");
        }
    }
}

