/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsObjectFilter;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsSubscription;
import com.ibm.mq.explorer.pubsub.internal.base.PsPlugin;
import com.ibm.mq.explorer.pubsub.internal.util.PsError;
import com.ibm.mq.explorer.pubsub.ui.internal.dialogs.PsSubIdentityDialog;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiBroker;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiMQBrokerObject;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiTopic;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.IDialogClosedListener;
import com.ibm.mq.explorer.ui.internal.properties.PropertyDlg;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PsUiSubscriber
extends PsUiMQBrokerObject
implements DmObjectListListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/objects/PsUiSubscriber.java";
    private int varUserId = 0;
    public static final int NOTSET = 1;
    public static final int SET = 2;
    public static final int BOTH = 3;
    private Action deRegister = null;
    private Object context;
    private int count = 1;
    private ArrayList objects;

    public PsUiSubscriber(Trace t, IDmObject dmObj, PsUiBroker uiBroker) {
        super(t, dmObj);
        this.setOwningUiBroker(uiBroker);
        this.objectType = PsPlugin.getMessage(t, "Ps.Object.Type.Subscriber");
    }

    public int getDataModelObjectType(Trace t) {
        return 1502;
    }

    public String getId() {
        return "com.ibm.mq.explorer.pubsub.topic.subscriber";
    }

    public String toString() {
        IDmObject dmObj = super.getDmObject();
        if (dmObj != null) {
            return dmObj.getTitle();
        }
        return "";
    }

    public void appendToContextMenu(Shell shell, IMenuManager manager, Object contextObject) {
        Trace t = Trace.getDefault();
        final Shell thisShell = shell;
        final PsUiSubscriber uiSubscriber = this;
        this.context = contextObject;
        if (this.deRegister == null) {
            this.deRegister = new Action(){

                public void run() {
                    Trace t2 = Trace.getDefault();
                    PsUiSubscriber.this.deregister(t2, PsUiSubscriber.this.context);
                }
            };
        }
        this.deRegister.setText(PsPlugin.getMessage(t, "Ps.Menu.DeregisterSubscriber"));
        UiPlugin.getHelpSystem().setHelp((IAction)this.deRegister, "com.ibm.mq.explorer.pubsub.infopop.PS_ActionDeregisterSubscriber");
        Action removeSubIdentity = new Action(){

            public void run() {
                Trace t1 = Trace.getDefault();
                PsUiSubscriber.this.removeSubIdentity(t1, PsUiSubscriber.this.context);
            }
        };
        removeSubIdentity.setText(PsPlugin.getMessage(t, "Ps.Menu.RemoveSubIdentity"));
        UiPlugin.getHelpSystem().setHelp((IAction)removeSubIdentity, "com.ibm.mq.explorer.pubsub.infopop.PS_ActionRemoveSubIdentity");
        Action properties = new Action(){

            public void run() {
                Trace t1 = Trace.getDefault();
                PropertyDlg propertyDlg = new PropertyDlg(t1, thisShell, 0);
                propertyDlg.addDialogClosedListener((IDialogClosedListener)uiSubscriber);
                propertyDlg.open(t1, (UiMQObject)uiSubscriber, !PsUiSubscriber.this.isChangeProperties(t1));
            }
        };
        properties.setText(PsPlugin.getMessage(t, "Ps.Menu.Properties"));
        UiPlugin.getHelpSystem().setHelp((IAction)properties, "com.ibm.mq.explorer.pubsub.infopop.PS_ActionProperties");
        manager.add((IAction)this.deRegister);
        if (this.context instanceof PsUiTopic) {
            manager.add((IAction)removeSubIdentity);
        }
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)properties);
    }

    public void deregister(Trace t, Object context) {
        this.getSubscriptions(t);
        this.varUserId = 0;
        int i = 0;
        while (i < this.objects.size()) {
            if (this.varUserId == 3) break;
            DmObject object = (DmObject)this.objects.get(i);
            if (Trace.isTracing) {
                t.data(66, "PsUiSubscriber.deregister", 300, String.valueOf(this.objects.size()) + " objects returned in list");
            }
            if (object instanceof PsSubscription) {
                this.varUserId = ((PsSubscription)object).isVariableUseridOptionEnabled(t) ? (this.varUserId |= 2) : (this.varUserId |= 1);
            }
            ++i;
        }
        int parms = 0;
        int parmsSecond = 0;
        String topic = null;
        if (Trace.isTracing) {
            t.data(66, "PsUiSubscriber.deregister", 300, "Deregistering subscriber " + this.toString() + " from  " + ((UiMQObject)context).toString());
        }
        final String msg = Message.format((String)PsPlugin.getMessage(t, "Ps.DeregisterSubscriber.Message"), (String)((UiMQObject)context).getObjectType().toLowerCase(), (String)((UiMQObject)context).getDmObject().toString(t));
        if (context instanceof PsUiBroker) {
            parmsSecond = parms = 64;
            if ((this.varUserId & 2) != 0) {
                parms |= 0x100000;
            }
        } else {
            topic = ((PsObject)((UiMQObject)context).getDmObject()).getTopicName(t);
            if ((this.varUserId & 2) != 0) {
                parms |= 0x100000;
            }
        }
        final Trace trace = t;
        int parameters = parms;
        int parametersSecond = parmsSecond;
        String topicToDelete = topic;
        this.count = 1;
        if (this.varUserId == 3) {
            this.count = 2;
        }
        int counter = this.count;
        PsUiSubscriber listener = this;
        Display.getDefault().asyncExec(new Runnable((DmActionListener)listener, parameters, topicToDelete, counter, parametersSecond){
            private final /* synthetic */ DmActionListener val$listener;
            private final /* synthetic */ int val$parameters;
            private final /* synthetic */ String val$topicToDelete;
            private final /* synthetic */ int val$counter;
            private final /* synthetic */ int val$parametersSecond;
            {
                this.val$listener = dmActionListener;
                this.val$parameters = n;
                this.val$topicToDelete = string2;
                this.val$counter = n2;
                this.val$parametersSecond = n3;
            }

            @Override
            public void run() {
                int rc = 1;
                rc = MessageBox.showYesNoMessage((Trace)trace, (Shell)PsUiSubscriber.this.shell, (String)msg, (int)1, null);
                if (rc == 0) {
                    PsUiSubscriber.this.busyDialog = new BusyDialog(PsUiSubscriber.this.shell, PsPlugin.getMessage(trace, "Ps.Deregister.Busy"));
                    ((PsObject)PsUiSubscriber.this.getDmObject()).actionDeregister(trace, this.val$listener, this.val$parameters, this.val$topicToDelete);
                    if (this.val$counter > 1) {
                        ((PsObject)PsUiSubscriber.this.getDmObject()).actionDeregister(trace, this.val$listener, this.val$parametersSecond, this.val$topicToDelete);
                    }
                    PsUiSubscriber.this.busyDialog.showDialog(trace);
                }
            }
        });
    }

    @Override
    public void dmActionDone(DmActionEvent event) {
        final Trace t = Trace.getDefault();
        final int rc = event.getReasonCode();
        final DmCoreException exc = event.getException();
        int command = event.getCommand();
        if (Trace.isTracing) {
            t.data(66, "PsUiSubscriber.dmActionDone", 300, "dmActionDone event received: " + command + " completed with return code " + rc);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace trace = Trace.getDefault();
                PsUiSubscriber psUiSubscriber = PsUiSubscriber.this;
                psUiSubscriber.count = psUiSubscriber.count - 1;
                if (PsUiSubscriber.this.count == 0) {
                    PsUiSubscriber.this.busyDialog.closeDialog(trace);
                }
                if (rc == 0) {
                    if (PsUiSubscriber.this.count == 0) {
                        MessageBox.showSystemMessageById((Trace)trace, (Shell)UiPlugin.getShell(), (String)"AMQ4536");
                    }
                } else {
                    String error = null;
                    error = PsError.getErrorMsg(t, rc);
                    if (error != null) {
                        MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)error);
                    } else if (exc != null) {
                        MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)exc);
                    } else {
                        MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)new DmCoreException("Reason code: " + rc, "Unknown", rc, 0, 1));
                    }
                }
            }
        });
    }

    public void dmObjectListDone(DmObjectListEvent event) {
        Trace t = Trace.getDefault();
        this.objects = event.getList();
        if (Trace.isTracing) {
            t.data(66, "PsUiSubscriber.dmObjectListDone", 300, String.valueOf(this.objects.size()) + " objects returned in list");
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace t2 = Trace.getDefault();
                PsUiSubscriber.this.busyDialog.closeDialog(t2);
            }
        });
    }

    public void getSubscriptions(Trace t) {
        PsObjectFilter filter = null;
        if (this.context instanceof PsUiTopic) {
            String topicName = ((PsObject)((UiMQObject)this.context).getDmObject()).getTopicName(t);
            filter = new PsObjectFilter(t, (PsObject)this.getDmObject(), topicName, 1503, null, true);
        } else {
            filter = new PsObjectFilter(t, (PsObject)this.getDmObject(), 1503, null, false);
        }
        this.busyDialog = new BusyDialog(this.shell, PsPlugin.getMessage(t, "Ps.RetrievingSubscriptions.Busy"));
        ((PsBroker)this.getOwningUiBroker().getDmObject()).getObjects(t, this, filter);
        this.busyDialog.showDialog(t);
    }

    public void removeSubIdentity(Trace t, Object context) {
        this.getSubscriptions(t);
        if (context instanceof PsUiTopic) {
            if (this.objects.size() > 1) {
                if (Trace.isTracing) {
                    t.data(66, "PsUiSubscriber.removeSubIdentity", 900, "Error - More than one subscription returned for subscriber on " + context.toString());
                }
            } else {
                PsObject child = (PsObject)this.objects.get(0);
                if (!child.getAttribute(t, 3055, 0).toString(t).equals("")) {
                    PsSubIdentityDialog dialog = new PsSubIdentityDialog(t, UiPlugin.getShell());
                    dialog.open(t, (PsSubscription)child, this);
                } else {
                    MessageBox.showSystemMessageById((Trace)t, (Shell)UiPlugin.getShell(), (String)"AMQ4537");
                }
            }
        } else if (Trace.isTracing) {
            t.data(66, "PsUiSubscriber.removeSubIdentity", 900, "Invalid context - Cannot remove any sub identities as this was not called from a topic context");
        }
    }
}

