/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.internal.base.PsPlugin;
import com.ibm.mq.explorer.pubsub.internal.util.PsError;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiBroker;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class PsUiMQBrokerObject
extends UiMQObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/objects/PsUiMQBrokerObject.java";
    protected String objectType = "";
    private PsUiBroker uiBroker = null;
    protected BusyDialog busyDialog = null;

    public PsUiMQBrokerObject(Trace t, IDmObject dmObj) {
        super(t, dmObj);
    }

    public String getObjectType() {
        return this.objectType;
    }

    public boolean isSupportDelete() {
        return false;
    }

    public boolean isAllowProperties() {
        return false;
    }

    public String getNLSResourceFileKey() {
        return null;
    }

    public boolean isChangeProperties(Trace t) {
        return false;
    }

    public boolean isCustomGroup(Trace t, UiDisplayGroup uiDisplayGroup) {
        return false;
    }

    public boolean isCustomItem(Trace t, Attr attr) {
        return false;
    }

    public CustomPropertyPage createCustomPropertyPage(Trace t, Composite parent, int style, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        return null;
    }

    public CustomPropertyItem createCustomPropertyItem(Trace t, Composite parent, int style, Attr attr, boolean readonly) {
        return null;
    }

    public boolean isNotifyChangedOnPropertyPage(Attr attr) {
        return false;
    }

    public boolean attrValueChangedOnPropertyPage(Trace t, Attr attr, Object newValue) {
        return false;
    }

    public boolean isAllowApplyProperties() {
        return false;
    }

    public boolean isDefaultDataModeEbcdic(Trace t) {
        return false;
    }

    public String getAttributeName(Trace t, int attrId) {
        return null;
    }

    public String getAttributeValue(Trace t, int attrId) {
        return null;
    }

    public String getCharacterSetIdForByteArray(Trace t, int attrId) {
        return null;
    }

    public void updateIcon() {
    }

    public void setOwningUiBroker(PsUiBroker uiBroker) {
        this.uiBroker = uiBroker;
    }

    public PsUiBroker getOwningUiBroker() {
        return this.uiBroker;
    }

    public void deleteMenuAction(Trace t, String msg, int parms, String topic) {
        int rc = 1;
        rc = MessageBox.showYesNoMessage((Trace)t, (Shell)this.shell, (String)msg, (int)1, null);
        if (rc == 0) {
            this.busyDialog = new BusyDialog(this.shell, PsPlugin.getMessage(t, "Ps.Deregister.Busy"));
            ((PsObject)this.getDmObject()).actionDeregister(t, (DmActionListener)this, parms, topic);
            this.busyDialog.showDialog(t);
        }
    }

    public void dmActionDone(DmActionEvent event) {
        final Trace t = Trace.getDefault();
        final int rc = event.getReasonCode();
        final DmCoreException exc = event.getException();
        int command = event.getCommand();
        if (Trace.isTracing) {
            t.data(66, "PsUiMQBrokerObject.dmActionDone", 300, "dmActionDone event received: " + command + " completed with return code " + rc);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace trace = Trace.getDefault();
                PsUiMQBrokerObject.this.busyDialog.closeDialog(trace);
                if (rc == 0) {
                    MessageBox.showSystemMessageById((Trace)trace, (Shell)UiPlugin.getShell(), (String)"AMQ4536");
                } else {
                    String error = null;
                    error = PsError.getErrorMsg(t, rc);
                    if (error != null) {
                        MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)error);
                    } else if (exc != null) {
                        MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)exc);
                    } else {
                        MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)new DmCoreException("Reason code: " + rc, "Unknown", rc, 0, 1));
                    }
                }
            }
        });
    }
}

