/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.menuactions;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsMessage;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObjectFactory;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsRegisterSubscriber;
import com.ibm.mq.explorer.pubsub.internal.base.PsPlugin;
import com.ibm.mq.explorer.pubsub.internal.util.PsError;
import com.ibm.mq.explorer.pubsub.ui.internal.dialogs.IPsPollListener;
import com.ibm.mq.explorer.pubsub.ui.internal.dialogs.PsPollQueue;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiMessage;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiTopic;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.IDialogClosedListener;
import com.ibm.mq.explorer.ui.internal.properties.PropertyDlg;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PsViewPublicationAction
extends Action
implements DmActionListener,
IPsPollListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/menuactions/PsViewPublicationAction.java";
    private BusyDialog busyDialog = null;
    private String queue = "SYSTEM.MQEXPLORER.BROKER.REPLY.QUEUE";
    private String qmgr = null;
    private String correlId = null;
    private String stream = null;
    private PsUiTopic topic;
    private PsPollQueue poll = null;
    private PsObject object = null;
    boolean subscribed = false;

    public PsViewPublicationAction(Trace t, PsUiTopic topic) {
        this.topic = topic;
    }

    public void run() {
        Trace t = Trace.getDefault();
        this.correlId = Long.toString(System.currentTimeMillis());
        if (this.correlId.length() > 48) {
            this.correlId = this.correlId.substring(0, 47);
        }
        this.stream = ((PsObject)this.topic.getDmObject()).getAttributeValue(t, 3030, 0);
        this.object = PsObjectFactory.create(t, (PsBroker)this.topic.getOwningUiBroker().getDmObject(), 1509, this.topic.toString(), this.stream);
        Object job = this.object.beginUpdate(t);
        this.busyDialog = new BusyDialog(UiPlugin.getShell(), PsPlugin.getMessage(t, "Ps.ViewRetained.Busy"));
        this.qmgr = ((PsBroker)this.topic.getOwningUiBroker().getDmObject()).getQueueManagerName(t);
        this.object.setAttributeValue(t, job, 2015, 0, this.qmgr);
        this.object.setAttributeValue(t, job, 2016, 0, this.queue);
        this.object.setAttributeValue(t, job, 10006, 0, "YES");
        this.object.setAttributeValue(t, job, 10008, 0, "YES");
        this.object.setAttributeValue(t, job, 10024, 0, -1);
        this.object.setAttributeValue(t, job, 10023, 0, this.correlId);
        this.object.actionCreate(t, this, job);
        this.busyDialog.showDialog(t);
    }

    public void dmActionDone(DmActionEvent event) {
        final Trace t = Trace.getDefault();
        final int rc = event.getReasonCode();
        final DmCoreException exc = event.getException();
        int command = event.getCommand();
        Object source = event.getSource();
        if (Trace.isTracing) {
            t.data(66, "PsViewPublicationAction.dmActionDone", 300, "dmActionDone event received: " + command + " completed with return code " + rc);
        }
        switch (command) {
            case 65: {
                if (rc == 0) {
                    this.subscribed = true;
                    ((PsRegisterSubscriber)source).actionRequestUpdate(t, this, 1, this.stream, this.topic.toString(), this.qmgr, this.queue, this.correlId);
                    break;
                }
            }
            case 66: {
                if (rc != 0) break;
                this.poll(t);
                break;
            }
        }
        if (rc != 0) {
            if (this.subscribed) {
                this.deregister(t);
            }
            final boolean closeDialog = !this.subscribed;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Trace trace = Trace.getDefault();
                    if (closeDialog) {
                        PsViewPublicationAction.this.busyDialog.closeDialog(trace);
                    }
                    String error = null;
                    error = PsError.getErrorMsg(t, rc);
                    if (error != null) {
                        if (rc == 3077) {
                            MessageBox.showMessageSuccess((Trace)t, (Shell)UiPlugin.getShell(), (String)error);
                        } else {
                            MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)error);
                        }
                    } else if (exc != null) {
                        MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)exc);
                    } else {
                        MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)new DmCoreException("Reason code: " + rc, "Unknown", rc, 0, 1));
                    }
                }
            });
        }
    }

    public void poll(Trace t) {
        this.poll = new PsPollQueue(t, this.queue, this.correlId, this.topic.getDmObject(), 1000);
        this.poll.addListener(t, this);
        this.poll.start();
    }

    @Override
    public boolean messageReceived(Trace t, MQMessage message, MQException ex) {
        this.poll.removeListener(t, this);
        if (this.subscribed) {
            this.deregister(t);
        }
        if (message != null) {
            PsMessage psMessage = new PsMessage(t, (PsBroker)this.topic.getOwningUiBroker().getDmObject(), this.topic.toString());
            psMessage.initialize(t, message);
            final PsUiMessage uiMessage = new PsUiMessage(t, (IDmObject)psMessage);
            uiMessage.setImage(Icons.get((String)Icons.iconkeyMessage));
            UiPlugin.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Trace t1 = Trace.getDefault();
                    PropertyDlg propertyDlg = new PropertyDlg(t1, UiPlugin.getShell(), 0);
                    propertyDlg.addDialogClosedListener((IDialogClosedListener)uiMessage);
                    propertyDlg.open(t1, (UiMQObject)uiMessage, !uiMessage.isChangeProperties(t1));
                }
            });
        } else if (ex != null) {
            MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)ex.toString());
            if (Trace.isTracing) {
                t.data(66, "PsViewPublicationAction.messageReceived", 900, "No message on the queue: " + ex.toString());
            }
        }
        return true;
    }

    public void deregister(Trace t) {
        ((PsRegisterSubscriber)this.object).actionDeregister(t, this, 1, this.stream, this.topic.toString(), null, null, this.qmgr, this.queue, this.correlId, 30);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace trace = Trace.getDefault();
                PsViewPublicationAction.this.busyDialog.closeDialog(trace);
            }
        });
    }
}

