/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.dialogs;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsObjectFilter;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObjectFactory;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsRegisterSubscriber;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsStream;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsSubscriber;
import com.ibm.mq.explorer.pubsub.internal.base.PsPlugin;
import com.ibm.mq.explorer.pubsub.internal.util.PsError;
import com.ibm.mq.explorer.pubsub.internal.util.PsHexString;
import com.ibm.mq.explorer.pubsub.internal.util.PsPaddedString;
import com.ibm.mq.explorer.pubsub.ui.internal.dialogs.IPsPollListener;
import com.ibm.mq.explorer.pubsub.ui.internal.dialogs.PsExplorerAdapter;
import com.ibm.mq.explorer.pubsub.ui.internal.dialogs.PsPollQueue;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiBroker;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiMQBrokerObject;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiTopic;
import com.ibm.mq.explorer.qmgradmin.internal.queues.SelectQueuesViewerFilter;
import com.ibm.mq.explorer.qmgradmin.internal.queues.UiQueueFilterProvider;
import com.ibm.mq.explorer.ui.extensions.IExplorerNotify;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.dialogs.SubscribeDialogBase;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.SelectUiMQObjectDialog;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.PCFFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PsSubscribeTestDialog
extends SubscribeDialogBase
implements DmActionListener,
DmObjectListener,
IPsPollListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/dialogs/PsSubscribeTestDialog.java";
    public static final String CLOSE_STRING = "CLOSE: ";
    public static final int DEFAULT_TIMEOUT = 30;
    private PsBroker broker;
    private UiMQObject owner = null;
    private String queue = null;
    private PsObjectFilter filter;
    private ExtCombo combo;
    private PsObject object;
    private BusyDialog busyDialog = null;
    private boolean subscribed = false;
    private String qmgr;
    private String topic;
    private String stream;
    private PsPollQueue poll = null;
    private String correlId = null;
    private String correlIdCompare = null;
    boolean isUnsubscribing = false;
    private PsExplorerAdapter adapter = null;
    private String identifier = null;
    private int messageLength = 0;
    protected Text streamText;

    public PsSubscribeTestDialog(Trace t, Shell parent) {
        super(t, parent);
        this.parent = parent;
    }

    public void open(Trace t, UiMQObject ownerObject, String helpId) {
        this.owner = ownerObject;
        if (this.owner instanceof PsUiTopic) {
            this.broker = (PsBroker)((PsUiMQBrokerObject)ownerObject).getOwningUiBroker().getDmObject();
            this.qmgr = this.broker.getQueueManager().getTitle();
            this.stream = ownerObject.getDmObject().getAttributeValue(t, 3030, 0);
            this.topic = ownerObject.toString();
        } else {
            this.broker = (PsBroker)this.owner.getDmObject();
            this.qmgr = this.broker.getQueueManager().getTitle();
        }
        super.open(t, this.qmgr, this.topic, true, this.stream, ownerObject.getImage(), helpId, false, false, false);
        this.adapter = new PsExplorerAdapter(this);
        UiPlugin.getNotificationManager().addListener(t, (IExplorerNotify)this.adapter, "com.ibm.mq.explorer.pubsub");
    }

    public void dmActionDone(DmActionEvent event) {
        final Trace t = Trace.getDefault();
        final int rc = event.getReasonCode();
        final DmCoreException exc = event.getException();
        final int command = event.getCommand();
        if (Trace.isTracing) {
            t.data(66, "PsSubscribeTestDialog.dmActionDone", 300, "dmActionDone event received: " + command + " completed with return code " + rc);
        }
        if (!this.myShell.isDisposed()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SimpleDateFormat dateFormat;
                    Trace trace = Trace.getDefault();
                    if (command == 65) {
                        if (rc == 0) {
                            dateFormat = new SimpleDateFormat("HH:mm:ss", locale);
                            String dateString = dateFormat.format(new Date());
                            PsSubscribeTestDialog.this.setStatus(Trace.getDefault(), PsSubscribeTestDialog.this.msgFile.getMessage("Ui.Last.Subscribed", dateString));
                            PsSubscribeTestDialog.this.subscribed = true;
                            if (PsSubscribeTestDialog.this.owner instanceof PsUiBroker) {
                                PsSubscribeTestDialog.this.topicText.setEnabled(false);
                                PsSubscribeTestDialog.this.combo.setEnabled(false);
                                PsSubscribeTestDialog.this.selectButton.setEnabled(false);
                            }
                            PsSubscribeTestDialog.this.myShell.setDefaultButton(PsSubscribeTestDialog.this.buttonUnsubscribe);
                            PsSubscribeTestDialog.this.buttonSubscribe.setEnabled(false);
                            PsSubscribeTestDialog.this.buttonUnsubscribe.setEnabled(true);
                            PsSubscribeTestDialog.this.busyDialog.closeDialog(trace);
                            PsSubscribeTestDialog.this.poll(trace);
                        }
                    } else if (command == 62 && rc == 0) {
                        PsSubscribeTestDialog.this.isUnsubscribing = false;
                        PsSubscribeTestDialog.this.subscribed = false;
                        dateFormat = new SimpleDateFormat("HH:mm:ss", locale);
                        String dateString = dateFormat.format(new Date());
                        PsSubscribeTestDialog.this.setStatus(Trace.getDefault(), PsSubscribeTestDialog.this.msgFile.getMessage("Ui.Last.Unsubscribed", dateString));
                        if (PsSubscribeTestDialog.this.owner instanceof PsUiBroker) {
                            PsSubscribeTestDialog.this.topicText.setEnabled(true);
                            PsSubscribeTestDialog.this.combo.setEnabled(true);
                            PsSubscribeTestDialog.this.selectButton.setEnabled(true);
                        }
                        PsSubscribeTestDialog.this.myShell.setDefaultButton(PsSubscribeTestDialog.this.buttonSubscribe);
                        PsSubscribeTestDialog.this.buttonSubscribe.setEnabled(true);
                        PsSubscribeTestDialog.this.buttonUnsubscribe.setEnabled(false);
                        PsSubscribeTestDialog.this.busyDialog.closeDialog(trace);
                    }
                    if (rc != 0) {
                        PsSubscribeTestDialog.this.busyDialog.closeDialog(trace);
                        String error = null;
                        error = PsError.getErrorMsg(t, rc);
                        if (error != null) {
                            MessageBox.showMessageFailure((Trace)t, (Shell)PsSubscribeTestDialog.this.myShell, (String)error);
                        } else if (exc != null) {
                            MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)exc);
                        } else {
                            MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)new DmCoreException("Reason code: " + rc, "Unknown", rc, 0, 1));
                        }
                    }
                }
            });
        }
    }

    public void subscribe(Trace t) {
        if (!this.subscribed) {
            this.queue = "SYSTEM.MQEXPLORER.BROKER.REPLY.QUEUE";
            this.correlId = Long.toString(System.currentTimeMillis());
            if (this.correlId.length() > 48) {
                this.correlId = this.correlId.substring(0, 47);
            }
            byte[] correlid = PsHexString.parseHex(this.correlId);
            this.correlIdCompare = PsPaddedString.pad(PsHexString.hexString(correlid), '0', 48);
            if (this.streamText != null) {
                this.stream = this.streamText.getText();
            }
            if (this.combo != null) {
                this.stream = this.combo.getText();
            }
            this.object = PsObjectFactory.create(t, this.broker, 1509, this.topicText.getText(), this.stream);
            this.topic = this.topicText.getText();
            Object job = this.object.beginUpdate(t);
            this.busyDialog = new BusyDialog(this.myShell, PsPlugin.getMessage(t, "Ps.Subscribing.Busy"));
            this.object.setAttributeValue(t, job, 2015, 0, this.qmgrText.getText());
            this.object.setAttributeValue(t, job, 2016, 0, this.queue);
            this.object.setAttributeValue(t, job, 10006, 0, "YES");
            this.object.setAttributeValue(t, job, 10024, 0, -1);
            this.object.setAttributeValue(t, job, 10023, 0, this.correlId);
            int result = this.object.actionCreate(t, this, job);
            if (Trace.isTracing) {
                t.data(66, "PsSubscribeTestDialog.subscribe", 300, "Creating a PsRegisterSubscriber object completed with return code: " + result);
            }
            this.busyDialog.showDialog(t);
            PCFFilter pcfFilter = new PCFFilter(3044, 2, this.correlIdCompare);
            PsObjectFilter psFilter = new PsObjectFilter(t, (PsObject)this.owner.getDmObject(), 1502, pcfFilter, true);
            this.broker.addObserver(t, this, psFilter);
        } else if (Trace.isTracing) {
            t.data(66, "PsSubscribeTestDialog.subscribe", 300, "Already subscribed, will not subscribe again");
        }
    }

    public void unsubscribe(Trace t) {
        if (this.subscribed) {
            this.isUnsubscribing = true;
            this.owner.getDmObject().beginUpdate(t);
            this.busyDialog = new BusyDialog(this.myShell, PsPlugin.getMessage(t, "Ps.Unsubscribing.Busy"));
            Thread put = new Thread(){

                @Override
                public void run() {
                    block2: {
                        Trace t2 = Trace.getDefault();
                        try {
                            PsSubscribeTestDialog.this.identifier = Long.toString(System.currentTimeMillis());
                            PsSubscribeTestDialog.this.messageLength = PsSubscribeTestDialog.this.identifier.length() + PsSubscribeTestDialog.CLOSE_STRING.length();
                            PsSubscribeTestDialog.this.poll.put(t2, PsSubscribeTestDialog.CLOSE_STRING + PsSubscribeTestDialog.this.identifier);
                        }
                        catch (MQException e) {
                            if (!Trace.isTracing) break block2;
                            t2.data(66, "PsSubscribeTestDialog.unsubscribe", 900, "Error putting a message to the queue: " + e.toString());
                        }
                    }
                }
            };
            put.start();
            this.busyDialog.showDialog(t);
        } else if (Trace.isTracing) {
            t.data(66, "PsSubscribeTestDialog.unsubscribe", 300, "Not currently subscribed, no need to unsubscribe");
        }
    }

    protected void selectNewStream(Trace t) {
        UiMQObject userselUiMQObject;
        SelectUiMQObjectDialog selDlg = new SelectUiMQObjectDialog(this.myShell);
        DmQueueManager dmQm = null;
        dmQm = this.broker.getQueueManager();
        selDlg.listenToDataModel(t, (IDmObservable)dmQm, 13, ((PsUiBroker)this.owner).getOwningUiQM(t).getFactoryClass(t, "com.ibm.mq.explorer.queue"), this.owner);
        boolean isSecondaryOrder = false;
        if (dmQm != null) {
            isSecondaryOrder = dmQm.isZos();
        }
        SelectQueuesViewerFilter viewerFilter = new SelectQueuesViewerFilter();
        viewerFilter.setHideTempQueues(true);
        viewerFilter.setHideAliasQueues(true);
        viewerFilter.setHideModelQueues(true);
        viewerFilter.setHideRemoteQueues(true);
        if (selDlg.open(t, PsPlugin.getMessage(t, "Ps.NewPubsub.Wizard.Select.Queue.Dialog"), null, "com.ibm.mq.explorer.queue", PsPlugin.getMessage(t, "UI.Q.Queues.Title"), "com.ibm.mq.explorer.orderid.queues", isSecondaryOrder, "com.ibm.mq.explorer.filterid.queues", (FilterProvider)new UiQueueFilterProvider(), null, (ViewerFilter)viewerFilter, true, true, null) && (userselUiMQObject = selDlg.getSelectedObject()) != null) {
            if (this.combo.indexOfObject((Object)userselUiMQObject.toString()) == -1) {
                this.combo.add(userselUiMQObject.toString(), 0);
            }
            this.combo.select(this.combo.indexOfObject((Object)userselUiMQObject.toString()));
            this.stream = (String)this.combo.getObject(0);
        }
    }

    public void shellClosed(ShellEvent e) {
        Trace t = Trace.getDefault();
        this.unsubscribe(t);
        UiPlugin.getNotificationManager().removeListener(t, (IExplorerNotify)this.adapter, "com.ibm.mq.explorer.pubsub");
        this.broker.deleteObserver(t, this);
    }

    public void poll(Trace t) {
        this.poll = new PsPollQueue(t, this.queue, this.correlId, this.owner.getDmObject(), 10000);
        this.poll.addListener(t, this);
        this.poll.start();
    }

    public void dmObjectAdded(DmObjectEvent event) {
    }

    public void dmObjectChanged(DmObjectEvent event) {
    }

    public void dmObjectDeleted(DmObjectEvent event) {
        final Trace t = Trace.getDefault();
        if (!this.isUnsubscribing && this.subscribed) {
            DmObject objectDeleted = (DmObject)event.getSource();
            String deletedQmgr = objectDeleted.getAttributeValue(t, 3042, 0);
            String deletedQueue = objectDeleted.getAttributeValue(t, 3043, 0);
            if (deletedQmgr.equals(this.qmgrText.getText()) && deletedQueue.equals(this.queue)) {
                this.subscribed = false;
                this.myShell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PsSubscribeTestDialog.this.buttonSubscribe.setEnabled(true);
                        PsSubscribeTestDialog.this.buttonUnsubscribe.setEnabled(false);
                        PsSubscribeTestDialog.this.messageText.setText(String.valueOf(PsPlugin.getMessage(t, "Ps.Test.Subscribe.Warning")) + PsSubscribeTestDialog.this.messageText.getLineDelimiter());
                    }
                });
            }
        }
    }

    public void dmRefreshComplete(DmObjectEvent event) {
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
    }

    public void dmObjectListDone(final DmObjectListEvent event) {
        final Trace t = Trace.getDefault();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PsSubscribeTestDialog.this.combo.isDisposed()) {
                    ArrayList objects = event.getList();
                    if (Trace.isTracing) {
                        t.data(66, "PsSubscribeTestDialog.dmObjectListDone", 300, String.valueOf(objects.size()) + " objects returned in list");
                    }
                    int i = 0;
                    while (i < objects.size()) {
                        DmObject dmObj = (DmObject)objects.get(i);
                        if (PsSubscribeTestDialog.this.combo.indexOfObject((Object)dmObj.getTitle()) == -1) {
                            PsSubscribeTestDialog.this.combo.add(dmObj.getTitle());
                        }
                        ++i;
                    }
                }
            }
        });
    }

    @Override
    public boolean messageReceived(Trace t, MQMessage message, MQException ex) {
        if (message != null) {
            String topicStr;
            String topicString;
            String messageInfo;
            block13: {
                block14: {
                    messageInfo = null;
                    topicString = this.msgFile.getMessage("Ui.Subscribe.Topic.String", TOPIC_STRING_NOT_FOUND);
                    if (message.format.equals("MQPCF   ")) {
                        PCFParameter p;
                        PCFMessage response = new PCFMessage(message);
                        topicStr = response.getParameter(3031);
                        if (topicStr != null) {
                            topicString = this.msgFile.getMessage("Ui.Subscribe.Topic.String", topicStr.getStringValue());
                        }
                        if ((p = response.getParameter(3035)) != null) {
                            messageInfo = p.getStringValue();
                        }
                        break block13;
                    }
                    if (!message.format.equals("MQSTR   ") || !this.isUnsubscribing) break block14;
                    String messageData = message.readStringOfCharLength(this.messageLength);
                    if (messageData.equals(CLOSE_STRING + this.identifier)) {
                        this.poll.removeListener(t, this);
                        this.object.beginUpdate(t);
                        ((PsRegisterSubscriber)this.object).actionDeregister(t, this, 1, this.stream, this.topic, null, null, this.qmgr, this.queue, this.correlId, 30);
                        return false;
                    }
                }
                try {
                    byte[] bytesReceived = new byte[500];
                    int length = message.getMessageLength();
                    if (length > 500) {
                        length = 500;
                    }
                    message.readFully(bytesReceived, 0, length);
                    messageInfo = PsHexString.printPrintableChars(bytesReceived);
                }
                catch (IOException e) {
                    if (Trace.isTracing) {
                        t.data(66, "PsSubscribeTestDialog.messageReceived", 900, e.toString());
                    }
                }
                catch (MQException e) {
                    if (!Trace.isTracing) break block13;
                    t.data(66, "PsSubscribeTestDialog.messageReceived", 900, "Error processing the message received: " + e.toString());
                }
            }
            final String stringData = this.msgFile.getMessage(t, "Ui.Subscribe.Message", messageInfo);
            topicStr = topicString;
            this.myShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss", locale);
                    String dateString = PsSubscribeTestDialog.this.msgFile.getMessage("Ui.Subscribe.Time", dateFormat.format(new Date()));
                    if (PsSubscribeTestDialog.this.containsMessages) {
                        PsSubscribeTestDialog.this.messageText.append(String.valueOf(dateString) + LINE_SEPARATOR + topicStr + LINE_SEPARATOR + stringData + LINE_SEPARATOR + "---------------------------------------------------------------------------------------" + LINE_SEPARATOR);
                    } else {
                        PsSubscribeTestDialog.this.messageText.setText(String.valueOf(dateString) + LINE_SEPARATOR + topicStr + LINE_SEPARATOR + stringData + LINE_SEPARATOR + "---------------------------------------------------------------------------------------" + LINE_SEPARATOR);
                        PsSubscribeTestDialog.this.containsMessages = true;
                    }
                }
            });
        } else if (Trace.isTracing) {
            t.data(66, "PsSubscribeTestDialog.messageReceived", 300, "No message on the queue");
        }
        return true;
    }

    public void explorerClosing() {
        Trace t = Trace.getDefault();
        if (this.subscribed) {
            ((PsSubscriber)this.object).actionDeregister(t, this, 1, this.stream, this.topic, null, null, this.qmgr, this.queue, this.correlId, 30);
        }
    }

    protected void drawStreamBox(Trace t, Composite group, String theStream) {
        Label streamLabel = new Label(group, 0);
        streamLabel.setText(PsPlugin.getMessage(t, "Ps.Test.Stream.Title"));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        streamLabel.setLayoutData((Object)gridData);
        if (theStream != null) {
            this.streamText = new Text(group, 2048);
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.streamText, (boolean)true);
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.streamText.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.streamText, (boolean)true);
            this.streamText.setText(theStream);
        } else {
            this.filter = new PsObjectFilter(t, null, 1505, null, true);
            this.combo = new ExtCombo(group, 2060);
            this.combo.add(PsStream.getDefaultName(t));
            this.combo.select(0);
            this.stream = (String)this.combo.getObject(0);
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PsSubscribeTestDialog.this.stream = (String)PsSubscribeTestDialog.this.combo.getObject(PsSubscribeTestDialog.this.combo.getSelectionIndex());
                }
            });
            this.broker.getObjects(t, (DmObjectListListener)this, this.filter);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.combo.setLayoutData((Object)gridData);
            this.selectButton = new Button(group, 8);
            this.selectButton.setText(PsPlugin.getMessage(t, "Ps.Button.Select.Text"));
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            this.selectButton.setLayoutData((Object)gridData);
            this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t2 = Trace.getDefault();
                    PsSubscribeTestDialog.this.selectNewStream(t2);
                }
            });
        }
    }

    protected boolean isSubscribed() {
        return this.subscribed;
    }
}

