/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsSubscriber;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsSubscription;
import com.ibm.mq.explorer.pubsub.internal.base.PsIcons;
import com.ibm.mq.explorer.pubsub.internal.base.PsPlugin;
import com.ibm.mq.explorer.pubsub.internal.util.PsError;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiSubscriber;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PsSubIdentityDialog
extends Dialog
implements DmActionListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/dialogs/PsSubIdentityDialog.java";
    private static final int NUM_COLUMNS = 4;
    protected Shell parent = null;
    protected Shell myShell;
    private BusyDialog busyDialog = null;

    public PsSubIdentityDialog(Trace t, Shell parent) {
        super(parent);
    }

    public void open(Trace t, PsSubscription subscription, PsUiSubscriber owningSubscriber) {
        int shellOptions = 68848;
        this.myShell = new Shell(this.parent, shellOptions);
        this.myShell.setText(PsPlugin.getMessage(t, "Ps.RemoveSubIdentity.Dialog.Title"));
        this.myShell.setImage(PsIcons.get(t, PsIcons.iconkeyTopic));
        UiUtils.setHelp((Control)this.myShell, (String)"com.ibm.mq.explorer.pubsub.infopop.PS_SubIdentityDialog");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.myShell.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.myShell.setLayoutData((Object)gridData);
        ArrayList identities = (ArrayList)subscription.getAttribute(t, 3055, 0).getValue(t);
        Label message = new Label((Composite)this.myShell, 0);
        message.setText(PsPlugin.getMessage(t, "Ps.RemoveSubIdentity.Dialog.Message"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        message.setLayoutData((Object)gridData);
        ExtCombo combo = new ExtCombo((Composite)this.myShell, 2060);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        combo.setLayoutData((Object)gridData);
        int i = 0;
        while (i < identities.size()) {
            combo.add(identities.get(i));
            ++i;
        }
        combo.select(0);
        Composite buttons = new Composite((Composite)this.myShell, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        buttons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        buttons.setLayoutData((Object)gridData);
        Label padding = new Label(buttons, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        padding.setLayoutData((Object)gridData);
        Button buttonOk = new Button(buttons, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        buttonOk.setText(PsPlugin.getMessage(t, "Ps.Button.Ok.Text"));
        buttonOk.setLayoutData((Object)gridData);
        final PsSubIdentityDialog listener = this;
        final String topic = subscription.getAttributeValue(t, 3031, 0);
        final ExtCombo combox = combo;
        final PsSubscriber parentSubscriber = (PsSubscriber)owningSubscriber.getDmObject();
        buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t = Trace.getDefault();
                PsSubIdentityDialog.this.busyDialog = new BusyDialog(PsSubIdentityDialog.this.myShell, PsPlugin.getMessage(t, "Ps.RemovingSubIdentity.Busy"));
                parentSubscriber.actionRemoveIdentity(t, listener, 524288, topic, combox.getText());
                PsSubIdentityDialog.this.myShell.close();
                PsSubIdentityDialog.this.busyDialog.showDialog(t);
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        buttonCancel.setText(PsPlugin.getMessage(t, "Ps.Button.Cancel.Text"));
        buttonCancel.setLayoutData((Object)gridData);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PsSubIdentityDialog.this.myShell.close();
            }
        });
        ButtonTools.makeEqualWidthGridData((Trace)t, (Composite)buttons);
        this.myShell.pack();
        this.myShell.open();
    }

    public void dmActionDone(DmActionEvent event) {
        final Trace t = Trace.getDefault();
        final int rc = event.getReasonCode();
        final DmCoreException exc = event.getException();
        int command = event.getCommand();
        if (Trace.isTracing) {
            t.data(66, "PsSubIdentityDialog.dmActionDone", 300, "dmActionDone event received: " + command + " completed with return code " + rc);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace trace = Trace.getDefault();
                PsSubIdentityDialog.this.busyDialog.closeDialog(trace);
                if (rc == 0) {
                    MessageBox.showSystemMessageById((Trace)trace, (Shell)UiPlugin.getShell(), (String)"AMQ4534");
                } else {
                    String error = null;
                    error = PsError.getErrorMsg(t, rc);
                    if (error != null) {
                        MessageBox.showMessageFailure((Trace)t, (Shell)UiPlugin.getShell(), (String)error);
                    } else if (exc != null) {
                        MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)exc);
                    } else {
                        MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)new DmCoreException("Reason code: " + rc, "Unknown", rc, 0, 1));
                    }
                }
            }
        });
    }
}

