/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.pubsub.internal.base.PsPlugin;
import com.ibm.mq.explorer.pubsub.ui.internal.dialogs.PsMultiStatusComposite;
import com.ibm.mq.explorer.pubsub.ui.internal.dialogs.PsStatusComposite;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiPubsubStatusProvider;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.status.UiStatusProvider;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PsStatusDialog
extends Dialog
implements ShellListener,
DisposeListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/dialogs/PsStatusDialog.java";
    private Shell shellDlg;
    private Composite composite;
    private Text[] infoTextArray = null;
    private PsUiPubsubStatusProvider statusProvider = null;
    private UiMQObject ownerUiMQObject = null;
    private boolean isActiveWindow = false;
    private StatusKeyListener statusKeyListener = null;

    public PsStatusDialog(Shell parent, int style) {
        super(parent, style);
        Trace.getDefault();
    }

    public void open(Trace t, PsUiPubsubStatusProvider status, UiMQObject ownerObject) {
        this.statusProvider = status;
        this.ownerUiMQObject = ownerObject;
        Shell parent = this.getParent();
        int shellOptions = 3312;
        if ((parent.getStyle() & 0x10000) == 65536) {
            shellOptions |= 0x10000;
        }
        this.shellDlg = new Shell(parent, shellOptions);
        UiUtils.setHelp((Control)this.shellDlg, (String)status.getDialogHelpId(t));
        this.statusKeyListener = new StatusKeyListener();
        this.shellDlg.getDisplay().addFilter(2, (Listener)this.statusKeyListener);
        this.shellDlg.addDisposeListener((DisposeListener)this);
        String element1 = ownerObject.toString();
        String element2 = status.getMenuTextForStatusType(t, null);
        if (element2 == null) {
            element2 = status.getMenuText(t);
        }
        Message.format((String)PsPlugin.getMessage(t, "Ps.Status.Status.Title"), (String)element1, (String)element2);
        this.shellDlg.setText(status.getDialogHeading(t, this.ownerUiMQObject));
        this.shellDlg.setImage(status.getImage(t, null));
        this.addInformationArea(t, status, ownerObject.getId());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = false;
        this.shellDlg.setLayout((Layout)gridLayout);
        boolean isMultiTableMode = false;
        PsUiPubsubStatusProvider[] multiUiStatusProvider = null;
        multiUiStatusProvider = status.getMultiModeStatusProvider(t, null);
        boolean bl = isMultiTableMode = multiUiStatusProvider != null;
        if (isMultiTableMode) {
            PsUiPubsubStatusProvider[] multi = new PsUiPubsubStatusProvider[multiUiStatusProvider.length + 1];
            multi[0] = status;
            int i = 1;
            while (i < multi.length) {
                multi[i] = multiUiStatusProvider[i - 1];
                ++i;
            }
            this.composite = new PsMultiStatusComposite(t, (Composite)this.shellDlg, 0, multi, ownerObject);
        } else {
            this.composite = new PsStatusComposite(t, (Composite)this.shellDlg, 0, status, ownerObject);
        }
        gridLayout = new GridLayout();
        this.composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 4;
        this.composite.setLayoutData((Object)gridData);
        Composite compRefreshCloseButtons = new Composite((Composite)this.shellDlg, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        compRefreshCloseButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        compRefreshCloseButtons.setLayoutData((Object)gridData);
        Label padding = new Label(compRefreshCloseButtons, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        padding.setLayoutData((Object)gridData);
        Button buttonRefresh = new Button(compRefreshCloseButtons, 8);
        GridData refreshGrid = new GridData();
        buttonRefresh.setText(PsPlugin.getMessage(t, "Ps.Button.Refresh.Text"));
        buttonRefresh.setLayoutData((Object)refreshGrid);
        buttonRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t = Trace.getDefault();
                PsStatusDialog.this.refresh(t);
            }
        });
        Button buttonClose = new Button(compRefreshCloseButtons, 8);
        GridData closeGrid = new GridData();
        buttonClose.setText(PsPlugin.getMessage(t, "Ps.Button.Close.Text"));
        buttonClose.setLayoutData((Object)closeGrid);
        buttonClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PsStatusDialog.this.shellDlg.close();
            }
        });
        int maxWidth = 0;
        Point sizeRefresh = buttonRefresh.computeSize(-1, -1);
        Point sizeClose = buttonClose.computeSize(-1, -1);
        if (sizeRefresh.x > maxWidth) {
            maxWidth = sizeRefresh.x;
        }
        if (sizeClose.x > maxWidth) {
            maxWidth = sizeClose.x;
        }
        refreshGrid.widthHint = maxWidth;
        closeGrid.widthHint = maxWidth;
        this.refresh(t);
        this.shellDlg.setDefaultButton(buttonClose);
        buttonClose.setFocus();
        this.shellDlg.addShellListener((ShellListener)this);
        Point size = null;
        size = status.getCustomSize(t);
        if (size != null) {
            this.shellDlg.setSize(size);
        }
        this.shellDlg.open();
        if (this.composite instanceof PsStatusComposite) {
            ((PsStatusComposite)this.composite).startListening(t);
        } else if (this.composite instanceof PsMultiStatusComposite) {
            ((PsMultiStatusComposite)this.composite).startListening(t);
        }
    }

    public void shellActivated(ShellEvent e) {
        this.isActiveWindow = true;
    }

    private void addInformationArea(Trace t, UiStatusProvider statusProvider, String type) {
        String[] titles = statusProvider.getInformationAreaTitles(t, type);
        if (titles != null) {
            Composite composite = new Composite((Composite)this.shellDlg, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 4;
            composite.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 4;
            composite.setLayoutData((Object)gridData);
            int count = titles.length;
            if (count % 2 == 1) {
                ++count;
            }
            Label label = new Label(composite, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            this.infoTextArray = new Text[count];
            int i = 0;
            while (i < count) {
                label = new Label(composite, 0);
                if (i < titles.length) {
                    label.setText(titles[i]);
                }
                gridData = new GridData();
                label.setLayoutData((Object)gridData);
                if (i < titles.length) {
                    this.infoTextArray[i] = new Text(composite, 8);
                    gridData = new GridData(768);
                    gridData.grabExcessHorizontalSpace = true;
                    this.infoTextArray[i].setLayoutData((Object)gridData);
                    this.infoTextArray[i].setBackground(composite.getDisplay().getSystemColor(22));
                } else {
                    label = new Label(composite, 0);
                    gridData = new GridData();
                    label.setLayoutData((Object)gridData);
                }
                UiUtils.createBlankLine((Composite)composite, (int)2);
                ++i;
            }
        }
    }

    public void refreshInformationAreaValues(Trace t) {
        if (this.infoTextArray != null) {
            String[] values = this.statusProvider.getInformationAreaValues(t, null, this.ownerUiMQObject);
            int limit = values.length;
            if (limit > this.infoTextArray.length) {
                limit = this.infoTextArray.length;
            }
            int i = 0;
            while (i < limit) {
                this.infoTextArray[i].setText(values[i]);
                ++i;
            }
        }
    }

    public void refresh(Trace t) {
        if (this.composite instanceof PsStatusComposite) {
            ((PsStatusComposite)this.composite).refresh(t);
        }
        if (this.composite instanceof PsMultiStatusComposite) {
            ((PsMultiStatusComposite)this.composite).refresh(t);
        }
        this.refreshInformationAreaValues(t);
    }

    public void shellClosed(ShellEvent e) {
        Trace t = Trace.getDefault();
        if (this.composite instanceof PsStatusComposite) {
            ((PsStatusComposite)this.composite).stopListening(t);
        }
        if (this.composite instanceof PsMultiStatusComposite) {
            ((PsMultiStatusComposite)this.composite).stopListening(t);
        }
    }

    public void shellDeactivated(ShellEvent e) {
        this.isActiveWindow = false;
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    public void widgetDisposed(DisposeEvent e) {
        this.shellDlg.getDisplay().removeFilter(2, (Listener)this.statusKeyListener);
    }

    private class StatusKeyListener
    implements Listener {
        private StatusKeyListener() {
        }

        public void handleEvent(Event event) {
            if (event.keyCode == 0x100000E && PsStatusDialog.this.isActiveWindow) {
                PsStatusDialog.this.refresh(Trace.getDefault());
            }
        }
    }
}

