/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsObjectFilter;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiPubsubStatusProvider;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiTopic;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableContentChangedListener;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTableSelectionChangedListener;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objecttable.ObjectTable;
import com.ibm.mq.explorer.ui.internal.objecttable.ObjectTableContentChangedEvent;
import com.ibm.mq.explorer.ui.internal.objecttable.ObjectTableContentChangedListener;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PsStatusComposite
extends Composite
implements ExplorerTableContentChangedListener,
ExplorerTableSelectionChangedListener,
ObjectTableContentChangedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/dialogs/PsStatusComposite.java";
    public static final int NUM_COLUMNS = 4;
    private PsBroker listenPsBroker = null;
    private int listenDmObjectId = -1;
    private String listenTopicName = null;
    private boolean listenExactMatch = false;
    private IUiMQObjectFactory listenFactory = null;
    private boolean isListenToDataModel = false;
    private Button[] buttons = null;
    private int[] buttonIds = null;
    private Label labelHeading = null;
    private PsStatusComposite[] children = null;
    private boolean isListeningToDataModel = false;
    private PsUiPubsubStatusProvider status = null;
    private UiMQObject ownerUiMQObject = null;
    private UiMQObject currentUiMQObject = null;
    private ExplorerTable explorerTable = null;
    private ObjectTable objectTable = null;
    private boolean singleInstanceMode = false;
    private UiMQObject context = null;

    public PsStatusComposite(Trace t, Composite parent, int style, PsUiPubsubStatusProvider status, UiMQObject ownerObject) {
        super(parent, style);
        this.status = status;
        this.ownerUiMQObject = ownerObject;
        this.context = status.getContext(t);
        ScrolledComposite comp = new ScrolledComposite((Composite)this, 768);
        UiUtils.setHelp((Control)comp, (String)status.getHelpId(t));
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        comp.setLayoutData((Object)gridData);
        Composite compTop = new Composite((Composite)comp, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        compTop.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        compTop.setLayoutData((Object)gridData);
        this.singleInstanceMode = status.getStatusInstances(t, this.ownerUiMQObject, null) == 1;
        comp.setContent((Control)compTop);
        String heading = status.getTableHeading(t, null, this.ownerUiMQObject);
        if (heading != null) {
            this.labelHeading = new Label(compTop, 0);
            this.labelHeading.setText(heading);
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            this.labelHeading.setLayoutData((Object)gridData);
        }
        if (!this.singleInstanceMode) {
            this.explorerTable = new ExplorerTable(t, compTop, 0, null, false, false, true, true, (Object)this.ownerUiMQObject);
            this.explorerTable.setAttributeOrderId(t, status.getAttributeOrderId(null));
            if (status.getTableViewerFilter(t, null) != null) {
                this.explorerTable.addViewerFilter(t, status.getTableViewerFilter(t, null));
            }
            this.explorerTable.addSelChangedListener(t, (ExplorerTableSelectionChangedListener)this);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            this.explorerTable.setLayoutData((Object)gridData);
        } else {
            this.objectTable = new ObjectTable(t, compTop, 0, false, true, false);
            this.objectTable.setAttributeOrderId(t, status.getAttributeOrderId(null));
            this.objectTable.addContentChangedListener(t, (ObjectTableContentChangedListener)this);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            this.objectTable.setLayoutData((Object)gridData);
        }
        this.buttonIds = status.getAdditionalButtonIds(t, null);
        if (this.buttonIds != null) {
            Composite compButtons = new Composite(compTop, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = this.buttonIds.length;
            compButtons.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            gridData.grabExcessHorizontalSpace = true;
            compButtons.setLayoutData((Object)gridData);
            this.buttons = new Button[this.buttonIds.length];
            int i = 0;
            while (i < this.buttons.length) {
                this.buttons[i] = new Button(compButtons, 8);
                GridData buttonGrid = new GridData();
                this.buttons[i].setText(status.getAdditionalButtonText(t, null, this.buttonIds[i]));
                this.buttons[i].setLayoutData((Object)buttonGrid);
                this.buttons[i].setEnabled(status.isEnableAdditionalButton(t, null, this.buttonIds[i], null));
                this.buttons[i].setData((Object)i);
                this.buttons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Trace t1 = Trace.getDefault();
                        if (event.getSource() instanceof Button) {
                            Button button = (Button)event.getSource();
                            int index = (Integer)button.getData();
                            PsStatusComposite.this.additionalButtonSelected(t1, index);
                        }
                    }
                });
                ++i;
            }
            ButtonTools.makeEqualWidthGridData((Trace)t, (Button[])this.buttons);
        }
        this.isListenToDataModel = status.supportsDataModelListen(t, null);
        if (this.ownerUiMQObject != null && this.isListenToDataModel) {
            this.listenDmObjectId = status.getDataModelObjectType(t, null);
            this.listenPsBroker = status.getPsBrokerObject(t, this.ownerUiMQObject);
            this.listenFactory = status.getUiMQObjectFactory(t, null, this.ownerUiMQObject);
        }
        compTop.layout();
        comp.setExpandHorizontal(true);
        comp.setExpandVertical(true);
    }

    public void contentChanged(ExplorerTableContentChangedEvent event) {
        Trace t = Trace.getDefault();
        if (this.buttons != null && this.explorerTable != null) {
            int i = 0;
            while (i < this.buttons.length) {
                Button buttonAdditional = this.buttons[i];
                if (buttonAdditional != null) {
                    UiMQObject selUiMQObject = this.explorerTable.getSelectedItem(t);
                    buttonAdditional.setEnabled(selUiMQObject != null);
                }
                ++i;
            }
        }
    }

    public void contentChanged(ObjectTableContentChangedEvent event) {
    }

    public void selChanged(ExplorerTableSelectionChangedEvent event) {
        int i;
        Trace t = Trace.getDefault();
        UiMQObject selUiMQObject = event.getObject();
        if (this.buttonIds != null) {
            i = 0;
            while (i < this.buttonIds.length) {
                Button buttonAdditional = this.buttons[i];
                if (buttonAdditional != null) {
                    buttonAdditional.setEnabled(this.status.isEnableAdditionalButton(t, null, this.buttonIds[i], selUiMQObject));
                }
                ++i;
            }
        }
        if (selUiMQObject != this.currentUiMQObject) {
            this.currentUiMQObject = selUiMQObject;
            if (this.children != null) {
                i = 1;
                while (i < this.children.length) {
                    this.children[i].setOwnerObject(t, selUiMQObject);
                    ++i;
                }
            }
        }
    }

    public void refresh(Trace t) {
        this.status.refresh(t, this.ownerUiMQObject);
        if (this.isListenToDataModel) {
            if (this.singleInstanceMode) {
                this.objectTable.refresh();
            } else {
                this.explorerTable.refresh();
            }
        }
    }

    public void startListening(Trace t) {
        PsObjectFilter psFilter = null;
        if (this.ownerUiMQObject != null) {
            this.listenExactMatch = this.status.getExactMatch(t);
            psFilter = this.listenTopicName != null ? new PsObjectFilter(t, (PsObject)this.ownerUiMQObject.getDmObject(), this.listenTopicName, this.listenDmObjectId, null, this.listenExactMatch) : new PsObjectFilter(t, (PsObject)this.ownerUiMQObject.getDmObject(), this.listenDmObjectId, null, this.listenExactMatch);
            if (!this.singleInstanceMode) {
                this.explorerTable.setUiMQObjectFactoryClass(t, this.listenFactory, this.ownerUiMQObject);
                if (this.explorerTable.startListener(t, (IDmObservable)this.listenPsBroker, (DmObjectFilter)psFilter)) {
                    this.isListeningToDataModel = true;
                } else if (Trace.isTracing) {
                    t.data(66, "PsStatusComposite.startListening", 900, "failed to start listening for changes - listenPsBroker " + this.listenPsBroker.getTitle() + ", listenDmObjectId " + this.listenDmObjectId);
                }
                this.explorerTable.addContentChangedListener(t, (ExplorerTableContentChangedListener)this);
            } else {
                this.objectTable.setUiMQObjectFactoryClass(t, this.listenFactory, this.ownerUiMQObject);
                if (this.objectTable.startListener(t, (IDmObservable)this.listenPsBroker, (DmObjectFilter)psFilter)) {
                    this.isListeningToDataModel = true;
                } else if (Trace.isTracing) {
                    t.data(66, "PsStatusComposite.startListening", 900, "failed to start listening for changes - listenPsBroker " + this.listenPsBroker.getTitle() + ", listenDmObjectId " + this.listenDmObjectId);
                }
                this.objectTable.addContentChangedListener(t, (ObjectTableContentChangedListener)this);
            }
        }
    }

    public void stopListening(Trace t) {
        if (this.isListeningToDataModel) {
            if (!this.singleInstanceMode) {
                if (!this.explorerTable.stopListener(t, (IDmObservable)this.listenPsBroker) && Trace.isTracing) {
                    t.data(66, "PsStatusComposite.stopListening", 900, "failed to stop listening for changes - listenPsBroker " + this.listenPsBroker.getTitle() + ", listenDmObjectId " + this.listenDmObjectId);
                }
                this.explorerTable.removeContentChangedListener(t, (ExplorerTableContentChangedListener)this);
            } else if (!this.objectTable.stopListener(t, (IDmObservable)this.listenPsBroker) && Trace.isTracing) {
                t.data(66, "PsStatusComposite.stopListening", 900, "failed to stop listening for changes - listenPsBroker " + this.listenPsBroker.getTitle() + ", listenDmObjectId " + this.listenDmObjectId);
            }
        }
    }

    private void additionalButtonSelected(Trace t, int index) {
        if (this.buttons[index] != null) {
            if (this.explorerTable != null) {
                UiMQObject selUiMQObject = this.explorerTable.getSelectedItem(t);
                this.status.additionalButtonSelected(t, this.buttonIds[index], this.getShell(), selUiMQObject);
                this.explorerTable.refresh();
            }
            this.buttons[index].setEnabled(this.status.isEnableAdditionalButton(t, null, this.buttonIds[index], null));
        }
    }

    public void setChildren(Trace t, PsStatusComposite[] children) {
        this.children = children;
    }

    public void setOwnerObject(Trace t, UiMQObject ownerObject) {
        if (this.isListeningToDataModel) {
            this.stopListening(t);
        }
        if (this.explorerTable != null) {
            this.explorerTable.removeAll(t);
        }
        this.ownerUiMQObject = ownerObject;
        DmQueueManager dmQmgr = this.status.getDmQueueManagerObject(t, ownerObject);
        if (dmQmgr != null && this.explorerTable != null) {
            this.explorerTable.setInstance(t, dmQmgr.getTreeName(t), dmQmgr.isZos());
        }
        if (this.labelHeading != null) {
            this.labelHeading.setText(this.status.getTableHeading(t, null, this.ownerUiMQObject));
            this.labelHeading.getParent().layout(true);
        }
        this.listenDmObjectId = this.status.getDataModelObjectType(t, null);
        if (this.context instanceof PsUiTopic) {
            this.listenTopicName = this.context.toString();
        }
        this.listenPsBroker = this.status.getPsBrokerObject(t, this.ownerUiMQObject);
        this.listenFactory = this.status.getUiMQObjectFactory(t, null, this.ownerUiMQObject);
        this.startListening(t);
    }

    public void setListenId(Trace t, int id) {
        this.listenDmObjectId = id;
    }

    public void setListenFactory(Trace t, UiMQObjectFactory factory) {
        this.listenFactory = factory;
    }

    public void setListenBroker(Trace t, PsBroker broker) {
        this.listenPsBroker = broker;
    }
}

