/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.dialogs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.pubsub.core.internal.event.PsObjectFilter;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsBroker;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObject;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsObjectFactory;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsStream;
import com.ibm.mq.explorer.pubsub.core.internal.objects.PsTopic;
import com.ibm.mq.explorer.pubsub.internal.base.PsPlugin;
import com.ibm.mq.explorer.pubsub.internal.util.PsError;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiBroker;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiMQBrokerObject;
import com.ibm.mq.explorer.pubsub.ui.internal.objects.PsUiTopic;
import com.ibm.mq.explorer.qmgradmin.internal.queues.SelectQueuesViewerFilter;
import com.ibm.mq.explorer.qmgradmin.internal.queues.UiQueueFilterProvider;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.dialogs.PublishDialogBase;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.SelectUiMQObjectDialog;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PsPublishTestDialog
extends PublishDialogBase
implements DmActionListener,
DmObjectListListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/dialogs/PsPublishTestDialog.java";
    public static final int DEFAULT_TIMEOUT = 30;
    private PsBroker broker;
    private UiMQObject owner = null;
    private String queue = "SYSTEM.MQEXPLORER.BROKER.REPLY.QUEUE";
    private PsObjectFilter filter;
    protected Text streamText;
    protected ExtCombo combo;
    private String currentTopic = null;
    private String currentStream = null;
    private UiMQObject topicObject = null;
    private PsObject object;

    public PsPublishTestDialog(Trace t, Shell parent) {
        super(t, parent);
        this.parent = parent;
    }

    public void open(Trace t, UiMQObject ownerObject, String helpId) {
        String qmgr = null;
        String stream = null;
        String topic = null;
        this.owner = ownerObject;
        if (this.owner instanceof PsUiTopic) {
            this.broker = (PsBroker)((PsUiMQBrokerObject)ownerObject).getOwningUiBroker().getDmObject();
            qmgr = this.broker.getQueueManager().getTitle();
            stream = ownerObject.getDmObject().getAttributeValue(t, 3030, 0);
            topic = ownerObject.toString();
        } else {
            this.broker = (PsBroker)this.owner.getDmObject();
            qmgr = this.broker.getQueueManager().getTitle();
        }
        super.open(t, qmgr, topic, true, stream, ownerObject.getImage(), helpId, false);
    }

    public void dmActionDone(DmActionEvent event) {
        final Trace t = Trace.getDefault();
        final int rc = event.getReasonCode();
        final DmCoreException exc = event.getException();
        int command = event.getCommand();
        if (Trace.isTracing) {
            t.data(66, "PsPublishTestDialog.dmActionDone", 300, "dmActionDone event received: " + command + " completed with return code " + rc);
        }
        if (!this.myShell.isDisposed()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Trace trace = Trace.getDefault();
                    if (rc != 0) {
                        String error = null;
                        error = PsError.getErrorMsg(t, rc);
                        if (error != null) {
                            MessageBox.showMessageFailure((Trace)t, (Shell)PsPublishTestDialog.this.myShell, (String)error);
                        } else if (exc != null) {
                            MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)exc);
                        } else {
                            MessageBox.showExceptionMessage((Trace)trace, (Shell)UiPlugin.getShell(), (DmCoreException)new DmCoreException("Reason code: " + rc, "Unknown", rc, 0, 1));
                        }
                    } else {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss", locale);
                        String dateString = dateFormat.format(new Date());
                        PsPublishTestDialog.this.setStatus(Trace.getDefault(), PsPublishTestDialog.this.msgFile.getMessage("Ui.Last.Published", dateString));
                    }
                }
            });
        }
    }

    public void publish(Trace t) {
        int pubOptions = 8;
        int timeout = 30;
        if (this.retained) {
            pubOptions |= 2;
            timeout = -1;
        }
        if (this.owner instanceof PsUiTopic) {
            ((PsTopic)this.owner.getDmObject()).actionPublish(t, this, pubOptions, 0, this.qmgrText.getText(), this.queue, null, -1, this.messageText.getText(), -1, timeout);
        } else {
            boolean streamChanged = false;
            String stream = "";
            if (this.streamText != null) {
                stream = this.streamText.getText();
            }
            if (this.combo != null) {
                stream = this.combo.getText();
            }
            if (this.currentStream != stream) {
                this.currentStream = stream;
                streamChanged = true;
            }
            if (this.topicObject == null) {
                this.object = PsObjectFactory.create(t, this.broker, 1501, this.topicText.getText(), this.currentStream);
                UiMQObjectFactory factory = ((PsUiBroker)this.owner).getFactoryClass(t, "com.ibm.mq.explorer.pubsub.topic.topic");
                if (factory != null) {
                    this.topicObject = factory.create(t, (DmObject)this.object, null);
                }
            }
            if (this.currentTopic != this.topicText.getText()) {
                this.currentTopic = this.topicText.getText();
                this.object.replaceAttributeValue(t, 3031, 0, this.currentTopic, false);
            }
            if (streamChanged) {
                this.object.replaceAttributeValue(t, 3030, 0, this.currentStream, false);
            }
            ((PsTopic)this.topicObject.getDmObject()).actionPublish(t, this, pubOptions, 0, this.qmgrText.getText(), this.queue, null, -1, this.messageText.getText(), -1, timeout);
        }
        this.messageText.setText("");
        this.messageText.setFocus();
    }

    protected void selectNewStream(Trace t) {
        UiMQObject userselUiMQObject;
        SelectUiMQObjectDialog selDlg = new SelectUiMQObjectDialog(this.myShell);
        DmQueueManager dmQm = null;
        dmQm = this.broker.getQueueManager();
        selDlg.listenToDataModel(t, (IDmObservable)dmQm, 13, ((PsUiBroker)this.owner).getOwningUiQM(t).getFactoryClass(t, "com.ibm.mq.explorer.queue"), this.owner);
        boolean isSecondaryOrder = false;
        if (dmQm != null) {
            isSecondaryOrder = dmQm.isZos();
        }
        SelectQueuesViewerFilter viewerFilter = new SelectQueuesViewerFilter();
        viewerFilter.setHideTempQueues(true);
        viewerFilter.setHideAliasQueues(true);
        viewerFilter.setHideModelQueues(true);
        viewerFilter.setHideRemoteQueues(true);
        if (selDlg.open(t, PsPlugin.getMessage(t, "Ps.NewPubsub.Wizard.Select.Queue.Dialog"), null, "com.ibm.mq.explorer.queue", PsPlugin.getMessage(t, "UI.Q.Queues.Title"), "com.ibm.mq.explorer.orderid.queues", isSecondaryOrder, "com.ibm.mq.explorer.filterid.queues", (FilterProvider)new UiQueueFilterProvider(), null, (ViewerFilter)viewerFilter, true, true, null) && (userselUiMQObject = selDlg.getSelectedObject()) != null) {
            if (this.combo.indexOfObject((Object)userselUiMQObject.toString()) == -1) {
                this.combo.add(userselUiMQObject.toString(), 0);
            }
            this.combo.select(this.combo.indexOfObject((Object)userselUiMQObject.toString()));
        }
    }

    public void dmObjectListDone(final DmObjectListEvent event) {
        final Trace t = Trace.getDefault();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!PsPublishTestDialog.this.combo.isDisposed()) {
                    ArrayList objects = event.getList();
                    if (Trace.isTracing) {
                        t.data(66, "PsPublishTestDialog.dmObjectListDone", 300, String.valueOf(objects.size()) + " objects returned in list");
                    }
                    int i = 0;
                    while (i < objects.size()) {
                        DmObject dmObj = (DmObject)objects.get(i);
                        if (PsPublishTestDialog.this.combo.indexOfObject((Object)dmObj.getTitle()) == -1) {
                            PsPublishTestDialog.this.combo.add(dmObj.getTitle());
                        }
                        ++i;
                    }
                }
            }
        });
    }

    protected void drawStreamBox(Trace t, Composite group, String stream) {
        Label streamLabel = new Label(group, 0);
        streamLabel.setText(PsPlugin.getMessage(t, "Ps.Test.Stream.Title"));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        streamLabel.setLayoutData((Object)gridData);
        if (stream != null) {
            this.streamText = new Text(group, 2048);
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.streamText, (boolean)true);
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.streamText.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly((Trace)t, (Text)this.streamText, (boolean)true);
            this.streamText.setText(stream);
        } else {
            this.filter = new PsObjectFilter(t, null, 1505, null, true);
            this.combo = new ExtCombo(group, 2060);
            this.combo.add(PsStream.getDefaultName(t));
            this.combo.select(0);
            this.broker.getObjects(t, this, this.filter);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.combo.setLayoutData((Object)gridData);
            Button button = new Button(group, 8);
            button.setText(PsPlugin.getMessage(t, "Ps.Button.Select.Text"));
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            button.setLayoutData((Object)gridData);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace t2 = Trace.getDefault();
                    PsPublishTestDialog.this.selectNewStream(t2);
                }
            });
        }
    }

    protected void enablePublish(Trace t) {
        int charCount = this.messageText.getText().trim().length();
        int topicTextCount = this.topicText.getText().trim().length();
        if (charCount > 0 && topicTextCount > 0) {
            this.buttonPublish.setEnabled(true);
            this.myShell.setDefaultButton(this.buttonPublish);
        } else {
            this.buttonPublish.setEnabled(false);
            this.myShell.setDefaultButton(this.buttonClose);
        }
    }
}

