/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.pubsub.ui.internal.dialogs;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmMQQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.pubsub.internal.util.PsHexString;
import com.ibm.mq.explorer.pubsub.ui.internal.dialogs.IPsPollListener;
import com.ibm.mq.pcf.CCSID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class PsPollQueue
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.pubsub/src/com/ibm/mq/explorer/pubsub/ui/internal/dialogs/PsPollQueue.java";
    private MQQueue mqQueue = null;
    private byte[] correlId = null;
    private MQQueueManager queueManager;
    private String queue = null;
    private IDmObject dmObject;
    private ArrayList listeners;
    private ArrayList removeListeners;
    private int pollInterval = 0;

    public PsPollQueue(Trace t, String queue, String correlId, IDmObject owner, int pollInterval) {
        this.queue = queue;
        this.pollInterval = pollInterval;
        this.dmObject = owner;
        this.correlId = PsHexString.parseHex(correlId);
        this.listeners = new ArrayList();
    }

    @Override
    public void run() {
        Trace t;
        block12: {
            DmMQQueueManager dmMQQueueManager;
            block11: {
                t = Trace.getDefault();
                dmMQQueueManager = this.dmObject.getQueueManager().getNewConnection(t);
                dmMQQueueManager.connect(t);
                try {
                    dmMQQueueManager.join();
                }
                catch (InterruptedException e) {
                    if (!Trace.isTracing) break block11;
                    t.data(66, "PsPollQueue.run", 900, e.toString());
                }
            }
            this.queueManager = dmMQQueueManager.getQueueManager(t);
            try {
                this.mqQueue = this.queueManager.accessQueue(this.queue, 18);
            }
            catch (MQException mqe) {
                if (!Trace.isTracing) break block12;
                t.data(66, "PsPollQueue.run", 900, "Error connecting to the queue: " + mqe.toString());
            }
        }
        while (!this.listeners.isEmpty()) {
            MQMessage message = null;
            MQException exception = null;
            try {
                try {
                    message = this.get(t, this.correlId, this.pollInterval);
                }
                catch (MQException mqe) {
                    exception = mqe;
                    if (mqe.reasonCode != 2033 && Trace.isTracing) {
                        t.data(66, "PsPollQueue.run", 900, "Error getting a message from the queue: " + mqe.toString());
                    }
                    this.notifyListeners(t, message, exception);
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.notifyListeners(t, message, exception);
                throw throwable;
            }
            this.notifyListeners(t, message, exception);
        }
        if (Trace.isTracing) {
            t.data(66, "PsPollQueue.run", 300, "No more registered listeners - Stop polling the queue for messages and close the connection.");
        }
        this.close(t);
    }

    public MQMessage get(Trace t, byte[] correlId, int wait) throws MQException {
        MQMessage getMessage;
        block3: {
            MQGetMessageOptions gmo = new MQGetMessageOptions();
            gmo.options = 24577;
            if (wait != 0) {
                gmo.waitInterval = wait;
            }
            getMessage = new MQMessage();
            getMessage.encoding = 273;
            getMessage.characterSet = 0;
            getMessage.correlationId = correlId;
            try {
                this.mqQueue.get(getMessage, gmo);
            }
            catch (MQException mqe) {
                if (mqe.reasonCode == 2079) break block3;
                throw mqe;
            }
        }
        return getMessage;
    }

    public void put(Trace t, String data) throws MQException {
        MQQueueManager putQueueManager;
        MQQueue putQueue;
        MQMessage message;
        MQPutMessageOptions pmo;
        byte[] dataArray;
        int defaultEncoding;
        int defaultCCSID;
        block13: {
            DmMQQueueManager putMQQueueManager;
            block12: {
                defaultCCSID = 1208;
                defaultEncoding = 546;
                dataArray = null;
                pmo = new MQPutMessageOptions();
                message = new MQMessage();
                putMQQueueManager = this.dmObject.getQueueManager().getNewConnection(t);
                putQueue = null;
                putMQQueueManager.connect(t);
                try {
                    putMQQueueManager.join();
                }
                catch (InterruptedException e) {
                    if (!Trace.isTracing) break block12;
                    t.data(66, "PsPollQueue.put", 900, e.toString());
                }
            }
            putQueueManager = putMQQueueManager.getQueueManager(t);
            try {
                putQueue = putQueueManager.accessQueue(this.queue, 16);
            }
            catch (MQException mqe) {
                if (!Trace.isTracing) break block13;
                t.data(66, "PsPollQueue.put", 900, "Error putting a message to the queue: " + mqe.toString());
            }
        }
        try {
            String msgCharSet = CCSID.getCharSet((int)defaultCCSID, (int)defaultEncoding);
            dataArray = data.getBytes(msgCharSet);
            message.encoding = defaultEncoding;
            message.characterSet = defaultCCSID;
            message.correlationId = this.correlId;
        }
        catch (Throwable throwable) {
            dataArray = data.getBytes();
        }
        try {
            try {
                message.write(dataArray);
                message.format = "MQSTR   ";
                putQueue.put(message, pmo);
            }
            catch (IOException e) {
                data = null;
                if (Trace.isTracing) {
                    t.data(66, "PsPollQueue.put", 900, "Error writing data to message: " + e.toString());
                }
                putQueue.close();
                putQueueManager.disconnect();
            }
        }
        finally {
            putQueue.close();
            putQueueManager.disconnect();
        }
    }

    public void close(Trace t) {
        block2: {
            try {
                this.mqQueue.close();
                this.queueManager.disconnect();
            }
            catch (MQException e) {
                this.queueManager = null;
                if (!Trace.isTracing) break block2;
                t.data(66, "PsPollQueue.close", 900, "Error closing the queue and disconnecting from the queue manaager: " + e.toString());
            }
        }
    }

    public void addListener(Trace t, IPsPollListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Trace t, IPsPollListener listener) {
        this.removeListeners.add(listener);
    }

    public void notifyListeners(Trace t, MQMessage message, MQException e) {
        this.removeListeners = new ArrayList();
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((IPsPollListener)i.next()).messageReceived(t, message, e);
        }
        i = this.removeListeners.iterator();
        while (i.hasNext()) {
            this.listeners.remove(i.next());
        }
    }
}

